/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileObject;
import org.openide.util.NbCollections;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;

class Ordering {
    private static final Logger LOG = Logger.getLogger(Ordering.class.getName());
    private static final String ATTR_POSITION = "position";

    private Ordering() {
    }

    static List<FileObject> getOrder(Collection<FileObject> children, final boolean logWarnings) throws IllegalArgumentException {
        Iterator it2;
        LOG.log(Level.FINE, "getOrder for {0}", children);
        Iterator<FileObject> it = children.iterator();
        if (!it.hasNext()) {
            return Collections.emptyList();
        }
        HashMap<String, FileObject> childrenByName = new HashMap<String, FileObject>();
        class ChildAndPosition
        implements Comparable<ChildAndPosition> {
            final FileObject child;
            private final Number position;

            ChildAndPosition(FileObject child, Number position) {
                this.child = child;
                this.position = position;
            }

            @Override
            public int compareTo(ChildAndPosition o) {
                int res;
                if (this.position instanceof Float || this.position instanceof Double || o.position instanceof Float || o.position instanceof Double) {
                    res = Double.compare(this.position.doubleValue(), o.position.doubleValue());
                } else {
                    long v2;
                    long v1 = this.position.longValue();
                    int n = v1 < (v2 = o.position.longValue()) ? -1 : (res = v1 == v2 ? 0 : 1);
                }
                if (res != 0) {
                    return res;
                }
                if (logWarnings && o != this && !this.position.equals(0)) {
                    LOG.log(Level.WARNING, "Found same position {0} for both {1} and {2}", new Object[]{this.position, o.child.getPath(), this.child.getPath()});
                }
                return this.child.getNameExt().compareTo(o.child.getNameExt());
            }
        }
        TreeSet<ChildAndPosition> childrenByPosition = new TreeSet<ChildAndPosition>();
        FileObject parent = null;
        while (it.hasNext()) {
            FileObject child = it.next();
            if (childrenByName.put(child.getNameExt(), child) != null) {
                throw new IllegalArgumentException("Duplicate in children list: " + child.getPath() + "\nChildren: " + children);
            }
            Object pos = child.getAttribute(ATTR_POSITION);
            if (pos instanceof Number) {
                childrenByPosition.add(new ChildAndPosition(child, (Number)pos));
            } else if (logWarnings && pos != null) {
                LOG.log(Level.WARNING, "Encountered nonnumeric position attribute {0} of {1} for {2}\nChildren: {3}", new Object[]{pos, pos.getClass(), child.getPath(), children});
            }
            if (parent == null) {
                parent = child.getParent();
                continue;
            }
            if (child.getParent() == parent) continue;
            throw new IllegalArgumentException("All children must have the same parent: " + child.getParent().getPath() + " vs. " + parent.getPath() + "\nChildren: " + children);
        }
        HashMap<FileObject, HashSet<FileObject>> edges = new HashMap<FileObject, HashSet<FileObject>>();
        for (String attr : NbCollections.iterable(parent.getAttributes())) {
            int slash;
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "  attr found {0}({1})", new Object[]{parent, attr});
            }
            if ((slash = attr.indexOf(47)) == -1) continue;
            Object val = parent.getAttribute(attr);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "  reading attribute {0}({1}) -> {2}", new Object[]{parent, attr, val});
            }
            if (!Boolean.TRUE.equals(val)) {
                if (!logWarnings || val == null || val instanceof Boolean) continue;
                LOG.log(Level.WARNING, "Encountered non-boolean relative ordering attribute {0} from {1} on {2}", new Object[]{val, attr, parent.getPath()});
                continue;
            }
            FileObject f1 = (FileObject)childrenByName.get(attr.substring(0, slash));
            FileObject f2 = (FileObject)childrenByName.get(attr.substring(slash + 1));
            if (f1 != null && f2 != null) {
                HashSet<FileObject> edge = (HashSet<FileObject>)edges.get(f1);
                if (edge == null) {
                    edge = new HashSet<FileObject>();
                    edges.put(f1, edge);
                }
                edge.add(f2);
                if (!logWarnings) continue;
                LOG.log(Level.WARNING, "Relative ordering attribute {0} on {1} is deprecated in favor of numeric position attributes", new Object[]{attr, parent.getPath()});
                continue;
            }
            if (!logWarnings) continue;
            LOG.log(Level.WARNING, "Could not find both sides of relative ordering attribute {0} on {1}", new Object[]{attr, parent.getPath()});
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "  no more attribs {0}", parent);
        }
        if ((it2 = childrenByPosition.iterator()).hasNext()) {
            FileObject previousChild = ((ChildAndPosition)it2.next()).child;
            while (it2.hasNext()) {
                FileObject subsequentChild = ((ChildAndPosition)it2.next()).child;
                HashSet<FileObject> edge = (HashSet<FileObject>)edges.get(previousChild);
                if (edge == null) {
                    edge = new HashSet<FileObject>();
                    edges.put(previousChild, edge);
                }
                edge.add(subsequentChild);
                previousChild = subsequentChild;
            }
        }
        if (logWarnings && !childrenByPosition.isEmpty() && childrenByPosition.size() < children.size()) {
            ArrayList<FileObject> missingPositions = new ArrayList<FileObject>(children);
            for (ChildAndPosition cap : childrenByPosition) {
                missingPositions.remove(cap.child);
            }
            if (!missingPositions.isEmpty()) {
                ArrayList<String> missingNames = new ArrayList<String>(missingPositions.size());
                for (FileObject f : missingPositions) {
                    missingNames.add(f.getNameExt());
                }
                ArrayList<String> presentNames = new ArrayList<String>(childrenByPosition.size());
                for (ChildAndPosition cap : childrenByPosition) {
                    presentNames.add(cap.child.getNameExt());
                }
                LOG.log(Level.WARNING, "Not all children in {0}/ marked with the position attribute: {1}, but some are: {2}", new Object[]{parent.getPath(), missingNames, presentNames});
            }
        }
        if (edges.isEmpty()) {
            return new ArrayList<FileObject>(children);
        }
        try {
            return Utilities.topologicalSort(children, edges);
        }
        catch (TopologicalSortException x) {
            if (logWarnings) {
                LOG.log(Level.WARNING, "Contradictory partial ordering in " + parent.getPath(), x);
            }
            return NbCollections.checkedListByCopy((List)x.partialSort(), FileObject.class, (boolean)true);
        }
    }

    static void setOrder(List<FileObject> children) throws IllegalArgumentException, IOException {
        boolean oneNewChild = false;
        boolean fullySpecified = true;
        for (FileObject f : children) {
            if (Ordering.findPosition(f) != null) continue;
            fullySpecified = false;
            break;
        }
        FileObject toBeMoved = null;
        FileObject before = null;
        FileObject after = null;
        if (fullySpecified) {
            int end;
            int start;
            List<FileObject> oldOrder = Ordering.getOrder(children, false);
            if (((Object)children).equals(oldOrder)) {
                return;
            }
            int length = children.size();
            for (start = 0; start < length && children.get(start).equals(oldOrder.get(start)); ++start) {
            }
            for (end = length - 1; end >= 0 && children.get(end).equals(oldOrder.get(end)); --end) {
            }
            int rangeLength = end - start + 1;
            if (rangeLength > 2) {
                if (children.get(end).equals(oldOrder.get(start)) && ((Object)children.subList(start, end)).equals(oldOrder.subList(start + 1, end + 1))) {
                    toBeMoved = children.get(end);
                    before = children.get(end - 1);
                    after = end + 1 < length ? children.get(end + 1) : null;
                } else if (children.get(start).equals(oldOrder.get(end)) && ((Object)children.subList(start + 1, end + 1)).equals(oldOrder.subList(start, end))) {
                    toBeMoved = children.get(start);
                    before = start - 1 >= 0 ? children.get(start - 1) : null;
                    after = children.get(start + 1);
                }
            } else if (rangeLength == 2) {
                if (start == 0) {
                    toBeMoved = children.get(start);
                    after = children.get(end);
                } else if (end == length - 1) {
                    toBeMoved = children.get(end);
                    before = children.get(start);
                } else {
                    Float outLeft = Ordering.findPosition(children.get(start - 1));
                    Float outRight = Ordering.findPosition(children.get(end + 1));
                    Float left = Ordering.findPosition(children.get(start));
                    Float right = Ordering.findPosition(children.get(end));
                    if (outLeft != null && outRight != null && left != null && right != null) {
                        if (left.floatValue() - outLeft.floatValue() < outRight.floatValue() - right.floatValue()) {
                            toBeMoved = children.get(end);
                            before = children.get(start);
                            after = children.get(end + 1);
                        } else {
                            toBeMoved = children.get(start);
                            before = children.get(start - 1);
                            after = children.get(end);
                        }
                    }
                }
            } else assert (rangeLength == 0) : oldOrder + " => " + children;
        } else if (children.size() > 1) {
            FileObject nue = null;
            for (FileObject f : children) {
                if (Ordering.findPosition(f) != null) continue;
                if (nue == null) {
                    nue = f;
                    continue;
                }
                nue = null;
                break;
            }
            if (nue != null) {
                oneNewChild = true;
                toBeMoved = nue;
                int idx = children.indexOf(nue);
                before = idx == 0 ? null : children.get(idx - 1);
                FileObject fileObject = after = idx == children.size() - 1 ? null : children.get(idx + 1);
            }
        }
        if (toBeMoved != null) {
            if (before == null) {
                toBeMoved.setAttribute(ATTR_POSITION, Math.round(Ordering.findPosition(after).floatValue() - 100.0f));
            } else if (after == null) {
                toBeMoved.setAttribute(ATTR_POSITION, Math.round(Ordering.findPosition(before).floatValue() + 100.0f));
            } else {
                Float beforePos = Ordering.findPosition(before);
                Float afterPos = Ordering.findPosition(after);
                int proposed = Math.round(beforePos.floatValue() + afterPos.floatValue()) / 2;
                if (beforePos.floatValue() < (float)proposed && (float)proposed < afterPos.floatValue()) {
                    toBeMoved.setAttribute(ATTR_POSITION, proposed);
                } else {
                    toBeMoved = null;
                }
            }
        }
        if (toBeMoved == null) {
            int pos = 100;
            for (FileObject f : children) {
                f.setAttribute(ATTR_POSITION, pos);
                pos += 100;
            }
        }
        if (oneNewChild && toBeMoved != null) {
            Ordering.setOrder(children);
            return;
        }
        FileObject d = children.get(0).getParent();
        for (String attr : NbCollections.iterable(d.getAttributes())) {
            if (attr.indexOf(47) == -1 || !(d.getAttribute(attr) instanceof Boolean)) continue;
            d.setAttribute(attr, null);
        }
        boolean asserts = false;
        if (!$assertionsDisabled) {
            asserts = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (asserts) {
            List<FileObject> actual = Ordering.getOrder(children, false);
            assert (((Object)actual).equals(children)) : "setOrder(" + children + ") -> " + actual;
        }
    }

    private static Float findPosition(FileObject f) {
        Object o = f.getAttribute(ATTR_POSITION);
        if (o instanceof Number) {
            return Float.valueOf(((Number)o).floatValue());
        }
        return null;
    }

    static boolean affectsOrder(FileAttributeEvent event) {
        String name = event.getName();
        if (name == null) {
            return true;
        }
        return name.equals(ATTR_POSITION) || event.getFile().isFolder() && name.indexOf(47) != -1;
    }
}

