/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.gsf.testrunner.api.Manager;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;
import org.netbeans.modules.gsf.testrunner.api.TestRunnerNodeFactory;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.ruby.codecoverage.RubyCoverageProvider;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.RubyProjectUtil;
import org.netbeans.modules.ruby.rubyproject.RubyTestingSettings;
import org.netbeans.modules.ruby.rubyproject.rake.RakeTask;
import org.netbeans.modules.ruby.rubyproject.spi.RakeTaskCustomizer;
import org.netbeans.modules.ruby.rubyproject.spi.TestRunner;
import org.netbeans.modules.ruby.testrunner.RubyTestRunnerNodeFactory;
import org.netbeans.modules.ruby.testrunner.TestExecutionManager;
import org.netbeans.modules.ruby.testrunner.TestRunnerUtilities;
import org.netbeans.modules.ruby.testrunner.ui.TestRunnerLineConvertor;
import org.netbeans.modules.ruby.testrunner.ui.TestUnitHandlerFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;

public final class TestUnitRunner
implements TestRunner,
RakeTaskCustomizer {
    private static final Logger LOGGER = Logger.getLogger(TestUnitRunner.class.getName());
    private static final String NB_TEST_RUNNER = "NB_TEST_RUNNER";
    static final String MEDIATOR_SCRIPT_NAME = "nb_test_mediator.rb";
    static final String TEST_RUNNER_SCRIPT_NAME = "nb_test_runner.rb";
    static final String SUITE_RUNNER_SCRIPT_NAME = "nb_suite_runner.rb";
    private static final TestRunner INSTANCE = new TestUnitRunner();

    public TestRunner getInstance() {
        return INSTANCE;
    }

    public void runSingleTest(FileObject testFile, String testMethod, boolean debug) {
        List<String> additionalArgs = this.getTestFileArgs(testFile);
        additionalArgs.add("-m");
        additionalArgs.add(testMethod);
        this.run(FileOwnerQuery.getOwner((FileObject)testFile), additionalArgs, testMethod, debug);
    }

    public void runTest(FileObject testFile, boolean debug) {
        Project project = FileOwnerQuery.getOwner((FileObject)testFile);
        if (!testFile.isFolder()) {
            this.run(project, this.getTestFileArgs(testFile), testFile.getName(), debug);
        } else {
            ArrayList<String> additionalArgs = new ArrayList<String>();
            additionalArgs.add("-d");
            additionalArgs.add(FileUtil.toFile((FileObject)testFile).getAbsolutePath());
            String name = ProjectUtils.getInformation((Project)project).getDisplayName();
            this.run(project, additionalArgs, name, debug);
        }
    }

    private List<String> getTestFileArgs(FileObject testFile) {
        String testFilePath = FileUtil.toFile((FileObject)testFile).getAbsolutePath();
        ArrayList<String> additionalArgs = new ArrayList<String>();
        additionalArgs.add("-f");
        additionalArgs.add(testFilePath);
        return additionalArgs;
    }

    private static File getScript(String name) {
        File script = InstalledFileLocator.getDefault().locate(name, "org.netbeans.modules.ruby.testrunner", false);
        if (script == null) {
            throw new IllegalStateException("Could not locate " + name);
        }
        return script;
    }

    static void addTestUnitRunnerToEnv(Map<String, String> env) {
        env.put(NB_TEST_RUNNER, TestUnitRunner.getScript(TEST_RUNNER_SCRIPT_NAME).getAbsolutePath());
    }

    public void runAllTests(Project project, boolean debug) {
        ArrayList<String> additionalArgs = new ArrayList<String>();
        RubyBaseProject baseProject = (RubyBaseProject)project.getLookup().lookup(RubyBaseProject.class);
        for (FileObject testDir : baseProject.getTestSourceRootFiles()) {
            additionalArgs.add("-d");
            additionalArgs.add(FileUtil.toFile((FileObject)testDir).getAbsolutePath());
        }
        String name = ProjectUtils.getInformation((Project)project).getDisplayName();
        this.run(project, additionalArgs, name, debug);
    }

    private void run(Project project, List<String> additionalArgs, String name, boolean debug) {
        LineConvertors.FileLocator locator = (LineConvertors.FileLocator)project.getLookup().lookup(LineConvertors.FileLocator.class);
        RubyPlatform platform = RubyPlatform.platformFor((Project)project);
        String targetPath = TestUnitRunner.getScript(MEDIATOR_SCRIPT_NAME).getAbsolutePath();
        RubyExecutionDescriptor desc = null;
        Object charsetName = null;
        desc = new RubyExecutionDescriptor(platform, name, FileUtil.toFile((FileObject)project.getProjectDirectory()), targetPath);
        desc.additionalArgs(additionalArgs.toArray(new String[additionalArgs.size()]));
        TestRunnerUtilities.addProperties(desc, project);
        desc.addInitialArgs(RubyProjectUtil.getLoadPath((Project)project));
        desc.debug(debug);
        desc.allowInput();
        desc.fileLocator(locator);
        desc.addStandardRecognizers();
        RubyCoverageProvider coverageProvider = RubyCoverageProvider.get((Project)project);
        if (coverageProvider != null && coverageProvider.isEnabled()) {
            desc = coverageProvider.wrapWithCoverage(desc, false, null);
        }
        TestSession session = new TestSession(name, project, debug ? TestSession.SessionType.DEBUG : TestSession.SessionType.TEST, (TestRunnerNodeFactory)new RubyTestRunnerNodeFactory());
        TestExecutionManager.getInstance().start(desc, new TestUnitHandlerFactory(), session);
    }

    public boolean supports(TestRunner.TestType type) {
        return type == TestRunner.TestType.TEST_UNIT;
    }

    public void customize(Project project, RakeTask task, RubyExecutionDescriptor taskDescriptor, boolean debug) {
        boolean useRunner;
        boolean bl = useRunner = RubyTestingSettings.getDefault().useRunner(TestRunner.TestType.TEST_UNIT) && TestRunnerUtilities.useTestRunner(project, "test.tasks", task, TestUnitTaskEvaluator.INSTANCE);
        if (!useRunner) {
            return;
        }
        TestExecutionManager.getInstance().reset();
        task.addRakeParameters(new String[]{"-r \"" + TestUnitRunner.getScript(TEST_RUNNER_SCRIPT_NAME).getAbsolutePath() + "\""});
        TestSession session = new TestSession(task.getDisplayName(), project, debug ? TestSession.SessionType.DEBUG : TestSession.SessionType.TEST, (TestRunnerNodeFactory)new RubyTestRunnerNodeFactory());
        HashMap<String, String> env = new HashMap<String, String>(1);
        TestUnitRunner.addTestUnitRunnerToEnv(env);
        taskDescriptor.addAdditionalEnv(env);
        Manager manager = Manager.getInstance();
        TestRunnerLineConvertor testConvertor = new TestRunnerLineConvertor(manager, session, new TestUnitHandlerFactory());
        taskDescriptor.addStandardRecognizers();
        TestRunnerUtilities.setUpConvertors(session, taskDescriptor, manager, testConvertor);
        TestRunnerUtilities.addProperties(taskDescriptor, project);
        TestExecutionManager.getInstance().init(taskDescriptor);
        session.setRerunHandler((RerunHandler)TestExecutionManager.getInstance());
    }

    static {
        System.setProperty(NB_TEST_RUNNER, TestUnitRunner.getScript(TEST_RUNNER_SCRIPT_NAME).getAbsolutePath());
    }

    private static class TestUnitTaskEvaluator
    implements TestRunnerUtilities.DefaultTaskEvaluator {
        static final TestUnitTaskEvaluator INSTANCE = new TestUnitTaskEvaluator();

        private TestUnitTaskEvaluator() {
        }

        @Override
        public boolean isDefault(RakeTask task) {
            return "test".equals(task.getTask()) || task.getTask().startsWith("test:");
        }
    }
}

