/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.gsf.testrunner.api.TestRunnerNodeFactory;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.ruby.codecoverage.RubyCoverageProvider;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.rubyproject.spi.TestRunner;
import org.netbeans.modules.ruby.testrunner.RspecRunner;
import org.netbeans.modules.ruby.testrunner.RubyTestRunnerNodeFactory;
import org.netbeans.modules.ruby.testrunner.TestExecutionManager;
import org.netbeans.modules.ruby.testrunner.TestRunnerUtilities;
import org.netbeans.modules.ruby.testrunner.ui.AutotestHandlerFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;

public class AutospecRunner
implements TestRunner {
    private static final Logger LOGGER = Logger.getLogger(AutospecRunner.class.getName());
    private static final TestRunner INSTANCE = new AutospecRunner();
    private static final String NB_RSPEC_MEDIATOR = "NB_RSPEC_MEDIATOR";
    private static final String AUTOSPEC_LOADER = "nb_autospec_loader.rb";

    public TestRunner getInstance() {
        return INSTANCE;
    }

    public boolean supports(TestRunner.TestType type) {
        return TestRunner.TestType.AUTOSPEC == type;
    }

    public void runTest(FileObject testFile, boolean debug) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void runSingleTest(FileObject testFile, String testMethod, boolean debug) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void runAllTests(Project project, boolean debug) {
        RubyPlatform platform = RubyPlatform.platformFor((Project)project);
        if (!platform.hasValidAutoSpec(true)) {
            return;
        }
        String displayName = NbBundle.getMessage(AutospecRunner.class, (String)"AutoSpec", (Object)ProjectUtils.getInformation((Project)project).getDisplayName());
        LineConvertors.FileLocator locator = (LineConvertors.FileLocator)project.getLookup().lookup(LineConvertors.FileLocator.class);
        String autospec = platform.getAutoTest();
        RubyExecutionDescriptor desc = new RubyExecutionDescriptor(platform, displayName, FileUtil.toFile((FileObject)project.getProjectDirectory()), autospec);
        TestRunnerUtilities.addProperties(desc, project);
        desc.addInitialArgs("-r \"" + AutospecRunner.getLoaderScript().getAbsolutePath() + "\"");
        HashMap<String, String> env = new HashMap<String, String>(2);
        AutospecRunner.addRspecMediatorOptionsToEnv(env);
        env.put("RSPEC", "true");
        desc.addAdditionalEnv(env);
        desc.debug(debug);
        desc.allowInput();
        desc.fileLocator(locator);
        desc.addStandardRecognizers();
        RubyCoverageProvider coverageProvider = RubyCoverageProvider.get((Project)project);
        if (coverageProvider != null && coverageProvider.isEnabled()) {
            desc = coverageProvider.wrapWithCoverage(desc, false, null);
        }
        TestSession session = new TestSession(displayName, project, debug ? TestSession.SessionType.DEBUG : TestSession.SessionType.TEST, (TestRunnerNodeFactory)new RubyTestRunnerNodeFactory());
        TestExecutionManager.getInstance().start(desc, new AutotestHandlerFactory(), session);
    }

    static void addRspecMediatorOptionsToEnv(Map<String, String> env) {
        String options = "--require '" + RspecRunner.getMediatorScript().getAbsolutePath() + "' --runner NbRspecMediator";
        env.put(NB_RSPEC_MEDIATOR, options);
    }

    private static File getLoaderScript() {
        File mediatorScript = InstalledFileLocator.getDefault().locate(AUTOSPEC_LOADER, "org.netbeans.modules.ruby.testrunner", false);
        if (mediatorScript == null) {
            throw new IllegalStateException("Could not locate nb_autospec_loader.rb");
        }
        return mediatorScript;
    }
}

