/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.tld;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.web.jsf.editor.JsfSupport;
import org.netbeans.modules.web.jsf.editor.tld.LibraryDescriptorException;
import org.netbeans.modules.web.jsf.editor.tld.TldLibrary;
import org.openide.filesystems.FileObject;

public class TldLibrariesCache {
    private final Map<String, TldLibrary> LIBRARIES = new HashMap<String, TldLibrary>();
    private JsfSupport support;

    public TldLibrariesCache(JsfSupport jsfSupport) {
        this.support = jsfSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        Map<String, TldLibrary> map = this.LIBRARIES;
        synchronized (map) {
            this.LIBRARIES.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized TldLibrary getLibrary(String string) throws LibraryDescriptorException {
        Map<String, TldLibrary> map = this.LIBRARIES;
        synchronized (map) {
            FileObject fileObject;
            TldLibrary tldLibrary = this.LIBRARIES.get(string);
            if (tldLibrary == null && (fileObject = this.support.getIndex().getTldFile(string)) != null) {
                tldLibrary = TldLibrary.create(fileObject);
                this.LIBRARIES.put(string, tldLibrary);
            }
            return tldLibrary;
        }
    }

    private void dumpLibs() {
        System.out.println("Available TLD libraries:");
        for (TldLibrary tldLibrary : this.LIBRARIES.values()) {
            System.out.println(tldLibrary.getDisplayName() + " (" + tldLibrary.getURI() + "; " + (tldLibrary.getDefinitionFile() != null ? tldLibrary.getDefinitionFile().getPath() : "default library") + ")");
        }
    }
}

