/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import org.netbeans.modules.tasklist.impl.TaskList;
import org.netbeans.modules.tasklist.impl.TaskManagerImpl;
import org.netbeans.spi.tasklist.Task;
import org.netbeans.spi.tasklist.TaskScanningScope;

class ScopeStatusBar
extends JLabel
implements PropertyChangeListener {
    private TaskManagerImpl taskManager;
    private TaskList.Listener listener;

    public ScopeStatusBar(TaskManagerImpl taskManager) {
        this.taskManager = taskManager;
        this.setEnabled(false);
        this.updateText();
        this.listener = new TaskList.Listener(){

            @Override
            public void tasksAdded(List<? extends Task> tasks) {
                ScopeStatusBar.this.updateText();
            }

            @Override
            public void tasksRemoved(List<? extends Task> tasks) {
                ScopeStatusBar.this.updateText();
            }

            @Override
            public void cleared() {
                ScopeStatusBar.this.updateText();
            }
        };
    }

    private void updateText() {
        String label;
        StringBuffer buffer = new StringBuffer();
        TaskScanningScope scope = this.taskManager.getScope();
        Map descriptions = (Map)scope.getLookup().lookup(Map.class);
        if (null != descriptions && null != (label = (String)descriptions.get("StatusBarLabel"))) {
            buffer.append(label);
        }
        this.setText(buffer.toString());
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.taskManager.removePropertyChangeListener("taskScanningScope", this);
        this.taskManager.getTasks().removeListener(this.listener);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.taskManager.addPropertyChangeListener("taskScanningScope", this);
        this.taskManager.getTasks().addListener(this.listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.updateText();
    }
}

