/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.index;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.php.editor.index.PHPElement;

public class AstElement
extends PHPElement {
    public static final Set<Modifier> STATIC = EnumSet.of(Modifier.STATIC);
    protected List<AstElement> children;
    protected String name;
    protected String in;
    protected ParserResult info;
    protected String signature;
    protected ElementKind kind;
    protected Set<Modifier> modifiers = Collections.EMPTY_SET;

    AstElement(ParserResult info) {
        this.info = info;
    }

    public String getSignature() {
        if (this.signature == null) {
            StringBuilder sb = new StringBuilder();
            String clz = this.getIn();
            if (clz != null && clz.length() > 0) {
                sb.append(clz);
                sb.append(".");
            }
            sb.append(this.getName());
            this.signature = sb.toString();
        }
        return this.signature;
    }

    public void setName(String name, String in) {
        if ("Element.Methods".equals(in)) {
            in = "Element";
        }
        this.name = name;
        this.in = in;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getIn() {
        if (this.in == null) {
            this.in = "";
        }
        return this.in;
    }

    void setKind(ElementKind kind) {
        this.kind = kind;
    }

    @Override
    public ElementKind getKind() {
        if (this.kind == null) {
            // empty if block
        }
        return this.kind;
    }

    public List<AstElement> getChildren() {
        return Collections.emptyList();
    }

    public String toString() {
        return "JsElement:" + this.getName() + "(" + this.getKind() + ")";
    }

    public ParserResult getInfo() {
        return this.info;
    }

    @Override
    public Set<Modifier> getModifiers() {
        return this.modifiers;
    }

    void setModifiers(Set<Modifier> modifiers) {
        this.modifiers = modifiers;
    }
}

