/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.threading;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.jackpot.spi.Hacks;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.JavaFix;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

public class Tiny {
    private static final Set<ElementKind> VARIABLES = EnumSet.of(ElementKind.ENUM_CONSTANT, ElementKind.EXCEPTION_PARAMETER, ElementKind.FIELD, ElementKind.LOCAL_VARIABLE, ElementKind.PARAMETER);
    private static final Set<Tree.Kind> LOOP_KINDS = EnumSet.of(Tree.Kind.DO_WHILE_LOOP, Tree.Kind.ENHANCED_FOR_LOOP, Tree.Kind.FOR_LOOP, Tree.Kind.WHILE_LOOP);

    public static ErrorDescription notifyOnCondition(HintContext hintContext) {
        String string = Tiny.methodName((MethodInvocationTree)hintContext.getPath().getLeaf());
        String string2 = string.endsWith("All") ? "signalAll" : "signal";
        String string3 = NbBundle.getMessage(Tiny.class, (String)"FIX_NotifyOnConditionFix", (Object)string2);
        Fix fix = JavaFix.rewriteFix(hintContext, string3, hintContext.getPath(), "$cond." + string2 + "()", new String[0]);
        String string4 = NbBundle.getMessage(Tiny.class, (String)"ERR_NotifyOnCondition", (Object)string);
        return ErrorDescriptionFactory.forName(hintContext, hintContext.getPath(), string4, fix);
    }

    public static ErrorDescription waitOnCondition(HintContext hintContext) {
        String string = NbBundle.getMessage(Tiny.class, (String)"ERR_WaitOnCondition");
        return ErrorDescriptionFactory.forName(hintContext, hintContext.getPath(), string, new Fix[0]);
    }

    public static ErrorDescription threadRun(HintContext hintContext) {
        String string = NbBundle.getMessage(Tiny.class, (String)"FIX_ThreadRun");
        Fix fix = JavaFix.rewriteFix(hintContext, string, hintContext.getPath(), "$thread.start()", new String[0]);
        String string2 = NbBundle.getMessage(Tiny.class, (String)"ERR_ThreadRun");
        return ErrorDescriptionFactory.forName(hintContext, hintContext.getPath(), string2, fix);
    }

    public static ErrorDescription threadStartInConstructor(HintContext hintContext) {
        if (!Utilities.isInConstructor(hintContext)) {
            return null;
        }
        String string = NbBundle.getMessage(Tiny.class, (String)"ERR_ThreadStartInConstructor");
        return ErrorDescriptionFactory.forName(hintContext, hintContext.getPath(), string, new Fix[0]);
    }

    public static ErrorDescription threadYield(HintContext hintContext) {
        String string = NbBundle.getMessage(Tiny.class, (String)"ERR_ThreadYield");
        return ErrorDescriptionFactory.forName(hintContext, hintContext.getPath(), string, new Fix[0]);
    }

    public static ErrorDescription threadSuspend(HintContext hintContext) {
        String string = NbBundle.getMessage(Tiny.class, (String)"ERR_ThreadSuspend", (Object)Tiny.methodName((MethodInvocationTree)hintContext.getPath().getLeaf()));
        return ErrorDescriptionFactory.forName(hintContext, hintContext.getPath(), string, new Fix[0]);
    }

    public static ErrorDescription nestedSynchronized(HintContext hintContext) {
        Object object;
        TreePath treePath;
        for (treePath = hintContext.getPath().getParentPath(); treePath != null && treePath.getLeaf().getKind() != Tree.Kind.METHOD && treePath.getLeaf().getKind() != Tree.Kind.CLASS; treePath = treePath.getParentPath()) {
            if (treePath.getLeaf().getKind() != Tree.Kind.SYNCHRONIZED) continue;
            return null;
        }
        boolean bl = false;
        if (treePath != null && treePath.getLeaf().getKind() == Tree.Kind.METHOD) {
            object = (MethodTree)treePath.getLeaf();
            bl = object.getModifiers().getFlags().contains((Object)Modifier.SYNCHRONIZED);
        }
        if (!bl) {
            class Found
            extends Error {
                Found() {
                }

                @Override
                public synchronized Throwable fillInStackTrace() {
                    return this;
                }
            }
            try {
                new TreeScanner<Void, Void>(){

                    @Override
                    public Void visitClass(ClassTree classTree, Void void_) {
                        return null;
                    }

                    @Override
                    public Void visitSynchronized(SynchronizedTree synchronizedTree, Void void_) {
                        throw new Found();
                    }
                }.scan(hintContext.getVariables().get("$block").getLeaf(), null);
                return null;
            }
            catch (Found found) {
                // empty catch block
            }
        }
        object = NbBundle.getMessage(Tiny.class, (String)"ERR_NestedSynchronized");
        return ErrorDescriptionFactory.forName(hintContext, hintContext.getPath(), (String)object, new Fix[0]);
    }

    public static ErrorDescription emptySynchronized(HintContext hintContext) {
        String string = NbBundle.getMessage(Tiny.class, (String)"ERR_EmptySynchronized");
        return ErrorDescriptionFactory.forName(hintContext, hintContext.getPath(), string, new Fix[0]);
    }

    public static ErrorDescription synchronizedOnLock(HintContext hintContext) {
        String string = NbBundle.getMessage(Tiny.class, (String)"FIX_SynchronizedOnLock");
        Fix fix = JavaFix.rewriteFix(hintContext, string, hintContext.getPath(), "$lock.lock(); try {$statements$;} finally {$lock.unlock();}", new String[0]);
        String string2 = NbBundle.getMessage(Tiny.class, (String)"ERR_SynchronizedOnLock");
        return ErrorDescriptionFactory.forName(hintContext, hintContext.getPath(), string2, fix);
    }

    public static ErrorDescription volatileArray(HintContext hintContext) {
        Element element = hintContext.getInfo().getTrees().getElement(hintContext.getPath());
        if (element == null || element.getKind() != ElementKind.FIELD || !element.getModifiers().contains((Object)Modifier.VOLATILE)) {
            return null;
        }
        String string = NbBundle.getMessage(Tiny.class, (String)"ERR_VolatileArrayField");
        return ErrorDescriptionFactory.forName(hintContext, hintContext.getPath(), string, new Fix[0]);
    }

    public static ErrorDescription unlockOutsideTryFinally(HintContext hintContext) {
        Tree tree;
        String string = NbBundle.getMessage(Tiny.class, (String)"FIX_UnlockOutsideTryFinally");
        Fix fix = JavaFix.rewriteFix(hintContext, string, hintContext.getPath(), "$lock.lock(); try {$statements$;} finally {$lock.unlock();}", new String[0]);
        String string2 = NbBundle.getMessage(Tiny.class, (String)"ERR_UnlockOutsideTryFinally");
        Tree tree2 = hintContext.getPath().getLeaf();
        if (tree2.getKind() == Tree.Kind.BLOCK) {
            List<? extends StatementTree> list = ((BlockTree)tree2).getStatements();
            int n = hintContext.getMultiVariables().get("$$1$").size();
            tree = list.get(n);
        } else {
            tree = tree2;
        }
        return ErrorDescriptionFactory.forName(hintContext, tree, string2, fix);
    }

    public static ErrorDescription unsyncWait(HintContext hintContext) {
        return Tiny.unsyncHint(hintContext, "ERR_UnsyncedWait");
    }

    public static ErrorDescription unsyncNotify(HintContext hintContext) {
        return Tiny.unsyncHint(hintContext, "ERR_UnsyncedNotify");
    }

    private static ErrorDescription unsyncHint(HintContext hintContext, String string) {
        Object object;
        VariableElement variableElement;
        Object object2;
        TreePath treePath = hintContext.getVariables().get("$site");
        if (treePath != null) {
            object2 = hintContext.getInfo().getTrees().getElement(treePath);
            if (object2 == null || !VARIABLES.contains((Object)object2.getKind())) {
                return null;
            }
            variableElement = (VariableElement)object2;
        } else {
            variableElement = Tiny.attributeThis(hintContext.getInfo(), hintContext.getPath());
            if (variableElement == null) {
                return null;
            }
        }
        for (object2 = hintContext.getPath(); object2 != null && ((TreePath)object2).getLeaf().getKind() != Tree.Kind.CLASS; object2 = ((TreePath)object2).getParentPath()) {
            if (((TreePath)object2).getLeaf().getKind() == Tree.Kind.SYNCHRONIZED && variableElement.equals(object = hintContext.getInfo().getTrees().getElement(new TreePath((TreePath)object2, ((SynchronizedTree)((TreePath)object2).getLeaf()).getExpression())))) {
                return null;
            }
            if (((TreePath)object2).getLeaf().getKind() != Tree.Kind.METHOD) continue;
            if (!((MethodTree)((TreePath)object2).getLeaf()).getModifiers().getFlags().contains((Object)Modifier.SYNCHRONIZED) || !variableElement.equals(Tiny.attributeThis(hintContext.getInfo(), (TreePath)object2))) break;
            return null;
        }
        object = NbBundle.getMessage(Tiny.class, (String)string);
        return ErrorDescriptionFactory.forName(hintContext, hintContext.getPath(), (String)object, new Fix[0]);
    }

    public static ErrorDescription sleepInSync(HintContext hintContext) {
        if (!Tiny.isSynced(hintContext, hintContext.getPath())) {
            return null;
        }
        String string = NbBundle.getMessage(Tiny.class, (String)"ERR_SleepInSync");
        return ErrorDescriptionFactory.forName(hintContext, hintContext.getPath(), string, new Fix[0]);
    }

    public static ErrorDescription sleepInLoop(HintContext hintContext) {
        if (Tiny.findLoop(hintContext.getPath()) == null) {
            return null;
        }
        String string = NbBundle.getMessage(Tiny.class, (String)"ERR_SleepInLoop");
        return ErrorDescriptionFactory.forName(hintContext, hintContext.getPath(), string, new Fix[0]);
    }

    private static String methodName(MethodInvocationTree methodInvocationTree) {
        ExpressionTree expressionTree = methodInvocationTree.getMethodSelect();
        switch (expressionTree.getKind()) {
            case IDENTIFIER: {
                return ((IdentifierTree)expressionTree).getName().toString();
            }
            case MEMBER_SELECT: {
                return ((MemberSelectTree)expressionTree).getIdentifier().toString();
            }
        }
        throw new UnsupportedOperationException(expressionTree.getKind().toString());
    }

    private static VariableElement attributeThis(CompilationInfo compilationInfo, TreePath treePath) {
        VariableElement variableElement = Hacks.attributeThis(compilationInfo, treePath);
        if (variableElement == null) {
            Logger.getLogger(Tiny.class.getName()).log(Level.WARNING, "m.localEnv == null");
            return null;
        }
        return variableElement;
    }

    private static boolean isSynced(HintContext hintContext, TreePath treePath) {
        while (treePath != null && treePath.getLeaf().getKind() != Tree.Kind.CLASS) {
            if (treePath.getLeaf().getKind() == Tree.Kind.SYNCHRONIZED) {
                return true;
            }
            if (treePath.getLeaf().getKind() == Tree.Kind.METHOD) {
                if (!((MethodTree)treePath.getLeaf()).getModifiers().getFlags().contains((Object)Modifier.SYNCHRONIZED)) break;
                return true;
            }
            treePath = treePath.getParentPath();
        }
        return false;
    }

    private static TreePath findLoop(TreePath treePath) {
        while (treePath != null && treePath.getLeaf().getKind() != Tree.Kind.CLASS && !LOOP_KINDS.contains((Object)treePath.getLeaf().getKind())) {
            treePath = treePath.getParentPath();
        }
        return LOOP_KINDS.contains((Object)treePath.getLeaf().getKind()) ? treePath : null;
    }
}

