/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.infrastructure;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.java.hints.infrastructure.CreatorBasedLazyFixList;
import org.netbeans.modules.java.hints.infrastructure.ErrorHintsProvider;
import org.netbeans.modules.java.hints.jackpot.impl.hints.HintsInvoker;
import org.netbeans.modules.java.hints.jackpot.impl.hints.HintsTask;
import org.netbeans.spi.editor.hints.Context;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.PositionRefresher;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class JavaHintsPositionRefresher
implements PositionRefresher {
    private static final Logger LOG = Logger.getLogger(JavaHintsPositionRefresher.class.getName());

    public Map<String, List<ErrorDescription>> getErrorDescriptionsAt(final Context context, final Document document) {
        final JavaSource javaSource = JavaSource.forDocument((Document)document);
        final HashMap<String, List<ErrorDescription>> hashMap = new HashMap<String, List<ErrorDescription>>();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    javaSource.runUserActionTask((Task)new RefreshTask(hashMap, context, document), true);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        };
        ProgressUtils.runOffEventDispatchThread((Runnable)runnable, (String)NbBundle.getMessage(JavaHintsPositionRefresher.class, (String)"Refresh_hints"), (AtomicBoolean)context.getCancel(), (boolean)false);
        return hashMap;
    }

    public static void hintsUpdated(Document document, long l) {
        if (document == null) {
            return;
        }
        JavaHintsPositionRefresher.getHolder(document).hints = l;
    }

    public static void suggestionsUpdated(Document document, long l, int n) {
        if (document == null) {
            return;
        }
        JavaHintsPositionRefresher.getHolder(document).suggestions = l;
        JavaHintsPositionRefresher.getHolder(document).suggestionsCaret = n;
    }

    public static void errorsUpdated(Document document, long l, List<ErrorDescription> list) {
        if (document == null) {
            return;
        }
        JavaHintsPositionRefresher.getHolder(document).errors = l;
        JavaHintsPositionRefresher.getHolder(document).errorsContent = list;
    }

    private static LastUpdatedHolder getHolder(Document document) {
        LastUpdatedHolder lastUpdatedHolder = (LastUpdatedHolder)document.getProperty(LastUpdatedHolder.class);
        if (lastUpdatedHolder == null) {
            lastUpdatedHolder = new LastUpdatedHolder();
            document.putProperty(LastUpdatedHolder.class, lastUpdatedHolder);
        }
        return lastUpdatedHolder;
    }

    private static final class LastUpdatedHolder {
        private long suggestions;
        private int suggestionsCaret;
        private long hints;
        private long errors;
        private List<ErrorDescription> errorsContent;

        private LastUpdatedHolder() {
        }
    }

    private class RefreshTask
    implements Task<CompilationController> {
        private final Map<String, List<ErrorDescription>> eds;
        private final Context ctx;
        private final Document doc;

        public RefreshTask(Map<String, List<ErrorDescription>> map, Context context, Document document) {
            this.eds = map;
            this.ctx = context;
            this.doc = document;
        }

        public void run(CompilationController compilationController) throws Exception {
            compilationController.toPhase(JavaSource.Phase.RESOLVED);
            Document document = compilationController.getDocument();
            if (document == null) {
                return;
            }
            long l = DocumentUtilities.getDocumentVersion((Document)document);
            int n = this.ctx.getPosition();
            if (this.ctx.isCanceled()) {
                return;
            }
            LastUpdatedHolder lastUpdatedHolder = JavaHintsPositionRefresher.getHolder(document);
            if (l > 0L && lastUpdatedHolder.suggestions < l || lastUpdatedHolder.suggestionsCaret != n) {
                LOG.fine("Computing suggestions");
                this.eds.put(HintsTask.KEY_SUGGESTIONS, new HintsInvoker((CompilationInfo)compilationController, n, new AtomicBoolean()).computeHints((CompilationInfo)compilationController));
            } else {
                LOG.fine("Suggestions already computed");
            }
            if (this.ctx.isCanceled()) {
                return;
            }
            if (l > 0L && lastUpdatedHolder.hints < l) {
                LOG.fine("Computing hints");
                int n2 = Utilities.getRowStart((BaseDocument)((BaseDocument)document), (int)n);
                int n3 = Utilities.getRowEnd((BaseDocument)((BaseDocument)document), (int)n);
                this.eds.put(HintsTask.KEY_HINTS, new HintsInvoker((CompilationInfo)compilationController, n2, n3, new AtomicBoolean()).computeHints((CompilationInfo)compilationController));
            } else {
                LOG.fine("Hints already computed");
            }
            if (this.ctx.isCanceled()) {
                return;
            }
            if (l > 0L && lastUpdatedHolder.errors < l) {
                LOG.fine("Computing errors");
                List<ErrorDescription> list = new ErrorHintsProvider().computeErrors((CompilationInfo)compilationController, document, n, "text/x-java");
                if (list != null) {
                    for (ErrorDescription errorDescription : list) {
                        LazyFixList lazyFixList = errorDescription.getFixes();
                        if (!(lazyFixList instanceof CreatorBasedLazyFixList)) continue;
                        ((CreatorBasedLazyFixList)errorDescription.getFixes()).compute((CompilationInfo)compilationController, this.ctx.getCancel());
                    }
                    this.eds.put(ErrorHintsProvider.class.getName(), list);
                }
            } else {
                LOG.fine("Errors already computed, computing fixes");
                for (ErrorDescription errorDescription : lastUpdatedHolder.errorsContent) {
                    if (errorDescription.getRange().getBegin().getOffset() > n || n > errorDescription.getRange().getEnd().getOffset() || errorDescription.getFixes().isComputed()) continue;
                    ((CreatorBasedLazyFixList)errorDescription.getFixes()).compute((CompilationInfo)compilationController, this.ctx.getCancel());
                }
            }
        }
    }
}

