/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.editor.rename.InstantRenamePerformer;
import org.netbeans.modules.java.hints.DoubleCheck;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class HideField
extends AbstractHint {
    volatile transient boolean stop;

    public HideField() {
        this("FieldNameHidesFieldInSuperclass");
    }

    public HideField(String ... stringArray) {
        super(true, true, AbstractHint.HintSeverity.WARNING, stringArray);
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(Tree.Kind.VARIABLE);
    }

    protected List<Fix> computeFixes(CompilationInfo compilationInfo, TreePath treePath, int[] nArray) {
        this.stop = false;
        Element element = compilationInfo.getTrees().getElement(treePath);
        if (element == null || element.getKind() != ElementKind.FIELD) {
            return null;
        }
        if (element.getSimpleName().contentEquals("<error>")) {
            return null;
        }
        Element element2 = null;
        TypeElement typeElement = (TypeElement)element.getEnclosingElement();
        for (Element object2 : compilationInfo.getElements().getAllMembers(typeElement)) {
            if (this.stop) {
                return null;
            }
            if (!compilationInfo.getElements().hides(element, object2)) continue;
            element2 = object2;
            break;
        }
        if (element2 == null) {
            return null;
        }
        Object object3 = compilationInfo.getTreeUtilities().findNameSpan((VariableTree)treePath.getLeaf());
        if (object3 == null) {
            return null;
        }
        List<Fix> list = Collections.singletonList(new FixImpl((int)((object3[1] + object3[0]) / 2), compilationInfo.getFileObject(), false));
        nArray[0] = (int)object3[0];
        nArray[1] = (int)object3[1];
        return list;
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        int[] nArray = new int[2];
        List<Fix> list = this.computeFixes(compilationInfo, treePath, nArray);
        if (list == null) {
            return null;
        }
        ErrorDescription errorDescription = ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)this.getDisplayName(), list, (FileObject)compilationInfo.getFileObject(), (int)nArray[0], (int)nArray[1]);
        return Collections.singletonList(errorDescription);
    }

    @Override
    public String getId() {
        return this.getClass().getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(DoubleCheck.class, (String)"MSG_HiddenField");
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(DoubleCheck.class, (String)"HINT_HiddenField");
    }

    @Override
    public void cancel() {
        this.stop = true;
    }

    public Preferences getPreferences() {
        return null;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    static class FixImpl
    implements Fix,
    Runnable {
        private final int caret;
        private final FileObject file;
        private final boolean hideFieldByVariable;

        public FixImpl(int n, FileObject fileObject, boolean bl) {
            this.caret = n;
            this.file = fileObject;
            this.hideFieldByVariable = bl;
        }

        public String getText() {
            return this.hideFieldByVariable ? NbBundle.getMessage(DoubleCheck.class, (String)"MSG_FixHiddenByVariableFiledText") : NbBundle.getMessage(DoubleCheck.class, (String)"MSG_FixHiddenFiledText");
        }

        public ChangeInfo implement() throws IOException {
            SwingUtilities.invokeLater(this);
            return null;
        }

        @Override
        public void run() {
            try {
                EditorCookie editorCookie = (EditorCookie)DataObject.find((FileObject)this.file).getLookup().lookup(EditorCookie.class);
                if (editorCookie == null) {
                    return;
                }
                JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
                if (jEditorPaneArray == null) {
                    return;
                }
                jEditorPaneArray[0].setCaretPosition(this.caret);
                InstantRenamePerformer.invokeInstantRename((JTextComponent)jEditorPaneArray[0]);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            }
        }

        public String toString() {
            return "FixHideField";
        }

        public void cancel() {
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            FixImpl fixImpl = (FixImpl)object;
            if (this.caret != fixImpl.caret) {
                return false;
            }
            if (!(this.file == fixImpl.file || this.file != null && this.file.equals(fixImpl.file))) {
                return false;
            }
            return this.hideFieldByVariable == fixImpl.hideFieldByVariable;
        }

        public int hashCode() {
            int n = 7;
            n = 17 * n + this.caret;
            n = 17 * n + (this.file != null ? this.file.hashCode() : 0);
            n = 17 * n + (this.hideFieldByVariable ? 1 : 0);
            return n;
        }
    }
}

