/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Stack;
import javax.microedition.m2g.SVGImage;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.netbeans.modules.mobility.svgcore.composer.ComposerAction;
import org.netbeans.modules.mobility.svgcore.composer.InputControlManager;
import org.netbeans.modules.mobility.svgcore.composer.PerseusController;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.view.svg.SVGImagePanel;
import org.netbeans.modules.mobility.svgcore.view.svg.SVGStatusBar;
import org.openide.awt.MouseUtils;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.w3c.dom.svg.SVGLocatableElement;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGSVGElement;

public final class ScreenManager {
    private static final Color VIEWBOXBORDER_COLOR = Color.DARK_GRAY;
    private static final float MINIMUM_ZOOM = 0.01f;
    private static final float MAXIMUM_ZOOM = 100.0f;
    private final SceneManager m_sceneMgr;
    private final SVGStatusBar m_statusBar;
    private JScrollPane m_topComponent;
    private JComponent m_animatorView;
    private SVGImagePanel m_imageContainer;
    private Cursor m_cursor;
    private boolean m_showAllArea;
    private boolean m_landscapeMode;
    private boolean m_showTooltip;
    private boolean m_highlightObject;
    private short m_changeTicker = 0;

    ScreenManager(SceneManager sceneMgr) {
        this.m_sceneMgr = sceneMgr;
        this.m_statusBar = new SVGStatusBar();
        this.m_showAllArea = false;
        this.m_landscapeMode = false;
        this.m_showTooltip = true;
        this.m_highlightObject = true;
    }

    void initialize() {
        PerseusController perseus = this.m_sceneMgr.getPerseusController();
        this.m_animatorView = perseus.getAnimatorGUI();
        this.m_imageContainer = new SVGImagePanel(this.m_animatorView){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void paintPanel(Graphics g, int x, int y) {
                PerseusController perseus = ScreenManager.this.m_sceneMgr.getPerseusController();
                if (perseus != null) {
                    Stack<ComposerAction> actions;
                    SVGLocatableElement elem;
                    if (ScreenManager.this.m_showAllArea && (elem = perseus.getViewBoxMarker()) != null) {
                        SVGRect rect = elem.getScreenBBox();
                        g.setColor(VIEWBOXBORDER_COLOR);
                        g.drawRect((int)((float)x + rect.getX()), (int)((float)y + rect.getY()), (int)rect.getWidth(), (int)rect.getHeight() - 1);
                    }
                    boolean isReadOnly = ScreenManager.this.m_sceneMgr.isReadOnly();
                    Stack<ComposerAction> stack = actions = ScreenManager.this.m_sceneMgr.getActiveActions();
                    synchronized (stack) {
                        for (int i = actions.size() - 1; i >= 0; --i) {
                            ((ComposerAction)actions.get(i)).paint(g, x, y, isReadOnly);
                        }
                    }
                }
            }
        };
        this.m_topComponent = new JScrollPane(this.m_imageContainer);
        this.incrementChangeTicker();
    }

    public void reset() {
        this.m_topComponent = null;
        this.m_animatorView = null;
        this.m_imageContainer = null;
        this.m_cursor = null;
    }

    public SVGStatusBar getStatusBar() {
        return this.m_statusBar;
    }

    void registerMouseController(InputControlManager.MouseController mouseListener) {
        this.m_animatorView.addMouseListener(mouseListener);
        this.m_animatorView.addMouseMotionListener(mouseListener);
        this.m_imageContainer.addMouseListener(mouseListener);
    }

    public void registerKeyController(KeyListener keyListener) {
        this.m_animatorView.addKeyListener(keyListener);
    }

    public void registerPopupMenu(final Action[] popupActions, final Lookup lookup) {
        this.m_imageContainer.addMouseListener((MouseListener)new MouseUtils.PopupMouseAdapter(){

            protected void showPopup(MouseEvent e) {
                JPopupMenu popup = Utilities.actionsToPopup((Action[])popupActions, (Lookup)lookup);
                popup.show(ScreenManager.this.m_imageContainer, e.getX(), e.getY());
            }
        });
        this.m_animatorView.addMouseListener((MouseListener)new MouseUtils.PopupMouseAdapter(){

            protected void showPopup(MouseEvent e) {
                ScreenManager.this.m_sceneMgr.popupAt(e.getX(), e.getY());
                JPopupMenu popup = Utilities.actionsToPopup((Action[])popupActions, (Lookup)lookup);
                popup.show(ScreenManager.this.m_animatorView, e.getX(), e.getY());
            }
        });
    }

    public JComponent getComponent() {
        return this.m_topComponent;
    }

    public JComponent getAnimatorView() {
        return this.m_animatorView;
    }

    public Rectangle getImageBounds() {
        return this.m_animatorView.getBounds();
    }

    public void repaint(int x, int y, int w, int h) {
        this.m_animatorView.repaint(x, y, w, h);
    }

    public void repaint(Rectangle rect) {
        this.m_animatorView.repaint(rect);
    }

    public void repaint(Rectangle rect, int overlap) {
        this.m_animatorView.repaint(rect.x - overlap, rect.y - overlap, rect.width + 2 * overlap, rect.height + 2 * overlap);
    }

    public void setCursor(Cursor cursor) {
        if (this.m_cursor != cursor) {
            this.m_animatorView.setCursor(cursor);
            this.m_cursor = cursor;
        }
    }

    public void setShowAllArea(boolean showAllArea) {
        if (showAllArea != this.m_showAllArea) {
            this.m_showAllArea = showAllArea;
            this.refresh();
            this.incrementChangeTicker();
        }
    }

    public boolean getShowAllArea() {
        return this.m_showAllArea;
    }

    public void setLandscapeMode(boolean landscapeMode) {
        if (landscapeMode != this.m_landscapeMode) {
            this.m_landscapeMode = landscapeMode;
            this.incrementChangeTicker();
        }
    }

    public boolean isLandscapeMode() {
        return this.m_landscapeMode;
    }

    public boolean setShowTooltip(boolean showTooltip) {
        boolean oldValue = this.m_showTooltip;
        this.m_showTooltip = showTooltip;
        return oldValue;
    }

    public boolean getShowTooltip() {
        return this.m_showTooltip;
    }

    public boolean setHighlightObject(boolean highlightObject) {
        if (highlightObject != this.m_highlightObject) {
            this.m_highlightObject = highlightObject;
            this.repaint();
            return !highlightObject;
        }
        return highlightObject;
    }

    public boolean getHighlightObject() {
        return this.m_highlightObject;
    }

    public float getZoomRatio() {
        return this.m_sceneMgr.m_zoomRatio;
    }

    public void setZoomRatio(float zoomRatio) {
        if (zoomRatio < 0.01f) {
            zoomRatio = 0.01f;
        } else if (zoomRatio > 100.0f) {
            zoomRatio = 100.0f;
        }
        if (zoomRatio != this.m_sceneMgr.m_zoomRatio) {
            this.m_sceneMgr.m_zoomRatio = zoomRatio;
            this.refresh();
            this.incrementChangeTicker();
        }
    }

    public void repaint() {
        this.m_imageContainer.setTryPaint();
        this.m_animatorView.invalidate();
        this.m_topComponent.validate();
        this.m_animatorView.repaint();
        this.m_topComponent.repaint();
    }

    public void refresh() {
        Dimension size;
        if (this.m_sceneMgr.getPerseusController() == null) {
            return;
        }
        SVGSVGElement svg = this.m_sceneMgr.getPerseusController().getSVGRootElement();
        SVGRect viewBoxRect = svg.getRectTrait("viewBox");
        SVGPoint translatePoint = svg.getCurrentTranslate();
        SVGRect rect = null;
        boolean showAll = viewBoxRect == null ? true : this.m_showAllArea;
        translatePoint.setX(0.0f);
        translatePoint.setY(0.0f);
        svg.setCurrentScale(1.0f);
        SVGRect sVGRect = rect = showAll ? svg.getBBox() : viewBoxRect;
        if (rect != null) {
            size = new Dimension((int)(rect.getWidth() * this.m_sceneMgr.m_zoomRatio), (int)(rect.getHeight() * this.m_sceneMgr.m_zoomRatio));
            SVGImage svgImage = this.m_sceneMgr.getSVGImage();
            svgImage.setViewportWidth(size.width);
            svgImage.setViewportHeight(size.height);
            if (showAll) {
                if (viewBoxRect != null) {
                    double xRatio = viewBoxRect.getWidth() / rect.getWidth();
                    double yRatio = viewBoxRect.getHeight() / rect.getHeight();
                    float ratio = (float)Math.max(xRatio, yRatio);
                    svg.setCurrentScale(ratio);
                }
                SVGRect screenBBox = svg.getScreenBBox();
                translatePoint.setX(-screenBBox.getX());
                translatePoint.setY(-screenBBox.getY());
            }
        } else {
            size = new Dimension(100, 100);
        }
        this.m_animatorView.setSize(size);
        this.repaint();
    }

    public short getChangeTicker() {
        return this.m_changeTicker;
    }

    public void incrementChangeTicker() {
        this.m_changeTicker = (short)(this.m_changeTicker + 1);
        if (this.m_changeTicker < 0) {
            this.m_changeTicker = 0;
        }
    }
}

