/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.coveragedata;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.sourceforge.cobertura.coveragedata.BranchCoverageData;
import net.sourceforge.cobertura.coveragedata.HasBeenInstrumented;

public class JumpData
implements BranchCoverageData,
Comparable,
Serializable,
HasBeenInstrumented {
    private static final long serialVersionUID = 8L;
    protected transient Lock lock;
    private int conditionNumber;
    private long trueHits;
    private long falseHits;

    JumpData(int conditionNumber) {
        this.conditionNumber = conditionNumber;
        this.trueHits = 0L;
        this.falseHits = 0L;
        this.initLock();
    }

    private void initLock() {
        this.lock = new ReentrantLock();
    }

    public int compareTo(Object o) {
        if (!o.getClass().equals(JumpData.class)) {
            return Integer.MAX_VALUE;
        }
        return this.conditionNumber - ((JumpData)o).conditionNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void touchBranch(boolean branch) {
        this.lock.lock();
        try {
            if (branch) {
                ++this.trueHits;
            } else {
                ++this.falseHits;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getConditionNumber() {
        return this.conditionNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTrueHits() {
        this.lock.lock();
        try {
            long l = this.trueHits;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFalseHits() {
        this.lock.lock();
        try {
            long l = this.falseHits;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getBranchCoverageRate() {
        this.lock.lock();
        try {
            double d = (double)this.getNumberOfCoveredBranches() / (double)this.getNumberOfValidBranches();
            return d;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        JumpData branchData = (JumpData)obj;
        this.getBothLocks(branchData);
        try {
            boolean bl = this.trueHits == branchData.trueHits && this.falseHits == branchData.falseHits && this.conditionNumber == branchData.conditionNumber;
            return bl;
        }
        finally {
            this.lock.unlock();
            branchData.lock.unlock();
        }
    }

    public int hashCode() {
        return this.conditionNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfCoveredBranches() {
        this.lock.lock();
        try {
            int n = (this.trueHits > 0L ? 1 : 0) + (this.falseHits > 0L ? 1 : 0);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getNumberOfValidBranches() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(BranchCoverageData coverageData) {
        JumpData jumpData = (JumpData)coverageData;
        this.getBothLocks(jumpData);
        try {
            this.trueHits += jumpData.trueHits;
            this.falseHits += jumpData.falseHits;
        }
        finally {
            this.lock.unlock();
            jumpData.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getBothLocks(JumpData other) {
        boolean myLock = false;
        boolean otherLock = false;
        while (!myLock || !otherLock) {
            try {
                myLock = this.lock.tryLock();
                otherLock = other.lock.tryLock();
            }
            finally {
                if (myLock && otherLock) continue;
                if (myLock) {
                    this.lock.unlock();
                }
                if (otherLock) {
                    other.lock.unlock();
                }
                Thread.yield();
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initLock();
    }
}

