/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;

public class ToggleCommentAction
extends ExtKit.ToggleCommentAction {
    public ToggleCommentAction() {
        super("");
    }

    public void actionPerformed(ActionEvent evt, final JTextComponent target) {
        if (target != null) {
            if (!target.isEditable() || !target.isEnabled()) {
                target.getToolkit().beep();
                return;
            }
            final BaseDocument doc = (BaseDocument)target.getDocument();
            final Caret caret = target.getCaret();
            TokenHierarchy th = TokenHierarchy.get((Document)doc);
            if (th == null) {
                return;
            }
            final TokenSequence ts = th.tokenSequence();
            boolean isCommented = true;
            doc.runAtomicAsUser(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (caret.isSelectionVisible()) {
                            int startPos = Utilities.getRowStart((BaseDocument)doc, (int)target.getSelectionStart());
                            int endPos = target.getSelectionEnd();
                            if (endPos > 0 && Utilities.getRowStart((BaseDocument)doc, (int)endPos) == endPos) {
                                --endPos;
                            }
                            int lineCnt = Utilities.getRowCount((BaseDocument)doc, (int)startPos, (int)endPos);
                            ArrayList<String> mimeTypes = new ArrayList<String>(lineCnt);
                            int pos = startPos;
                            boolean commented = true;
                            for (int x = lineCnt; x > 0; --x) {
                                String mimeType = ToggleCommentAction.this.getRealMimeType(ts, pos);
                                mimeTypes.add(mimeType);
                                commented = commented && ToggleCommentAction.this.isCommentedLine(doc, mimeType, pos);
                                pos = Utilities.getRowStart((BaseDocument)doc, (int)pos, (int)1);
                            }
                            pos = startPos;
                            Iterator iter = mimeTypes.iterator();
                            while (iter.hasNext()) {
                                if (commented) {
                                    ToggleCommentAction.this.uncommentLine(doc, (String)iter.next(), pos);
                                } else {
                                    ToggleCommentAction.this.commentLine(doc, (String)iter.next(), pos);
                                }
                                pos = Utilities.getRowStart((BaseDocument)doc, (int)pos, (int)1);
                            }
                        } else {
                            int pos = Utilities.getRowStart((BaseDocument)doc, (int)target.getSelectionStart());
                            String mt = ToggleCommentAction.this.getRealMimeType(ts, pos);
                            if (ToggleCommentAction.this.isCommentedLine(doc, mt, pos)) {
                                ToggleCommentAction.this.uncommentLine(doc, mt, pos);
                            } else {
                                ToggleCommentAction.this.commentLine(doc, mt, pos);
                            }
                        }
                    }
                    catch (BadLocationException e) {
                        target.getToolkit().beep();
                    }
                }
            });
        }
    }

    private String getRealMimeType(TokenSequence ts, int offset) {
        while (true) {
            ts.move(offset);
            if (!ts.moveNext()) break;
            offset = ts.offset();
            TokenSequence ts2 = ts.embedded();
            if (ts2 == null) break;
            ts = ts2;
        }
        return ts.language().mimeType();
    }

    private void commentLine(BaseDocument doc, String mimeType, int offset) throws BadLocationException {
        Feature feature = null;
        try {
            Language language = LanguagesManager.getDefault().getLanguage(mimeType);
            feature = language.getFeatureList().getFeature("COMMENT_LINE");
        }
        catch (LanguageDefinitionNotFoundException e) {
            // empty catch block
        }
        if (feature != null) {
            String prefix = (String)feature.getValue("prefix");
            if (prefix == null) {
                return;
            }
            String suffix = (String)feature.getValue("suffix");
            if (suffix != null) {
                int end = Utilities.getRowEnd((BaseDocument)doc, (int)offset);
                doc.insertString(end, suffix, null);
            }
            doc.insertString(offset, prefix, null);
        }
    }

    private void uncommentLine(BaseDocument doc, String mimeType, int offset) throws BadLocationException {
        Feature feature = null;
        try {
            Language language = LanguagesManager.getDefault().getLanguage(mimeType);
            feature = language.getFeatureList().getFeature("COMMENT_LINE");
        }
        catch (LanguageDefinitionNotFoundException e) {
            // empty catch block
        }
        if (feature != null) {
            int firstNonWhitePos;
            CharSequence maybeLineComment;
            int commentLen;
            int lastNonWhitePos;
            String prefix = (String)feature.getValue("prefix");
            if (prefix == null) {
                return;
            }
            String suffix = (String)feature.getValue("suffix");
            if (suffix != null && (lastNonWhitePos = Utilities.getRowLastNonWhite((BaseDocument)doc, (int)offset)) != -1) {
                commentLen = suffix.length();
                if (lastNonWhitePos - Utilities.getRowStart((BaseDocument)doc, (int)offset) >= commentLen && CharSequenceUtilities.textEquals((CharSequence)(maybeLineComment = DocumentUtilities.getText((Document)doc, (int)(lastNonWhitePos - commentLen + 1), (int)commentLen)), (CharSequence)suffix)) {
                    doc.remove(lastNonWhitePos - commentLen + 1, commentLen);
                }
            }
            if ((firstNonWhitePos = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset)) != -1) {
                commentLen = prefix.length();
                if (Utilities.getRowEnd((BaseDocument)doc, (int)firstNonWhitePos) - firstNonWhitePos >= prefix.length() && CharSequenceUtilities.textEquals((CharSequence)(maybeLineComment = DocumentUtilities.getText((Document)doc, (int)firstNonWhitePos, (int)commentLen)), (CharSequence)prefix)) {
                    doc.remove(firstNonWhitePos, commentLen);
                }
            }
        }
    }

    private boolean isCommentedLine(BaseDocument doc, String mimeType, int offset) throws BadLocationException {
        Feature feature = null;
        boolean suffixCommentOk = false;
        boolean prefixCommentOk = false;
        try {
            Language language = LanguagesManager.getDefault().getLanguage(mimeType);
            feature = language.getFeatureList().getFeature("COMMENT_LINE");
        }
        catch (LanguageDefinitionNotFoundException e) {
            // empty catch block
        }
        if (feature != null) {
            CharSequence maybeLineComment;
            int commentLen;
            String prefix = (String)feature.getValue("prefix");
            if (prefix == null) {
                return true;
            }
            String suffix = (String)feature.getValue("suffix");
            if (suffix != null) {
                int lastNonWhitePos = Utilities.getRowLastNonWhite((BaseDocument)doc, (int)offset);
                if (lastNonWhitePos != -1) {
                    commentLen = suffix.length();
                    if (lastNonWhitePos - Utilities.getRowStart((BaseDocument)doc, (int)offset) >= commentLen && CharSequenceUtilities.textEquals((CharSequence)(maybeLineComment = DocumentUtilities.getText((Document)doc, (int)(lastNonWhitePos - commentLen + 1), (int)commentLen)), (CharSequence)suffix)) {
                        suffixCommentOk = true;
                    }
                }
            } else {
                suffixCommentOk = true;
            }
            int firstNonWhitePos = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset);
            if (firstNonWhitePos != -1) {
                commentLen = prefix.length();
                if (Utilities.getRowEnd((BaseDocument)doc, (int)firstNonWhitePos) - firstNonWhitePos >= prefix.length() && CharSequenceUtilities.textEquals((CharSequence)(maybeLineComment = DocumentUtilities.getText((Document)doc, (int)firstNonWhitePos, (int)commentLen)), (CharSequence)prefix)) {
                    prefixCommentOk = true;
                }
            }
            return prefixCommentOk && suffixCommentOk;
        }
        return true;
    }
}

