/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.io.Serializable;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;

class StateHolderSaver
implements Serializable {
    private static final long serialVersionUID = 6470180891722042701L;
    private String className = null;
    private Serializable savedState = null;

    public StateHolderSaver(FacesContext context, Object toSave) {
        this.className = toSave.getClass().getName();
        if (toSave instanceof StateHolder) {
            if (!((StateHolder)toSave).isTransient()) {
                this.savedState = (Serializable)((StateHolder)toSave).saveState(context);
            } else {
                this.className = null;
            }
        } else if (toSave instanceof Serializable) {
            this.savedState = (Serializable)toSave;
            this.className = null;
        }
    }

    public Object restore(FacesContext context) throws IllegalStateException {
        Class toRestoreClass;
        Object result = null;
        if (null == this.className && null != this.savedState) {
            return this.savedState;
        }
        if (this.className == null) {
            return null;
        }
        try {
            toRestoreClass = StateHolderSaver.loadClass(this.className, this);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e.getMessage());
        }
        if (null != toRestoreClass) {
            try {
                result = toRestoreClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalStateException(e.getMessage());
            }
            catch (IllegalAccessException a) {
                throw new IllegalStateException(a.getMessage());
            }
        }
        if (null != result && null != this.savedState && result instanceof StateHolder) {
            ((StateHolder)result).restoreState(context, this.savedState);
        }
        return result;
    }

    private static Class loadClass(String name, Object fallbackClass) throws ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = fallbackClass.getClass().getClassLoader();
        }
        return Class.forName(name, false, loader);
    }
}

