/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.ui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.netbeans.modules.ruby.rubyproject.ui.wizards.NewRubyProjectWizardIterator;
import org.netbeans.modules.ruby.rubyproject.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.ruby.rubyproject.ui.wizards.PanelOptionsVisual;
import org.netbeans.modules.ruby.rubyproject.ui.wizards.PanelProjectLocationExtSrc;
import org.netbeans.modules.ruby.rubyproject.ui.wizards.PanelProjectLocationVisual;
import org.netbeans.modules.ruby.rubyproject.ui.wizards.SettingsPanel;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.NbBundle;

public final class PanelConfigureProjectVisual
extends JPanel {
    private final SettingsPanel projectLocationPanel;
    private final PanelOptionsVisual optionsPanel;
    private final NewRubyProjectWizardIterator.Type type;
    private JSeparator jSeparator1;
    private JPanel locationContainer;
    private JPanel optionsContainer;

    PanelConfigureProjectVisual(PanelConfigureProject panel, NewRubyProjectWizardIterator.Type type) {
        this.initComponents();
        this.type = type;
        this.setName(NbBundle.getMessage(PanelConfigureProjectVisual.class, (String)"TXT_NameAndLoc"));
        switch (type) {
            case APPLICATION: {
                this.projectLocationPanel = new PanelProjectLocationVisual(panel, type);
                this.putClientProperty("NewProjectWizard_Title", NbBundle.getMessage(PanelConfigureProjectVisual.class, (String)"TXT_NewJavaApp"));
                this.jSeparator1.setVisible(true);
                this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelConfigureProjectVisual.class, (String)"TXT_NewJavaApp"));
                this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelConfigureProjectVisual.class, (String)"ACSD_NewJavaApp"));
                break;
            }
            case EXISTING: {
                this.projectLocationPanel = new PanelProjectLocationExtSrc(panel);
                this.jSeparator1.setVisible(true);
                this.putClientProperty("NewProjectWizard_Title", NbBundle.getMessage(PanelConfigureProjectVisual.class, (String)"TXT_JavaExtSourcesProjectLocation"));
                this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelConfigureProjectVisual.class, (String)"TXT_JavaExtSourcesProjectLocation"));
                this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelConfigureProjectVisual.class, (String)"ACSD_JavaExtSourcesProjectLocation"));
                break;
            }
            default: {
                throw new IllegalStateException("unknown type: " + (Object)((Object)type));
            }
        }
        this.locationContainer.add((Component)this.projectLocationPanel, "Center");
        this.optionsPanel = new PanelOptionsVisual(panel, type);
        this.projectLocationPanel.addPropertyChangeListener(this.optionsPanel);
        this.optionsContainer.add((Component)this.optionsPanel, "Center");
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
        return this.projectLocationPanel.valid(wizardDescriptor) && this.optionsPanel.valid(wizardDescriptor);
    }

    void read(WizardDescriptor d) {
        NewRubyProjectWizardIterator.Type lastType = (NewRubyProjectWizardIterator.Type)((Object)d.getProperty("ruby-wizard-type"));
        if (lastType == null || lastType != this.type) {
            d.putProperty("name", null);
            d.putProperty("projdir", null);
            d.putProperty("platform", null);
        }
        this.projectLocationPanel.read(d);
        this.optionsPanel.read(d);
    }

    void store(WizardDescriptor d) {
        d.putProperty("ruby-wizard-type", (Object)this.type);
        this.projectLocationPanel.store(d);
        this.optionsPanel.store(d);
    }

    void validate(WizardDescriptor d) throws WizardValidationException {
        this.projectLocationPanel.validate(d);
    }

    private void initComponents() {
        this.locationContainer = new JPanel();
        this.jSeparator1 = new JSeparator();
        this.optionsContainer = new JPanel();
        this.setLayout(new GridBagLayout());
        this.locationContainer.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.locationContainer, gridBagConstraints);
        this.locationContainer.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelConfigureProjectVisual.class).getString("ACSN_locationContainer"));
        this.locationContainer.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelConfigureProjectVisual.class).getString("ACSD_locationContainer"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 12, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.optionsContainer.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.optionsContainer, gridBagConstraints);
        this.optionsContainer.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelConfigureProjectVisual.class).getString("ACSN_optionsContainer"));
        this.optionsContainer.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelConfigureProjectVisual.class).getString("ACSD_optionsContainer"));
    }
}

