/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.api;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.ObjectStreamException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.netbeans.modules.gsf.testrunner.api.StatisticsPanel;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.IOContainer;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class ResultWindow
extends TopComponent {
    private static final String ID = "gsf-testrunner-results";
    private static WeakReference<ResultWindow> instance = null;
    private JSplitPane view;
    private Object lookup;
    private boolean activated;
    private JComponent outputComp;
    private JComponent outputTab;
    private IOContainer ioContainer;

    public static ResultWindow getInstance() {
        final ResultWindow[] result = new ResultWindow[1];
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        result[0] = ResultWindow.getResultWindow();
                    }
                });
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            result[0] = ResultWindow.getResultWindow();
        }
        return result[0];
    }

    private static synchronized ResultWindow getResultWindow() {
        ResultWindow result = (ResultWindow)WindowManager.getDefault().findTopComponent(ID);
        if (result == null) {
            result = ResultWindow.getDefault();
        }
        return result;
    }

    public static synchronized ResultWindow getDefault() {
        ResultWindow window;
        ResultWindow resultWindow = window = instance != null ? (ResultWindow)((Object)instance.get()) : null;
        if (window == null) {
            window = new ResultWindow();
            window.initActions();
            instance = new WeakReference<ResultWindow>(window);
        }
        return window;
    }

    private void initActions() {
        ActionMap actions = this.getActionMap();
        actions.put("jumpNext", new PrevNextFailure(true));
        actions.put("jumpPrev", new PrevNextFailure(false));
    }

    public ResultWindow() {
        this.setFocusable(true);
        this.setLayout(new BorderLayout());
        this.setName(ID);
        this.setDisplayName(NbBundle.getMessage(ResultWindow.class, (String)"TITLE_TEST_RESULTS"));
        this.setIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/testResults.png", (boolean)true));
        AccessibleContext accessibleContext = this.getAccessibleContext();
        accessibleContext.setAccessibleName(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ACSN_TestResults"));
        accessibleContext.setAccessibleDescription(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ACSD_TestResults"));
    }

    public void addDisplayComponent(JSplitPane displayComp, Lookup l) {
        assert (EventQueue.isDispatchThread());
        this.removeAll();
        this.addView(displayComp);
        this.lookup = new WeakReference<Lookup>(l);
        this.revalidate();
    }

    private void addView(JSplitPane view) {
        assert (EventQueue.isDispatchThread());
        this.view = view;
        view.setMinimumSize(new Dimension(0, 0));
        this.add(view);
    }

    private boolean isActivated() {
        return TopComponent.getRegistry().getActivated() == this;
    }

    public void promote() {
        assert (EventQueue.isDispatchThread());
        this.open();
        this.requestVisible();
    }

    public void setOrientation(int orientation) {
        if (this.view == null) {
            return;
        }
        if (this.view.getOrientation() != orientation) {
            this.view.setOrientation(orientation);
        }
    }

    protected String preferredID() {
        return ID;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(((Object)((Object)this)).getClass());
    }

    public int getPersistenceType() {
        return 0;
    }

    public Lookup getLookup() {
        Object l;
        if (this.lookup == null) {
            return super.getLookup();
        }
        if (this.lookup instanceof Reference && (l = ((Reference)this.lookup).get()) instanceof Lookup) {
            return (Lookup)l;
        }
        return Lookup.EMPTY;
    }

    private Object readResolve() throws ObjectStreamException {
        return ResultWindow.getDefault();
    }

    IOContainer getIOContainer() {
        if (this.ioContainer == null) {
            this.ioContainer = IOContainer.create((IOContainer.Provider)new IOContainerImpl());
        }
        return this.ioContainer;
    }

    void setOutputComp(JComponent comp) {
        this.outputComp = comp;
    }

    protected void componentActivated() {
        this.activated = true;
    }

    protected void componentDeactivated() {
        this.activated = false;
    }

    private static final class PrevNextFailure
    extends AbstractAction {
        private final boolean next;

        public PrevNextFailure(boolean next) {
            this.next = next;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JSplitPane view = ResultWindow.getInstance().view;
            if (view == null || !(view.getLeftComponent() instanceof StatisticsPanel)) {
                return;
            }
            StatisticsPanel statisticsPanel = (StatisticsPanel)view.getLeftComponent();
            if (this.next) {
                statisticsPanel.selectNextFailure();
            } else {
                statisticsPanel.selectPreviousFailure();
            }
        }
    }

    private class IOContainerImpl
    implements IOContainer.Provider {
        private IOContainerImpl() {
        }

        public void remove(JComponent comp) {
            ResultWindow.this.outputTab = null;
            ResultWindow.this.outputComp.remove(comp);
            ResultWindow.getInstance().close();
        }

        public void select(JComponent comp) {
        }

        public JComponent getSelected() {
            return ResultWindow.this.outputTab;
        }

        public boolean isActivated() {
            return ResultWindow.this.activated;
        }

        public void open() {
        }

        public void requestActive() {
        }

        public void requestVisible() {
        }

        public void setIcon(JComponent comp, Icon icon) {
        }

        public void setTitle(JComponent comp, String name) {
        }

        public void setToolTipText(JComponent comp, String name) {
        }

        public void add(JComponent comp, IOContainer.CallBacks cb) {
            ResultWindow.this.outputTab = comp;
            ResultWindow.this.outputComp.add(comp);
        }

        public void setToolbarActions(JComponent comp, Action[] toolbarActions) {
        }

        public boolean isCloseable(JComponent comp) {
            return false;
        }
    }
}

