/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.api;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.accessibility.AccessibleContext;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.gsf.testrunner.api.ResultDisplayHandler;
import org.netbeans.modules.gsf.testrunner.output.OutputDocument;
import org.netbeans.modules.gsf.testrunner.output.OutputEditorKit;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

final class ResultPanelOutput
extends JScrollPane
implements ActionListener {
    private static final boolean LOG = false;
    static final Color selectedFg;
    static final Color unselectedFg;
    static final Color selectedErr;
    static final Color unselectedErr;
    private static final int UPDATE_DELAY = 300;
    private final JEditorPane textPane = new JEditorPane();
    private final Document doc;
    private final ResultDisplayHandler displayHandler;
    private Timer timer = null;
    private volatile boolean timerRunning = false;

    ResultPanelOutput(ResultDisplayHandler displayHandler) {
        this.textPane.setFont(new Font("monospaced", 0, this.getFont().getSize()));
        this.textPane.setEditorKit(new OutputEditorKit());
        this.textPane.setEditable(false);
        this.textPane.getCaret().setVisible(true);
        this.textPane.getCaret().setBlinkRate(0);
        this.textPane.setCursor(Cursor.getPredefinedCursor(2));
        this.setViewportView(this.textPane);
        Color background = UIManager.getColor("TextPane.background");
        if (background != null) {
            this.textPane.setBackground(background);
        }
        this.doc = this.textPane.getDocument();
        AccessibleContext accessibleContext = this.textPane.getAccessibleContext();
        accessibleContext.setAccessibleName(NbBundle.getMessage(this.getClass(), (String)"ACSN_OutputTextPane"));
        accessibleContext.setAccessibleDescription(NbBundle.getMessage(this.getClass(), (String)"ACSD_OutputTextPane"));
        this.displayHandler = displayHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        Object[] pendingOutput;
        super.addNotify();
        Object object = this.displayHandler.getOutputQueueLock();
        synchronized (object) {
            pendingOutput = this.displayHandler.consumeOutput();
            if (pendingOutput.length == 0) {
                // empty if block
            }
        }
        if (pendingOutput.length != 0) {
            this.displayOutput(pendingOutput);
            this.startTimer();
        }
    }

    void outputAvailable() {
        Object[] pendingOutput = this.displayHandler.consumeOutput();
        assert (pendingOutput.length != 0);
        new OutputDisplayer(pendingOutput).run();
        if (!this.timerRunning) {
            this.startTimer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        assert (EventQueue.isDispatchThread());
        Object[] pendingOutput = this.displayHandler.consumeOutput();
        if (pendingOutput.length != 0) {
            this.displayOutput(pendingOutput);
        } else {
            Object object = this.displayHandler.getOutputQueueLock();
            synchronized (object) {
                this.stopTimer();
            }
        }
    }

    private void startTimer() {
        if (this.timer == null) {
            this.timer = new Timer(300, this);
        }
        this.timerRunning = true;
        this.timer.start();
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.stop();
            this.timerRunning = false;
        }
    }

    void displayOutput(Object[] output) {
        Object o;
        assert (EventQueue.isDispatchThread());
        int index = 0;
        while ((o = output[index++]) != null) {
            boolean errOutput = false;
            if (o == Boolean.TRUE) {
                o = output[index++];
                errOutput = true;
            }
            this.displayOutputLine(o.toString(), errOutput);
        }
    }

    private void displayOutputLine(String text, boolean error) {
        String[] lines = text.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            if (i == lines.length - 1) {
                lines[i] = lines[i] + "\n";
            }
            try {
                this.doc.insertString(this.doc.getLength(), lines[i], error ? OutputDocument.attrs : null);
                continue;
            }
            catch (BadLocationException ex) {
                ErrorManager.getDefault().notify(65536, (Throwable)ex);
            }
        }
    }

    private void clear() {
        assert (EventQueue.isDispatchThread());
        try {
            this.doc.remove(0, this.doc.getLength());
        }
        catch (BadLocationException ex) {
            ErrorManager.getDefault().notify(65536, (Throwable)ex);
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.textPane.requestFocusInWindow();
    }

    static {
        Color color = UIManager.getColor("nb.output.foreground.selected");
        if (color == null && (color = UIManager.getColor("textText")) == null) {
            color = Color.BLACK;
        }
        selectedFg = color;
        color = UIManager.getColor("nb.output.foreground");
        if (color == null) {
            color = selectedFg;
        }
        unselectedFg = color;
        color = UIManager.getColor("nb.output.err.foreground.selected");
        if (color == null) {
            color = new Color(164, 0, 0);
        }
        selectedErr = color;
        color = UIManager.getColor("nb.output.err.foreground");
        if (color == null) {
            color = selectedErr;
        }
        unselectedErr = color;
    }

    final class OutputDisplayer
    implements Runnable {
        private final Object[] output;

        OutputDisplayer(Object[] output) {
            this.output = output;
        }

        @Override
        public void run() {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(this);
                return;
            }
            ResultPanelOutput.this.displayOutput(this.output);
        }
    }
}

