/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.newtable;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.css.style.Length;
import org.xhtmlrenderer.css.style.derived.BorderPropertySet;
import org.xhtmlrenderer.css.style.derived.RectPropertySet;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.newtable.ColumnData;
import org.xhtmlrenderer.newtable.TableCellBox;
import org.xhtmlrenderer.newtable.TableColumn;
import org.xhtmlrenderer.newtable.TableRowBox;
import org.xhtmlrenderer.newtable.TableSectionBox;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.PageBox;

public class TableBox
extends BlockBox {
    private List _columns = new ArrayList();
    private int[] _columnPos;
    private TableLayout _tableLayout;
    private List _styleColumns;
    private int _pageClearance;

    public void addStyleColumn(TableColumn col) {
        if (this._styleColumns == null) {
            this._styleColumns = new ArrayList();
        }
        this._styleColumns.add(col);
    }

    public List getStyleColumns() {
        return this._styleColumns == null ? Collections.EMPTY_LIST : this._styleColumns;
    }

    public int[] getColumnPos() {
        return this._columnPos;
    }

    private void setColumnPos(int[] columnPos) {
        this._columnPos = columnPos;
    }

    public int numEffCols() {
        return this._columns.size();
    }

    public int spanOfEffCol(int effCol) {
        return ((ColumnData)this._columns.get(effCol)).getSpan();
    }

    public int colToEffCol(int col) {
        int i;
        int c = 0;
        for (i = 0; c < col && i < this.numEffCols(); c += this.spanOfEffCol(i), ++i) {
        }
        return i;
    }

    public int effColToCol(int effCol) {
        int c = 0;
        for (int i = 0; i < effCol; ++i) {
            c += this.spanOfEffCol(i);
        }
        return c;
    }

    public void appendColumn(int span) {
        ColumnData data = new ColumnData();
        data.setSpan(span);
        this._columns.add(data);
        Iterator i = this.getChildIterator();
        while (i.hasNext()) {
            TableSectionBox section = (TableSectionBox)i.next();
            section.extendGridToColumnCount(this._columns.size());
        }
    }

    public void setStyle(CalculatedStyle style) {
        super.setStyle(style);
        this._tableLayout = this.getStyle().isIdent(CSSName.TABLE_LAYOUT, IdentValue.FIXED) ? new FixedTableLayout(this) : new AutoTableLayout(this);
    }

    public void calcMinMaxWidth(LayoutContext c) {
        if (!this.isMinMaxCalculated()) {
            this.recalcSections(c);
            if (this.getStyle().isCollapseBorders()) {
                this.calcBorders(c);
            }
            this._tableLayout.calcMinMaxWidth(c);
            this.setMinMaxCalculated(true);
        }
    }

    public void splitColumn(int pos, int firstSpan) {
        ColumnData newColumn = new ColumnData();
        newColumn.setSpan(firstSpan);
        this._columns.add(pos, newColumn);
        ColumnData leftOver = (ColumnData)this._columns.get(pos + 1);
        leftOver.setSpan(leftOver.getSpan() - firstSpan);
        Iterator i = this.getChildIterator();
        while (i.hasNext()) {
            TableSectionBox section = (TableSectionBox)i.next();
            section.splitColumn(pos);
        }
    }

    public int marginsBordersPaddingAndSpacing(CssContext c) {
        int result = 0;
        RectPropertySet margin = this.getMargin(c);
        result += (int)margin.left() + (int)margin.right();
        BorderPropertySet border = this.getBorder(c);
        result += (int)border.left() + (int)border.right();
        if (!this.getStyle().isCollapseBorders()) {
            RectPropertySet padding = this.getPadding(c);
            int hSpacing = this.getStyle().getBorderHSpacing(c);
            result = (int)((float)result + (padding.left() + padding.right() + (float)((this.numEffCols() + 1) * hSpacing)));
        }
        return result;
    }

    public List getColumns() {
        return this._columns;
    }

    private void recalcSections(LayoutContext c) {
        this.ensureChildren(c);
        Iterator i = this.getChildIterator();
        while (i.hasNext()) {
            TableSectionBox section = (TableSectionBox)i.next();
            section.recalcCells(c);
        }
    }

    private void calcBorders(LayoutContext c) {
        this.ensureChildren(c);
        Iterator i = this.getChildIterator();
        while (i.hasNext()) {
            TableSectionBox section = (TableSectionBox)i.next();
            section.calcBorders(c);
        }
    }

    public void layout(LayoutContext c) {
        this.calcMinMaxWidth(c);
        this.calcDimensions(c);
        this.calcWidth();
        this.calcPageClearance(c);
        if (!this.isAnonymous()) {
            this.setDimensionsCalculated(false);
            this.calcDimensions(c, this.getContentWidth());
        }
        this._tableLayout.layout(c);
        this.setCellWidths(c);
        super.layout(c);
    }

    private void calcPageClearance(LayoutContext c) {
        if (c.isPrint() && this.getStyle().isCollapseBorders()) {
            PageBox page = c.getRootLayer().getFirstPage(c, this);
            TableRowBox row = this.getFirstRow();
            if (row != null) {
                int spill = 0;
                Iterator i = row.getChildIterator();
                while (i.hasNext()) {
                    TableCellBox cell = (TableCellBox)i.next();
                    BorderPropertySet collapsed = cell.getCollapsedPaintingBorder();
                    int tmp = (int)collapsed.top() / 2;
                    if (tmp <= spill) continue;
                    spill = tmp;
                }
                int borderTop = this.getAbsY() + (int)this.getMargin(c).top() - spill;
                int delta = page.getTop() - borderTop;
                if (delta > 0) {
                    this.setY(this.getY() + delta);
                    this.setPageClearance(delta);
                    this.calcCanvasLocation();
                    c.translate(0, delta);
                }
            }
        }
    }

    private void calcWidth() {
        if (this.getMinWidth() > this.getWidth()) {
            this.setContentWidth(this.getContentWidth() + this.getMinWidth() - this.getWidth());
        } else if (this.getStyle().isIdent(CSSName.WIDTH, IdentValue.AUTO) && this.getMaxWidth() < this.getWidth()) {
            this.setContentWidth(this.getContentWidth() - (this.getWidth() - this.getMaxWidth()));
        }
    }

    public TableRowBox getFirstRow() {
        Iterator i = this.getChildIterator();
        while (i.hasNext()) {
            TableSectionBox section = (TableSectionBox)i.next();
            if (section.getChildCount() <= 0) continue;
            return (TableRowBox)section.getChild(0);
        }
        return null;
    }

    private void setCellWidths(LayoutContext c) {
        Iterator i = this.getChildIterator();
        while (i.hasNext()) {
            BlockBox box = (BlockBox)i.next();
            if (!box.getStyle().isTableSection()) continue;
            ((TableSectionBox)box).setCellWidths(c);
        }
    }

    protected void calcLayoutHeight(LayoutContext c, BorderPropertySet border, RectPropertySet margin, RectPropertySet padding) {
        super.calcLayoutHeight(c, border, margin, padding);
        if (this.getChildCount() > 0) {
            this.setHeight(this.getHeight() + this.getStyle().getBorderVSpacing(c));
        }
    }

    public void reset(LayoutContext c) {
        super.reset(c);
        this._tableLayout.reset();
    }

    protected int getCSSWidth(CssContext c) {
        if (this.getStyle().isAutoWidth()) {
            return -1;
        }
        int result = (int)this.getStyle().getFloatPropertyProportionalWidth(CSSName.WIDTH, this.getContainingBlock().getContentWidth(), c);
        BorderPropertySet border = this.getBorder(c);
        result -= (int)border.left() + (int)border.right();
        if (!this.getStyle().isCollapseBorders()) {
            RectPropertySet padding = this.getPadding(c);
            result -= (int)padding.left() + (int)padding.right();
        }
        return result >= 0 ? result : -1;
    }

    public TableColumn colElement(int col) {
        List styleColumns = this.getStyleColumns();
        if (styleColumns.size() == 0) {
            return null;
        }
        int cCol = 0;
        Iterator i = styleColumns.iterator();
        while (i.hasNext()) {
            TableColumn colElem = (TableColumn)i.next();
            int span = colElem.getStyle().getColSpan();
            if ((cCol += span) <= col) continue;
            return colElem;
        }
        return null;
    }

    public Rectangle getColumnBounds(CssContext c, int col) {
        int effCol = this.colToEffCol(col);
        int hspacing = this.getStyle().getBorderHSpacing(c);
        int vspacing = this.getStyle().getBorderVSpacing(c);
        Rectangle result = this.getContentAreaEdge(this.getAbsX(), this.getAbsY(), c);
        result.y += vspacing;
        result.height -= vspacing * 2;
        result.x += this._columnPos[effCol] + hspacing;
        return result;
    }

    public BorderPropertySet getBorder(CssContext cssCtx) {
        if (this.getStyle().isCollapseBorders()) {
            return BorderPropertySet.ALL_ZEROS;
        }
        return super.getBorder(cssCtx);
    }

    protected boolean isMayCollapseMarginsWithChildren() {
        return false;
    }

    protected TableSectionBox sectionAbove(TableSectionBox section, boolean skipEmptySections) {
        TableSectionBox prevSection = (TableSectionBox)section.getPreviousSibling();
        if (prevSection == null) {
            return null;
        }
        while (prevSection != null && prevSection.numRows() <= 0 && skipEmptySections) {
            prevSection = (TableSectionBox)prevSection.getPreviousSibling();
        }
        return prevSection;
    }

    protected TableSectionBox sectionBelow(TableSectionBox section, boolean skipEmptySections) {
        TableSectionBox nextSection = (TableSectionBox)section.getNextSibling();
        if (nextSection == null) {
            return null;
        }
        while (nextSection != null && nextSection.numRows() <= 0 && skipEmptySections) {
            nextSection = (TableSectionBox)nextSection.getNextSibling();
        }
        return nextSection;
    }

    protected TableCellBox cellAbove(TableCellBox cell) {
        int r = cell.getRow();
        TableSectionBox section = null;
        int rAbove = 0;
        if (r > 0) {
            section = cell.getSection();
            rAbove = r - 1;
        } else {
            section = this.sectionAbove(cell.getSection(), true);
            if (section != null) {
                rAbove = section.numRows() - 1;
            }
        }
        if (section != null) {
            TableCellBox aboveCell;
            int effCol = this.colToEffCol(cell.getCol());
            while ((aboveCell = section.cellAt(rAbove, effCol)) == TableCellBox.SPANNING_CELL && --effCol >= 0) {
            }
            return aboveCell == TableCellBox.SPANNING_CELL ? null : aboveCell;
        }
        return null;
    }

    protected TableCellBox cellBelow(TableCellBox cell) {
        int r = cell.getRow() + cell.getStyle().getRowSpan() - 1;
        TableSectionBox section = null;
        int rBelow = 0;
        if (r < cell.getSection().numRows() - 1) {
            section = cell.getSection();
            rBelow = r + 1;
        } else {
            section = this.sectionBelow(cell.getSection(), true);
            if (section != null) {
                rBelow = 0;
            }
        }
        if (section != null) {
            TableCellBox belowCell;
            int effCol = this.colToEffCol(cell.getCol());
            while ((belowCell = section.cellAt(rBelow, effCol)) == TableCellBox.SPANNING_CELL && --effCol >= 0) {
            }
            return belowCell == TableCellBox.SPANNING_CELL ? null : belowCell;
        }
        return null;
    }

    protected TableCellBox cellLeft(TableCellBox cell) {
        TableCellBox prevCell;
        TableSectionBox section = cell.getSection();
        int effCol = this.colToEffCol(cell.getCol());
        if (effCol == 0) {
            return null;
        }
        while ((prevCell = section.cellAt(cell.getRow(), effCol - 1)) == TableCellBox.SPANNING_CELL && --effCol >= 0) {
        }
        return prevCell == TableCellBox.SPANNING_CELL ? null : prevCell;
    }

    protected TableCellBox cellRight(TableCellBox cell) {
        int effCol = this.colToEffCol(cell.getCol() + cell.getStyle().getColSpan());
        if (effCol >= this.numEffCols()) {
            return null;
        }
        TableCellBox result = cell.getSection().cellAt(cell.getRow(), effCol);
        return result == TableCellBox.SPANNING_CELL ? null : result;
    }

    public int calcInlineBaseline() {
        int result = 0;
        boolean found = false;
        Iterator i = this.getChildIterator();
        while (i.hasNext()) {
            TableSectionBox section = (TableSectionBox)i.next();
            Iterator j = section.getChildIterator();
            if (!j.hasNext()) continue;
            TableRowBox row = (TableRowBox)j.next();
            found = true;
            result = row.getAbsY() + row.getBaseline() - this.getAbsY();
            break;
        }
        if (!found) {
            result = this.getHeight();
        }
        return result;
    }

    protected int getPageClearance() {
        return this._pageClearance;
    }

    protected void setPageClearance(int pageClearance) {
        this._pageClearance = pageClearance;
    }

    private static class AutoTableLayout
    implements TableLayout {
        private TableBox _table;
        private Layout[] _layoutStruct;
        private List _spanCells;

        public AutoTableLayout(TableBox table) {
            this._table = table;
        }

        public void reset() {
            this._layoutStruct = null;
            this._spanCells = null;
        }

        private void fullRecalc(LayoutContext c) {
            this._layoutStruct = new Layout[this._table.numEffCols()];
            for (int i = 0; i < this._layoutStruct.length; ++i) {
                this._layoutStruct[i] = new Layout();
            }
            this._spanCells = new ArrayList();
            TableBox table = this._table;
            int nEffCols = table.numEffCols();
            int cCol = 0;
            Iterator j = table.getStyleColumns().iterator();
            while (j.hasNext()) {
                TableColumn col = (TableColumn)j.next();
                int span = col.getStyle().getColSpan();
                Length w = col.getStyle().asLength(c, CSSName.WIDTH);
                if (w.isVariable() && col.getParent() != null) {
                    w = col.getParent().getStyle().asLength(c, CSSName.WIDTH);
                }
                if (w.isFixed() && w.value() == 0 || w.isPercent() && w.value() == 0) {
                    w = new Length();
                }
                int cEffCol = table.colToEffCol(cCol);
                if (!w.isVariable() && span == 1 && cEffCol < nEffCols && table.spanOfEffCol(cEffCol) == 1) {
                    this._layoutStruct[cEffCol].setWidth(w);
                    if (w.isFixed() && this._layoutStruct[cEffCol].maxWidth() < w.value()) {
                        this._layoutStruct[cEffCol].setMaxWidth(w.value());
                    }
                }
                cCol += span;
            }
            for (int i = 0; i < nEffCols; ++i) {
                this.recalcColumn(c, i);
            }
        }

        private void recalcColumn(LayoutContext c, int effCol) {
            Layout l = this._layoutStruct[effCol];
            Iterator j = this._table.getChildIterator();
            while (j.hasNext()) {
                TableSectionBox section = (TableSectionBox)j.next();
                int numRows = section.numRows();
                for (int i = 0; i < numRows; ++i) {
                    TableCellBox cell = section.cellAt(i, effCol);
                    if (cell == TableCellBox.SPANNING_CELL || cell == null) continue;
                    if (cell.getStyle().getColSpan() == 1) {
                        l.setMinWidth(Math.max(l.minWidth(), 1));
                        l.setMaxWidth(Math.max(l.maxWidth(), 1));
                        cell.calcMinMaxWidth(c);
                        if (cell.getMinWidth() > l.minWidth()) {
                            l.setMinWidth(cell.getMinWidth());
                        }
                        if (cell.getMaxWidth() > l.maxWidth()) {
                            l.setMaxWidth(cell.getMaxWidth());
                        }
                        Length w = cell.getOuterStyleOrColWidth(c);
                        w.setValue(Math.min(0x3FFFFFFF, Math.max(0, w.value())));
                        switch (w.type()) {
                            case 2: {
                                if (w.value() <= 0 || l.width().isPercent()) break;
                                if (l.width().isFixed()) {
                                    if (w.value() > l.width().value()) {
                                        l.width().setValue(w.value());
                                    }
                                } else {
                                    l.setWidth(w);
                                }
                                if (w.value() <= l.maxWidth()) break;
                                l.setMaxWidth(w.value());
                                break;
                            }
                            case 3: {
                                if (w.value() <= 0 || l.width().isPercent() && w.value() <= l.width().value()) break;
                                l.setWidth(w);
                            }
                        }
                        continue;
                    }
                    if (effCol != 0 && section.cellAt(i, effCol - 1) == cell) continue;
                    l.setMinWidth(Math.max(l.minWidth(), 1));
                    l.setMaxWidth(Math.max(l.maxWidth(), 1));
                    this._spanCells.add(cell);
                }
            }
            l.setMaxWidth(Math.max(l.maxWidth(), l.minWidth()));
        }

        private int calcEffectiveWidth(LayoutContext c) {
            int tMaxWidth = 0;
            Layout[] layoutStruct = this._layoutStruct;
            int nEffCols = layoutStruct.length;
            int hspacing = this._table.getStyle().getBorderHSpacing(c);
            for (int i = 0; i < nEffCols; ++i) {
                layoutStruct[i].setEffWidth(layoutStruct[i].width());
                layoutStruct[i].setEffMinWidth(layoutStruct[i].minWidth());
                layoutStruct[i].setEffMaxWidth(layoutStruct[i].maxWidth());
            }
            Collections.sort(this._spanCells, new Comparator(){

                public int compare(Object o1, Object o2) {
                    TableCellBox c1 = (TableCellBox)o1;
                    TableCellBox c2 = (TableCellBox)o2;
                    return c1.getStyle().getColSpan() - c2.getStyle().getColSpan();
                }
            });
            Iterator i = this._spanCells.iterator();
            while (i.hasNext()) {
                int cWidth;
                int pos;
                int pos2;
                int col;
                TableCellBox cell = (TableCellBox)i.next();
                cell.calcMinMaxWidth(c);
                int span = cell.getStyle().getColSpan();
                Length w = cell.getOuterStyleOrColWidth(c);
                if (w.value() == 0) {
                    w = new Length();
                }
                int lastCol = col = this._table.colToEffCol(cell.getCol());
                int cMinWidth = cell.getMinWidth() + hspacing;
                int cMaxWidth = cell.getMaxWidth() + hspacing;
                int totalPercent = 0;
                int minWidth = 0;
                int maxWidth = 0;
                boolean allColsArePercent = true;
                boolean allColsAreFixed = true;
                boolean haveVariable = false;
                int fixedWidth = 0;
                while (lastCol < nEffCols && span > 0) {
                    switch (layoutStruct[lastCol].width().type()) {
                        case 3: {
                            totalPercent += layoutStruct[lastCol].width().value();
                            allColsAreFixed = false;
                            break;
                        }
                        case 2: {
                            if (layoutStruct[lastCol].width().value() > 0) {
                                fixedWidth += layoutStruct[lastCol].width().value();
                                allColsArePercent = false;
                                break;
                            }
                        }
                        case 1: {
                            haveVariable = true;
                        }
                        default: {
                            if (!layoutStruct[lastCol].effWidth().isPercent()) {
                                layoutStruct[lastCol].setEffWidth(new Length());
                                allColsArePercent = false;
                            } else {
                                totalPercent += layoutStruct[lastCol].effWidth().value();
                            }
                            allColsAreFixed = false;
                        }
                    }
                    span -= this._table.spanOfEffCol(lastCol);
                    minWidth += layoutStruct[lastCol].effMinWidth();
                    maxWidth += layoutStruct[lastCol].effMaxWidth();
                    ++lastCol;
                    cMinWidth -= hspacing;
                    cMaxWidth -= hspacing;
                }
                if (w.isPercent()) {
                    if (totalPercent > w.value() || allColsArePercent) {
                        w = new Length();
                    } else {
                        int spanMax = Math.max(maxWidth, cMaxWidth);
                        tMaxWidth = Math.max(tMaxWidth, spanMax * 100 / w.value());
                        int percentMissing = w.value() - totalPercent;
                        int totalWidth = 0;
                        for (pos2 = col; pos2 < lastCol; ++pos2) {
                            if (layoutStruct[pos2].width().isPercent()) continue;
                            totalWidth += layoutStruct[pos2].effMaxWidth();
                        }
                        for (pos2 = col; pos2 < lastCol && totalWidth > 0; ++pos2) {
                            if (layoutStruct[pos2].width().isPercent()) continue;
                            int percent = percentMissing * layoutStruct[pos2].effMaxWidth() / totalWidth;
                            totalWidth -= layoutStruct[pos2].effMaxWidth();
                            percentMissing -= percent;
                            if (percent > 0) {
                                layoutStruct[pos2].setEffWidth(new Length(percent, 3));
                                continue;
                            }
                            layoutStruct[pos2].setEffWidth(new Length());
                        }
                    }
                }
                if (cMinWidth > minWidth) {
                    int minw;
                    int maxw;
                    if (allColsAreFixed) {
                        for (pos = col; fixedWidth > 0 && pos < lastCol; ++pos) {
                            cWidth = Math.max(layoutStruct[pos].effMinWidth(), cMinWidth * layoutStruct[pos].width().value() / fixedWidth);
                            fixedWidth -= layoutStruct[pos].width().value();
                            cMinWidth -= cWidth;
                            layoutStruct[pos].setEffMinWidth(cWidth);
                        }
                    } else if (allColsArePercent) {
                        maxw = maxWidth;
                        minw = minWidth;
                        int cminw = cMinWidth;
                        for (pos2 = col; maxw > 0 && pos2 < lastCol; ++pos2) {
                            if (!layoutStruct[pos2].effWidth().isPercent() || layoutStruct[pos2].effWidth().value() <= 0 || fixedWidth > cMinWidth) continue;
                            int cWidth2 = layoutStruct[pos2].effMinWidth();
                            cWidth2 = Math.max(cWidth2, cminw * layoutStruct[pos2].effWidth().value() / totalPercent);
                            cWidth2 = Math.min(layoutStruct[pos2].effMinWidth() + (cMinWidth - minw), cWidth2);
                            maxw -= layoutStruct[pos2].effMaxWidth();
                            minw -= layoutStruct[pos2].effMinWidth();
                            cMinWidth -= cWidth2;
                            layoutStruct[pos2].setEffMinWidth(cWidth2);
                        }
                    } else {
                        int cWidth3;
                        int pos3;
                        maxw = maxWidth;
                        minw = minWidth;
                        for (pos3 = col; maxw > 0 && pos3 < lastCol; ++pos3) {
                            if (!layoutStruct[pos3].width().isFixed() || !haveVariable || fixedWidth > cMinWidth) continue;
                            cWidth3 = Math.max(layoutStruct[pos3].effMinWidth(), layoutStruct[pos3].width().value());
                            fixedWidth -= layoutStruct[pos3].width().value();
                            minw -= layoutStruct[pos3].effMinWidth();
                            maxw -= layoutStruct[pos3].effMaxWidth();
                            cMinWidth -= cWidth3;
                            layoutStruct[pos3].setEffMinWidth(cWidth3);
                        }
                        for (pos3 = col; maxw > 0 && pos3 < lastCol && minw < cMinWidth; ++pos3) {
                            if (layoutStruct[pos3].width().isFixed() && haveVariable && fixedWidth <= cMinWidth) continue;
                            cWidth3 = Math.max(layoutStruct[pos3].effMinWidth(), cMinWidth * layoutStruct[pos3].effMaxWidth() / maxw);
                            cWidth3 = Math.min(layoutStruct[pos3].effMinWidth() + (cMinWidth - minw), cWidth3);
                            maxw -= layoutStruct[pos3].effMaxWidth();
                            minw -= layoutStruct[pos3].effMinWidth();
                            cMinWidth -= cWidth3;
                            layoutStruct[pos3].setEffMinWidth(cWidth3);
                        }
                    }
                }
                if (!w.isPercent()) {
                    if (cMaxWidth <= maxWidth) continue;
                    for (pos = col; maxWidth > 0 && pos < lastCol; ++pos) {
                        cWidth = Math.max(layoutStruct[pos].effMaxWidth(), cMaxWidth * layoutStruct[pos].effMaxWidth() / maxWidth);
                        maxWidth -= layoutStruct[pos].effMaxWidth();
                        cMaxWidth -= cWidth;
                        layoutStruct[pos].setEffMaxWidth(cWidth);
                    }
                    continue;
                }
                for (pos = col; pos < lastCol; ++pos) {
                    layoutStruct[pos].setMaxWidth(Math.max(layoutStruct[pos].maxWidth(), layoutStruct[pos].minWidth()));
                }
            }
            return tMaxWidth;
        }

        private boolean shouldScaleColumns(TableBox table) {
            return true;
        }

        public void calcMinMaxWidth(LayoutContext c) {
            TableBox table = this._table;
            this.fullRecalc(c);
            Layout[] layoutStruct = this._layoutStruct;
            int spanMaxWidth = this.calcEffectiveWidth(c);
            int minWidth = 0;
            int maxWidth = 0;
            int maxPercent = 0;
            int maxNonPercent = 0;
            int remainingPercent = 100;
            for (int i = 0; i < layoutStruct.length; ++i) {
                minWidth += layoutStruct[i].effMinWidth();
                maxWidth += layoutStruct[i].effMaxWidth();
                if (layoutStruct[i].effWidth().isPercent()) {
                    int percent = Math.min(layoutStruct[i].effWidth().value(), remainingPercent);
                    int pw = layoutStruct[i].effMaxWidth() * 100 / Math.max(percent, 1);
                    remainingPercent -= percent;
                    maxPercent = Math.max(pw, maxPercent);
                    continue;
                }
                maxNonPercent += layoutStruct[i].effMaxWidth();
            }
            if (this.shouldScaleColumns(table)) {
                maxNonPercent = (maxNonPercent * 100 + 50) / Math.max(remainingPercent, 1);
                maxWidth = Math.max(maxNonPercent, maxWidth);
                maxWidth = Math.max(maxWidth, maxPercent);
            }
            maxWidth = Math.max(maxWidth, spanMaxWidth);
            int bs = table.marginsBordersPaddingAndSpacing(c);
            minWidth += bs;
            maxWidth += bs;
            Length tw = table.getStyle().asLength(c, CSSName.WIDTH);
            if (tw.isFixed() && tw.value() > 0) {
                table.calcDimensions(c);
                int width = table.getWidth();
                maxWidth = minWidth = Math.max(minWidth, width);
            }
            table.setMaxWidth(Math.min(maxWidth, 0x3FFFFFFF));
            table.setMinWidth(Math.min(minWidth, 0x3FFFFFFF));
        }

        public void layout(LayoutContext c) {
            int i;
            int tableWidth;
            TableBox table = this._table;
            int available = tableWidth = table.getWidth() - table.marginsBordersPaddingAndSpacing(c);
            int nEffCols = table.numEffCols();
            boolean havePercent = false;
            int numVariable = 0;
            int numFixed = 0;
            int totalVariable = 0;
            int totalFixed = 0;
            int totalPercent = 0;
            int allocVariable = 0;
            Layout[] layoutStruct = this._layoutStruct;
            block5: for (i = 0; i < nEffCols; ++i) {
                int w = layoutStruct[i].effMinWidth();
                layoutStruct[i].setCalcWidth(w);
                available -= w;
                Length width = layoutStruct[i].effWidth();
                switch (width.type()) {
                    case 3: {
                        havePercent = true;
                        totalPercent += width.value();
                        continue block5;
                    }
                    case 2: {
                        ++numFixed;
                        totalFixed += layoutStruct[i].effMaxWidth();
                        continue block5;
                    }
                    case 1: {
                        ++numVariable;
                        totalVariable += layoutStruct[i].effMaxWidth();
                        allocVariable += w;
                    }
                }
            }
            if (available > 0 && havePercent) {
                for (i = 0; i < nEffCols; ++i) {
                    Length width = layoutStruct[i].effWidth();
                    if (!width.isPercent()) continue;
                    int w = Math.max(layoutStruct[i].effMinWidth(), width.minWidth(tableWidth));
                    available += layoutStruct[i].calcWidth() - w;
                    layoutStruct[i].setCalcWidth(w);
                }
                if (totalPercent > 100) {
                    int excess = tableWidth * (totalPercent - 100) / 100;
                    for (int i2 = nEffCols - 1; i2 >= 0; --i2) {
                        if (!layoutStruct[i2].effWidth().isPercent()) continue;
                        int w = layoutStruct[i2].calcWidth();
                        int reduction = Math.min(w, excess);
                        excess -= reduction;
                        int newWidth = Math.max(layoutStruct[i2].effMinWidth(), w - reduction);
                        available += w - newWidth;
                        layoutStruct[i2].setCalcWidth(newWidth);
                    }
                }
            }
            if (available > 0) {
                for (i = 0; i < nEffCols; ++i) {
                    Length width = layoutStruct[i].effWidth();
                    if (!width.isFixed() || width.value() <= layoutStruct[i].calcWidth()) continue;
                    available += layoutStruct[i].calcWidth() - width.value();
                    layoutStruct[i].setCalcWidth(width.value());
                }
            }
            if (available > 0 && numVariable > 0) {
                available += allocVariable;
                for (i = 0; i < nEffCols; ++i) {
                    Length width = layoutStruct[i].effWidth();
                    if (!width.isVariable() || totalVariable == 0) continue;
                    int w = Math.max(layoutStruct[i].calcWidth(), available * layoutStruct[i].effMaxWidth() / totalVariable);
                    available -= w;
                    totalVariable -= layoutStruct[i].effMaxWidth();
                    layoutStruct[i].setCalcWidth(w);
                }
            }
            if (available > 0 && numFixed > 0) {
                for (i = 0; i < nEffCols; ++i) {
                    Length width = layoutStruct[i].effWidth();
                    if (!width.isFixed()) continue;
                    int w = available * layoutStruct[i].effMaxWidth() / totalFixed;
                    available -= w;
                    totalFixed -= layoutStruct[i].effMaxWidth();
                    layoutStruct[i].setCalcWidth(layoutStruct[i].calcWidth() + w);
                }
            }
            if (available > 0 && havePercent && totalPercent < 100) {
                for (i = 0; i < nEffCols; ++i) {
                    Length width = layoutStruct[i].effWidth();
                    if (!width.isPercent()) continue;
                    int w = available * width.value() / totalPercent;
                    layoutStruct[i].setCalcWidth(layoutStruct[i].calcWidth() + w);
                    if ((available -= w) == 0 || (totalPercent -= width.value()) == 0) break;
                }
            }
            if (available > 0) {
                int total = nEffCols;
                int i3 = nEffCols;
                while (i3-- > 0) {
                    int w = available / total;
                    available -= w;
                    --total;
                    layoutStruct[i3].setCalcWidth(layoutStruct[i3].calcWidth() + w);
                }
            }
            if (available < 0) {
                int reduce;
                int minMaxDiff;
                int mw;
                if (available < 0) {
                    int i4;
                    mw = 0;
                    for (i4 = nEffCols - 1; i4 >= 0; --i4) {
                        Length width = layoutStruct[i4].effWidth();
                        if (!width.isVariable()) continue;
                        mw += layoutStruct[i4].calcWidth() - layoutStruct[i4].effMinWidth();
                    }
                    for (i4 = nEffCols - 1; i4 >= 0 && mw > 0; --i4) {
                        Length width = layoutStruct[i4].effWidth();
                        if (!width.isVariable()) continue;
                        minMaxDiff = layoutStruct[i4].calcWidth() - layoutStruct[i4].effMinWidth();
                        reduce = available * minMaxDiff / mw;
                        layoutStruct[i4].setCalcWidth(layoutStruct[i4].calcWidth() + reduce);
                        mw -= minMaxDiff;
                        if ((available -= reduce) >= 0) break;
                    }
                }
                if (available < 0) {
                    int i5;
                    mw = 0;
                    for (i5 = nEffCols - 1; i5 >= 0; --i5) {
                        Length width = layoutStruct[i5].effWidth();
                        if (!width.isFixed()) continue;
                        mw += layoutStruct[i5].calcWidth() - layoutStruct[i5].effMinWidth();
                    }
                    for (i5 = nEffCols - 1; i5 >= 0 && mw > 0; --i5) {
                        Length width = layoutStruct[i5].effWidth();
                        if (!width.isFixed()) continue;
                        minMaxDiff = layoutStruct[i5].calcWidth() - layoutStruct[i5].effMinWidth();
                        reduce = available * minMaxDiff / mw;
                        layoutStruct[i5].setCalcWidth(layoutStruct[i5].calcWidth() + reduce);
                        mw -= minMaxDiff;
                        if ((available -= reduce) >= 0) break;
                    }
                }
                if (available < 0) {
                    int i6;
                    mw = 0;
                    for (i6 = nEffCols - 1; i6 >= 0; --i6) {
                        Length width = layoutStruct[i6].effWidth();
                        if (!width.isPercent()) continue;
                        mw += layoutStruct[i6].calcWidth() - layoutStruct[i6].effMinWidth();
                    }
                    for (i6 = nEffCols - 1; i6 >= 0 && mw > 0; --i6) {
                        Length width = layoutStruct[i6].effWidth();
                        if (!width.isPercent()) continue;
                        minMaxDiff = layoutStruct[i6].calcWidth() - layoutStruct[i6].effMinWidth();
                        reduce = available * minMaxDiff / mw;
                        layoutStruct[i6].setCalcWidth(layoutStruct[i6].calcWidth() + reduce);
                        mw -= minMaxDiff;
                        if ((available -= reduce) >= 0) break;
                    }
                }
            }
            int pos = 0;
            int hspacing = this._table.getStyle().getBorderHSpacing(c);
            int[] columnPos = new int[nEffCols + 1];
            for (int i7 = 0; i7 < nEffCols; ++i7) {
                columnPos[i7] = pos;
                pos += layoutStruct[i7].calcWidth() + hspacing;
            }
            columnPos[columnPos.length - 1] = pos;
            this._table.setColumnPos(columnPos);
        }

        private static class Layout {
            private Length _width = new Length();
            private Length _effWidth = new Length();
            private int _minWidth = 1;
            private int _maxWidth = 1;
            private int _effMinWidth = 0;
            private int _effMaxWidth = 0;
            private int _calcWidth = 0;

            public Length width() {
                return this._width;
            }

            public void setWidth(Length l) {
                this._width = l;
            }

            public Length effWidth() {
                return this._effWidth;
            }

            public void setEffWidth(Length l) {
                this._effWidth = l;
            }

            public int minWidth() {
                return this._minWidth;
            }

            public void setMinWidth(int i) {
                this._minWidth = i;
            }

            public int maxWidth() {
                return this._maxWidth;
            }

            public void setMaxWidth(int i) {
                this._maxWidth = i;
            }

            public int effMinWidth() {
                return this._effMinWidth;
            }

            public void setEffMinWidth(int i) {
                this._effMinWidth = i;
            }

            public int effMaxWidth() {
                return this._effMaxWidth;
            }

            public void setEffMaxWidth(int i) {
                this._effMaxWidth = i;
            }

            public int calcWidth() {
                return this._calcWidth;
            }

            public void setCalcWidth(int i) {
                this._calcWidth = i;
            }
        }
    }

    private static class FixedTableLayout
    implements TableLayout {
        private TableBox _table;
        private List _widths;

        public FixedTableLayout(TableBox table) {
            this._table = table;
        }

        public void reset() {
            this._widths = null;
        }

        private void initWidths() {
            this._widths = new ArrayList(this._table.numEffCols());
            for (int i = 0; i < this._table.numEffCols(); ++i) {
                this._widths.add(new Length());
            }
        }

        private int calcWidthArray(LayoutContext c) {
            Length w;
            this.initWidths();
            TableBox table = this._table;
            int cCol = 0;
            int nEffCols = table.numEffCols();
            int usedWidth = 0;
            Iterator j = table.getStyleColumns().iterator();
            while (j.hasNext()) {
                TableColumn col = (TableColumn)j.next();
                int span = col.getStyle().getColSpan();
                w = col.getStyle().asLength(c, CSSName.WIDTH);
                if (w.isVariable() && col.getParent() != null) {
                    w = col.getParent().getStyle().asLength(c, CSSName.WIDTH);
                }
                int effWidth = 0;
                if (w.isFixed() && w.value() > 0) {
                    effWidth = w.value();
                    effWidth = Math.min(effWidth, 0x3FFFFFFF);
                }
                int usedSpan = 0;
                int i = 0;
                while (usedSpan < span) {
                    if (cCol + i >= nEffCols) {
                        table.appendColumn(span - usedSpan);
                        ++nEffCols;
                        this._widths.add(new Length());
                    }
                    int eSpan = table.spanOfEffCol(cCol + i);
                    if ((w.isFixed() || w.isPercent()) && w.value() > 0) {
                        this._widths.set(cCol + i, new Length(w.value() * eSpan, w.type()));
                        usedWidth += effWidth * eSpan;
                    }
                    usedSpan += eSpan;
                    ++i;
                }
                cCol += i;
            }
            cCol = 0;
            TableRowBox firstRow = this._table.getFirstRow();
            if (firstRow != null) {
                Iterator j2 = firstRow.getChildIterator();
                while (j2.hasNext()) {
                    TableCellBox cell = (TableCellBox)j2.next();
                    w = cell.getOuterStyleWidth(c);
                    int span = cell.getStyle().getColSpan();
                    int effWidth = 0;
                    if (w.isFixed() && w.value() > 0) {
                        effWidth = w.value();
                    }
                    int usedSpan = 0;
                    int i = 0;
                    while (usedSpan < span) {
                        int eSpan = this._table.spanOfEffCol(cCol + i);
                        Length columnWidth = (Length)this._widths.get(cCol + i);
                        if (columnWidth.isVariable() && !w.isVariable()) {
                            this._widths.set(cCol + i, new Length(w.value() * eSpan, w.type()));
                            usedWidth += effWidth * eSpan;
                        }
                        usedSpan += eSpan;
                        ++i;
                    }
                    cCol += i;
                }
            }
            return usedWidth;
        }

        public void calcMinMaxWidth(LayoutContext c) {
            int bs = this._table.marginsBordersPaddingAndSpacing(c);
            this._table.calcDimensions(c);
            int mw = this.calcWidthArray(c) + bs;
            this._table.setMinWidth(Math.max(mw, this._table.getWidth()));
            this._table.setMaxWidth(this._table.getMinWidth());
            boolean haveNonFixed = false;
            for (int i = 0; i < this._widths.size(); ++i) {
                Length w = (Length)this._widths.get(i);
                if (w.isFixed()) continue;
                haveNonFixed = true;
                break;
            }
            if (haveNonFixed) {
                this._table.setMaxWidth(0x3FFFFFFF);
            }
        }

        public void layout(LayoutContext c) {
            int i;
            int tableWidth;
            int available = tableWidth = this._table.getWidth() - this._table.marginsBordersPaddingAndSpacing(c);
            int nEffCols = this._table.numEffCols();
            int[] calcWidth = new int[nEffCols];
            for (i = 0; i < calcWidth.length; ++i) {
                calcWidth[i] = -1;
            }
            for (i = 0; i < nEffCols; ++i) {
                Length l = (Length)this._widths.get(i);
                if (!l.isFixed()) continue;
                calcWidth[i] = l.value();
                available -= l.value();
            }
            if (available > 0) {
                int totalPercent = 0;
                for (int i2 = 0; i2 < nEffCols; ++i2) {
                    Length l = (Length)this._widths.get(i2);
                    if (!l.isPercent()) continue;
                    totalPercent += l.value();
                }
                int base = tableWidth * totalPercent / 100;
                if (base > available) {
                    base = available;
                }
                for (int i3 = 0; available > 0 && i3 < nEffCols; ++i3) {
                    Length l = (Length)this._widths.get(i3);
                    if (!l.isPercent()) continue;
                    int w = base * l.value() / totalPercent;
                    available -= w;
                    calcWidth[i3] = w;
                }
            }
            if (available > 0) {
                int i4;
                int totalVariable = 0;
                for (i4 = 0; i4 < nEffCols; ++i4) {
                    Length l = (Length)this._widths.get(i4);
                    if (!l.isVariable()) continue;
                    ++totalVariable;
                }
                for (i4 = 0; available > 0 && i4 < nEffCols; ++i4) {
                    Length l = (Length)this._widths.get(i4);
                    if (!l.isVariable()) continue;
                    int w = available / totalVariable;
                    available -= w;
                    calcWidth[i4] = w;
                    --totalVariable;
                }
            }
            for (i = 0; i < nEffCols; ++i) {
                if (calcWidth[i] >= 0) continue;
                calcWidth[i] = 0;
            }
            if (available > 0) {
                int total = nEffCols;
                int i5 = nEffCols;
                while (i5-- > 0) {
                    int w = available / total;
                    available -= w;
                    --total;
                    int n = i5;
                    calcWidth[n] = calcWidth[n] + w;
                }
            }
            int pos = 0;
            int hspacing = this._table.getStyle().getBorderHSpacing(c);
            int[] columnPos = new int[nEffCols + 1];
            for (int i6 = 0; i6 < nEffCols; ++i6) {
                columnPos[i6] = pos;
                pos += calcWidth[i6] + hspacing;
            }
            columnPos[columnPos.length - 1] = pos;
            this._table.setColumnPos(columnPos);
        }
    }

    private static interface TableLayout {
        public void calcMinMaxWidth(LayoutContext var1);

        public void layout(LayoutContext var1);

        public void reset();
    }
}

