/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import org.netbeans.modules.web.monitor.data.MonitorData;
import org.netbeans.modules.web.monitor.data.RequestData;
import org.netbeans.modules.web.monitor.server.Logger;

class NotifyUtil {
    private String ideServer = null;
    private Vector otherIDEs = new Vector();
    boolean errorPrinted = false;
    private static final String putServlet = "/servlet/org.netbeans.modules.web.monitor.client.PutTransaction?";
    private static final String replayServlet = "/servlet/org.netbeans.modules.web.monitor.client.ReplaySendXMLServlet";
    private static final boolean debug = false;

    NotifyUtil() {
    }

    void setIDE(String name, String portS) throws MalformedURLException {
        int port = 0;
        try {
            port = Integer.parseInt(portS);
        }
        catch (NumberFormatException nfe) {
            throw new MalformedURLException("Port number is not an integer");
        }
        if (this.ideServer == null) {
            this.ideServer = new URL("http", name, port, putServlet).toString();
        } else {
            this.otherIDEs.add(new URL("http", name, port, putServlet).toString());
        }
    }

    void setIDE(String server) throws MalformedURLException {
        String host = server.substring(0, server.indexOf(":"));
        String port = server.substring(server.indexOf(":") + 1);
        this.setIDE(host, port);
    }

    void sendRecord(MonitorData monData, String queryStr) {
        if (this.ideServer != null) {
            String urlStr = this.ideServer.concat(queryStr);
            this.sendRecord(urlStr, monData);
        }
        if (this.otherIDEs.isEmpty()) {
            return;
        }
        Enumeration ides = this.otherIDEs.elements();
        while (ides.hasMoreElements()) {
            String base = (String)ides.nextElement();
            if (this.sendRecord(base.concat(queryStr), monData)) continue;
            this.otherIDEs.remove(base);
        }
    }

    private boolean sendRecord(String urlS, MonitorData monData) {
        boolean status = false;
        URL url = null;
        try {
            url = new URL(urlS);
        }
        catch (MalformedURLException mux) {
            return status;
        }
        RecordSender recordSender = new RecordSender(url, monData);
        recordSender.start();
        try {
            recordSender.join(3000L);
            status = recordSender.getStatus();
        }
        catch (InterruptedException ix) {
            // empty catch block
        }
        recordSender = null;
        return status;
    }

    RequestData getRecord(String id, String status, String host, int port) {
        Object rd = null;
        StringBuffer uriBuf = new StringBuffer(replayServlet);
        uriBuf.append("?status=");
        uriBuf.append(status);
        uriBuf.append("&id=");
        uriBuf.append(id);
        URL url = null;
        try {
            url = new URL("http", host, port, uriBuf.toString());
        }
        catch (MalformedURLException mux) {
            // empty catch block
        }
        RecordFetcher recordFetcher = new RecordFetcher(url);
        recordFetcher.start();
        try {
            recordFetcher.join(3000L);
            if (recordFetcher.getStatus()) {
                return recordFetcher.getMonitorData().getRequestData();
            }
            return null;
        }
        catch (InterruptedException ix) {
            recordFetcher = null;
            return null;
        }
    }

    void log(Throwable t) {
        this.log(Logger.getStackTrace(t));
    }

    void log(String msg) {
        System.out.println("NotifyUtil::" + msg);
    }

    class RecordFetcher
    extends Thread {
        URL url;
        boolean gotAck;
        String trace;
        MonitorData monData;

        RecordFetcher(URL url) {
            super("HTTP Monitor, retrieves data from IDE");
            this.url = null;
            this.gotAck = false;
            this.trace = null;
            this.monData = null;
            this.url = url;
        }

        MonitorData getMonitorData() {
            return this.monData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            InputStream in = null;
            InputStreamReader urlIn = null;
            try {
                in = this.url.openStream();
                urlIn = new InputStreamReader(in);
                this.monData = MonitorData.createGraph(urlIn);
                this.gotAck = true;
            }
            catch (Throwable t) {
                this.gotAck = false;
                this.trace = Logger.getStackTrace(t);
            }
            finally {
                try {
                    urlIn.close();
                }
                catch (Exception ex) {}
                try {
                    in.close();
                }
                catch (Exception ex) {}
            }
        }

        boolean getStatus() {
            return this.gotAck;
        }
    }

    class RecordSender
    extends Thread {
        URL url;
        boolean gotAck;
        boolean triedToRestart;
        URLConnection conn;
        MonitorData monData;

        RecordSender(URL url, MonitorData monData) {
            super("HTTP Monitor, sends data to IDE");
            this.url = null;
            this.gotAck = false;
            this.triedToRestart = false;
            this.conn = null;
            this.monData = null;
            this.monData = monData;
            this.url = url;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            PrintWriter out = null;
            BufferedReader in = null;
            try {
                this.conn = this.url.openConnection();
                this.conn.setRequestProperty("\tContent-type", "text/xml");
                this.conn.setDoOutput(true);
                try {
                    out = new PrintWriter(this.conn.getOutputStream());
                }
                catch (IOException e) {
                    if (!NotifyUtil.this.errorPrinted) {
                        String msg = ResourceBundle.getBundle("org.netbeans.modules.web.monitor.server.Bundle").getString("MON_Warning_httpserver_problem");
                        System.out.println(msg);
                        NotifyUtil.this.errorPrinted = true;
                    }
                    try {
                        in.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    try {
                        out.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    return;
                }
                this.monData.write(out);
                out.flush();
                try {
                    in = new BufferedReader(new InputStreamReader(this.conn.getInputStream()));
                }
                catch (IOException e) {
                    if (!NotifyUtil.this.errorPrinted) {
                        String msg = ResourceBundle.getBundle("org.netbeans.modules.web.monitor.server.Bundle").getString("MON_Warning_disabled_monitor");
                        System.out.println(msg);
                        NotifyUtil.this.errorPrinted = true;
                    }
                    try {
                        in.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    try {
                        out.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    return;
                }
                String inputLine = null;
                while ((inputLine = in.readLine()) != null) {
                    if (!inputLine.equals("ACK")) continue;
                    this.gotAck = true;
                    break;
                }
            }
            catch (IOException ioe) {
                NotifyUtil.this.log(ioe);
            }
            catch (NullPointerException npe) {
                NotifyUtil.this.log(npe);
            }
            catch (Throwable t) {
                NotifyUtil.this.log(t);
            }
            finally {
                try {
                    in.close();
                }
                catch (Throwable t) {}
                try {
                    out.close();
                }
                catch (Throwable t) {}
            }
        }

        boolean getStatus() {
            return this.gotAck;
        }
    }
}

