/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.napi.gsfret.source.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.DataLoadersBridge;
import org.netbeans.napi.gsfret.source.Source;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;

class OpenedEditors
implements PropertyChangeListener {
    private List<JTextComponent> visibleEditors = new ArrayList<JTextComponent>();
    private Map<JTextComponent, FileObject> visibleEditors2Files = new HashMap<JTextComponent, FileObject>();
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private static OpenedEditors DEFAULT;

    private OpenedEditors() {
        EditorRegistry.addPropertyChangeListener((PropertyChangeListener)new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                OpenedEditors.this.stateChanged();
            }
        });
    }

    public static synchronized OpenedEditors getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new OpenedEditors();
        }
        return DEFAULT;
    }

    public synchronized void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeEvent() {
        ChangeEvent e = new ChangeEvent(this);
        ArrayList<ChangeListener> listenersCopy = null;
        OpenedEditors openedEditors = this;
        synchronized (openedEditors) {
            listenersCopy = new ArrayList<ChangeListener>(this.listeners);
        }
        for (ChangeListener l : listenersCopy) {
            l.stateChanged(e);
        }
    }

    public synchronized List<JTextComponent> getVisibleEditors() {
        return Collections.unmodifiableList(this.visibleEditors);
    }

    public synchronized Collection<FileObject> getVisibleEditorsFiles() {
        return Collections.unmodifiableCollection(this.visibleEditors2Files.values());
    }

    public synchronized void stateChanged() {
        FileObject fo;
        for (JTextComponent c : this.visibleEditors) {
            c.removePropertyChangeListener(this);
            this.visibleEditors2Files.remove(c);
        }
        this.visibleEditors.clear();
        JTextComponent editor = EditorRegistry.lastFocusedComponent();
        FileObject fileObject = fo = editor != null ? OpenedEditors.getFileObject(editor) : null;
        if (editor instanceof JEditorPane && fo != null && Source.forFileObject(fo) != null) {
            this.visibleEditors.add(editor);
        }
        for (JTextComponent c : this.visibleEditors) {
            c.addPropertyChangeListener(this);
            this.visibleEditors2Files.put(c, OpenedEditors.getFileObject(c));
        }
        this.fireChangeEvent();
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent evt) {
        FileObject nueFile;
        JTextComponent c = (JTextComponent)evt.getSource();
        FileObject originalFile = this.visibleEditors2Files.get(c);
        if (originalFile != (nueFile = OpenedEditors.getFileObject(c))) {
            this.visibleEditors2Files.put(c, nueFile);
            this.fireChangeEvent();
        }
    }

    static FileObject getFileObject(JTextComponent pane) {
        return DataLoadersBridge.getDefault().getFileObject(pane);
    }

    public static boolean isSupported(FileObject file, String ... mimeTypes) throws NullPointerException {
        Parameters.notNull((CharSequence)"files", (Object)file);
        return !OpenedEditors.filterSupportedMIMETypes(Collections.singletonList(file), mimeTypes).isEmpty();
    }

    public static List<FileObject> filterSupportedMIMETypes(Collection<FileObject> files, String ... mimeTypes) throws NullPointerException {
        Parameters.notNull((CharSequence)"files", files);
        LinkedList<FileObject> result = new LinkedList<FileObject>();
        for (FileObject f : files) {
            Logger.getLogger(OpenedEditors.class.getName()).log(Level.FINER, "analyzing={0}", f);
            if (!LanguageRegistry.getInstance().isSupported(f.getMIMEType()) || Source.forFileObject(f) == null) continue;
            result.add(f);
        }
        return result;
    }
}

