/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.properties;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.ui.properties.PropertiesTable;
import org.netbeans.modules.subversion.ui.properties.SvnProperties;
import org.netbeans.modules.versioning.util.ListenersSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PropertiesPanel
extends JPanel
implements DocumentListener,
ItemListener,
PreferenceChangeListener,
TableModelListener {
    final JButton btnAdd = new JButton(){
        private Dimension prefSize;

        @Override
        public Dimension getPreferredSize() {
            if (this.prefSize == null) {
                Mnemonics.setLocalizedText((AbstractButton)this, (String)AddButtonState.ADD.getLabel());
                Dimension d = super.getPreferredSize();
                int maxWidth = d.width;
                int maxHeight = d.height;
                Mnemonics.setLocalizedText((AbstractButton)this, (String)AddButtonState.ADD_UPDATE.getLabel());
                d = super.getPreferredSize();
                maxWidth = Math.max(maxWidth, d.width);
                maxHeight = Math.max(maxHeight, d.height);
                Mnemonics.setLocalizedText((AbstractButton)this, (String)AddButtonState.UPDATE.getLabel());
                d = super.getPreferredSize();
                maxWidth = Math.max(maxWidth, d.width);
                maxHeight = Math.max(maxHeight, d.height);
                this.prefSize = new Dimension(maxWidth, maxHeight);
            }
            return this.prefSize;
        }
    };
    final JButton btnBrowse = new JButton();
    final JButton btnRefresh = new JButton();
    final JButton btnRemove = new JButton();
    final JCheckBox cbxRecursively = new JCheckBox();
    final JComboBox comboName = new JComboBox();
    final JTextArea txtAreaValue = new JTextArea();
    final JPanel propsPanel = new DerivedHeightPanel(this.txtAreaValue, 2.0f);
    final JLabel labelForTable = new JLabel();
    private static final Object EVENT_SETTINGS_CHANGED = new Object();
    private PropertiesTable propertiesTable;
    private ListenersSupport listenerSupport = new ListenersSupport((Object)this);
    private final ImageIcon warningIcon = new ImageIcon(this.getClass().getResource("/org/netbeans/modules/subversion/resources/icons/warning.gif"));
    private final ImageIcon errorIcon = new ImageIcon(this.getClass().getResource("/org/netbeans/modules/subversion/resources/icons/error.gif"));
    private final JLabel lblErrMessage = new JLabel(this.errorIcon, 10);
    private final Document propNameDocument;
    private final Document propValueDocument;
    private String propertyName;
    private String propertyValue;
    private String illegalPropErrMsgKey;
    private boolean recursive;
    private String[] existingProperties;
    private String[] illegalProperties = new String[0];
    private Set<String> recursiveProperties = Collections.EMPTY_SET;
    private SvnProperties propValueChangeListener;
    private boolean interactionInitialized;

    public PropertiesPanel() {
        this.propNameDocument = ((JTextField)this.comboName.getEditor().getEditorComponent()).getDocument();
        this.propValueDocument = this.txtAreaValue.getDocument();
        this.initComponents();
    }

    String getPropertyName() {
        return this.propertyName;
    }

    String getPropertyValue() {
        return this.propertyValue;
    }

    void setPropertiesTable(PropertiesTable propertiesTable) {
        this.propertiesTable = propertiesTable;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        SvnModuleConfig.getDefault().getPreferences().addPreferenceChangeListener(this);
        this.propertiesTable.getTableModel().addTableModelListener(this);
        this.listenerSupport.fireVersioningEvent(EVENT_SETTINGS_CHANGED);
        this.txtAreaValue.selectAll();
    }

    @Override
    public void removeNotify() {
        this.propertiesTable.getTableModel().removeTableModelListener(this);
        SvnModuleConfig.getDefault().getPreferences().removePreferenceChangeListener(this);
        super.removeNotify();
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().startsWith("commitExclusions")) {
            this.propertiesTable.dataChanged();
            this.listenerSupport.fireVersioningEvent(EVENT_SETTINGS_CHANGED);
        }
    }

    void setPredefinedPropertyNames(String[] propertyNames) {
        this.comboName.setModel(new DefaultComboBoxModel<String>(propertyNames));
        this.comboName.getEditor().setItem("");
    }

    void setExistingPropertyNames(String[] propNames) {
        this.existingProperties = propNames;
        if (this.interactionInitialized) {
            this.existingPropertiesChanged();
        }
    }

    void setIllegalPropertyNames(String[] propNames, String errMsgKey) {
        this.illegalProperties = propNames;
        this.illegalPropErrMsgKey = errMsgKey;
        if (this.interactionInitialized) {
            this.illegalPropertiesChanged();
        }
    }

    void setRecursiveProperties(Collection<String> propNames) {
        this.recursiveProperties = new HashSet<String>(propNames);
    }

    void setForDirectory(boolean forDirectory) {
        if (forDirectory) {
            this.cbxRecursively.setEnabled(true);
        } else {
            this.cbxRecursively.setEnabled(false);
            this.cbxRecursively.setSelected(false);
        }
    }

    void initInteraction() {
        this.updatePropertyName();
        this.updatePropertyValue();
        this.updateIsRecursive();
        this.propNameDocument.addDocumentListener(this);
        this.propValueDocument.addDocumentListener(this);
        this.cbxRecursively.addItemListener(this);
        this.refreshAddButtonText();
        this.refreshAddButtonState();
        this.interactionInitialized = true;
    }

    void setPropertyValueChangeListener(SvnProperties l) {
        this.propValueChangeListener = l;
    }

    void removePropertyValueChangeListener() {
        this.propValueChangeListener = null;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.listenerSupport.fireVersioningEvent(EVENT_SETTINGS_CHANGED);
    }

    private void initComponents() {
        JLabel lblPropertyName = new JLabel();
        lblPropertyName.setLabelFor(this.comboName);
        Mnemonics.setLocalizedText((JLabel)lblPropertyName, (String)PropertiesPanel.getString("PropertiesPanel.jLabel2.text"));
        JLabel lblPropertyValue = new JLabel();
        lblPropertyValue.setLabelFor(this.txtAreaValue);
        Mnemonics.setLocalizedText((JLabel)lblPropertyValue, (String)PropertiesPanel.getString("PropertiesPanel.jLabel1.text"));
        this.txtAreaValue.setColumns(20);
        this.txtAreaValue.setRows(5);
        JScrollPane jScrollPane1 = new JScrollPane();
        jScrollPane1.setViewportView(this.txtAreaValue);
        this.lblErrMessage.setForeground(Color.RED);
        this.lblErrMessage.setVisible(false);
        this.lblErrMessage.setText(" ");
        Mnemonics.setLocalizedText((AbstractButton)this.btnBrowse, (String)PropertiesPanel.getString("PropertiesPanel.btnBrowse.text"));
        this.btnBrowse.setActionCommand(PropertiesPanel.getString("btnBrowse.actionCommand"));
        JSeparator jSeparator1 = new JSeparator();
        Mnemonics.setLocalizedText((AbstractButton)this.btnAdd, (String)PropertiesPanel.getString("PropertiesPanel.btnAdd.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbxRecursively, (String)PropertiesPanel.getString("PropertiesPanel.cbxRecursively.text"));
        this.cbxRecursively.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemove, (String)PropertiesPanel.getString("PropertiesPanel.btnRemove.text"));
        this.btnRemove.setActionCommand(PropertiesPanel.getString("btnRemove.actionCommand"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRefresh, (String)PropertiesPanel.getString("PropertiesPanel.btnRefresh.text"));
        this.btnRefresh.setActionCommand(PropertiesPanel.getString("btnRefresh.actionCommand"));
        Mnemonics.setLocalizedText((JLabel)this.labelForTable, (String)PropertiesPanel.getString("jLabel3.text"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup().add((Component)lblPropertyName).add((Component)lblPropertyValue)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup().add((Component)this.comboName, 0, -1, -1).add((Component)jScrollPane1))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.lblErrMessage, 0, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.btnBrowse)).add((Component)jSeparator1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.btnAdd, -2, -1, -1).addPreferredGap(0).add((Component)this.cbxRecursively).addPreferredGap((JComponent)this.cbxRecursively, (JComponent)this.btnRemove, 0, true).add((Component)this.btnRemove).addPreferredGap(0).add((Component)this.btnRefresh)).add((Component)this.labelForTable).add((Component)this.propsPanel)).addContainerGap());
        layout.linkSize(new Component[]{this.btnBrowse, this.btnRefresh, this.btnRemove}, 1);
        layout.setHonorsVisibility(false);
        layout.setVerticalGroup((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)lblPropertyName).add((Component)this.comboName)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)lblPropertyValue).add((Component)jScrollPane1, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lblErrMessage).add((Component)this.btnBrowse)).addPreferredGap(0).add((Component)jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.btnAdd).add((Component)this.cbxRecursively).add((Component)this.btnRemove).add((Component)this.btnRefresh)).add(18).add((Component)this.labelForTable).addPreferredGap(0).add((Component)this.propsPanel, -1, -1, Short.MAX_VALUE).addContainerGap());
        lblPropertyName.getAccessibleContext().setAccessibleDescription(PropertiesPanel.getString("jLabel2.AccessibleContext.accessibleDescription"));
        lblPropertyValue.getAccessibleContext().setAccessibleDescription(PropertiesPanel.getString("jLabel1.AccessibleContext.accessibleDescription"));
        this.comboName.getAccessibleContext().setAccessibleName(PropertiesPanel.getString("comboName.AccessibleContext.accessibleName"));
        this.comboName.getAccessibleContext().setAccessibleDescription(PropertiesPanel.getString("comboName.AccessibleContext.accessibleDescription"));
        this.txtAreaValue.getAccessibleContext().setAccessibleName(PropertiesPanel.getString("txtAreaValue.AccessibleContext.accessibleName"));
        this.txtAreaValue.getAccessibleContext().setAccessibleDescription(PropertiesPanel.getString("txtAreaValue.AccessibleContext.accessibleDescription"));
        this.btnBrowse.getAccessibleContext().setAccessibleDescription(PropertiesPanel.getString("btnBrowse.AccessibleContext.accessibleDescription"));
        this.btnAdd.getAccessibleContext().setAccessibleDescription(PropertiesPanel.getString("btnAdd.AccessibleContext.accessibleDescription"));
        this.cbxRecursively.getAccessibleContext().setAccessibleDescription(PropertiesPanel.getString("cbxRecursively.AccessibleContext.accessibleDescription"));
        this.btnRemove.getAccessibleContext().setAccessibleDescription(PropertiesPanel.getString("btnRemove.AccessibleContext.accessibleDescription"));
        this.btnRefresh.getAccessibleContext().setAccessibleDescription(PropertiesPanel.getString("btnRefresh.AccessibleContext.accessibleDescription"));
        this.labelForTable.getAccessibleContext().setAccessibleDescription(PropertiesPanel.getString("labelForTable.AccessibleContext.accessibleDescription"));
    }

    private void setErrMessage(String message) {
        this.setMessage(message, this.errorIcon, Color.RED);
    }

    private void setWarningMessage(String message) {
        this.setMessage(message, this.warningIcon, Color.BLACK);
    }

    private void setMessage(String message, ImageIcon icon, Color foregroundColor) {
        if (message == null) {
            this.lblErrMessage.setText(" ");
            this.lblErrMessage.setVisible(false);
        } else {
            this.lblErrMessage.setText(message);
            this.lblErrMessage.setVisible(true);
            this.lblErrMessage.setIcon(icon);
            this.lblErrMessage.setForeground(foregroundColor);
            int widthReserve = this.lblErrMessage.getSize().width - this.lblErrMessage.getPreferredSize().width;
            if (widthReserve < 0) {
                this.makeDialogWider(-widthReserve);
            }
        }
    }

    private void makeDialogWider(int delta) {
        Window w = SwingUtilities.getWindowAncestor(this);
        if (w != null) {
            Dimension size = w.getSize();
            size.width += delta;
            w.setSize(size);
        }
    }

    private static String getString(String msgKey) {
        return NbBundle.getMessage(PropertiesPanel.class, (String)msgKey);
    }

    private void refreshAddButtonText() {
        AddButtonState buttonState;
        if (this.recursive) {
            buttonState = AddButtonState.ADD_UPDATE;
        } else {
            boolean isExistingProperty = false;
            if (this.existingProperties != null) {
                for (int i = 0; i < this.existingProperties.length; ++i) {
                    if (!this.existingProperties[i].equals(this.propertyName)) continue;
                    isExistingProperty = true;
                    break;
                }
            }
            buttonState = isExistingProperty ? AddButtonState.UPDATE : AddButtonState.ADD;
        }
        Mnemonics.setLocalizedText((AbstractButton)this.btnAdd, (String)buttonState.getLabel());
    }

    private void refreshAddButtonState() {
        String errMsg;
        boolean enabled;
        String warningMsg = null;
        if (this.propertyName.length() == 0) {
            enabled = false;
            errMsg = null;
        } else if (!this.isPropertyNameLegal()) {
            enabled = false;
            errMsg = NbBundle.getMessage(PropertiesPanel.class, (String)this.illegalPropErrMsgKey, (Object)this.propertyName);
        } else if (this.propertyName.indexOf(32) != -1) {
            enabled = false;
            errMsg = NbBundle.getMessage(PropertiesPanel.class, (String)"PropertiesPanel.errPropNameInvalid");
        } else {
            enabled = this.propertyValue.length() != 0;
            errMsg = null;
        }
        if (errMsg == null && this.recursiveProperties.contains(this.propertyName)) {
            this.cbxRecursively.setSelected(true);
            this.cbxRecursively.setEnabled(false);
            warningMsg = NbBundle.getMessage(PropertiesPanel.class, (String)"PropertiesPanel.needsRecursive", (Object)this.propertyName);
        } else {
            this.cbxRecursively.setEnabled(true);
        }
        this.btnAdd.setEnabled(enabled);
        if (errMsg != null) {
            this.setErrMessage(errMsg);
        } else {
            this.setWarningMessage(warningMsg);
        }
    }

    private boolean isPropertyNameLegal() {
        for (int i = 0; i < this.illegalProperties.length; ++i) {
            if (!this.propertyName.equals(this.illegalProperties[i])) continue;
            return false;
        }
        return true;
    }

    private void propNameChanged() {
        if (!this.recursive) {
            this.refreshAddButtonText();
        }
        this.refreshAddButtonState();
    }

    private void propValueChanged() {
        this.refreshAddButtonState();
        if (this.propValueChangeListener != null) {
            this.propValueChangeListener.propertyValueChanged();
        }
    }

    private void recursiveToggled() {
        this.refreshAddButtonText();
    }

    private void existingPropertiesChanged() {
        this.refreshAddButtonText();
    }

    private void illegalPropertiesChanged() {
        this.refreshAddButtonState();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.textChanged(e.getDocument());
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.textChanged(e.getDocument());
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        assert (e.getSource() == this.cbxRecursively);
        this.updateIsRecursive();
        this.recursiveToggled();
    }

    private void textChanged(Document document) {
        if (document == this.propNameDocument) {
            this.updatePropertyName();
            this.propNameChanged();
        } else {
            assert (document == this.propValueDocument);
            this.updatePropertyValue();
            this.propValueChanged();
        }
    }

    private void updatePropertyName() {
        try {
            this.propertyName = this.propNameDocument.getText(0, this.propNameDocument.getLength()).trim();
        }
        catch (BadLocationException ex) {
            assert (false);
            this.propertyName = "";
        }
    }

    private void updatePropertyValue() {
        this.propertyValue = this.txtAreaValue.getText().trim();
    }

    private void updateIsRecursive() {
        this.recursive = this.cbxRecursively.isSelected();
    }

    private final class DerivedHeightPanel
    extends JPanel {
        private final Component deriveFrom;
        private final float ratio;
        private Dimension prefSize = null;

        private DerivedHeightPanel(Component deriveFrom, float ratio) {
            this.deriveFrom = deriveFrom;
            this.ratio = ratio;
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.prefSize == null) {
                this.prefSize = this.computePrefSize();
            }
            return this.prefSize;
        }

        private Dimension computePrefSize() {
            int prefHeight = Math.round(this.ratio * (float)this.deriveFrom.getPreferredSize().height);
            return new Dimension(0, prefHeight);
        }
    }

    private static enum AddButtonState {
        ADD("PropertiesPanel.btnAdd.text"),
        ADD_UPDATE("PropertiesPanel.btnAddUpdate.text"),
        UPDATE("PropertiesPanel.btnUpdate.text");

        private final String btnLabel;

        private AddButtonState(String msgKey) {
            this.btnLabel = NbBundle.getMessage(PropertiesPanel.class, (String)msgKey);
        }

        String getLabel() {
            return this.btnLabel;
        }
    }
}

