/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.DownloadPlugin;
import org.netbeans.modules.subversion.client.MissingClientPanel;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnClientFactory;
import org.netbeans.modules.subversion.options.SvnOptionsController;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.AccessibleJFileChooser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class MissingClient
implements ActionListener,
HyperlinkListener {
    private final MissingClientPanel panel = new MissingClientPanel();

    public MissingClient() {
        this.panel.browseButton.addActionListener(this);
        this.panel.executablePathTextField.setText(SvnModuleConfig.getDefault().getExecutableBinaryPath());
        this.panel.textPane.addHyperlinkListener(this);
        this.panel.downloadRadioButton.addActionListener(this);
        this.panel.cliRadioButton.addActionListener(this);
        if (Utilities.isWindows() && !SvnUtils.isJava64()) {
            this.panel.downloadRadioButton.setSelected(true);
        } else {
            this.panel.cliRadioButton.setSelected(true);
            this.panel.downloadRadioButton.setEnabled(false);
            this.panel.forceGlobalCheckBox.setEnabled(false);
            this.panel.lblBinariesAvailableTip.setEnabled(false);
        }
        this.radioSwitch();
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void show() {
        JButton ok = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Action_OK"));
        JButton cancel = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Action_Cancel"));
        NotifyDescriptor descriptor = new NotifyDescriptor((Object)this.panel, NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_CommandFailed_Title"), 2, 0, new Object[]{ok, cancel}, (Object)ok);
        if (DialogDisplayer.getDefault().notify(descriptor) == ok) {
            if (this.panel.downloadRadioButton.isSelected()) {
                this.onDownload();
            } else {
                SvnModuleConfig.getDefault().setExecutableBinaryPath(this.panel.executablePathTextField.getText());
                SvnClientFactory.reset();
            }
        }
    }

    private void onBrowseClick() {
        File oldFile = this.getExecutableFile();
        AccessibleJFileChooser fileChooser = new AccessibleJFileChooser(NbBundle.getMessage(SvnOptionsController.class, (String)"ACSD_BrowseFolder"), oldFile);
        fileChooser.setDialogTitle(NbBundle.getMessage(SvnOptionsController.class, (String)"Browse_title"));
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileSelectionMode(1);
        fileChooser.showDialog(this.panel, NbBundle.getMessage(SvnOptionsController.class, (String)"OK_Button"));
        File f = fileChooser.getSelectedFile();
        if (f != null) {
            this.panel.executablePathTextField.setText(f.getAbsolutePath());
        }
    }

    private File getExecutableFile() {
        String execPath = this.panel.executablePathTextField.getText();
        return FileUtil.normalizeFile((File)new File(execPath));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.panel.browseButton) {
            this.onBrowseClick();
        } else if (evt.getSource() == this.panel.downloadRadioButton || evt.getSource() == this.panel.cliRadioButton) {
            this.radioSwitch();
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        URL url = e.getURL();
        assert (url != null);
        HtmlBrowser.URLDisplayer displayer = HtmlBrowser.URLDisplayer.getDefault();
        assert (displayer != null) : "HtmlBrowser.URLDisplayer found.";
        if (displayer != null) {
            displayer.showURL(url);
        } else {
            Subversion.LOG.info("No URLDisplayer found.");
        }
    }

    private void onDownload() {
        DownloadPlugin dp = new DownloadPlugin();
        dp.show();
        UpdateElement updateElement = dp.getUpdateElement();
        if (updateElement != null) {
            this.install(updateElement);
        }
    }

    private void install(final UpdateElement updateElement) {
        Subversion.getInstance().getParallelRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                try {
                    InstallCancellable ic = new InstallCancellable();
                    OperationContainer oc = OperationContainer.createForInstall();
                    if (oc.canBeAdded(updateElement.getUpdateUnit(), updateElement)) {
                        oc.add(updateElement);
                    } else {
                        if (updateElement.getUpdateUnit().isPending()) {
                            MissingClient.notifyInDialog(NbBundle.getMessage(MissingClient.class, (String)"MSG_MissingClient_RestartNeeded"), NbBundle.getMessage(MissingClient.class, (String)"LBL_MissingClient_RestartNeeded"), 1, false);
                            return;
                        }
                        oc = OperationContainer.createForUpdate();
                        if (oc.canBeAdded(updateElement.getUpdateUnit(), updateElement)) {
                            oc.add(updateElement);
                        } else {
                            Subversion.LOG.log(Level.WARNING, "MissingClient: cannot install {0}", updateElement.toString());
                            if (updateElement.getUpdateUnit().getInstalled() != null) {
                                Subversion.LOG.log(Level.WARNING, "MissingClient: already installed {0}", updateElement.getUpdateUnit().getInstalled().toString());
                            }
                            MissingClient.notifyInDialog(NbBundle.getMessage(MissingClient.class, (String)"MSG_MissingClient_InvalidOperation"), NbBundle.getMessage(MissingClient.class, (String)"LBL_MissingClient_InvalidOperation"), 0, false);
                            return;
                        }
                    }
                    InstallSupport.Validator v = ((InstallSupport)oc.getSupport()).doDownload(ProgressHandleFactory.createHandle((String)(NbBundle.getMessage(MissingClient.class, (String)"LBL_Downloading") + updateElement.getDisplayName()), (Cancellable)ic), ((MissingClient)MissingClient.this).panel.forceGlobalCheckBox.isSelected());
                    if (ic.cancelled) {
                        return;
                    }
                    InstallSupport.Installer i = ((InstallSupport)oc.getSupport()).doValidate(v, ProgressHandleFactory.createHandle((String)(NbBundle.getMessage(MissingClient.class, (String)"LBL_Validating") + updateElement.getDisplayName()), (Cancellable)ic));
                    if (ic.cancelled) {
                        return;
                    }
                    OperationSupport.Restarter rest = ((InstallSupport)oc.getSupport()).doInstall(i, ProgressHandleFactory.createHandle((String)(NbBundle.getMessage(MissingClient.class, (String)"LBL_Installing") + updateElement.getDisplayName()), (Cancellable)ic));
                    if (rest != null) {
                        JButton restart = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Action_Restart"));
                        JButton cancel = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Action_Cancel"));
                        NotifyDescriptor descriptor = new NotifyDescriptor((Object)NbBundle.getMessage(MissingClient.class, (String)"MSG_NeedsRestart"), NbBundle.getMessage(MissingClient.class, (String)"LBL_DownloadJavahl"), 2, 3, new Object[]{restart, cancel}, (Object)restart);
                        if (DialogDisplayer.getDefault().notify(descriptor) == restart) {
                            ((InstallSupport)oc.getSupport()).doRestart(rest, ProgressHandleFactory.createHandle((String)NbBundle.getMessage(MissingClient.class, (String)"LBL_Restarting")));
                        }
                    }
                }
                catch (OperationException e) {
                    Subversion.LOG.log(Level.INFO, null, e);
                    MissingClient.notifyError(NbBundle.getMessage(MissingClient.class, (String)"MSG_MissingClient_UC_Unavailable"), NbBundle.getMessage(MissingClient.class, (String)"LBL_MissingClient_UC_Unavailable"));
                }
            }
        });
    }

    private static void notifyError(String message, String title) {
        MissingClient.notifyInDialog(message, title, 0, true);
    }

    private static void notifyInDialog(String message, String title, int messageType, boolean cancelVisible) {
        Object[] objectArray;
        if (cancelVisible) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = NotifyDescriptor.OK_OPTION;
            objectArray = objectArray2;
            objectArray2[1] = NotifyDescriptor.CANCEL_OPTION;
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = NotifyDescriptor.OK_OPTION;
        }
        NotifyDescriptor nd = new NotifyDescriptor((Object)message, title, -1, messageType, objectArray, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notifyLater(nd);
    }

    private void radioSwitch() {
        boolean cliEnabled = this.panel.cliRadioButton.isSelected();
        this.panel.browseButton.setEnabled(cliEnabled);
        this.panel.executablePathTextField.setEnabled(cliEnabled);
    }

    private class InstallCancellable
    implements Cancellable {
        private boolean cancelled;

        private InstallCancellable() {
        }

        public boolean cancel() {
            this.cancelled = true;
            return true;
        }
    }
}

