/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.tomcat5.config.gen.Context;
import org.netbeans.modules.tomcat5.config.gen.Engine;
import org.netbeans.modules.tomcat5.config.gen.Host;
import org.netbeans.modules.tomcat5.config.gen.SContext;
import org.netbeans.modules.tomcat5.config.gen.Server;
import org.netbeans.modules.tomcat5.config.gen.Service;

public class TomcatModuleConfig {
    private static final String CONTEXT_XML_PATH = "/META-INF/context.xml";
    private File contextXml;
    private File serverXml;
    private long timestampContextXML;
    private long timestampServerXML;
    private String path;
    private boolean hasLogger;
    private String loggerClassName;
    private String loggerDir;
    private String loggerPrefix;
    private String loggerSuffix;
    private boolean loggerTimestamp;

    public TomcatModuleConfig(String string, String string2, String string3) {
        this.path = string2.equals("/") ? "" : string2;
        this.contextXml = new File(string + CONTEXT_XML_PATH);
        this.serverXml = new File(string3);
        this.refresh();
    }

    private Context getContext() {
        try {
            this.timestampContextXML = this.contextXml.lastModified();
            Context context = Context.createGraph(this.contextXml);
            return context;
        }
        catch (IOException iOException) {
            Logger.getLogger(TomcatModuleConfig.class.getName()).log(Level.INFO, null, iOException);
            return null;
        }
        catch (RuntimeException runtimeException) {
            Logger.getLogger(TomcatModuleConfig.class.getName()).log(Level.INFO, null, runtimeException);
            return null;
        }
    }

    private SContext getSContext() {
        try {
            Host[] hostArray;
            Engine engine;
            this.timestampServerXML = this.serverXml.lastModified();
            Server server = Server.createGraph(this.serverXml);
            Service[] serviceArray = server.getService();
            if (serviceArray.length > 0 && (engine = serviceArray[0].getEngine()) != null && (hostArray = engine.getHost()).length > 0) {
                SContext[] sContextArray = hostArray[0].getSContext();
                for (int i = 0; i < sContextArray.length; ++i) {
                    if (!sContextArray[i].getAttributeValue("path").equals(this.path)) continue;
                    return sContextArray[i];
                }
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(TomcatModuleConfig.class.getName()).log(Level.INFO, null, iOException);
        }
        return null;
    }

    public boolean hasLogger() {
        return this.hasLogger;
    }

    public String loggerClassName() {
        return this.loggerClassName;
    }

    public String loggerDir() {
        return this.loggerDir;
    }

    public String loggerPrefix() {
        return this.loggerPrefix;
    }

    public String loggerSuffix() {
        return this.loggerSuffix;
    }

    public boolean loggerTimestamp() {
        return this.loggerTimestamp;
    }

    public void refresh() {
        if (this.contextXml.exists()) {
            long l = this.contextXml.lastModified();
            if (l > this.timestampContextXML) {
                this.timestampContextXML = l;
                Context context = this.getContext();
                if (context != null) {
                    this.hasLogger = context.isLogger();
                    if (this.hasLogger) {
                        this.loggerClassName = context.getLoggerClassName();
                        this.loggerDir = context.getLoggerDirectory();
                        this.loggerPrefix = context.getLoggerPrefix();
                        this.loggerSuffix = context.getLoggerSuffix();
                        this.loggerTimestamp = Boolean.valueOf(context.getLoggerTimestamp());
                        return;
                    }
                }
            }
        } else if (this.serverXml.exists()) {
            long l = this.serverXml.lastModified();
            if (l > this.timestampServerXML) {
                this.timestampServerXML = l;
                SContext sContext = this.getSContext();
                if (sContext != null) {
                    this.hasLogger = sContext.isLogger();
                    if (this.hasLogger) {
                        this.loggerClassName = sContext.getAttributeValue("Logger", "className");
                        this.loggerDir = sContext.getAttributeValue("Logger", "directory");
                        this.loggerPrefix = sContext.getAttributeValue("Logger", "prefix");
                        this.loggerSuffix = sContext.getAttributeValue("Logger", "suffix");
                        String string = sContext.getAttributeValue("Logger", "timestamp");
                        this.loggerTimestamp = Boolean.valueOf(string);
                    }
                }
            }
        } else {
            this.hasLogger = false;
        }
    }
}

