/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.componentssupport.ui.helpers;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.netbeans.modules.vmd.componentssupport.ui.helpers.XmlHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ProjectXmlHelper
extends XmlHelper {
    private static final String PROJECT_TAG_MODULE_DEPENDENCIES = "module-dependencies";
    private static final String PROJECT_TAG_DEPENDENCY = "dependency";
    private static final String PROJECT_TAG_CODE_NAME_BASE = "code-name-base";
    private static final String PROJECT_TAG_BUILD_PREREQUISITE = "build-prerequisite";
    private static final String PROJECT_TAG_COMPILE_DEPENDENCY = "compile-dependency";
    private static final String PROJECT_TAG_RUN_DEPENDENCY = "run-dependency";
    private static final String PROJECT_TAG_SPECIFICATION_VERSION = "specification-version";
    private static final String PROJECT_XPATH_TAG_DATA = "/project/configuration/data";

    public static Node getPrimaryConfigurationData(XPath xpath, Element parent) throws XPathExpressionException {
        String expression = PROJECT_XPATH_TAG_DATA;
        Node confData = (Node)xpath.evaluate(expression, parent, XPathConstants.NODE);
        assert (confData != null);
        return confData;
    }

    public static Node goToModuleDependencies(Document doc, XPath xpath, Node parent) throws XPathExpressionException {
        return ProjectXmlHelper.goAndCreateNode(doc, xpath, parent, PROJECT_TAG_MODULE_DEPENDENCIES);
    }

    public static Node testAndAddDependency(Document doc, XPath xpath, Node modDepsNode, String moduleName, String moduleVersion) throws XPathExpressionException {
        Node node = ProjectXmlHelper.getDependency(xpath, modDepsNode, moduleName);
        if (node == null) {
            node = ProjectXmlHelper.addDependency(doc, xpath, modDepsNode, moduleName, moduleVersion);
        }
        return node;
    }

    public static Node getDependency(XPath xpath, Node modDepsNode, String moduleName) throws XPathExpressionException {
        String expression = "./dependency[code-name-base=\"" + moduleName + "\"]";
        Node node = (Node)xpath.evaluate(expression, modDepsNode, XPathConstants.NODE);
        return node;
    }

    public static Node addDependency(Document doc, XPath xpath, Node modDepsNode, String moduleName, String moduleVersion) throws XPathExpressionException {
        Element dependency = doc.createElement(PROJECT_TAG_DEPENDENCY);
        Element cnb = doc.createElement(PROJECT_TAG_CODE_NAME_BASE);
        cnb.setTextContent(moduleName);
        dependency.appendChild(cnb);
        Element prerequisite = doc.createElement(PROJECT_TAG_BUILD_PREREQUISITE);
        dependency.appendChild(prerequisite);
        Element compile = doc.createElement(PROJECT_TAG_COMPILE_DEPENDENCY);
        dependency.appendChild(compile);
        Element run = doc.createElement(PROJECT_TAG_RUN_DEPENDENCY);
        Element version = doc.createElement(PROJECT_TAG_SPECIFICATION_VERSION);
        version.setTextContent(moduleVersion);
        run.appendChild(version);
        dependency.appendChild(run);
        modDepsNode.appendChild(dependency);
        return dependency;
    }

    private static Node goAndCreateNode(Document doc, XPath xpath, Node parent, String name) throws XPathExpressionException {
        String expression = "./" + name;
        Node node = (Node)xpath.evaluate(expression, parent, XPathConstants.NODE);
        if (node == null) {
            Element el = doc.createElement(name);
            parent.appendChild(el);
            node = el;
        }
        return node;
    }
}

