/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.ri.platform.installer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.validation.adapters.DialogBuilder;
import org.netbeans.modules.javacard.common.GuiUtils;
import org.netbeans.modules.javacard.common.Utils;
import org.netbeans.modules.javacard.spi.AddCardHandler;
import org.netbeans.modules.javacard.spi.Card;
import org.netbeans.modules.javacard.spi.CardCustomizer;
import org.netbeans.modules.javacard.spi.JavacardPlatform;
import org.netbeans.modules.javacard.spi.actions.CardActions;
import org.netbeans.modules.javacard.spi.capabilities.CardCustomizerProvider;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationUI;
import org.openide.DialogDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.ListView;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.windows.WindowManager;

public class ServersPanel
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener,
AddCardHandler.CardCreatedCallback,
Lookup.Provider,
Runnable {
    private final ExplorerManager mgr = new ExplorerManager();
    private final JavacardPlatform pform;
    private final ValidationGroup grp = ValidationGroup.create((ValidationUI[])new ValidationUI[0]);
    private Lookup lkp;
    private JButton addButton;
    private JPanel customizerPanel;
    private JLabel jLabel1;
    private JLabel noCustomizerLabel;
    private JButton removeButton;
    private JScrollPane view;
    private Map<Node, CardCustomizer> cache = new HashMap<Node, CardCustomizer>();

    public ServersPanel(JavacardPlatform pform) {
        this.pform = pform;
        this.mgr.setRootContext((Node)new AbstractNode(pform.getCards().createChildren(), Lookups.fixed((Object[])new Object[]{pform})));
        this.initComponents();
        ((ListView)this.view).setPopupAllowed(false);
        ((ListView)this.view).setSelectionMode(0);
        GuiUtils.prepareContainer((Container)this);
        this.addButton.setEnabled(AddCardHandler.createAddDeviceAction((DataObject)Utils.findPlatformDataObjectNamed((String)pform.getSystemName()), (JavacardPlatform)pform, (AddCardHandler.CardCreatedCallback)this) != null);
        this.lkp = ExplorerUtils.createLookup((ExplorerManager)this.mgr, (ActionMap)this.getActionMap());
        this.removeButton.setAction(CardActions.createDeleteAction().createContextAwareInstance(this.lkp));
        this.mgr.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void showDialog() {
        DialogBuilder b = new DialogBuilder(ServersPanel.class).setModal(true).setTitle(NbBundle.getMessage(ServersPanel.class, (String)"TTL_MANAGE_DEVICES", (Object)this.pform.getDisplayName())).setContent((Object)this).setValidationGroup(this.grp);
        if (b.showDialog(DialogDescriptor.OK_OPTION)) {
            this.save();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        EventQueue.invokeLater(this);
    }

    @Override
    public void run() {
        Node[] n = this.mgr.getRootContext().getChildren().getNodes(true);
        if (n != null && n.length > 0) {
            try {
                this.mgr.setSelectedNodes(new Node[]{n[0]});
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private void initComponents() {
        this.view = new ListView();
        this.customizerPanel = new JPanel();
        this.noCustomizerLabel = new JLabel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.jLabel1 = this.grp.createProblemLabel();
        this.view.setBorder(new LineBorder(UIManager.getDefaults().getColor("controlShadow"), 1, true));
        this.customizerPanel.setLayout(new BorderLayout());
        this.noCustomizerLabel.setText(NbBundle.getMessage(ServersPanel.class, (String)"ServersPanel.noCustomizerLabel.text"));
        this.customizerPanel.add((Component)this.noCustomizerLabel, "Center");
        this.addButton.setText(NbBundle.getMessage(ServersPanel.class, (String)"ServersPanel.addButton.text"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServersPanel.this.onAdd(evt);
            }
        });
        this.removeButton.setText(NbBundle.getMessage(ServersPanel.class, (String)"ServersPanel.removeButton.text"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServersPanel.this.onRemove(evt);
            }
        });
        this.jLabel1.setText(NbBundle.getMessage(ServersPanel.class, (String)"ServersPanel.jLabel1.text"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(20, 20, 20).add((Component)this.view, -2, 256, -2).addPreferredGap(0).add((Component)this.customizerPanel, -1, 253, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.addButton).addPreferredGap(1).add((Component)this.removeButton).addPreferredGap(0).add((Component)this.jLabel1, -1, 325, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(20, 20, 20).add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.customizerPanel, -1, 335, Short.MAX_VALUE).add(1, (Component)this.view, -1, 335, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.addButton).add((Component)this.removeButton).add((Component)this.jLabel1)).add(20, 20, 20)));
    }

    private void onAdd(ActionEvent evt) {
        Action a = AddCardHandler.createAddDeviceAction((DataObject)Utils.findPlatformDataObjectNamed((String)this.pform.getSystemName()), (JavacardPlatform)this.pform, (AddCardHandler.CardCreatedCallback)this);
        if (a != null) {
            a.actionPerformed(evt);
        }
    }

    private void onRemove(ActionEvent evt) {
    }

    public ExplorerManager getExplorerManager() {
        return this.mgr;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt == null || "selectedNodes".equals(evt.getPropertyName())) {
            Node[] n = this.mgr.getSelectedNodes();
            if (n == null || n.length != 1) {
                this.clear();
                return;
            }
            Node nd = n[0];
            Card card = (Card)nd.getLookup().lookup(Card.class);
            if (card == null) {
                this.clear();
                return;
            }
            CardCustomizer cust = this.findCustomizer(nd, card);
            if (cust != null) {
                ValidationGroup group = cust.getValidationGroup();
                if (group != null) {
                    try {
                        this.grp.addValidationGroup(group, false);
                    }
                    catch (AssertionError e) {
                        Logger.getLogger(ServersPanel.class.getName()).log(Level.INFO, null, (Throwable)((Object)e));
                    }
                    catch (Throwable e) {
                        Logger.getLogger(ServersPanel.class.getName()).log(Level.INFO, null, e);
                    }
                }
                Component comp = cust.getComponent();
                this.setCustomizerComponent(comp);
            } else if (nd.hasCustomizer()) {
                this.setCustomizerComponent(nd.getCustomizer());
            }
        }
    }

    private void save() {
        for (CardCustomizer c : this.cache.values()) {
            if (!c.isContentValid()) continue;
            c.save();
        }
        this.cache.clear();
    }

    private CardCustomizer findCustomizer(Node n, Card card) {
        CardCustomizer result = this.cache.get(n);
        if (result == null) {
            CardCustomizerProvider prov = (CardCustomizerProvider)card.getCapability(CardCustomizerProvider.class);
            if (prov == null) {
                prov = (CardCustomizerProvider)n.getLookup().lookup(CardCustomizerProvider.class);
            }
            if (prov == null) {
                prov = (CardCustomizerProvider)Lookups.forPath((String)("org-netbeans-modules-javacard-spi/kinds/" + this.pform.getPlatformKind())).lookup(CardCustomizerProvider.class);
            }
            if (prov != null && (result = prov.getCardCustomizer(card)) != null) {
                this.cache.put(n, result);
            }
        }
        return result;
    }

    private void clear() {
        this.setCustomizerComponent(null);
    }

    private void setCustomizerComponent(Component c) {
        c = c == null ? this.noCustomizerLabel : c;
        this.customizerPanel.removeAll();
        this.customizerPanel.add(c, "Center");
        this.customizerPanel.invalidate();
        this.customizerPanel.revalidate();
        this.customizerPanel.repaint();
        if (c != this.noCustomizerLabel && this.getTopLevelAncestor() instanceof Dialog) {
            ((Dialog)this.getTopLevelAncestor()).pack();
            ((Dialog)this.getTopLevelAncestor()).setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
        }
    }

    public void onCardCreated(final Card card, FileObject file) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (final Node nd : ServersPanel.this.mgr.getRootContext().getChildren().getNodes(true)) {
                    if (!card.equals(nd.getLookup().lookup(Card.class))) continue;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ServersPanel.this.mgr.setSelectedNodes(new Node[]{nd});
                            }
                            catch (PropertyVetoException propertyVetoException) {
                                // empty catch block
                            }
                        }
                    });
                    return;
                }
            }
        });
    }

    public Lookup getLookup() {
        return this.lkp;
    }
}

