/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.ri.platform.installer;

import java.util.Map;
import org.netbeans.api.java.platform.Profile;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.javacard.ri.platform.installer.RIPlatformFactory;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.modules.SpecificationVersion;

public final class PlatformInfo {
    private final EditableProperties props;

    public PlatformInfo(EditableProperties props) {
        this.props = props;
    }

    public int getMajorVersion() {
        String mv = this.props.getProperty("javacard.java.majorVersion");
        if (mv != null) {
            try {
                return Integer.parseInt(mv);
            }
            catch (NumberFormatException nfe) {
                return 1;
            }
        }
        return 1;
    }

    public int getMinorVersion() {
        String mv = this.props.getProperty("javacard.java.majorVersion");
        if (mv != null) {
            try {
                return Integer.parseInt(mv);
            }
            catch (NumberFormatException nfe) {
                return 6;
            }
        }
        return 1;
    }

    public String getToolsClassPath() {
        return this.props.getProperty("javacard.toolClassPath");
    }

    public Specification getSpecificationVersion() {
        SpecificationVersion specVer = new SpecificationVersion(this.getMajorVersion() + "." + this.getMinorVersion());
        Profile p = this.getProfile();
        return p == null ? new Specification("JCRE", specVer) : new Specification("JCRE", specVer, new Profile[]{p});
    }

    Profile getProfile() {
        String profile = this.props.getProperty("javacard.profile");
        Profile p = profile == null || profile.length() == 0 ? null : new Profile(profile, new SpecificationVersion("1.0"));
        return p;
    }

    public String getName() {
        return this.props.getProperty("javacard.name");
    }

    public String getTitle() {
        return this.getName();
    }

    public boolean isRi() {
        return "javacard.platform.kind".equals(this.props.getProperty("javacard.platform.kind"));
    }

    public EditableProperties getDeviceDefaults() {
        EditableProperties result = new EditableProperties(true);
        boolean found = RIPlatformFactory.addPrototypeValues(result, this.props);
        return found ? result : null;
    }

    public EditableProperties writeTo(EditableProperties props) {
        props.putAll((Map)this.props);
        String kind = props.getProperty("javacard.platform.kind");
        if ("RI".equals(kind)) {
            String home = props.getProperty("javacard.home");
            props.setProperty("javacard.ri.home", home);
        }
        return props;
    }
}

