/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.editor;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.project.Project;
import org.netbeans.editor.BaseDocument;
import org.netbeans.mobility.antext.preprocessor.PPBlockInfo;
import org.netbeans.mobility.antext.preprocessor.PPLine;
import org.netbeans.mobility.antext.preprocessor.PPToken;
import org.netbeans.mobility.antext.preprocessor.PreprocessorScanner;
import org.netbeans.modules.mobility.editor.PPDirectiveCompletionItem;
import org.netbeans.modules.mobility.editor.PPVariableCompletionItem;
import org.netbeans.modules.mobility.editor.Utilities;
import org.netbeans.modules.mobility.project.J2MEProjectUtils;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.netbeans.spi.project.ProjectConfiguration;
import org.openide.util.NbBundle;

public final class PPCompletionProvider
implements CompletionProvider {
    private int myQueryType;
    public static final int DIRECTIVE_COMPLETION_QUERY = 998;
    public static final int VARIABLE_COMPLETION_QUERY = 999;
    private static final String DEBUG = "debug";
    private static final String ELSE = "else";
    private static final String ENDIF = "endif";
    private static final String ENDDEBUG = "enddebug";
    private static final String PREFIX = "//#";
    private static final String DESCDIR = "DESC_DIRECTIVE_CC_";
    public static final String[] DEBUG_LEVELS = new String[]{"debug", "info", "warn", "error", "fatal"};
    private static final String[] operatorTokens = new String[]{"==", "<=", ">=", "!=", "&&", "||"};
    private static final char[] operatorChars = new char[]{'^', ',', '@', '('};
    private static final String[] directives = new String[]{"if", "ifdef", "ifndef", "elifdef", "elifndef", "elif", "else", "endif", "debug", "mdebug", "enddebug", "define", "undefine", "condition"};

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        Project p;
        ProjectConfigurationsHelper hlp;
        String line;
        int ret = 0;
        if (typedText != null && typedText.endsWith("#")) {
            ret |= 1;
            this.myQueryType = 998;
        }
        if (typedText != null && typedText.endsWith(" ")) {
            ret |= 1;
            this.myQueryType = 999;
        }
        if (!PPCompletionProvider.canBeValidPPLine(line = PPCompletionProvider.getLine(component))) {
            ret = 0;
        }
        ProjectConfigurationsHelper projectConfigurationsHelper = hlp = (p = J2MEProjectUtils.getProjectForDocument((Document)component.getDocument())) == null ? null : (ProjectConfigurationsHelper)p.getLookup().lookup(ProjectConfigurationsHelper.class);
        if (hlp == null || !hlp.isPreprocessorOn()) {
            ret = 0;
        }
        return ret;
    }

    public static String getLine(JTextComponent component) {
        return PPCompletionProvider.getLine(component, component.getCaret().getDot());
    }

    public static String getLine(JTextComponent component, int offset) {
        BaseDocument workingDocument = org.netbeans.editor.Utilities.getDocument((JTextComponent)component);
        try {
            int lineStartOffset = org.netbeans.editor.Utilities.getRowStart((BaseDocument)workingDocument, (int)offset);
            int lineEndOffset = org.netbeans.editor.Utilities.getRowEnd((BaseDocument)workingDocument, (int)offset);
            return String.valueOf(workingDocument.getChars(lineStartOffset, lineEndOffset - lineStartOffset));
        }
        catch (BadLocationException ble) {
            return "";
        }
    }

    public static boolean canBeValidPPLine(String line) {
        StringTokenizer st = new StringTokenizer(line);
        boolean flag = false;
        while (st.hasMoreElements()) {
            String s = st.nextToken();
            if (!s.startsWith(PREFIX)) continue;
            if (flag) {
                return false;
            }
            flag = true;
        }
        return flag;
    }

    public static boolean isLegalOperatorToken(String op) {
        for (int i = 0; i < operatorTokens.length; ++i) {
            if (!operatorTokens[i].equals(op)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLegalOperatorChar(char op) {
        for (int i = 0; i < operatorChars.length; ++i) {
            if (operatorChars[i] != op) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidDirective(String directive) {
        for (int i = 0; i < directives.length; ++i) {
            if (!directive.equals(directives[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean canBeValidDirective(String directive) {
        for (int i = 0; i < directives.length; ++i) {
            if (!directives[i].startsWith(directive)) continue;
            return true;
        }
        return false;
    }

    public static boolean canBeValidVariable(String variable) {
        PreprocessorScanner ps = new PreprocessorScanner((Reader)new StringReader(variable));
        ps.yybegin(1);
        PPToken ppt = null;
        try {
            ppt = ps.nextToken();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        return ppt != null && ppt.getType() == 279;
    }

    public CompletionTask createTask(int queryType, JTextComponent component) {
        ProjectConfigurationsHelper hlp;
        Project p = J2MEProjectUtils.getProjectForDocument((Document)component.getDocument());
        ProjectConfigurationsHelper projectConfigurationsHelper = hlp = p == null ? null : (ProjectConfigurationsHelper)p.getLookup().lookup(ProjectConfigurationsHelper.class);
        if (hlp != null && hlp.isPreprocessorOn()) {
            block6: {
                try {
                    int offset = component.getCaret().getDot();
                    String line = PPCompletionProvider.getLine(component, offset);
                    if (PPCompletionProvider.canBeValidPPLine(line)) {
                        int ancor = org.netbeans.editor.Utilities.getPreviousWord((JTextComponent)component, (int)offset);
                        String word = component.getDocument().getText(ancor, offset - ancor);
                        this.myQueryType = PPCompletionProvider.canBeValidDirective(word) ? (component.getDocument().getText(ancor - 3, 3).equals(PREFIX) ? 998 : 999) : (PREFIX.equals(word) ? 998 : 999);
                        break block6;
                    }
                    return null;
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
            }
            if (queryType == 1 && this.myQueryType == 998) {
                return new AsyncCompletionTask((AsyncCompletionQuery)new DirectiveQuery(), component);
            }
            if (queryType == 1 && this.myQueryType == 999) {
                return new AsyncCompletionTask((AsyncCompletionQuery)new VariableQuery(), component);
            }
        }
        return null;
    }

    static final class DirectiveQuery
    extends AsyncCompletionQuery {
        private static final String[] directives = new String[]{"if", "ifdef", "ifndef", "elifdef", "elifndef", "elif", "endif", "else", "debug", "mdebug", "enddebug", "define", "undefine", "condition"};
        private ArrayList<PPDirectiveCompletionItem> directiveItems;
        private String filterPrefix;
        private JTextComponent component;
        private int ancor;

        DirectiveQuery() {
        }

        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            try {
                int ancor = org.netbeans.editor.Utilities.getPreviousWord((JTextComponent)this.component, (int)caretOffset);
                if (this.canFilter(this.component)) {
                    this.ancor = ancor;
                    resultSet.setTitle(NbBundle.getMessage(PPCompletionProvider.class, (String)"DESC_TITLE_DIRE_CC"));
                    resultSet.setAnchorOffset(ancor);
                    resultSet.addAllItems(this.getFilteredData(this.directiveItems, this.filterPrefix));
                }
            }
            catch (BadLocationException ble) {
                // empty catch block
            }
            resultSet.finish();
        }

        protected boolean canFilter(JTextComponent component) {
            this.filterPrefix = null;
            try {
                int ancor = org.netbeans.editor.Utilities.getPreviousWord((JTextComponent)component, (int)component.getCaret().getDot());
                this.filterPrefix = component.getDocument().getText(ancor, component.getCaret().getDot() - ancor);
                if (PPCompletionProvider.PREFIX.equals(this.filterPrefix)) {
                    this.filterPrefix = "";
                } else if (!PPCompletionProvider.canBeValidDirective(this.filterPrefix) || "".equals(this.filterPrefix)) {
                    this.filterPrefix = null;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return this.filterPrefix != null;
        }

        protected void filter(CompletionResultSet resultSet) {
            if (this.filterPrefix != null) {
                resultSet.setTitle("Available directives");
                resultSet.setAnchorOffset(this.ancor);
                resultSet.addAllItems(this.getFilteredData(this.directiveItems, this.filterPrefix));
                resultSet.finish();
            }
        }

        private Collection<PPDirectiveCompletionItem> getFilteredData(Collection<PPDirectiveCompletionItem> data, String prefix) {
            ArrayList<PPDirectiveCompletionItem> ret = new ArrayList<PPDirectiveCompletionItem>();
            for (PPDirectiveCompletionItem item : data) {
                String name = ((Object)item.getSortText()).toString();
                if (!name.startsWith(prefix)) continue;
                ret.add(item);
            }
            return ret;
        }

        private PPBlockInfo getBlock(JTextComponent component) {
            try {
                BaseDocument doc = (BaseDocument)component.getDocument();
                int lineNumber = org.netbeans.editor.Utilities.getLineOffset((BaseDocument)doc, (int)component.getCaret().getDot());
                ArrayList lineList = (ArrayList)doc.getProperty((Object)"preprocessor.line.list");
                if (lineList != null) {
                    PPLine myPpLine = null;
                    if (lineNumber >= 0 && lineNumber < lineList.size() && (myPpLine = (PPLine)lineList.get(lineNumber)) != null) {
                        return myPpLine.getBlock();
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return null;
        }

        private boolean provideEndIf(JTextComponent component) {
            PPBlockInfo b = this.getBlock(component);
            return this.isIf(b) || this.isElse(b) || this.isElif(b);
        }

        private boolean provideElse(JTextComponent component) {
            PPBlockInfo b = this.getBlock(component);
            return this.isIf(b) || this.isElif(b);
        }

        private boolean isIf(PPBlockInfo b) {
            return b != null && (b.getType() == 0 || b.getType() == 2 || b.getType() == 3);
        }

        private boolean isElse(PPBlockInfo b) {
            return b != null && b.getType() == 4;
        }

        private boolean isElif(PPBlockInfo b) {
            return b != null && (b.getType() == 5 || b.getType() == 6 || b.getType() == 7);
        }

        protected void prepareQuery(JTextComponent component) {
            this.component = component;
            this.directiveItems = new ArrayList();
            for (int i = 0; i < directives.length; ++i) {
                if (directives[i].startsWith("if") || directives[i].equals(PPCompletionProvider.DEBUG) || directives[i].equals("mdebug") || directives[i].equals(PPCompletionProvider.ENDDEBUG) || directives[i].equals("define") || directives[i].equals("undefine") || directives[i].equals("condition")) {
                    this.directiveItems.add(new PPDirectiveCompletionItem(directives[i], NbBundle.getMessage(PPCompletionProvider.class, (String)(PPCompletionProvider.DESCDIR + (i + 1)))));
                    continue;
                }
                if (this.provideEndIf(component) && directives[i].equals(PPCompletionProvider.ENDIF)) {
                    this.directiveItems.add(new PPDirectiveCompletionItem(directives[i], NbBundle.getMessage(PPCompletionProvider.class, (String)(PPCompletionProvider.DESCDIR + (i + 1)))));
                }
                if (this.provideElse(component) && (directives[i].equals("elif") || directives[i].equals("elifdef") || directives[i].equals("elifndef"))) {
                    this.directiveItems.add(new PPDirectiveCompletionItem(directives[i], NbBundle.getMessage(PPCompletionProvider.class, (String)(PPCompletionProvider.DESCDIR + (i + 1)))));
                }
                if (!this.provideElse(component) || !directives[i].equals(PPCompletionProvider.ELSE)) continue;
                this.directiveItems.add(new PPDirectiveCompletionItem(directives[i], NbBundle.getMessage(PPCompletionProvider.class, (String)(PPCompletionProvider.DESCDIR + (i + 1)))));
            }
        }
    }

    static final class VariableQuery
    extends AsyncCompletionQuery {
        private ArrayList<PPVariableCompletionItem> debugItems;
        private ArrayList<PPVariableCompletionItem> variableItems;
        private Set<String> variableSet;
        private JTextComponent component;
        private ProjectConfigurationsHelper pch;
        private String filterPrefix;
        private int ancor;

        VariableQuery() {
        }

        protected void prepareQuery(JTextComponent component) {
            this.component = component;
            this.variableItems = new ArrayList();
            this.debugItems = new ArrayList();
            this.variableSet = new TreeSet<String>();
            this.pch = J2MEProjectUtils.getCfgHelperForDoc((Document)component.getDocument());
            ProjectConfiguration[] devConfigs = this.pch.getConfigurations().toArray(new ProjectConfiguration[0]);
            for (int i = 0; i < devConfigs.length; ++i) {
                this.variableItems.add(new PPVariableCompletionItem(devConfigs[i].getDisplayName(), NbBundle.getMessage(PPCompletionProvider.class, (String)"DESC_CONFIG_CC")));
                Map varMap = this.pch.getAbilitiesFor(devConfigs[i]);
                for (String varName : varMap.keySet()) {
                    this.variableSet.add(varName);
                }
            }
            for (String varName : this.variableSet) {
                this.variableItems.add(new PPVariableCompletionItem(varName, this.getVarInfo(varName)));
            }
            for (int i = 0; i < DEBUG_LEVELS.length; ++i) {
                this.debugItems.add(new PPVariableCompletionItem(DEBUG_LEVELS[i], NbBundle.getMessage(PPCompletionProvider.class, (String)("DESC_DEBUG_CC_" + (i + 1)))));
            }
        }

        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            try {
                int ancor = org.netbeans.editor.Utilities.getPreviousWord((JTextComponent)this.component, (int)caretOffset);
                PPToken tok = new PreprocessorScanner((Reader)new StringReader(Utilities.getLine(this.component))).nextToken();
                if (this.canFilter(this.component)) {
                    this.ancor = ancor;
                    resultSet.setTitle(NbBundle.getMessage(PPCompletionProvider.class, (String)"DESC_TITLE_VAR_CC"));
                    resultSet.setAnchorOffset(ancor);
                    if (tok.getType() == 272 || tok.getType() == 273) {
                        resultSet.addAllItems(this.getFilteredData(this.debugItems, this.filterPrefix));
                    } else {
                        resultSet.addAllItems(this.getFilteredData(this.variableItems, this.filterPrefix));
                    }
                } else {
                    Completion.get().hideCompletion();
                }
            }
            catch (BadLocationException ble) {
            }
            catch (IOException ioe) {
                // empty catch block
            }
            resultSet.finish();
        }

        protected boolean canFilter(JTextComponent component) {
            this.filterPrefix = null;
            try {
                int ancor = org.netbeans.editor.Utilities.getPreviousWord((JTextComponent)component, (int)component.getCaret().getDot());
                String origFilterPrefix = component.getDocument().getText(ancor, component.getCaret().getDot() - ancor);
                this.filterPrefix = origFilterPrefix.trim();
                if (!"".equals(this.filterPrefix) && (this.filterPrefix.length() == 1 ? PPCompletionProvider.isLegalOperatorChar(this.filterPrefix.charAt(this.filterPrefix.length() - 1)) : PPCompletionProvider.isLegalOperatorToken(this.filterPrefix.substring(this.filterPrefix.length() - 2)))) {
                    this.filterPrefix = "";
                } else if (origFilterPrefix.length() > this.filterPrefix.length()) {
                    this.filterPrefix = PPCompletionProvider.isValidDirective(this.filterPrefix) ? (this.filterPrefix.equals(PPCompletionProvider.ENDIF) || this.filterPrefix.equals(PPCompletionProvider.ENDDEBUG) || this.filterPrefix.equals(PPCompletionProvider.ELSE) ? null : "") : null;
                } else if (PPCompletionProvider.isValidDirective(this.filterPrefix)) {
                    this.filterPrefix = null;
                } else if (!PPCompletionProvider.canBeValidVariable(this.filterPrefix)) {
                    this.filterPrefix = null;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return this.filterPrefix != null;
        }

        protected void filter(CompletionResultSet resultSet) {
            if (this.filterPrefix != null) {
                resultSet.setTitle(NbBundle.getMessage(PPCompletionProvider.class, (String)"DESC_TITLE_VAR_CC"));
                resultSet.setAnchorOffset(this.ancor);
                resultSet.addAllItems(this.getFilteredData(this.variableItems, this.filterPrefix));
                resultSet.finish();
            }
        }

        private Collection<PPVariableCompletionItem> getFilteredData(Collection<PPVariableCompletionItem> data, String prefix) {
            ArrayList<PPVariableCompletionItem> ret = new ArrayList<PPVariableCompletionItem>();
            for (PPVariableCompletionItem item : data) {
                String name = ((Object)item.getSortText()).toString();
                if (!name.startsWith(prefix)) continue;
                ret.add(item);
            }
            return ret;
        }

        private String getVarInfo(Object variableName) {
            Map activeAbilities = this.pch.getAbilitiesFor(this.pch.getActiveConfiguration());
            if (!activeAbilities.containsKey(variableName)) {
                return NbBundle.getMessage(PPCompletionProvider.class, (String)"DESC_UNDEFINED_CC");
            }
            if (activeAbilities.get(variableName) == null) {
                return NbBundle.getMessage(PPCompletionProvider.class, (String)"DESC_DEFINED_CC");
            }
            String value = (String)activeAbilities.get(variableName);
            if (value.length() > 30) {
                value = value.substring(0, 29) + "...";
            }
            return NbBundle.getMessage(PPCompletionProvider.class, (String)"DESC_DEFINED_CC") + " <b>(" + value + ")</b>";
        }
    }
}

