/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.pom.spi;

import java.util.prefs.Preferences;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.util.NbPreferences;

public final class Configuration {
    private String id;
    private String description;
    private boolean defaultEnabled;
    static final String ENABLED_KEY = "enabled";
    static final String SEVERITY_KEY = "severity";
    static final String IN_TASK_LIST_KEY = "inTaskList";
    private HintSeverity defaultSeverity;
    private String displayName;

    public Configuration(String id, String displayName, String description, boolean defaultEnabled, HintSeverity defaultSeverity) {
        this.id = id;
        this.description = description;
        this.defaultEnabled = defaultEnabled;
        this.defaultSeverity = defaultSeverity;
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getId() {
        return this.id;
    }

    public Preferences getPreferences() {
        return NbPreferences.forModule(this.getClass()).node(this.getId());
    }

    public String getDescription() {
        return this.description;
    }

    public final boolean isEnabled(Preferences p) {
        return p.getBoolean(ENABLED_KEY, this.defaultEnabled);
    }

    public void setEnabled(Preferences p, boolean value) {
        p.putBoolean(ENABLED_KEY, value);
    }

    public final HintSeverity getSeverity(Preferences p) {
        String s = p.get(SEVERITY_KEY, null);
        return s == null ? this.defaultSeverity : Configuration.fromPreferenceString(s);
    }

    public void setSeverity(Preferences p, HintSeverity severity) {
        p.put(SEVERITY_KEY, severity.toPreferenceString());
    }

    public static HintSeverity fromPreferenceString(String sev) {
        if (sev.equals("error")) {
            return HintSeverity.ERROR;
        }
        if (sev.equals("warning")) {
            return HintSeverity.WARNING;
        }
        throw new IllegalStateException(sev);
    }

    public static enum HintSeverity {
        ERROR,
        WARNING;


        public Severity toEditorSeverity() {
            switch (this) {
                case ERROR: {
                    return Severity.ERROR;
                }
                case WARNING: {
                    return Severity.VERIFIER;
                }
            }
            return null;
        }

        public String toPreferenceString() {
            switch (this) {
                case ERROR: {
                    return "error";
                }
                case WARNING: {
                    return "warning";
                }
            }
            return null;
        }
    }
}

