/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.server;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.gems.GemInfo;
import org.netbeans.modules.ruby.railsprojects.RailsProjectUtil;
import org.netbeans.modules.ruby.railsprojects.server.RailsApplication;
import org.netbeans.modules.ruby.railsprojects.server.RubyServer;
import org.netbeans.modules.ruby.railsprojects.server.nodes.RubyServerNode;
import org.netbeans.modules.ruby.railsprojects.server.spi.RubyInstance;
import org.netbeans.spi.server.ServerInstanceImplementation;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

class GlassFishGem
implements RubyServer,
ServerInstanceImplementation {
    static final String GEM_NAME = "glassfish";
    private static final Pattern[] PATTERNS = new Pattern[]{Pattern.compile(".*INFO: Glassfish v3 started.*", 32), Pattern.compile(".*Press Ctrl\\+C to stop\\..*", 32), Pattern.compile(".*[0-9] milliseconds.*", 32)};
    private final List<RailsApplication> applications = new ArrayList<RailsApplication>();
    private final RubyPlatform platform;
    private final String version;
    private final String location;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private Node node;

    GlassFishGem(RubyPlatform platform, GemInfo gemInfo) {
        Parameters.notNull((CharSequence)"platform", (Object)platform);
        this.platform = platform;
        this.version = gemInfo.getVersion();
        this.location = this.getGemFolder(gemInfo.getSpecFile());
    }

    private String getGemFolder(File specFile) {
        String gemFolderName = specFile.getName();
        if (gemFolderName.endsWith(".gemspec")) {
            gemFolderName = gemFolderName.substring(0, gemFolderName.length() - 8);
        }
        return new File(specFile.getParentFile().getParentFile(), "gems" + File.separatorChar + gemFolderName).getAbsolutePath();
    }

    private Node getNode() {
        if (this.node == null) {
            this.node = new RubyServerNode(this);
        }
        return this.node;
    }

    @Override
    public String getNodeName() {
        return NbBundle.getMessage(GlassFishGem.class, (String)"LBL_ServerNodeName", (Object)this.getDisplayName(), (Object)this.platform.getLabel());
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public List<String> getStartupParams(RailsProjectUtil.RailsVersion version) {
        return Collections.emptyList();
    }

    @Override
    public String getScriptPrefix() {
        return "-S";
    }

    @Override
    public String getServerPath(RailsProjectUtil.RailsVersion version) {
        return this.compareVersion("0.9.4") >= 0 ? GEM_NAME : "glassfish_rails";
    }

    @Override
    public boolean isStartupMsg(String outputLine) {
        for (Pattern each : PATTERNS) {
            if (!each.matcher(outputLine).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<RailsApplication> getApplications() {
        return Collections.unmodifiableList(this.applications);
    }

    @Override
    public boolean addApplication(RailsApplication application) {
        boolean result = this.applications.add(application);
        this.changeSupport.fireChange();
        return result;
    }

    @Override
    public boolean removeApplication(int port) {
        boolean result = false;
        for (RailsApplication app : this.applications) {
            if (app.getPort() != port) continue;
            result = this.applications.remove(app);
            this.changeSupport.fireChange();
            break;
        }
        return result;
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public int compareVersion(String targetVersion) {
        int[] sv = this.extractVersion(this.version);
        int[] tv = this.extractVersion(targetVersion);
        for (int i = 0; i < 3; ++i) {
            if (sv[i] < tv[i]) {
                return -1;
            }
            if (sv[i] <= tv[i]) continue;
            return 1;
        }
        return 0;
    }

    private int[] extractVersion(String vs) {
        int[] v = new int[]{0, 0, 0};
        String[] parts = vs.split("\\.");
        for (int i = 0; i < 3 && i < parts.length; ++i) {
            v[i] = Integer.valueOf(parts[i]);
        }
        return v;
    }

    public String getServerDisplayName() {
        return this.getNodeName();
    }

    public Node getFullNode() {
        return this.getNode();
    }

    public Node getBasicNode() {
        return this.getNode();
    }

    public JComponent getCustomizer() {
        return null;
    }

    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isRemovable() {
        return false;
    }

    @Override
    public String getServerUri() {
        return "GLASSFISH";
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(GlassFishGem.class, (String)"LBL_GlassFish", (Object)this.version);
    }

    @Override
    public RubyInstance.ServerState getServerState() {
        return null;
    }

    @Override
    public Future<RubyInstance.OperationState> startServer(RubyPlatform platform) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Future<RubyInstance.OperationState> stopServer() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Future<RubyInstance.OperationState> deploy(String applicationName, File applicationDir) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Future<RubyInstance.OperationState> stop(String applicationName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Future<RubyInstance.OperationState> runApplication(RubyPlatform platform, String applicationName, File applicationDir) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isPlatformSupported(RubyPlatform platform) {
        return this.platform.equals((Object)platform);
    }

    @Override
    public String getContextRoot(String applicationName) {
        return "";
    }

    @Override
    public int getRailsPort() {
        return 3000;
    }

    @Override
    public String getServerCommand(RubyPlatform platform, String classpath, File applicationDir, int httpPort, boolean debug) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GlassFishGem other = (GlassFishGem)obj;
        if (!(this.platform == other.platform || this.platform != null && this.platform.equals((Object)other.platform))) {
            return false;
        }
        if (!(this.version == other.version || this.version != null && this.version.equals(other.version))) {
            return false;
        }
        return this.location == other.location || this.location != null && this.location.equals(other.location);
    }

    public int hashCode() {
        int hash = 3;
        hash = 47 * hash + (this.platform != null ? this.platform.hashCode() : 0);
        hash = 47 * hash + (this.version != null ? this.version.hashCode() : 0);
        return hash;
    }
}

