/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ext.ffi.jna;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyNumeric;
import org.jruby.nb.RubyString;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.ext.ffi.AbstractMemoryPointer;
import org.jruby.nb.ext.ffi.FFIProvider;
import org.jruby.nb.ext.ffi.MemoryIO;
import org.jruby.nb.ext.ffi.Util;
import org.jruby.nb.ext.ffi.jna.JNAMemoryIO;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

@JRubyClass(name={"JRuby::FFI::MemoryPointer"}, parent="JRuby::FFI::AbstractMemoryPointer")
public class JNAMemoryPointer
extends AbstractMemoryPointer {
    public static final String MEMORY_POINTER_NAME = "MemoryPointer";

    public static RubyClass createMemoryPointerClass(Ruby runtime) {
        RubyModule module = FFIProvider.getModule(runtime);
        RubyClass result = module.defineClassUnder(MEMORY_POINTER_NAME, module.getClass("AbstractMemoryPointer"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        result.defineAnnotatedMethods(JNAMemoryPointer.class);
        result.defineAnnotatedConstants(JNAMemoryPointer.class);
        return result;
    }

    public JNAMemoryPointer(Ruby runtime, RubyClass klass) {
        super(runtime, klass, JNAMemoryIO.wrap(Pointer.NULL), 0L, 0L);
    }

    JNAMemoryPointer(Ruby runtime, Pointer value) {
        this(runtime, JNAMemoryIO.wrap(value), 0L, Long.MAX_VALUE);
    }

    private JNAMemoryPointer(Ruby runtime, JNAMemoryPointer ptr, long offset) {
        this(runtime, ptr.io, ptr.offset + offset, ptr.size == Long.MAX_VALUE ? Long.MAX_VALUE : ptr.size - offset);
    }

    JNAMemoryPointer(Ruby runtime, MemoryIO io, long offset, long size) {
        super(runtime, FFIProvider.getModule(runtime).fastGetClass(MEMORY_POINTER_NAME), io, offset, size);
    }

    @JRubyMethod(name={"allocate", "allocate_direct", "allocateDirect"}, meta=true)
    public static JNAMemoryPointer allocateDirect(ThreadContext context, IRubyObject recv, IRubyObject sizeArg) {
        int size = Util.int32Value(sizeArg);
        JNAMemoryIO io = size > 0 ? JNAMemoryIO.allocateDirect(size) : JNAMemoryIO.NULL;
        return new JNAMemoryPointer(context.getRuntime(), io, 0L, size);
    }

    @JRubyMethod(name={"allocate", "allocate_direct", "allocateDirect"}, meta=true)
    public static JNAMemoryPointer allocateDirect(ThreadContext context, IRubyObject recv, IRubyObject sizeArg, IRubyObject clearArg) {
        JNAMemoryIO io;
        int size = Util.int32Value(sizeArg);
        JNAMemoryIO jNAMemoryIO = io = size > 0 ? JNAMemoryIO.allocateDirect(size) : JNAMemoryIO.NULL;
        if (clearArg.isTrue()) {
            io.setMemory(0L, size, (byte)0);
        }
        return new JNAMemoryPointer(context.getRuntime(), io, 0L, size);
    }

    @Override
    @JRubyMethod(name={"to_s"}, optional=1)
    public IRubyObject to_s(ThreadContext context, IRubyObject[] args) {
        String hex = ((JNAMemoryIO)this.getMemoryIO()).getAddress().toString();
        return RubyString.newString(context.getRuntime(), "MemoryPointer[address=" + hex + "]");
    }

    Pointer getAddress() {
        return ((JNAMemoryIO)this.getMemoryIO()).getAddress();
    }

    public Object getNativeMemory() {
        return ((JNAMemoryIO)this.getMemoryIO()).slice(this.offset).getMemory();
    }

    private static final long ptr2long(Pointer ptr) {
        return new PointerByReference(ptr).getPointer().getInt(0L);
    }

    @JRubyMethod(name={"address"})
    public IRubyObject address(ThreadContext context) {
        return context.getRuntime().newFixnum(JNAMemoryPointer.ptr2long(this.getAddress()));
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        String hex = Long.toHexString(JNAMemoryPointer.ptr2long(this.getAddress()) + this.offset);
        return RubyString.newString(context.getRuntime(), String.format("#<MemoryPointer address=0x%s>", hex));
    }

    @JRubyMethod(name={"+"}, required=1)
    public IRubyObject op_plus(ThreadContext context, IRubyObject value) {
        return new JNAMemoryPointer(context.getRuntime(), this, RubyNumeric.fix2long(value));
    }

    @JRubyMethod(name={"put_pointer"}, required=2)
    public IRubyObject put_pointer(ThreadContext context, IRubyObject offset, IRubyObject value) {
        Pointer ptr;
        if (value instanceof JNAMemoryPointer) {
            ptr = ((JNAMemoryPointer)value).getAddress();
        } else if (value.isNil()) {
            ptr = Pointer.NULL;
        } else {
            throw context.getRuntime().newArgumentError("Cannot convert argument to pointer");
        }
        ((JNAMemoryIO)this.getMemoryIO()).putPointer(this.getOffset(offset), ptr);
        return this;
    }

    @Override
    protected AbstractMemoryPointer getMemoryPointer(Ruby runtime, long offset) {
        return new JNAMemoryPointer(runtime, this.getMemoryIO().getMemoryIO(this.offset + offset), 0L, Long.MAX_VALUE);
    }
}

