/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import javax.swing.text.Document;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class JsUtils {
    public static final String HTML_MIME_TYPE = "text/html";
    public static final String[] CALL_KEYWORDS = new String[]{"true", "false", "null"};
    public static final String[] JAVASCRIPT_KEYWORDS = new String[]{"break", "case", "catch", "continue", "default", "delete", "do", "else", "false", "finally", "for", "function", "if", "in", "instanceof", "let", "new", "null", "return", "switch", "this", "throw", "true", "try", "typeof", "undefined", "var", "void", "while", "with", "yield"};
    public static final String[] JAVASCRIPT_RESERVED_WORDS = new String[]{"abstract", "boolean", "byte", "char", "class", "const", "debugger", "double", "enum", "export", "extends", "final", "float", "goto", "implements", "import", "int", "interface", "long", "native", "package", "private", "protected", "public", "short", "static", "super", "synchronized", "throws", "transient", "volatile"};

    private JsUtils() {
    }

    public static boolean isJsFile(FileObject f) {
        return "text/javascript".equals(f.getMIMEType());
    }

    public static boolean isJsOrJsonDocument(Document doc) {
        String mimeType = (String)doc.getProperty("mimeType");
        return "text/javascript".equals(mimeType) || "text/x-json".equals(mimeType);
    }

    public static boolean isJsonFile(FileObject f) {
        return f != null && "json".equals(f.getExt());
    }

    public static boolean isEjsFile(FileObject f) {
        return f != null && "ejs".equals(f.getExt());
    }

    public static boolean isSafeIdentifierName(String name, int fromIndex) {
        int i = fromIndex;
        if (i >= name.length()) {
            return i != 0;
        }
        if (i == 0) {
            if (JsUtils.isJsKeyword(name)) {
                return false;
            }
            if (Character.isDigit(name.charAt(0))) {
                return false;
            }
        }
        while (i < name.length()) {
            char c = name.charAt(i);
            if (c == '\\' ? i == name.length() - 1 || name.charAt(i + 1) != 'u' : c != '$' && c != '_' && !Character.isLetterOrDigit(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String getIdentifierWarning(String name, int fromIndex) {
        if (JsUtils.isSafeIdentifierName(name, fromIndex)) {
            return null;
        }
        return NbBundle.getMessage(JsUtils.class, (String)"UnsafeIdentifierName");
    }

    public static boolean isValidJsClassName(String name) {
        if (JsUtils.isJsKeyword(name)) {
            return false;
        }
        if (name.trim().length() == 0) {
            return false;
        }
        if (!Character.isUpperCase(name.charAt(0))) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (JsUtils.isStrictIdentifierChar(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidJsMethodName(String name) {
        return JsUtils.isSafeIdentifierName(name, 0);
    }

    public static boolean isValidJsIdentifier(String name) {
        return JsUtils.isSafeIdentifierName(name, 0);
    }

    public static boolean isJsKeyword(String name) {
        for (String s : JAVASCRIPT_KEYWORDS) {
            if (!s.equals(name)) continue;
            return true;
        }
        return false;
    }

    public static String getLineCommentPrefix() {
        return "//";
    }

    public static boolean isIdentifierChar(char c) {
        return Character.isJavaIdentifierPart(c) || c == '$' || c == '\\';
    }

    public static boolean isStrictIdentifierChar(char c) {
        return Character.isJavaIdentifierPart(c) || c == '$' || c == '\\';
    }

    public static String normalizeTypeString(String s) {
        if (s.indexOf("Array<") != -1) {
            String[] types = s.split("\\|");
            StringBuilder sb = new StringBuilder();
            for (String t : types) {
                if (sb.length() > 0) {
                    sb.append("|");
                }
                if (t.startsWith("Array<") && t.endsWith(">")) {
                    sb.append(t.substring(6, t.length() - 1));
                    sb.append("[]");
                    continue;
                }
                sb.append(t);
            }
            return sb.toString();
        }
        return s;
    }
}

