/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.ValueNodeList;

public abstract class BinaryListOperatorNode
extends ValueNode {
    String methodName;
    String operator;
    String leftInterfaceType;
    String rightInterfaceType;
    ValueNode receiver;
    ValueNode leftOperand;
    ValueNodeList rightOperandList;

    public void init(Object object, Object object2, Object object3, Object object4) {
        this.leftOperand = (ValueNode)object;
        this.rightOperandList = (ValueNodeList)object2;
        this.operator = (String)object3;
        this.methodName = (String)object4;
    }

    public String toString() {
        return "";
    }

    public void printSubNodes(int n) {
    }

    public void setClause(int n) {
        super.setClause(n);
        this.leftOperand.setClause(n);
        this.rightOperandList.setClause(n);
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        this.leftOperand = this.leftOperand.bindExpression(fromList, subqueryList, vector);
        this.rightOperandList.bindExpression(fromList, subqueryList, vector);
        if (this.leftOperand.requiresTypeFromContext()) {
            ValueNode valueNode = (ValueNode)this.rightOperandList.elementAt(0);
            if (this.rightOperandList.containsAllParameterNodes()) {
                throw StandardException.newException("42X35", this.operator);
            }
            this.leftOperand.setType(this.rightOperandList.getTypeServices());
        }
        if (this.rightOperandList.containsParameterNode()) {
            this.rightOperandList.setParameterDescriptor(this.leftOperand.getTypeServices());
        }
        if (this.leftOperand.getTypeId().userType()) {
            this.leftOperand = this.leftOperand.genSQLJavaSQLTree();
        }
        this.rightOperandList.genSQLJavaSQLTrees();
        this.bindComparisonOperator();
        return this;
    }

    public void bindComparisonOperator() throws StandardException {
        this.rightOperandList.comparable(this.leftOperand);
        boolean bl = this.leftOperand.getTypeServices().isNullable() || this.rightOperandList.isNullable();
        this.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, bl));
    }

    public ValueNode preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        this.leftOperand = this.leftOperand.preprocess(n, fromList, subqueryList, predicateList);
        this.rightOperandList.preprocess(n, fromList, subqueryList, predicateList);
        return this;
    }

    public void setLeftOperand(ValueNode valueNode) {
        this.leftOperand = valueNode;
    }

    public ValueNode getLeftOperand() {
        return this.leftOperand;
    }

    public void setRightOperandList(ValueNodeList valueNodeList) {
        this.rightOperandList = valueNodeList;
    }

    public ValueNodeList getRightOperandList() {
        return this.rightOperandList;
    }

    public boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        boolean bl2 = this.leftOperand.categorize(jBitSet, bl);
        bl2 = this.rightOperandList.categorize(jBitSet, bl) && bl2;
        return bl2;
    }

    public ValueNode remapColumnReferencesToExpressions() throws StandardException {
        this.leftOperand = this.leftOperand.remapColumnReferencesToExpressions();
        this.rightOperandList.remapColumnReferencesToExpressions();
        return this;
    }

    public boolean isConstantExpression() {
        return this.leftOperand.isConstantExpression() && this.rightOperandList.isConstantExpression();
    }

    public boolean constantExpression(PredicateList predicateList) {
        return this.leftOperand.constantExpression(predicateList) && this.rightOperandList.constantExpression(predicateList);
    }

    protected int getOrderableVariantType() throws StandardException {
        int n = this.leftOperand.getOrderableVariantType();
        int n2 = this.rightOperandList.getOrderableVariantType();
        return Math.min(n, n2);
    }

    public Visitable accept(Visitor visitor) throws StandardException {
        Visitable visitable = visitor.visit(this);
        if (visitor.skipChildren(this)) {
            return visitable;
        }
        if (this.leftOperand != null && !visitor.stopTraversal()) {
            this.leftOperand = (ValueNode)this.leftOperand.accept(visitor);
        }
        if (this.rightOperandList != null && !visitor.stopTraversal()) {
            this.rightOperandList = (ValueNodeList)this.rightOperandList.accept(visitor);
        }
        return visitable;
    }

    protected boolean isEquivalent(ValueNode valueNode) throws StandardException {
        if (!this.isSameNodeType(valueNode)) {
            return false;
        }
        BinaryListOperatorNode binaryListOperatorNode = (BinaryListOperatorNode)valueNode;
        if (!this.operator.equals(binaryListOperatorNode.operator) || !this.leftOperand.isEquivalent(binaryListOperatorNode.getLeftOperand())) {
            return false;
        }
        int n = this.getRightOperandList().size();
        if (n != binaryListOperatorNode.rightOperandList.size()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            ValueNode valueNode2 = (ValueNode)this.rightOperandList.elementAt(i);
            if (valueNode2.isEquivalent((ValueNode)binaryListOperatorNode.rightOperandList.elementAt(i))) continue;
            return false;
        }
        return true;
    }
}

