/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.codecoverage;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.codecoverage.CoverageManagerImpl;
import org.netbeans.modules.gsf.codecoverage.api.CoverageProvider;
import org.openide.awt.Actions;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public final class CoverageAction
extends AbstractAction
implements ContextAwareAction {
    private static final int ACTION_TOGGLE_COLLECT = 1;
    private static final int ACTION_TOGGLE_AGGREGATION = 2;
    private static final int ACTION_CLEAR_RESULTS = 3;
    private static final int ACTION_SHOW_REPORT = 4;
    private static final int ACTION_TOGGLE_EDITORBAR = 5;
    private Action configureAction;
    private Action[] extraActions;

    public CoverageAction(Action configureAction, Action[] extraActions) {
        this.configureAction = configureAction;
        this.extraActions = extraActions;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        assert (false) : "Action should never be called without a context";
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new ContextAction(actionContext, this.configureAction, this.extraActions);
    }

    private static JMenu createMenu(Project project, Action configureAction, Action[] extraActions) {
        return new LazyMenu(project, configureAction, extraActions);
    }

    static void buildMenu(JMenu menu, Project project, Action configureAction, Action[] extraActions) {
        boolean enabled = true;
        if (configureAction != null && configureAction.isEnabled()) {
            enabled = false;
            JMenuItem menuitem = new JMenuItem((String)configureAction.getValue("Name"));
            menuitem.addActionListener(configureAction);
            menu.add(menuitem);
            menu.addSeparator();
            enabled = false;
        }
        CoverageManagerImpl manager = CoverageManagerImpl.getInstance();
        boolean selected = manager.isEnabled(project);
        JMenuItem menuitem = new JCheckBoxMenuItem(NbBundle.getMessage(CoverageAction.class, (String)"LBL_CollectCoverageAction"), selected);
        menuitem.addActionListener(new CoverageItemHandler(project, 1));
        if (!enabled) {
            menuitem.setEnabled(false);
        }
        menu.add(menuitem);
        CoverageProvider provider = CoverageManagerImpl.getProvider(project);
        if (provider == null) {
            return;
        }
        boolean on = provider.isEnabled();
        if (provider.supportsAggregation()) {
            menu.addSeparator();
            boolean aggregating = manager.isAggregating(project);
            menuitem = new JCheckBoxMenuItem(NbBundle.getMessage(CoverageAction.class, (String)"LBL_AggregateResults"), aggregating);
            menuitem.addActionListener(new CoverageItemHandler(project, 2));
            if (!enabled || !on) {
                menuitem.setEnabled(false);
            }
            menu.add(menuitem);
        }
        menuitem = new JMenuItem(NbBundle.getMessage(CoverageAction.class, (String)"LBL_ClearResultsAction"));
        menuitem.addActionListener(new CoverageItemHandler(project, 3));
        if (!enabled || !on) {
            menuitem.setEnabled(false);
        }
        menu.add(menuitem);
        menu.addSeparator();
        menuitem = new JMenuItem(NbBundle.getMessage(CoverageAction.class, (String)"LBL_ShowReportAction"));
        menuitem.addActionListener(new CoverageItemHandler(project, 4));
        if (!enabled || !on) {
            menuitem.setEnabled(false);
        }
        menu.add(menuitem);
        menu.addSeparator();
        menuitem = new JCheckBoxMenuItem(NbBundle.getMessage(CoverageAction.class, (String)"LBL_ShowEditorBar"), manager.getShowEditorBar());
        menuitem.addActionListener(new CoverageItemHandler(project, 5));
        if (!enabled || !on) {
            menuitem.setEnabled(false);
        }
        menu.add(menuitem);
        menu.add(menuitem);
        if (extraActions != null && extraActions.length > 0) {
            menu.addSeparator();
            for (Action action : extraActions) {
                String name = (String)action.getValue("Name");
                String SELECTED_KEY = "SwingSelectedKey";
                Boolean sel = (Boolean)action.getValue(SELECTED_KEY);
                menuitem = sel != null ? new JCheckBoxMenuItem(name, sel) : new JMenuItem(name);
                menuitem.addActionListener(configureAction);
                if (!enabled || !on) {
                    menuitem.setEnabled(false);
                }
                menu.add(menuitem);
            }
        }
    }

    private static final class CoverageItemHandler
    implements ActionListener {
        private final Project project;
        private final int action;

        public CoverageItemHandler(Project project, int action) {
            this.project = project;
            this.action = action;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            CoverageManagerImpl manager = CoverageManagerImpl.getInstance();
            switch (this.action) {
                case 1: {
                    boolean enabled = ((JCheckBoxMenuItem)ev.getSource()).isSelected();
                    manager.setEnabled(this.project, enabled);
                    break;
                }
                case 2: {
                    boolean enabled = ((JCheckBoxMenuItem)ev.getSource()).isSelected();
                    manager.setAggregating(this.project, enabled);
                    break;
                }
                case 4: {
                    manager.showReport(this.project);
                    break;
                }
                case 3: {
                    manager.clear(this.project);
                    break;
                }
                case 5: {
                    boolean enabled = ((JCheckBoxMenuItem)ev.getSource()).isSelected();
                    manager.setShowEditorBar(enabled);
                    break;
                }
            }
        }
    }

    private static final class LazyMenu
    extends JMenu {
        private final Project project;
        private boolean initialized = false;
        private Action configureAction;
        private Action[] extraActions;

        public LazyMenu(Project project, Action configureAction, Action[] extraActions) {
            super(NbBundle.getMessage(CoverageAction.class, (String)"LBL_CodeCoverage"));
            this.project = project;
            this.configureAction = configureAction;
            this.extraActions = extraActions;
        }

        @Override
        public JPopupMenu getPopupMenu() {
            if (!this.initialized) {
                this.initialized = true;
                super.removeAll();
                CoverageAction.buildMenu(this, this.project, this.configureAction, this.extraActions);
            }
            return super.getPopupMenu();
        }
    }

    private static final class ContextAction
    extends AbstractAction
    implements Presenter.Popup {
        private final Project project;
        private Action configureAction;
        private Action[] extraActions;

        public ContextAction(Lookup lkp, Action configureAction, Action[] extraActions) {
            super(NbBundle.getMessage(CoverageAction.class, (String)"LBL_CodeCoverage"));
            this.configureAction = configureAction;
            this.extraActions = extraActions;
            Collection apcs = lkp.lookupAll(Project.class);
            this.project = apcs.size() == 1 ? (Project)apcs.iterator().next() : null;
            super.setEnabled(this.project != null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            assert (false) : "Action should not be called directly";
        }

        public JMenuItem getPopupPresenter() {
            if (this.project != null) {
                return CoverageAction.createMenu(this.project, this.configureAction, this.extraActions);
            }
            return new Actions.MenuItem((Action)this, false);
        }

        @Override
        public void setEnabled(boolean b) {
            assert (false) : "No modifications to enablement status permitted";
        }
    }
}

