/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.actions;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.css.actions.CssDisplayer;
import org.netbeans.modules.css.actions.XMLDisplayer;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;
import org.w3c.flute.parser.Parser;

public class CheckStyleAction
extends NodeAction
implements ErrorHandler,
DocumentHandler {
    private boolean failed;
    private int warnings;
    private DataObject csso;
    private CssDisplayer disp;

    public String getName() {
        return NbBundle.getMessage(CheckStyleAction.class, (String)"NAME_check_CSS");
    }

    protected String iconResource() {
        return "org/netbeans/modules/css/resources/checkStyleAction.gif";
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CheckStyleAction.class.getName());
    }

    protected boolean enable(Node[] activatedNodes) {
        return true;
    }

    protected void performAction(Node[] activatedNodes) {
        try {
            assert (activatedNodes.length > 0);
            Node node = activatedNodes[0];
            EditorCookie ec = (EditorCookie)node.getCookie(EditorCookie.class);
            if (ec == null) {
                return;
            }
            this.csso = (DataObject)node.getLookup().lookup(DataObject.class);
            if (this.csso == null) {
                return;
            }
            BaseDocument bdoc = (BaseDocument)ec.openDocument();
            if (bdoc == null) {
                return;
            }
            this.failed = false;
            this.warnings = 0;
            this.disp = new CssDisplayer();
            Parser parser = new Parser();
            parser.setErrorHandler(this);
            parser.setDocumentHandler(this);
            try {
                SaveCookie cake = (SaveCookie)this.csso.getCookie(SaveCookie.class);
                if (cake != null) {
                    cake.save();
                }
                String uri = this.csso.getPrimaryFile().getURL().toExternalForm();
                parser.parseStyleSheet(uri);
            }
            catch (IOException ex) {
                this.failed = true;
            }
            catch (CSSParseException ex) {
                this.failed = true;
            }
            catch (Throwable t) {
                this.disp.display("Unexpected exception from CSS parser: " + t.getMessage());
                Logger.global.log(Level.INFO, "Unexpected exception from CSS parser", t);
                this.failed = true;
            }
            if (this.failed || this.warnings > 0) {
                this.disp.moveToFront();
            }
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(XMLDisplayer.class, (String)"TEXT_PART_CSS_checking") + " " + this.getStatus() + ".");
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private String getStatus() {
        return this.failed ? NbBundle.getMessage(XMLDisplayer.class, (String)"TEXT_PART_failed") : (this.warnings > 1 ? NbBundle.getMessage(XMLDisplayer.class, (String)"TEXT_PART_finished_with_warnings") : NbBundle.getMessage(XMLDisplayer.class, (String)"TEXT_PART_finished"));
    }

    @Override
    public void warning(CSSParseException exception) throws CSSException {
        this.disp.display(this.csso, exception);
        ++this.warnings;
    }

    @Override
    public void error(CSSParseException exception) throws CSSException {
        this.disp.display(this.csso, exception);
        this.failed = true;
    }

    @Override
    public void fatalError(CSSParseException exception) throws CSSException {
        this.disp.display(this.csso, exception);
        this.failed = true;
    }

    @Override
    public void startDocument(InputSource source) throws CSSException {
    }

    @Override
    public void endDocument(InputSource source) throws CSSException {
    }

    @Override
    public void comment(String text) throws CSSException {
    }

    @Override
    public void ignorableAtRule(String atRule) throws CSSException {
    }

    @Override
    public void namespaceDeclaration(String prefix, String uri) throws CSSException {
    }

    @Override
    public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException {
    }

    @Override
    public void startMedia(SACMediaList media) throws CSSException {
    }

    @Override
    public void endMedia(SACMediaList media) throws CSSException {
    }

    @Override
    public void startPage(String name, String pseudo_page) throws CSSException {
    }

    @Override
    public void endPage(String name, String pseudo_page) throws CSSException {
    }

    @Override
    public void startFontFace() throws CSSException {
    }

    @Override
    public void endFontFace() throws CSSException {
    }

    @Override
    public void startSelector(SelectorList selectors) throws CSSException {
    }

    @Override
    public void endSelector(SelectorList selectors) throws CSSException {
    }

    @Override
    public void property(String name, LexicalUnit value, boolean important) throws CSSException {
    }
}

