/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.editor.AtomicLockEvent;
import org.netbeans.editor.AtomicLockListener;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.impl.SourceAccessor;
import org.netbeans.modules.parsing.impl.SourceFlags;
import org.netbeans.modules.parsing.impl.Utilities;
import org.netbeans.modules.parsing.impl.event.EventSupport;
import org.netbeans.modules.parsing.impl.indexing.CacheFolder;
import org.netbeans.modules.parsing.impl.indexing.CancelRequest;
import org.netbeans.modules.parsing.impl.indexing.ClusteredIndexables;
import org.netbeans.modules.parsing.impl.indexing.Crawler;
import org.netbeans.modules.parsing.impl.indexing.DeletedIndexable;
import org.netbeans.modules.parsing.impl.indexing.EventKind;
import org.netbeans.modules.parsing.impl.indexing.FileEventLog;
import org.netbeans.modules.parsing.impl.indexing.FileObjectCrawler;
import org.netbeans.modules.parsing.impl.indexing.FileObjectIndexable;
import org.netbeans.modules.parsing.impl.indexing.FileObjectProvider;
import org.netbeans.modules.parsing.impl.indexing.IndexImpl;
import org.netbeans.modules.parsing.impl.indexing.IndexableImpl;
import org.netbeans.modules.parsing.impl.indexing.IndexerCache;
import org.netbeans.modules.parsing.impl.indexing.Pair;
import org.netbeans.modules.parsing.impl.indexing.PathRecognizerRegistry;
import org.netbeans.modules.parsing.impl.indexing.PathRegistry;
import org.netbeans.modules.parsing.impl.indexing.PathRegistryEvent;
import org.netbeans.modules.parsing.impl.indexing.PathRegistryListener;
import org.netbeans.modules.parsing.impl.indexing.ProxyIterable;
import org.netbeans.modules.parsing.impl.indexing.SPIAccessor;
import org.netbeans.modules.parsing.impl.indexing.TimeStamps;
import org.netbeans.modules.parsing.impl.indexing.Util;
import org.netbeans.modules.parsing.impl.indexing.errors.TaskCache;
import org.netbeans.modules.parsing.impl.indexing.friendapi.IndexingActivityInterceptor;
import org.netbeans.modules.parsing.impl.indexing.friendapi.IndexingController;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.indexing.BinaryIndexer;
import org.netbeans.modules.parsing.spi.indexing.BinaryIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexer;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexer;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.parsing.spi.indexing.SourceIndexerFactory;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.TopologicalSortException;

public final class RepositoryUpdater
implements PathRegistryListener,
PropertyChangeListener,
DocumentListener,
AtomicLockListener {
    final FileEventLog eventQueue = new FileEventLog();
    private static RepositoryUpdater instance;
    private static final Logger LOGGER;
    private static final Logger TEST_LOGGER;
    private static final Logger SFEC_LOGGER;
    private static final boolean PERF_TEST;
    private static final boolean notInterruptible;
    private static final boolean useRecursiveListeners;
    private static final int FILE_LOCKS_DELAY;
    private static final String PROP_LAST_INDEXED_VERSION;
    private static final String PROP_LAST_DIRTY_VERSION;
    private static final String PROP_MODIFIED_UNDER_WRITE_LOCK;
    private static final String PROP_OWNING_SOURCE_ROOT_URL;
    private static final String PROP_OWNING_SOURCE_ROOT;
    static final List<URL> EMPTY_DEPS;
    private final Map<URL, List<URL>> scannedRoots2Dependencies = Collections.synchronizedMap(new TreeMap(new LexicographicComparator(true)));
    private final Map<URL, List<URL>> scannedBinaries2InvDependencies = Collections.synchronizedMap(new HashMap());
    private final Set<URL> scannedUnknown = Collections.synchronizedSet(new HashSet());
    private final Set<URL> sourcesForBinaryRoots = Collections.synchronizedSet(new HashSet());
    private volatile State state = State.CREATED;
    private volatile Task worker;
    private volatile Reference<Document> activeDocumentRef = null;
    private volatile Reference<JTextComponent> activeComponentRef = null;
    private Lookup.Result<? extends IndexingActivityInterceptor> indexingActivityInterceptors = null;
    private IndexingController controller;
    private final String lastOwningSourceRootCacheLock = new String("lastOwningSourceRootCacheLock");
    private boolean ignoreIndexerCacheEvents = false;
    final RootsListeners rootsListeners = new RootsListeners();
    private final FileChangeListener sourceRootsListener = new FCL(useRecursiveListeners ? Boolean.TRUE : null);
    private final FileChangeListener binaryRootsListener = new FCL(Boolean.FALSE);
    private final ThreadLocal<Boolean> inIndexer = new ThreadLocal();
    private static final Map<List<StackTraceElement>, Long> lastRecordedStackTraces;
    private static long stackTraceId;
    private static final Comparator<URL> C;

    public static synchronized RepositoryUpdater getDefault() {
        if (instance == null) {
            instance = new RepositoryUpdater();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(boolean force) {
        InitialRootsWork work = null;
        RepositoryUpdater repositoryUpdater = this;
        synchronized (repositoryUpdater) {
            if (this.state == State.CREATED) {
                this.state = State.STARTED;
                LOGGER.fine("Initializing...");
                this.indexingActivityInterceptors = Lookup.getDefault().lookupResult(IndexingActivityInterceptor.class);
                PathRegistry.getDefault().addPathRegistryListener(this);
                this.rootsListeners.setListener(this.sourceRootsListener, this.binaryRootsListener);
                EditorRegistry.addPropertyChangeListener((PropertyChangeListener)this);
                IndexerCache.getCifCache().addPropertyChangeListener(this);
                IndexerCache.getEifCache().addPropertyChangeListener(this);
                if (force) {
                    work = new InitialRootsWork(this.scannedRoots2Dependencies, this.scannedBinaries2InvDependencies, this.sourcesForBinaryRoots, false);
                }
            }
        }
        if (work != null) {
            this.scheduleWork(work, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        boolean cancel = false;
        RepositoryUpdater repositoryUpdater = this;
        synchronized (repositoryUpdater) {
            if (this.state != State.STOPPED) {
                this.state = State.STOPPED;
                LOGGER.fine("Closing...");
                PathRegistry.getDefault().removePathRegistryListener(this);
                this.rootsListeners.setListener(null, null);
                EditorRegistry.removePropertyChangeListener((PropertyChangeListener)this);
                cancel = true;
            }
        }
        if (cancel) {
            this.getWorker().cancelAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isScanInProgress() {
        boolean openingProjects;
        boolean beforeInitialScanStarted;
        RepositoryUpdater repositoryUpdater = this;
        synchronized (repositoryUpdater) {
            beforeInitialScanStarted = this.state == State.CREATED || this.state == State.STARTED;
        }
        try {
            Future f = OpenProjects.getDefault().openProjects();
            openingProjects = !f.isDone() || ((Project[])f.get()).length > 0;
        }
        catch (Exception ie) {
            openingProjects = true;
        }
        return beforeInitialScanStarted && openingProjects || this.getWorker().isWorking() || !PathRegistry.getDefault().isFinished();
    }

    public boolean isProtectedModeOwner(Thread thread) {
        return this.getWorker().isProtectedModeOwner(thread);
    }

    public boolean isIndexer() {
        return this.inIndexer.get() == Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runIndexer(Runnable indexer) {
        assert (indexer != null);
        this.inIndexer.set(Boolean.TRUE);
        try {
            indexer.run();
        }
        finally {
            this.inIndexer.remove();
        }
    }

    public boolean waitUntilFinished(long timeout) throws InterruptedException {
        long ts1;
        long ts2 = ts1 = System.currentTimeMillis();
        do {
            boolean timedOut = !this.getWorker().waitUntilFinished(timeout);
            ts2 = System.currentTimeMillis();
            if (!timedOut) continue;
            return false;
        } while (this.isScanInProgress() && (timeout <= 0L || ts2 - ts1 < timeout));
        return timeout <= 0L || ts2 - ts1 < timeout;
    }

    public void addIndexingJob(URL rootUrl, Collection<? extends URL> fileUrls, boolean followUpJob, boolean checkEditor, boolean wait, boolean forceRefresh, boolean steady) {
        FileObject root;
        assert (rootUrl != null);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("addIndexingJob: rootUrl=" + rootUrl + ", fileUrls=" + fileUrls + ", followUpJob=" + followUpJob + ", checkEditor=" + checkEditor + ", wait=" + wait);
        }
        if ((root = URLMapper.findFileObject((URL)rootUrl)) == null) {
            LOGGER.info(rootUrl + " can't be translated to FileObject");
            return;
        }
        FileListWork flw = null;
        if (fileUrls != null && fileUrls.size() > 0) {
            HashSet<FileObject> files = new HashSet<FileObject>();
            for (URL uRL : fileUrls) {
                FileObject file = URLMapper.findFileObject((URL)uRL);
                if (file == null) continue;
                if (FileUtil.isParentOf((FileObject)root, (FileObject)file)) {
                    files.add(file);
                    continue;
                }
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.warning(file + " does not lie under " + root + ", not indexing it");
            }
            if (files.size() > 0) {
                flw = new FileListWork(this.scannedRoots2Dependencies, rootUrl, files, followUpJob, checkEditor, forceRefresh, this.sourcesForBinaryRoots.contains(rootUrl), steady);
            }
        } else {
            flw = new FileListWork(this.scannedRoots2Dependencies, rootUrl, followUpJob, checkEditor, forceRefresh, this.sourcesForBinaryRoots.contains(rootUrl));
        }
        if (flw != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Scheduling index refreshing: root=" + rootUrl + ", files=" + fileUrls);
            }
            this.scheduleWork(flw, wait);
        }
    }

    public void addIndexingJob(String indexerName) {
        Collection<IndexerCache.IndexerInfo<CustomIndexerFactory>> cifInfos;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("addIndexingJob: indexerName=" + indexerName);
        }
        if ((cifInfos = IndexerCache.getCifCache().getIndexersByName(indexerName)) == null) {
            throw new InvalidParameterException("No CustomIndexerFactory with name: '" + indexerName + "'");
        }
        RefreshCifIndices w = new RefreshCifIndices(cifInfos, this.scannedRoots2Dependencies, this.sourcesForBinaryRoots);
        this.scheduleWork(w, false);
    }

    public void refreshAll(boolean fullRescan, boolean wait, boolean logStatistics, Object ... filesOrFileObjects) {
        FSRefreshInterceptor fsRefreshInterceptor = null;
        for (IndexingActivityInterceptor iai : this.indexingActivityInterceptors.allInstances()) {
            if (!(iai instanceof FSRefreshInterceptor)) continue;
            fsRefreshInterceptor = (FSRefreshInterceptor)iai;
            break;
        }
        this.scheduleWork(new RefreshWork(this.scannedRoots2Dependencies, this.scannedBinaries2InvDependencies, this.sourcesForBinaryRoots, fullRescan, logStatistics, filesOrFileObjects == null ? Collections.emptySet() : Arrays.asList(filesOrFileObjects), fsRefreshInterceptor), wait);
    }

    public synchronized IndexingController getController() {
        if (this.controller == null) {
            this.controller = new Controller();
        }
        return this.controller;
    }

    @Override
    public void pathsChanged(PathRegistryEvent event) {
        assert (event != null);
        if (LOGGER.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Paths changed:\n");
            for (PathRegistryEvent.Change change : event.getChanges()) {
                sb.append(" event=").append((Object)change.getEventKind());
                sb.append(" pathKind=").append((Object)change.getPathKind());
                sb.append(" pathType=").append(change.getPathId());
                sb.append(" affected paths:\n");
                Set<? extends ClassPath> set = change.getAffectedPaths();
                if (set != null) {
                    for (ClassPath classPath : set) {
                        sb.append("  \"");
                        sb.append(classPath.toString(ClassPath.PathConversionMode.PRINT));
                        sb.append("\"\n");
                    }
                }
                sb.append("--\n");
            }
            sb.append("====\n");
            LOGGER.fine(sb.toString());
        }
        boolean existingPathsChanged = false;
        boolean containsRelevantChanges = false;
        for (PathRegistryEvent.Change change : event.getChanges()) {
            containsRelevantChanges = true;
            if (change.getEventKind() != EventKind.PATHS_CHANGED) continue;
            existingPathsChanged = true;
            break;
        }
        if (containsRelevantChanges) {
            this.scheduleWork(new RootsWork(this.scannedRoots2Dependencies, this.scannedBinaries2InvDependencies, this.sourcesForBinaryRoots, !existingPathsChanged), false);
        }
    }

    private void fileFolderCreatedImpl(FileEvent fe, Boolean source) {
        FileObject fo = fe.getFile();
        if (this.isCacheFile(fo)) {
            return;
        }
        if (!this.authorize(fe)) {
            return;
        }
        boolean processed = false;
        Pair<URL, FileObject> root = null;
        if (fo != null && fo.isValid() && VisibilityQuery.getDefault().isVisible(fo)) {
            if ((source == null || source.booleanValue()) && (root = this.getOwningSourceRoot(fo)) != null) {
                ClassPath.Entry entry;
                boolean sourcForBinaryRoot = this.sourcesForBinaryRoots.contains(root.first);
                ClassPath.Entry entry2 = entry = sourcForBinaryRoot ? null : RepositoryUpdater.getClassPathEntry((FileObject)root.second);
                if (entry == null || entry.includes(fo)) {
                    FileListWork wrk = new FileListWork(this.scannedRoots2Dependencies, (URL)root.first, Collections.singleton(fo), false, false, true, sourcForBinaryRoot, true);
                    this.eventQueue.record(FileEventLog.FileOp.CREATE, (URL)root.first, FileUtil.getRelativePath((FileObject)((FileObject)root.second), (FileObject)fo), fe, wrk);
                    processed = true;
                }
            }
            if (!(processed || source != null && source.booleanValue() || (root = this.getOwningBinaryRoot(fo)) == null)) {
                BinaryWork wrk = new BinaryWork((URL)root.first);
                this.eventQueue.record(FileEventLog.FileOp.CREATE, (URL)root.first, null, fe, wrk);
                processed = true;
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Folder created (" + (processed ? "processed" : "ignored") + "): " + FileUtil.getFileDisplayName((FileObject)fo) + " Owner: " + root);
        }
    }

    private void fileChangedImpl(FileEvent fe, Boolean source) {
        FileObject fo = fe.getFile();
        if (this.isCacheFile(fo)) {
            return;
        }
        if (!this.authorize(fe)) {
            return;
        }
        boolean processed = false;
        Pair<URL, FileObject> root = null;
        if (fo != null && fo.isValid() && VisibilityQuery.getDefault().isVisible(fo)) {
            if ((source == null || source.booleanValue()) && (root = this.getOwningSourceRoot(fo)) != null) {
                ClassPath.Entry entry;
                boolean sourceForBinaryRoot = this.sourcesForBinaryRoots.contains(root.first);
                ClassPath.Entry entry2 = entry = sourceForBinaryRoot ? null : RepositoryUpdater.getClassPathEntry((FileObject)root.second);
                if (entry == null || entry.includes(fo)) {
                    FileListWork wrk = new FileListWork(this.scannedRoots2Dependencies, (URL)root.first, Collections.singleton(fo), false, false, true, sourceForBinaryRoot, true);
                    this.eventQueue.record(FileEventLog.FileOp.CREATE, (URL)root.first, FileUtil.getRelativePath((FileObject)((FileObject)root.second), (FileObject)fo), fe, wrk);
                    processed = true;
                }
            }
            if (!(processed || source != null && source.booleanValue() || (root = this.getOwningBinaryRoot(fo)) == null)) {
                BinaryWork wrk = new BinaryWork((URL)root.first);
                this.eventQueue.record(FileEventLog.FileOp.CREATE, (URL)root.first, null, fe, wrk);
                processed = true;
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("File modified (" + (processed ? "processed" : "ignored") + "): " + FileUtil.getFileDisplayName((FileObject)fo) + " Owner: " + root);
        }
    }

    private void fileDeletedImpl(FileEvent fe, Boolean source) {
        FileObject fo = fe.getFile();
        if (this.isCacheFile(fo)) {
            return;
        }
        if (!this.authorize(fe)) {
            return;
        }
        boolean processed = false;
        Pair<URL, FileObject> root = null;
        if (fo != null && VisibilityQuery.getDefault().isVisible(fo)) {
            if ((source == null || source.booleanValue()) && (root = this.getOwningSourceRoot(fo)) != null && fo.isData()) {
                String relativePath = FileUtil.getRelativePath((FileObject)((FileObject)root.second), (FileObject)fo);
                assert (relativePath != null) : "FileObject not under root: f=" + fo + ", root=" + root;
                DeleteWork wrk = new DeleteWork((URL)root.first, Collections.singleton(relativePath));
                this.eventQueue.record(FileEventLog.FileOp.DELETE, (URL)root.first, relativePath, fe, wrk);
                processed = true;
            }
            if (!(processed || source != null && source.booleanValue() || (root = this.getOwningBinaryRoot(fo)) == null)) {
                BinaryWork wrk = new BinaryWork((URL)root.first);
                this.eventQueue.record(FileEventLog.FileOp.DELETE, (URL)root.first, null, fe, wrk);
                processed = true;
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("File deleted (" + (processed ? "processed" : "ignored") + "): " + FileUtil.getFileDisplayName((FileObject)fo) + " Owner: " + root);
        }
    }

    private void fileRenamedImpl(FileRenameEvent fe, Boolean source) {
        FileObject fo = fe.getFile();
        if (this.isCacheFile(fo)) {
            return;
        }
        if (!this.authorize((FileEvent)fe)) {
            return;
        }
        FileObject newFile = fe.getFile();
        String oldNameExt = fe.getExt().length() == 0 ? fe.getName() : fe.getName() + "." + fe.getExt();
        Pair<URL, FileObject> root = null;
        boolean processed = false;
        if (newFile != null && newFile.isValid()) {
            if ((source == null || source.booleanValue()) && (root = this.getOwningSourceRoot(newFile)) != null) {
                String oldFilePath;
                FileObject rootFo = (FileObject)root.second;
                String ownerPath = FileUtil.getRelativePath((FileObject)rootFo, (FileObject)newFile.getParent());
                String string = oldFilePath = ownerPath.length() == 0 ? oldNameExt : ownerPath + "/" + oldNameExt;
                if (newFile.isData()) {
                    DeleteWork work = new DeleteWork((URL)root.first, Collections.singleton(oldFilePath));
                    this.eventQueue.record(FileEventLog.FileOp.DELETE, (URL)root.first, oldFilePath, (FileEvent)fe, work);
                } else {
                    HashSet<String> oldFilePaths = new HashSet<String>();
                    RepositoryUpdater.collectFilePaths(newFile, oldFilePath, oldFilePaths);
                    for (String path : oldFilePaths) {
                        DeleteWork work = new DeleteWork((URL)root.first, oldFilePaths);
                        this.eventQueue.record(FileEventLog.FileOp.DELETE, (URL)root.first, path, (FileEvent)fe, work);
                    }
                }
                if (VisibilityQuery.getDefault().isVisible(newFile) && newFile.isData()) {
                    ClassPath.Entry entry;
                    boolean sourceForBinaryRoot = this.sourcesForBinaryRoots.contains(root.first);
                    ClassPath.Entry entry2 = entry = sourceForBinaryRoot ? null : RepositoryUpdater.getClassPathEntry(rootFo);
                    if (entry == null || entry.includes(newFile)) {
                        FileListWork flw = new FileListWork(this.scannedRoots2Dependencies, (URL)root.first, Collections.singleton(newFile), false, false, true, sourceForBinaryRoot, true);
                        this.eventQueue.record(FileEventLog.FileOp.CREATE, (URL)root.first, FileUtil.getRelativePath((FileObject)rootFo, (FileObject)newFile), (FileEvent)fe, flw);
                    }
                }
                processed = true;
            }
            if (!(processed || source != null && source.booleanValue() || (root = this.getOwningBinaryRoot(newFile)) == null)) {
                File parentFile = FileUtil.toFile((FileObject)newFile.getParent());
                if (parentFile != null) {
                    try {
                        URL oldBinaryRoot = new File(parentFile, oldNameExt).toURI().toURL();
                        this.eventQueue.record(FileEventLog.FileOp.DELETE, oldBinaryRoot, null, (FileEvent)fe, new BinaryWork(oldBinaryRoot));
                    }
                    catch (MalformedURLException mue) {
                        LOGGER.log(Level.WARNING, null, mue);
                    }
                }
                this.eventQueue.record(FileEventLog.FileOp.CREATE, (URL)root.first, null, (FileEvent)fe, new BinaryWork((URL)root.first));
                processed = true;
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("File renamed (" + (processed ? "processed" : "ignored") + "): " + FileUtil.getFileDisplayName((FileObject)newFile) + " Owner: " + root + " Original Name: " + oldNameExt);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        JTextComponent jtc;
        if (evt.getPropertyName() != null && evt.getPropertyName().equals(CustomIndexerFactory.class.getName())) {
            if (!this.ignoreIndexerCacheEvents) {
                Set changedIndexers = (Set)evt.getNewValue();
                this.scheduleWork(new RefreshCifIndices(changedIndexers, this.scannedRoots2Dependencies, this.sourcesForBinaryRoots), false);
            }
            return;
        }
        if (evt.getPropertyName() != null && evt.getPropertyName().equals(EmbeddingIndexerFactory.class.getName())) {
            if (!this.ignoreIndexerCacheEvents) {
                Set changedIndexers = (Set)evt.getNewValue();
                this.scheduleWork(new RefreshEifIndices(changedIndexers, this.scannedRoots2Dependencies, this.sourcesForBinaryRoots), false);
            }
            return;
        }
        assert (SwingUtilities.isEventDispatchThread()) : "Changes in focused editor component should be delivered on AWT";
        List<JTextComponent> components = Collections.emptyList();
        if (evt.getPropertyName() == null) {
            components = EditorRegistry.componentList();
        } else if (evt.getPropertyName().equals("focusLost") || evt.getPropertyName().equals("lastFocusedRemoved")) {
            if (evt.getOldValue() instanceof JTextComponent) {
                jtc = (JTextComponent)evt.getOldValue();
                this.handleActiveDocumentChange(jtc.getDocument(), null);
            }
        } else if (evt.getPropertyName().equals("componentRemoved")) {
            if (evt.getOldValue() instanceof JTextComponent) {
                jtc = (JTextComponent)evt.getOldValue();
                components = Collections.singletonList(jtc);
            }
        } else if (evt.getPropertyName().equals("focusGained")) {
            if (evt.getNewValue() instanceof JTextComponent) {
                JTextComponent activeComponent;
                jtc = (JTextComponent)evt.getNewValue();
                this.handleActiveDocumentChange(null, jtc.getDocument());
                JTextComponent jTextComponent = activeComponent = this.activeComponentRef == null ? null : this.activeComponentRef.get();
                if (activeComponent != jtc) {
                    if (activeComponent != null) {
                        components = Collections.singletonList(activeComponent);
                    }
                    this.activeComponentRef = new WeakReference<JTextComponent>(jtc);
                }
            }
        } else if (evt.getPropertyName().equals("focusedDocument")) {
            jtc = EditorRegistry.focusedComponent();
            if (jtc == null) {
                jtc = EditorRegistry.lastFocusedComponent();
            }
            if (jtc != null) {
                components = Collections.singletonList(jtc);
            }
            this.handleActiveDocumentChange((Document)evt.getOldValue(), (Document)evt.getNewValue());
        }
        HashMap jobs = new HashMap();
        if (components.size() > 0) {
            for (JTextComponent jtc2 : components) {
                FileListWork job;
                Document doc = jtc2.getDocument();
                Pair<URL, FileObject> root = this.getOwningSourceRoot(doc);
                if (root == null) continue;
                long version = DocumentUtilities.getDocumentVersion((Document)doc);
                Long lastIndexedVersion = (Long)doc.getProperty(PROP_LAST_INDEXED_VERSION);
                Long lastDirtyVersion = (Long)doc.getProperty(PROP_LAST_DIRTY_VERSION);
                boolean reindex = false;
                boolean openedInEditor = EditorRegistry.componentList().contains(jtc2);
                reindex = openedInEditor ? (lastIndexedVersion == null ? lastDirtyVersion != null : lastIndexedVersion < version) : lastDirtyVersion != null;
                FileObject docFile = Util.getFileObject(doc);
                LOGGER.log(Level.FINE, "{0}: version={1}, lastIndexerVersion={2}, lastDirtyVersion={3}, openedInEditor={4} => reindex={5}", new Object[]{docFile.getPath(), version, lastIndexedVersion, lastDirtyVersion, openedInEditor, reindex});
                if (!reindex) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Document modified (reindexing): " + FileUtil.getFileDisplayName((FileObject)docFile) + " Owner: " + root.first);
                }
                if ((job = (FileListWork)jobs.get(root.first)) == null) {
                    job = new FileListWork(this.scannedRoots2Dependencies, (URL)root.first, Collections.singleton(docFile), false, openedInEditor, true, this.sourcesForBinaryRoots.contains(root.first), true);
                    jobs.put(root.first, job);
                    continue;
                }
                job.addFile(docFile);
            }
        }
        if (jobs.isEmpty()) {
            this.scheduleWork(null, false);
        } else {
            for (FileListWork job : jobs.values()) {
                this.scheduleWork(job, false);
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.removeUpdate(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        Document d = e.getDocument();
        if (d instanceof BaseDocument) {
            d.putProperty(PROP_MODIFIED_UNDER_WRITE_LOCK, true);
        } else {
            this.handleDocumentModification(d);
        }
    }

    public void atomicLock(AtomicLockEvent e) {
        Document d = (Document)e.getSource();
        d.putProperty(PROP_MODIFIED_UNDER_WRITE_LOCK, null);
    }

    public void atomicUnlock(AtomicLockEvent e) {
        Document d = (Document)e.getSource();
        Boolean modified = (Boolean)d.getProperty(PROP_MODIFIED_UNDER_WRITE_LOCK);
        d.putProperty(PROP_MODIFIED_UNDER_WRITE_LOCK, null);
        if (modified != null && modified.booleanValue()) {
            this.handleDocumentModification(d);
        }
    }

    private RepositoryUpdater() {
        LOGGER.log(Level.FINE, "perf.refactoring.test={0}", PERF_TEST);
        LOGGER.log(Level.FINE, "netbeans.indexing.notInterruptible={0}", notInterruptible);
        LOGGER.log(Level.FINE, "netbeans.indexing.recursiveListeners={0}", useRecursiveListeners);
        LOGGER.log(Level.FINE, "FILE_LOCKS_DELAY={0}", FILE_LOCKS_DELAY);
    }

    private void handleActiveDocumentChange(Document deactivated, Document activated) {
        Document activeDocument;
        Document document = activeDocument = this.activeDocumentRef == null ? null : this.activeDocumentRef.get();
        if (deactivated != null && deactivated == activeDocument) {
            if (activeDocument instanceof BaseDocument) {
                ((BaseDocument)activeDocument).removeAtomicLockListener((AtomicLockListener)this);
            }
            activeDocument.removeDocumentListener(this);
            this.activeDocumentRef = null;
            LOGGER.log(Level.FINE, "Unregistering active document listener: activeDocument={0}", activeDocument);
        }
        if (activated != null && activated != activeDocument) {
            if (activeDocument != null) {
                if (activeDocument instanceof BaseDocument) {
                    ((BaseDocument)activeDocument).removeAtomicLockListener((AtomicLockListener)this);
                }
                activeDocument.removeDocumentListener(this);
                LOGGER.log(Level.FINE, "Unregistering active document listener: activeDocument={0}", activeDocument);
            }
            activeDocument = activated;
            this.activeDocumentRef = new WeakReference<Document>(activeDocument);
            if (activeDocument instanceof BaseDocument) {
                ((BaseDocument)activeDocument).addAtomicLockListener((AtomicLockListener)this);
            }
            activeDocument.addDocumentListener(this);
            LOGGER.log(Level.FINE, "Registering active document listener: activeDocument={0}", activeDocument);
        }
    }

    public void handleDocumentModification(Document document) {
        block10: {
            Pair<URL, FileObject> root;
            block11: {
                Reference<Document> ref = this.activeDocumentRef;
                Document activeDocument = ref == null ? null : ref.get();
                root = this.getOwningSourceRoot(document);
                if (root == null) break block10;
                if (activeDocument != document) break block11;
                long version = DocumentUtilities.getDocumentVersion((Document)activeDocument);
                Long lastDirtyVersion = (Long)activeDocument.getProperty(PROP_LAST_DIRTY_VERSION);
                boolean markDirty = false;
                if (lastDirtyVersion == null || lastDirtyVersion < version) {
                    markDirty = true;
                }
                activeDocument.putProperty(PROP_LAST_DIRTY_VERSION, version);
                if (!markDirty) break block10;
                FileObject docFile = Util.getFileObject(document);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Active document modified (marking dirty): " + FileUtil.getFileDisplayName((FileObject)docFile) + " Owner: " + root.first);
                }
                Set<Indexable> dirty = Collections.singleton(SPIAccessor.getInstance().create(new FileObjectIndexable((FileObject)root.second, docFile)));
                String mimeType = DocumentUtilities.getMimeType((Document)document);
                Collection<IndexerCache.IndexerInfo<CustomIndexerFactory>> cifInfos = IndexerCache.getCifCache().getIndexersFor(mimeType);
                for (IndexerCache.IndexerInfo<CustomIndexerFactory> info : cifInfos) {
                    try {
                        CustomIndexerFactory factory = info.getIndexerFactory();
                        Context ctx = SPIAccessor.getInstance().createContext(CacheFolder.getDataFolder((URL)root.first), (URL)root.first, factory.getIndexerName(), factory.getIndexVersion(), null, false, true, false, null);
                        factory.filesDirty(dirty, ctx);
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.WARNING, null, ex);
                    }
                }
                Collection<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>> eifInfos = IndexerCache.getEifCache().getIndexersFor(mimeType);
                for (IndexerCache.IndexerInfo<EmbeddingIndexerFactory> info : eifInfos) {
                    try {
                        EmbeddingIndexerFactory factory = info.getIndexerFactory();
                        Context ctx = SPIAccessor.getInstance().createContext(CacheFolder.getDataFolder((URL)root.first), (URL)root.first, factory.getIndexerName(), factory.getIndexVersion(), null, false, true, false, null);
                        factory.filesDirty(dirty, ctx);
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.WARNING, null, ex);
                    }
                }
                break block10;
            }
            try {
                FileObject f = Util.getFileObject(document);
                this.addIndexingJob((URL)root.first, Collections.singleton(f.getURL()), false, true, false, true, true);
            }
            catch (FileStateInvalidException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleWork(Iterable<? extends Work> multipleWork) {
        boolean canScheduleMultiple;
        RepositoryUpdater.recordCaller();
        RepositoryUpdater repositoryUpdater = this;
        synchronized (repositoryUpdater) {
            canScheduleMultiple = this.state == State.INITIAL_SCAN_RUNNING || this.state == State.ACTIVE;
        }
        if (canScheduleMultiple) {
            this.getWorker().schedule(multipleWork);
        } else {
            for (Work work : multipleWork) {
                this.scheduleWork(work, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleWork(Work work, boolean wait) {
        RepositoryUpdater.recordCaller();
        boolean scheduleExtraWork = false;
        RepositoryUpdater repositoryUpdater = this;
        synchronized (repositoryUpdater) {
            if (this.state == State.STARTED) {
                this.state = State.INITIAL_SCAN_RUNNING;
                scheduleExtraWork = !(work instanceof InitialRootsWork);
            }
        }
        if (scheduleExtraWork) {
            this.getWorker().schedule(new InitialRootsWork(this.scannedRoots2Dependencies, this.scannedBinaries2InvDependencies, this.sourcesForBinaryRoots, true), false);
            if (work instanceof RootsWork) {
                return;
            }
        }
        if (work != null) {
            this.getWorker().schedule(work, wait);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task getWorker() {
        Task t = this.worker;
        if (t == null) {
            RepositoryUpdater repositoryUpdater = this;
            synchronized (repositoryUpdater) {
                if (this.worker == null) {
                    this.worker = new Task();
                }
                t = this.worker;
            }
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<URL, FileObject> getOwningSourceRoot(Object fileOrDoc) {
        String string = this.lastOwningSourceRootCacheLock;
        synchronized (string) {
            FileObject file = null;
            Document doc = null;
            if (fileOrDoc instanceof Document) {
                doc = (Document)fileOrDoc;
                file = Util.getFileObject(doc);
                if (file == null) {
                    return null;
                }
                URL cachedSourceRootUrl = (URL)doc.getProperty(PROP_OWNING_SOURCE_ROOT_URL);
                FileObject cachedSourceRoot = (FileObject)doc.getProperty(PROP_OWNING_SOURCE_ROOT);
                if (cachedSourceRootUrl != null && cachedSourceRoot != null && cachedSourceRoot.isValid() && FileUtil.isParentOf((FileObject)cachedSourceRoot, (FileObject)file)) {
                    return Pair.of(cachedSourceRootUrl, cachedSourceRoot);
                }
            } else if (fileOrDoc instanceof FileObject) {
                file = (FileObject)fileOrDoc;
            } else {
                return null;
            }
            URL owningSourceRootUrl = null;
            FileObject owningSourceRoot = null;
            ArrayList<URL> clone = new ArrayList<URL>(this.scannedRoots2Dependencies.keySet());
            for (URL root : clone) {
                FileObject rootFo = URLCache.getInstance().findFileObject(root);
                if (rootFo == null || !FileUtil.isParentOf((FileObject)rootFo, (FileObject)file)) continue;
                owningSourceRootUrl = root;
                owningSourceRoot = rootFo;
                break;
            }
            if (owningSourceRootUrl != null) {
                assert (owningSourceRoot != null) : "Expecting both owningSourceRootUrl=" + owningSourceRootUrl + " and owningSourceRoot=" + owningSourceRoot;
                if (doc != null) {
                    doc.putProperty(PROP_OWNING_SOURCE_ROOT_URL, owningSourceRootUrl);
                    doc.putProperty(PROP_OWNING_SOURCE_ROOT, owningSourceRoot);
                }
                return Pair.of(owningSourceRootUrl, owningSourceRoot);
            }
            return null;
        }
    }

    private Pair<URL, FileObject> getOwningBinaryRoot(FileObject fo) {
        String foPath;
        if (fo == null) {
            return null;
        }
        try {
            foPath = fo.getURL().getPath();
        }
        catch (FileStateInvalidException fsie) {
            LOGGER.log(Level.WARNING, null, fsie);
            return null;
        }
        ArrayList<URL> clone = new ArrayList<URL>(this.scannedBinaries2InvDependencies.keySet());
        for (URL root : clone) {
            String filePath;
            URL fileURL = FileUtil.getArchiveFile((URL)root);
            boolean archive = true;
            if (fileURL == null) {
                fileURL = root;
                archive = false;
            }
            if ((filePath = fileURL.getPath()).equals(foPath)) {
                return Pair.of(root, null);
            }
            if (archive || !foPath.startsWith(filePath)) continue;
            return Pair.of(root, null);
        }
        return null;
    }

    private static ClassPath.Entry getClassPathEntry(FileObject root) {
        try {
            Set<String> ids;
            if (root != null && (ids = PathRegistry.getDefault().getSourceIdsFor(root.getURL())) != null) {
                for (String id : ids) {
                    ClassPath cp = ClassPath.getClassPath((FileObject)root, (String)id);
                    if (cp == null) continue;
                    URL rootURL = root.getURL();
                    for (ClassPath.Entry e : cp.entries()) {
                        if (!rootURL.equals(e.getURL())) continue;
                        return e;
                    }
                }
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        return null;
    }

    private boolean authorize(FileEvent event) {
        Collection interceptors = this.indexingActivityInterceptors.allInstances();
        for (IndexingActivityInterceptor i : interceptors) {
            if (i.authorizeFileSystemEvent(event) != IndexingActivityInterceptor.Authorization.IGNORE) continue;
            return false;
        }
        return true;
    }

    private boolean isCacheFile(FileObject f) {
        return FileUtil.isParentOf((FileObject)CacheFolder.getCacheFolder(), (FileObject)f);
    }

    private static void collectFilePaths(FileObject folder, String pathPrefix, Set<String> collectedPaths) {
        assert (folder.isFolder()) : "Expecting folder: " + folder;
        if (folder.isValid()) {
            for (FileObject kid : folder.getChildren()) {
                if (!kid.isValid()) continue;
                String kidPath = pathPrefix + "/" + kid.getNameExt();
                if (kid.isData()) {
                    collectedPaths.add(kidPath);
                    continue;
                }
                RepositoryUpdater.collectFilePaths(kid, kidPath, collectedPaths);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean findDependencies(URL rootURL, DependenciesContext ctx, Set<String> libraryIds, Set<String> binaryLibraryIds, CancelRequest cancelRequest) {
        List deps;
        if (cancelRequest.isRaised()) {
            return false;
        }
        if (ctx.useInitialState && (deps = (List)ctx.initialRoots2Deps.get(rootURL)) != null && deps != EMPTY_DEPS) {
            ctx.oldRoots.remove(rootURL);
            return true;
        }
        if (ctx.newRoots2Deps.containsKey(rootURL)) {
            return true;
        }
        FileObject rootFo = URLMapper.findFileObject((URL)rootURL);
        if (rootFo == null) {
            return true;
        }
        LinkedList<URL> deps2 = new LinkedList<URL>();
        ctx.cycleDetector.push(rootURL);
        try {
            ClassPath cp2;
            Set<String> ids2;
            if (libraryIds == null || binaryLibraryIds == null) {
                ids2 = PathRegistry.getDefault().getSourceIdsFor(rootURL);
                if (null != ids2 && !ids2.isEmpty()) {
                    LOGGER.log(Level.FINER, "Resolving Ids based on sourceIds for {0}: {1}", new Object[]{rootURL, ids2});
                    HashSet<String> lids = new HashSet<String>();
                    HashSet<String> blids = new HashSet<String>();
                    for (String id : ids2) {
                        lids.addAll(PathRecognizerRegistry.getDefault().getLibraryIdsForSourceId(id));
                        blids.addAll(PathRecognizerRegistry.getDefault().getBinaryLibraryIdsForSourceId(id));
                    }
                    if (libraryIds == null) {
                        libraryIds = lids;
                    }
                    if (binaryLibraryIds == null) {
                        binaryLibraryIds = blids;
                    }
                } else {
                    ids2 = PathRegistry.getDefault().getLibraryIdsFor(rootURL);
                    if (null != ids2 && !ids2.isEmpty()) {
                        LOGGER.log(Level.FINER, "Resolving Ids based on libraryIds for {0}: {1}", new Object[]{rootURL, ids2});
                        HashSet<String> blids = new HashSet<String>();
                        for (String id2 : ids2) {
                            blids.addAll(PathRecognizerRegistry.getDefault().getBinaryLibraryIdsForLibraryId(id2));
                        }
                        if (libraryIds == null) {
                            libraryIds = ids2;
                        }
                        if (binaryLibraryIds == null) {
                            binaryLibraryIds = blids;
                        }
                    }
                }
            }
            if (cancelRequest.isRaised()) {
                boolean ids2 = false;
                return ids2;
            }
            LOGGER.log(Level.FINER, "LibraryIds for {0}: {1}", new Object[]{rootURL, libraryIds});
            LOGGER.log(Level.FINER, "BinaryLibraryIds for {0}: {1}", new Object[]{rootURL, binaryLibraryIds});
            ids2 = libraryIds == null ? PathRecognizerRegistry.getDefault().getLibraryIds() : libraryIds;
            for (String id : ids2) {
                if (cancelRequest.isRaised()) {
                    boolean id2 = false;
                    return id2;
                }
                cp2 = ClassPath.getClassPath((FileObject)rootFo, (String)id);
                if (cp2 == null) continue;
                for (ClassPath.Entry entry : cp2.entries()) {
                    if (cancelRequest.isRaised()) {
                        boolean bl = false;
                        return bl;
                    }
                    URL sourceRoot = entry.getURL();
                    if (sourceRoot.equals(rootURL) || ctx.cycleDetector.contains(sourceRoot)) continue;
                    deps2.add(sourceRoot);
                    if (RepositoryUpdater.findDependencies(sourceRoot, ctx, libraryIds, binaryLibraryIds, cancelRequest)) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            ids2 = binaryLibraryIds == null ? PathRecognizerRegistry.getDefault().getBinaryLibraryIds() : binaryLibraryIds;
            for (String id : ids2) {
                if (cancelRequest.isRaised()) {
                    boolean cp2 = false;
                    return cp2;
                }
                cp2 = ClassPath.getClassPath((FileObject)rootFo, (String)id);
                if (cp2 == null) continue;
                for (ClassPath.Entry entry : cp2.entries()) {
                    LinkedList<URL> binDeps;
                    if (cancelRequest.isRaised()) {
                        boolean sourceRoot = false;
                        return sourceRoot;
                    }
                    URL binaryRoot = entry.getURL();
                    URL[] sourceRoots = PathRegistry.getDefault().sourceForBinaryQuery(binaryRoot, cp2, false);
                    if (sourceRoots != null) {
                        for (URL sourceRoot : sourceRoots) {
                            if (cancelRequest.isRaised()) {
                                boolean bl = false;
                                return bl;
                            }
                            if (sourceRoot.equals(rootURL)) {
                                ctx.sourcesForBinaryRoots.add(rootURL);
                                continue;
                            }
                            if (ctx.cycleDetector.contains(sourceRoot)) continue;
                            deps2.add(sourceRoot);
                            if (RepositoryUpdater.findDependencies(sourceRoot, ctx, libraryIds, binaryLibraryIds, cancelRequest)) continue;
                            boolean bl = false;
                            return bl;
                        }
                        continue;
                    }
                    if (ctx.useInitialState) {
                        if (!ctx.initialBinaries2InvDeps.keySet().contains(binaryRoot)) {
                            ctx.newBinariesToScan.add(binaryRoot);
                            binDeps = (List)ctx.newBinaries2InvDeps.get(binaryRoot);
                            if (binDeps == null) {
                                binDeps = new LinkedList();
                                ctx.newBinaries2InvDeps.put(binaryRoot, binDeps);
                            }
                            binDeps.add(rootURL);
                        }
                        ctx.oldBinaries.remove(binaryRoot);
                    } else {
                        ctx.newBinariesToScan.add(binaryRoot);
                        binDeps = (LinkedList<URL>)ctx.newBinaries2InvDeps.get(binaryRoot);
                        if (binDeps == null) {
                            binDeps = new LinkedList<URL>();
                            ctx.newBinaries2InvDeps.put(binaryRoot, binDeps);
                        }
                        binDeps.add(rootURL);
                        ctx.oldBinaries.remove(binaryRoot);
                    }
                    Set<String> sourceIds = PathRegistry.getDefault().getSourceIdsFor(binaryRoot);
                    if (sourceIds == null || sourceIds.isEmpty()) {
                        if (binaryRoot.equals(rootURL) || ctx.cycleDetector.contains(binaryRoot)) continue;
                        deps2.add(binaryRoot);
                        continue;
                    }
                    LOGGER.log(Level.INFO, "The root {0} is registered for both {1} and {2}", new Object[]{binaryRoot, id, sourceIds});
                }
            }
        }
        finally {
            ctx.cycleDetector.pop();
        }
        ctx.newRoots2Deps.put(rootURL, deps2);
        return true;
    }

    private static Map<FileObject, Document> getEditorFiles() {
        HashMap<FileObject, Document> f2d = new HashMap<FileObject, Document>();
        for (JTextComponent jtc : EditorRegistry.componentList()) {
            Document d = jtc.getDocument();
            FileObject f = Util.getFileObject(d);
            if (f == null) continue;
            f2d.put(f, d);
        }
        return f2d;
    }

    private static boolean getSystemBoolean(String propertyName, boolean defaultValue) {
        if (defaultValue) {
            String value = System.getProperty(propertyName);
            return value == null || !value.equals("false");
        }
        return Boolean.getBoolean(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recordCaller() {
        if (!LOGGER.isLoggable(Level.FINE)) {
            return;
        }
        Map<List<StackTraceElement>, Long> map = lastRecordedStackTraces;
        synchronized (map) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            ArrayList<StackTraceElement> stackTraceList = new ArrayList<StackTraceElement>(stackTrace.length);
            stackTraceList.addAll(Arrays.asList(stackTrace));
            Long id = lastRecordedStackTraces.get(stackTraceList);
            if (id == null) {
                id = stackTraceId++;
                lastRecordedStackTraces.put(stackTraceList, id);
                StringBuilder sb = new StringBuilder();
                sb.append("RepositoryUpdater caller [id=").append(id).append("] :\n");
                for (StackTraceElement e : stackTraceList) {
                    sb.append(e.toString());
                    sb.append("\n");
                }
                LOGGER.fine(sb.toString());
            } else {
                StackTraceElement caller = Util.findCaller(stackTrace, new Object[0]);
                LOGGER.fine("RepositoryUpdater caller [refid=" + id + "]: " + caller);
            }
        }
    }

    private static void printMap(Map<URL, List<URL>> deps, Level level) {
        TreeSet<URL> sortedRoots = new TreeSet<URL>(C);
        sortedRoots.addAll(deps.keySet());
        for (URL url : sortedRoots) {
            LOGGER.log(level, "  {0}:\n", url);
        }
    }

    private static StringBuilder printMap(Map<URL, List<URL>> deps, StringBuilder sb) {
        TreeSet<URL> sortedRoots = new TreeSet<URL>(C);
        sortedRoots.addAll(deps.keySet());
        for (URL url : sortedRoots) {
            sb.append("  ").append(url).append(":\n");
        }
        return sb;
    }

    private static void printCollection(Collection<? extends URL> collection, Level level) {
        TreeSet<URL> sortedRoots = new TreeSet<URL>(C);
        sortedRoots.addAll(collection);
        for (URL url : sortedRoots) {
            LOGGER.log(level, "  {0}\n", url);
        }
    }

    private static StringBuilder printCollection(Collection<? extends URL> collection, StringBuilder sb) {
        TreeSet<URL> sortedRoots = new TreeSet<URL>(C);
        sortedRoots.addAll(collection);
        for (URL url : sortedRoots) {
            sb.append("  ").append(url).append("\n");
        }
        return sb;
    }

    private static StringBuilder printMimeTypes(Collection<? extends String> collection, StringBuilder sb) {
        Iterator<? extends String> i = collection.iterator();
        while (i.hasNext()) {
            String mimeType = i.next();
            sb.append("'").append(mimeType).append("'");
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        return sb;
    }

    State getState() {
        return this.state;
    }

    Set<URL> getScannedBinaries() {
        return this.scannedBinaries2InvDependencies.keySet();
    }

    Set<URL> getScannedSources() {
        return this.scannedRoots2Dependencies.keySet();
    }

    Map<URL, List<URL>> getScannedRoots2Dependencies() {
        return this.scannedRoots2Dependencies;
    }

    Set<URL> getScannedUnknowns() {
        return this.scannedUnknown;
    }

    void ignoreIndexerCacheEvents(boolean ignore) {
        this.ignoreIndexerCacheEvents = ignore;
    }

    static /* synthetic */ boolean access$3600() {
        return PERF_TEST;
    }

    static {
        LOGGER = Logger.getLogger(RepositoryUpdater.class.getName());
        TEST_LOGGER = Logger.getLogger(RepositoryUpdater.class.getName() + ".tests");
        SFEC_LOGGER = Logger.getLogger("org.netbeans.ui.ScanForExternalChanges");
        PERF_TEST = RepositoryUpdater.getSystemBoolean("perf.refactoring.test", false);
        notInterruptible = RepositoryUpdater.getSystemBoolean("netbeans.indexing.notInterruptible", false);
        useRecursiveListeners = RepositoryUpdater.getSystemBoolean("netbeans.indexing.recursiveListeners", true);
        FILE_LOCKS_DELAY = org.openide.util.Utilities.isWindows() ? 2000 : 1000;
        PROP_LAST_INDEXED_VERSION = RepositoryUpdater.class.getName() + "-last-indexed-document-version";
        PROP_LAST_DIRTY_VERSION = RepositoryUpdater.class.getName() + "-last-dirty-document-version";
        PROP_MODIFIED_UNDER_WRITE_LOCK = RepositoryUpdater.class.getName() + "-modified-under-write-lock";
        PROP_OWNING_SOURCE_ROOT_URL = RepositoryUpdater.class.getName() + "-owning-source-root-url";
        PROP_OWNING_SOURCE_ROOT = RepositoryUpdater.class.getName() + "-owning-source-root";
        EMPTY_DEPS = Collections.unmodifiableList(new LinkedList());
        lastRecordedStackTraces = new HashMap<List<StackTraceElement>, Long>();
        stackTraceId = 0L;
        C = new Comparator<URL>(){

            @Override
            public int compare(URL o1, URL o2) {
                return o1.toString().compareTo(o2.toString());
            }
        };
    }

    private final class FCL
    extends FileChangeAdapter {
        private final Boolean listeningOnSources;

        public FCL(Boolean listeningOnSources) {
            this.listeningOnSources = listeningOnSources;
        }

        public void fileFolderCreated(FileEvent fe) {
            RepositoryUpdater.this.fileFolderCreatedImpl(fe, this.listeningOnSources);
        }

        public void fileDataCreated(FileEvent fe) {
            RepositoryUpdater.this.fileChangedImpl(fe, this.listeningOnSources);
        }

        public void fileChanged(FileEvent fe) {
            RepositoryUpdater.this.fileChangedImpl(fe, this.listeningOnSources);
        }

        public void fileDeleted(FileEvent fe) {
            RepositoryUpdater.this.fileDeletedImpl(fe, this.listeningOnSources);
        }

        public void fileRenamed(FileRenameEvent fe) {
            RepositoryUpdater.this.fileRenamedImpl(fe, this.listeningOnSources);
        }
    }

    static final class RootsListeners {
        private FileChangeListener sourcesListener = null;
        private FileChangeListener binariesListener = null;
        private final Map<URL, File> sourceRoots = new HashMap<URL, File>();
        private final Map<URL, Pair<File, Boolean>> binaryRoots = new HashMap<URL, Pair<File, Boolean>>();
        private final AtomicBoolean noRecursiveListenerLogged = new AtomicBoolean();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setListener(FileChangeListener sourcesListener, FileChangeListener binariesListener) {
            assert (sourcesListener != null && binariesListener != null || sourcesListener == null && binariesListener == null) : "Both sourcesListener and binariesListener must either be null or non-null";
            RootsListeners rootsListeners = this;
            synchronized (rootsListeners) {
                if (sourcesListener != null) {
                    assert (this.sourcesListener == null) : "Already using " + this.sourcesListener + "and " + this.binariesListener + ", won't attach " + sourcesListener + " and " + binariesListener;
                    assert (this.sourceRoots.isEmpty()) : "Expecting no source roots: " + this.sourceRoots;
                    assert (this.binaryRoots.isEmpty()) : "Expecting no binary roots: " + this.binaryRoots;
                    this.sourcesListener = sourcesListener;
                    this.binariesListener = binariesListener;
                    if (!useRecursiveListeners) {
                        FileUtil.addFileChangeListener((FileChangeListener)sourcesListener);
                    }
                } else {
                    assert (this.sourcesListener != null) : "RootsListeners are already dormant";
                    if (!useRecursiveListeners) {
                        FileUtil.removeFileChangeListener((FileChangeListener)sourcesListener);
                    }
                    for (Map.Entry<URL, File> entry : this.sourceRoots.entrySet()) {
                        this.safeRemoveRecursiveListener(this.sourcesListener, entry.getValue());
                    }
                    this.sourceRoots.clear();
                    for (Map.Entry<URL, Object> entry : this.binaryRoots.entrySet()) {
                        if (((Boolean)((Pair)entry.getValue()).second).booleanValue()) {
                            this.safeRemoveFileChangeListener(this.binariesListener, (File)((Pair)entry.getValue()).first);
                            continue;
                        }
                        this.safeRemoveRecursiveListener(this.binariesListener, (File)((Pair)entry.getValue()).first);
                    }
                    this.binaryRoots.clear();
                    this.sourcesListener = null;
                    this.binariesListener = null;
                }
            }
        }

        public synchronized boolean add(URL root, boolean sourceRoot) {
            if (sourceRoot) {
                if (this.sourcesListener != null && !this.sourceRoots.containsKey(root) && root.getProtocol().equals("file")) {
                    try {
                        File f = new File(root.toURI());
                        this.safeAddRecursiveListener(this.sourcesListener, f);
                        this.sourceRoots.put(root, f);
                    }
                    catch (URISyntaxException use) {
                        LOGGER.log(Level.INFO, null, use);
                    }
                }
            } else if (this.binariesListener != null && !this.binaryRoots.containsKey(root)) {
                File f = null;
                URL archiveUrl = FileUtil.getArchiveFile((URL)root);
                try {
                    URI uri;
                    URI uRI = uri = archiveUrl != null ? archiveUrl.toURI() : root.toURI();
                    if (uri.getScheme().equals("file")) {
                        f = new File(uri);
                    }
                }
                catch (URISyntaxException use) {
                    LOGGER.log(Level.INFO, "Can't convert " + root + " to java.io.File; archiveUrl=" + archiveUrl, use);
                }
                if (f != null) {
                    if (archiveUrl != null) {
                        this.safeAddFileChangeListener(this.binariesListener, f);
                    } else {
                        this.safeAddRecursiveListener(this.binariesListener, f);
                    }
                    this.binaryRoots.put(root, Pair.of(f, archiveUrl != null));
                }
            }
            return this.sourcesListener != null && this.binariesListener != null;
        }

        public synchronized void remove(Iterable<? extends URL> roots, boolean sourceRoot) {
            for (URL uRL : roots) {
                Pair<File, Boolean> pair;
                if (sourceRoot) {
                    File f;
                    if (this.sourcesListener == null || (f = this.sourceRoots.remove(uRL)) == null) continue;
                    this.safeRemoveRecursiveListener(this.sourcesListener, f);
                    continue;
                }
                if (this.binariesListener == null || (pair = this.binaryRoots.remove(uRL)) == null) continue;
                if (((Boolean)pair.second).booleanValue()) {
                    this.safeRemoveFileChangeListener(this.binariesListener, (File)pair.first);
                    continue;
                }
                this.safeRemoveRecursiveListener(this.binariesListener, (File)pair.first);
            }
        }

        private void safeAddRecursiveListener(FileChangeListener listener, File path) {
            if (useRecursiveListeners) {
                try {
                    FileUtil.addRecursiveListener((FileChangeListener)listener, (File)path, (Callable)new Callable<Boolean>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Boolean call() throws Exception {
                            RootsListeners rootsListeners = RootsListeners.this;
                            synchronized (rootsListeners) {
                                return RootsListeners.this.sourcesListener == null || RootsListeners.this.binariesListener == null;
                            }
                        }
                    });
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, null, e);
                }
            }
        }

        private void safeRemoveRecursiveListener(FileChangeListener listener, File path) {
            if (useRecursiveListeners) {
                try {
                    FileUtil.removeRecursiveListener((FileChangeListener)listener, (File)path);
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, null, e);
                }
            }
        }

        private void safeAddFileChangeListener(FileChangeListener listener, File path) {
            try {
                FileUtil.addFileChangeListener((FileChangeListener)listener, (File)path);
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, null, e);
            }
        }

        private void safeRemoveFileChangeListener(FileChangeListener listener, File path) {
            try {
                FileUtil.removeFileChangeListener((FileChangeListener)listener, (File)path);
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, null, e);
            }
        }
    }

    static final class LexicographicComparator
    implements Comparator<URL> {
        private final boolean reverse;

        public LexicographicComparator(boolean reverse) {
            this.reverse = reverse;
        }

        @Override
        public int compare(URL o1, URL o2) {
            int order = o1.toString().compareTo(o2.toString());
            return this.reverse ? -1 * order : order;
        }
    }

    public static final class FSRefreshInterceptor
    implements IndexingActivityInterceptor {
        private FileSystem.AtomicAction activeAA = null;
        private boolean ignoreFsEvents = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IndexingActivityInterceptor.Authorization authorizeFileSystemEvent(FileEvent event) {
            FSRefreshInterceptor fSRefreshInterceptor = this;
            synchronized (fSRefreshInterceptor) {
                if (this.activeAA != null) {
                    boolean firedFrom = event.firedFrom(this.activeAA);
                    LOGGER.log(Level.FINE, "{0} fired from {1}: {2}", new Object[]{event, this.activeAA, firedFrom});
                    return firedFrom ? IndexingActivityInterceptor.Authorization.IGNORE : IndexingActivityInterceptor.Authorization.PROCESS;
                }
                LOGGER.log(Level.FINE, "Set to ignore {0}: {1}", new Object[]{event, this.ignoreFsEvents});
                return this.ignoreFsEvents ? IndexingActivityInterceptor.Authorization.IGNORE : IndexingActivityInterceptor.Authorization.PROCESS;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setActiveAtomicAction(FileSystem.AtomicAction aa) {
            FSRefreshInterceptor fSRefreshInterceptor = this;
            synchronized (fSRefreshInterceptor) {
                LOGGER.log(Level.FINE, "setActiveAtomicAction({0})", aa);
                if (aa != null) {
                    assert (this.activeAA == null) : "Expecting no activeAA: " + this.activeAA;
                    this.activeAA = aa;
                } else {
                    assert (this.activeAA != null) : "Expecting some activeAA";
                    this.activeAA = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setIgnoreFsEvents(boolean ignore) {
            FSRefreshInterceptor fSRefreshInterceptor = this;
            synchronized (fSRefreshInterceptor) {
                LOGGER.log(Level.FINE, "setIgnoreFsEvents({0})", ignore);
                assert (this.activeAA == null) : "Expecting no activeAA: " + this.activeAA;
                this.ignoreFsEvents = ignore;
            }
        }
    }

    public static final class URLCache {
        private static URLCache instance = null;
        private final Map<URL, Reference<FileObject>> cache = new WeakHashMap<URL, Reference<FileObject>>();

        public static synchronized URLCache getInstance() {
            if (instance == null) {
                instance = new URLCache();
            }
            return instance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileObject findFileObject(URL url) {
            FileObject f = null;
            Map<URL, Reference<FileObject>> map = this.cache;
            synchronized (map) {
                Reference<FileObject> ref = this.cache.get(url);
                if (ref != null) {
                    f = ref.get();
                }
            }
            try {
                if (f != null && f.isValid() && url.equals(f.getURL())) {
                    return f;
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
            f = URLMapper.findFileObject((URL)url);
            map = this.cache;
            synchronized (map) {
                if (f != null && f.isValid()) {
                    this.cache.put(url, new WeakReference<FileObject>(f));
                }
                return f;
            }
        }

        private URLCache() {
        }
    }

    private final class Controller
    extends IndexingController {
        private Map<URL, List<URL>> roots2Dependencies = Collections.emptyMap();
        private Map<URL, List<URL>> binRoots2Dependencies = Collections.emptyMap();

        public Controller() {
            RepositoryUpdater.this.start(false);
        }

        @Override
        public void enterProtectedMode() {
            RepositoryUpdater.this.getWorker().enterProtectedMode();
        }

        @Override
        public void exitProtectedMode(Runnable followUpTask) {
            RepositoryUpdater.this.getWorker().exitProtectedMode(followUpTask);
        }

        @Override
        public boolean isInProtectedMode() {
            return RepositoryUpdater.this.getWorker().isInProtectedMode();
        }

        @Override
        public synchronized Map<URL, List<URL>> getRootDependencies() {
            return this.roots2Dependencies;
        }

        @Override
        public synchronized Map<URL, List<URL>> getBinaryRootDependencies() {
            return this.binRoots2Dependencies;
        }

        @Override
        public int getFileLocksDelay() {
            return FILE_LOCKS_DELAY;
        }
    }

    private static final class BinaryIndexers {
        public final Collection<? extends BinaryIndexerFactory> bifs = MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookupAll(BinaryIndexerFactory.class);

        public static BinaryIndexers load() {
            return new BinaryIndexers();
        }

        private BinaryIndexers() {
        }
    }

    private static final class SourceIndexers {
        public final Set<IndexerCache.IndexerInfo<CustomIndexerFactory>> changedCifs;
        public final Collection<? extends IndexerCache.IndexerInfo<CustomIndexerFactory>> cifInfos;
        public final Set<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>> changedEifs;
        public final Map<String, Set<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>>> eifInfosMap;

        public static SourceIndexers load(boolean detectChanges) {
            return new SourceIndexers(detectChanges);
        }

        private SourceIndexers(boolean detectChanges) {
            long start = System.currentTimeMillis();
            if (detectChanges) {
                this.changedCifs = new HashSet<IndexerCache.IndexerInfo<CustomIndexerFactory>>();
                this.changedEifs = new HashSet<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>>();
            } else {
                this.changedCifs = null;
                this.changedEifs = null;
            }
            this.cifInfos = IndexerCache.getCifCache().getIndexers(this.changedCifs);
            this.eifInfosMap = IndexerCache.getEifCache().getIndexersMap(this.changedEifs);
            long delta = System.currentTimeMillis() - start;
            LOGGER.log(Level.FINE, "Loading indexers took {0} ms.", delta);
        }
    }

    private static final class DependenciesContext {
        private final Map<URL, List<URL>> initialRoots2Deps;
        private final Map<URL, List<URL>> initialBinaries2InvDeps;
        private final Set<URL> oldRoots;
        private final Set<URL> oldBinaries;
        private final Map<URL, List<URL>> newRoots2Deps;
        private final Map<URL, List<URL>> newBinaries2InvDeps;
        private final List<URL> newRootsToScan;
        private final Set<URL> newBinariesToScan;
        private final Set<URL> scannedRoots;
        private final Set<URL> scannedBinaries;
        private final Set<URL> sourcesForBinaryRoots;
        private Set<URL> fullRescanSourceRoots;
        private final Stack<URL> cycleDetector;
        private final boolean useInitialState;

        public DependenciesContext(Map<URL, List<URL>> scannedRoots2Deps, Map<URL, List<URL>> scannedBinaries2InvDependencies, Set<URL> sourcesForBinaryRoots, boolean useInitialState) {
            assert (scannedRoots2Deps != null);
            assert (scannedBinaries2InvDependencies != null);
            this.initialRoots2Deps = Collections.unmodifiableMap(scannedRoots2Deps);
            this.initialBinaries2InvDeps = Collections.unmodifiableMap(scannedBinaries2InvDependencies);
            this.oldRoots = new HashSet<URL>(scannedRoots2Deps.keySet());
            this.oldBinaries = new HashSet<URL>(scannedBinaries2InvDependencies.keySet());
            this.newRoots2Deps = new HashMap<URL, List<URL>>();
            this.newBinaries2InvDeps = new HashMap<URL, List<URL>>();
            this.newRootsToScan = new ArrayList<URL>();
            this.newBinariesToScan = new HashSet<URL>();
            this.scannedRoots = new HashSet<URL>();
            this.scannedBinaries = new HashSet<URL>();
            this.sourcesForBinaryRoots = sourcesForBinaryRoots;
            this.fullRescanSourceRoots = new HashSet<URL>();
            this.useInitialState = useInitialState;
            this.cycleDetector = new Stack();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            sb.append(": {\n");
            sb.append("  useInitialState=").append(this.useInitialState).append("\n");
            sb.append("  initialRoots2Deps(").append(this.initialRoots2Deps.size()).append(")=\n");
            RepositoryUpdater.printMap((Map<URL, List<URL>>)this.initialRoots2Deps, sb);
            sb.append("  initialBinaries(").append(this.initialBinaries2InvDeps.size()).append(")=\n");
            RepositoryUpdater.printMap((Map<URL, List<URL>>)this.initialBinaries2InvDeps, sb);
            sb.append("  oldRoots(").append(this.oldRoots.size()).append(")=\n");
            RepositoryUpdater.printCollection((Collection<? extends URL>)this.oldRoots, sb);
            sb.append("  oldBinaries(").append(this.oldBinaries.size()).append(")=\n");
            RepositoryUpdater.printCollection((Collection<? extends URL>)this.oldBinaries, sb);
            sb.append("  newRootsToScan(").append(this.newRootsToScan.size()).append(")=\n");
            RepositoryUpdater.printCollection((Collection<? extends URL>)this.newRootsToScan, sb);
            sb.append("  newBinariesToScan(").append(this.newBinariesToScan.size()).append(")=\n");
            RepositoryUpdater.printCollection((Collection<? extends URL>)this.newBinariesToScan, sb);
            sb.append("  scannedRoots(").append(this.scannedRoots.size()).append(")=\n");
            RepositoryUpdater.printCollection((Collection<? extends URL>)this.scannedRoots, sb);
            sb.append("  scannedBinaries(").append(this.scannedBinaries.size()).append(")=\n");
            RepositoryUpdater.printCollection((Collection<? extends URL>)this.scannedBinaries, sb);
            sb.append("  newRoots2Deps(").append(this.newRoots2Deps.size()).append(")=\n");
            RepositoryUpdater.printMap((Map<URL, List<URL>>)this.newRoots2Deps, sb);
            sb.append("  newBinaries2InvDeps(").append(this.newBinaries2InvDeps.size()).append(")=\n");
            RepositoryUpdater.printMap((Map<URL, List<URL>>)this.newBinaries2InvDeps, sb);
            sb.append("} ----\n");
            return sb.toString();
        }
    }

    private static final class Task
    extends ParserResultTask {
        private final List<Work> todo = new LinkedList<Work>();
        private Work workInProgress = null;
        private Work cancelledWork = null;
        private boolean scheduled = false;
        private boolean allCancelled = false;
        private boolean cancelled = false;
        private List<Long> protectedOwners = new LinkedList<Long>();
        private List<Runnable> followupTasks = null;
        private static final RequestProcessor RP = new RequestProcessor("RepositoryUpdater.exitProtextedMode.delay");

        private Task() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void schedule(Iterable<? extends Work> multipleWork) {
            List<Work> list = this.todo;
            synchronized (list) {
                for (Work work : multipleWork) {
                    this.schedule(work, false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void schedule(Work work, boolean wait) {
            boolean enforceWork = false;
            boolean waitForWork = false;
            List<Work> list = this.todo;
            synchronized (list) {
                assert (work != null);
                if (!this.allCancelled) {
                    if (wait && Utilities.holdsParserLock()) {
                        if (this.protectedOwners.isEmpty()) {
                            enforceWork = true;
                        } else {
                            LOGGER.log(Level.FINE, "Won't enforce {0} when in protected mode", work);
                            wait = false;
                        }
                    }
                    if (!enforceWork) {
                        if (this.workInProgress != null) {
                            this.workInProgress.cancelBy(work);
                        }
                        boolean absorbed = false;
                        if (!wait) {
                            for (Work w : this.todo) {
                                if (!w.absorb(work)) continue;
                                absorbed = true;
                                break;
                            }
                        }
                        if (!absorbed) {
                            LOGGER.log(Level.FINE, "Scheduling {0}", work);
                            this.todo.add(work);
                        } else {
                            LOGGER.log(Level.FINE, "Work absorbed {0}", work);
                        }
                        if (!this.scheduled && this.protectedOwners.isEmpty()) {
                            this.scheduled = true;
                            Utilities.scheduleSpecialTask(this);
                        }
                        waitForWork = wait;
                    }
                }
            }
            if (enforceWork) {
                LOGGER.log(Level.FINE, "Enforcing {0}", work);
                work.doTheWork();
            } else if (waitForWork) {
                LOGGER.log(Level.FINE, "Waiting for {0}", work);
                work.waitUntilDone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelAll() {
            List<Work> list = this.todo;
            synchronized (list) {
                if (!this.allCancelled) {
                    this.allCancelled = true;
                    this.todo.clear();
                    Work work = this.workInProgress;
                    if (work != null) {
                        work.setCancelled(true);
                    }
                    int cnt = 10;
                    while (this.scheduled && cnt-- > 0) {
                        LOGGER.log(Level.FINE, "Waiting for indexing jobs to finish; job in progress: {0}, jobs queue: {1}", new Object[]{work, this.todo});
                        try {
                            this.todo.wait(1000L);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                            break;
                        }
                    }
                    if (this.scheduled && cnt == 0) {
                        LOGGER.log(Level.INFO, "Waiting for indexing jobs to finish timed out; job in progress {0}, jobs queue: {1}", new Object[]{work, this.todo});
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isWorking() {
            List<Work> list = this.todo;
            synchronized (list) {
                return this.scheduled || !this.protectedOwners.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enterProtectedMode() {
            List<Work> list = this.todo;
            synchronized (list) {
                this.protectedOwners.add(Thread.currentThread().getId());
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Entering protected mode: {0}", this.protectedOwners.size());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void exitProtectedMode(Runnable followupTask) {
            List<Work> list = this.todo;
            synchronized (list) {
                if (this.protectedOwners.isEmpty()) {
                    throw new IllegalStateException("Calling exitProtectedMode without enterProtectedMode");
                }
                if (followupTask != null) {
                    if (this.followupTasks == null) {
                        this.followupTasks = new LinkedList<Runnable>();
                    }
                    this.followupTasks.add(followupTask);
                }
                this.protectedOwners.remove(Thread.currentThread().getId());
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Exiting protected mode: {0}", this.protectedOwners.size());
                }
                if (this.protectedOwners.isEmpty()) {
                    final List<Runnable> tasks = this.followupTasks;
                    RP.create(new Runnable(){

                        @Override
                        public void run() {
                            Task.this.schedule(new Work(false, false, false, true){

                                @Override
                                protected boolean getDone() {
                                    if (tasks != null) {
                                        for (Runnable task : tasks) {
                                            try {
                                                task.run();
                                            }
                                            catch (ThreadDeath td) {
                                                throw td;
                                            }
                                            catch (Throwable t) {
                                                LOGGER.log(Level.WARNING, null, t);
                                            }
                                        }
                                    }
                                    return true;
                                }
                            }, false);
                        }
                    }).schedule(FILE_LOCKS_DELAY);
                    LOGGER.log(Level.FINE, "Protected mode exited, scheduling postprocess tasks: {0}", tasks);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isInProtectedMode() {
            List<Work> list = this.todo;
            synchronized (list) {
                return !this.protectedOwners.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isProtectedModeOwner(Thread thread) {
            List<Work> list = this.todo;
            synchronized (list) {
                return this.protectedOwners.contains(thread.getId());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitUntilFinished(long timeout) throws InterruptedException {
            if (Utilities.holdsParserLock()) {
                throw new IllegalStateException("Can't wait for indexing to finish from inside a running parser task");
            }
            List<Work> list = this.todo;
            synchronized (list) {
                while (this.scheduled) {
                    if (timeout > 0L) {
                        this.todo.wait(timeout);
                        return !this.scheduled;
                    }
                    this.todo.wait();
                }
            }
            return true;
        }

        @Override
        public int getPriority() {
            return 0;
        }

        @Override
        public Class<? extends Scheduler> getSchedulerClass() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            RepositoryUpdater.recordCaller();
            if (notInterruptible) {
                return;
            }
            List<Work> list = this.todo;
            synchronized (list) {
                if (!this.cancelled) {
                    this.cancelled = true;
                    this.cancelledWork = this.workInProgress;
                    if (this.cancelledWork != null) {
                        this.cancelledWork.setCancelled(true);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(Parser.Result nil, SchedulerEvent nothing) {
            List<Work> list = this.todo;
            synchronized (list) {
                this.cancelled = false;
                this.cancelledWork = null;
            }
            try {
                this._run();
            }
            finally {
                list = this.todo;
                synchronized (list) {
                    if (this.cancelledWork != null && !this.cancelledWork.isFinished()) {
                        if (!this.allCancelled) {
                            this.cancelledWork.setCancelled(false);
                            this.todo.add(0, this.cancelledWork);
                        }
                        this.cancelledWork = null;
                    }
                    if (this.todo.isEmpty()) {
                        this.scheduled = false;
                    } else {
                        Utilities.scheduleSpecialTask(this);
                    }
                    this.todo.notifyAll();
                }
            }
        }

        /*
         * Exception decompiling
         */
        private void _run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Work getWork() {
            List<Work> list = this.todo;
            synchronized (list) {
                Work w = !this.cancelled && this.protectedOwners.isEmpty() && this.todo.size() > 0 ? this.todo.remove(0) : null;
                this.workInProgress = w;
                return w;
            }
        }
    }

    private final class InitialRootsWork
    extends RootsWork {
        private final boolean waitForProjects;

        public InitialRootsWork(Map<URL, List<URL>> scannedRoots2Depencencies, Map<URL, List<URL>> scannedBinaries2InvDependencies, Set<URL> sourcesForBinaryRoots, boolean waitForProjects) {
            super(scannedRoots2Depencencies, scannedBinaries2InvDependencies, sourcesForBinaryRoots, true);
            this.waitForProjects = waitForProjects;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean getDone() {
            try {
                if (this.indexers == null) {
                    this.indexers = SourceIndexers.load(true);
                }
                if (this.waitForProjects) {
                    boolean retry = true;
                    while (retry) {
                        try {
                            OpenProjects.getDefault().openProjects().get(1000L, TimeUnit.MILLISECONDS);
                            retry = false;
                        }
                        catch (TimeoutException ex) {
                            if (!this.isCancelledExternally()) continue;
                            boolean bl = false;
                            if (RepositoryUpdater.this.state == State.INITIAL_SCAN_RUNNING) {
                                RepositoryUpdater repositoryUpdater = RepositoryUpdater.this;
                                synchronized (repositoryUpdater) {
                                    if (RepositoryUpdater.this.state == State.INITIAL_SCAN_RUNNING) {
                                        RepositoryUpdater.this.state = State.ACTIVE;
                                    }
                                }
                            }
                            return bl;
                        }
                        catch (Exception ex) {
                            retry = false;
                        }
                    }
                }
                boolean bl = super.getDone();
                return bl;
            }
            finally {
                if (RepositoryUpdater.this.state == State.INITIAL_SCAN_RUNNING) {
                    RepositoryUpdater repositoryUpdater = RepositoryUpdater.this;
                    synchronized (repositoryUpdater) {
                        if (RepositoryUpdater.this.state == State.INITIAL_SCAN_RUNNING) {
                            RepositoryUpdater.this.state = State.ACTIVE;
                        }
                    }
                }
            }
        }
    }

    private static abstract class AbstractRootsWork
    extends Work {
        private boolean logStatistics;

        protected AbstractRootsWork(boolean logStatistics) {
            super(false, false, true, true);
            this.logStatistics = logStatistics;
        }

        protected final boolean scanBinaries(DependenciesContext ctx) {
            assert (ctx != null);
            long[] scannedRootsCnt = new long[]{0L};
            long[] completeTime = new long[]{0L};
            boolean finished = true;
            BinaryIndexers binaryIndexers = null;
            for (URL binary : ctx.newBinariesToScan) {
                if (this.isCancelled()) {
                    finished = false;
                    break;
                }
                if (binaryIndexers == null) {
                    binaryIndexers = BinaryIndexers.load();
                }
                if (this.scanBinary(binary, binaryIndexers, scannedRootsCnt, completeTime)) {
                    ctx.scannedBinaries.add(binary);
                    continue;
                }
                finished = true;
                break;
            }
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info(String.format("Complete indexing of %d binary roots took: %d ms", scannedRootsCnt[0], completeTime[0]));
            }
            TEST_LOGGER.log(Level.FINEST, "scanBinary", ctx.newBinariesToScan);
            return finished;
        }

        /*
         * Exception decompiling
         */
        protected final boolean scanBinary(URL root, BinaryIndexers binaryIndexers, long[] scannedRootsCnt, long[] completeTime) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        protected final boolean scanSources(DependenciesContext ctx, SourceIndexers indexers, Map<URL, List<URL>> preregisterIn) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 20[SIMPLE_IF_TAKEN]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static boolean isNoRootsScan() {
            return Boolean.getBoolean("netbeans.indexing.noRootsScan");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean scanSource(URL root, boolean fullRescan, boolean sourceForBinaryRoot, SourceIndexers indexers, int[] outOfDateFiles, int[] deletedFiles, long[] recursiveListenersTime) throws IOException {
            LOGGER.log(Level.FINE, "Scanning sources root: {0}", root);
            if (AbstractRootsWork.isNoRootsScan() && !fullRescan && TimeStamps.existForRoot(root)) {
                LinkedList transactionContexts = new LinkedList();
                try {
                    FileObject cacheRoot = CacheFolder.getDataFolder(root);
                    for (IndexerCache.IndexerInfo<CustomIndexerFactory> indexerInfo : indexers.cifInfos) {
                        CustomIndexerFactory factory = indexerInfo.getIndexerFactory();
                        Context ctx = SPIAccessor.getInstance().createContext(cacheRoot, root, factory.getIndexerName(), factory.getIndexVersion(), null, this.isFollowUpJob(), this.hasToCheckEditor(), sourceForBinaryRoot, null);
                        CustomIndexer indexer = factory.createIndexer();
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Fake indexing: indexer=" + indexer);
                        }
                        try {
                            SPIAccessor.getInstance().index(indexer, Collections.emptySet(), ctx);
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (Throwable t) {
                            LOGGER.log(Level.WARNING, null, t);
                        }
                    }
                }
                finally {
                    for (Context ctx : transactionContexts) {
                        IndexImpl indexImpl = SPIAccessor.getInstance().getIndexFactory(ctx).getIndex(ctx.getIndexFolder());
                        if (indexImpl == null) continue;
                        indexImpl.store(this.isSteady(), null);
                    }
                }
                return true;
            }
            FileObject rootFo = URLMapper.findFileObject((URL)root);
            if (rootFo != null) {
                ClassPath.Entry entry = sourceForBinaryRoot ? null : RepositoryUpdater.getClassPathEntry(rootFo);
                FileObjectCrawler crawler = new FileObjectCrawler(rootFo, !fullRescan, entry, this.getShuttdownRequest());
                Collection<IndexableImpl> collection = crawler.getResources();
                Collection<IndexableImpl> allResources = crawler.getAllResources();
                Collection<IndexableImpl> deleted = crawler.getDeletedResources();
                if (crawler.isFinished()) {
                    IdentityHashMap<SourceIndexerFactory, Boolean> invalidatedMap = new IdentityHashMap<SourceIndexerFactory, Boolean>();
                    IdentityHashMap<SourceIndexerFactory, Context> ctxToFinish = new IdentityHashMap<SourceIndexerFactory, Context>();
                    this.scanStarted(root, sourceForBinaryRoot, indexers, invalidatedMap, ctxToFinish);
                    try {
                        this.delete(deleted, root);
                        this.invalidateSources(collection);
                        if (this.index(collection, allResources, root, sourceForBinaryRoot, indexers, invalidatedMap, recursiveListenersTime)) {
                            crawler.storeTimestamps();
                            outOfDateFiles[0] = collection.size();
                            deletedFiles[0] = deleted.size();
                            if (this.logStatistics) {
                                this.logStatistics = false;
                                if (SFEC_LOGGER.isLoggable(Level.INFO)) {
                                    LogRecord r = new LogRecord(Level.INFO, "STATS_SCAN_SOURCES");
                                    r.setParameters(new Object[]{outOfDateFiles[0] > 0 || deletedFiles[0] > 0});
                                    r.setResourceBundle(NbBundle.getBundle(RepositoryUpdater.class));
                                    r.setResourceBundleName(RepositoryUpdater.class.getPackage().getName() + ".Bundle");
                                    r.setLoggerName(SFEC_LOGGER.getName());
                                    SFEC_LOGGER.log(r);
                                }
                            }
                            boolean bl = true;
                            return bl;
                        }
                    }
                    finally {
                        this.scanFinished(ctxToFinish);
                    }
                }
                return false;
            }
            return true;
        }

        private static void reportRootScan(URL root, long duration) {
            try {
                Class<?> c = Class.forName("org.netbeans.performance.test.utilities.LoggingScanClasspath", true, Thread.currentThread().getContextClassLoader());
                Method m = c.getMethod("reportScanOfFile", String.class, Long.class);
                m.invoke(c.newInstance(), root.toExternalForm(), new Long(duration));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, null, e);
            }
        }
    }

    private static class RootsWork
    extends AbstractRootsWork {
        private final Map<URL, List<URL>> scannedRoots2Dependencies;
        private final Map<URL, List<URL>> scannedBinaries2InvDependencies;
        private final Set<URL> sourcesForBinaryRoots;
        private boolean useInitialState;
        private DependenciesContext depCtx;
        protected SourceIndexers indexers = null;

        public RootsWork(Map<URL, List<URL>> scannedRoots2Depencencies, Map<URL, List<URL>> scannedBinaries2InvDependencies, Set<URL> sourcesForBinaryRoots, boolean useInitialState) {
            super(false);
            this.scannedRoots2Dependencies = scannedRoots2Depencencies;
            this.scannedBinaries2InvDependencies = scannedBinaries2InvDependencies;
            this.sourcesForBinaryRoots = sourcesForBinaryRoots;
            this.useInitialState = useInitialState;
        }

        @Override
        public String toString() {
            return super.toString() + ", useInitialState=" + this.useInitialState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean getDone() {
            List<URL> deps;
            boolean finished;
            Controller controller;
            boolean restarted;
            if (this.isCancelled()) {
                return false;
            }
            this.updateProgress(NbBundle.getMessage(RepositoryUpdater.class, (String)"MSG_ProjectDependencies"));
            long tm1 = System.currentTimeMillis();
            if (this.depCtx == null) {
                restarted = false;
                this.depCtx = new DependenciesContext(this.scannedRoots2Dependencies, this.scannedBinaries2InvDependencies, this.sourcesForBinaryRoots, this.useInitialState);
                LinkedList<? extends URL> newRoots = new LinkedList<URL>();
                Collection<? extends URL> c = PathRegistry.getDefault().getSources();
                LOGGER.log(Level.FINE, "PathRegistry.sources=");
                RepositoryUpdater.printCollection((Collection<? extends URL>)c, Level.FINE);
                newRoots.addAll(c);
                c = PathRegistry.getDefault().getLibraries();
                LOGGER.log(Level.FINE, "PathRegistry.libraries=");
                RepositoryUpdater.printCollection((Collection<? extends URL>)c, Level.FINE);
                newRoots.addAll(c);
                this.depCtx.newBinariesToScan.addAll(PathRegistry.getDefault().getBinaryLibraries());
                Iterator it = this.depCtx.newBinariesToScan.iterator();
                while (it.hasNext()) {
                    if (!this.depCtx.oldBinaries.remove(it.next())) continue;
                    it.remove();
                }
                if (this.useInitialState) {
                    c = PathRegistry.getDefault().getUnknownRoots();
                    LOGGER.log(Level.FINE, "PathRegistry.unknown=");
                    RepositoryUpdater.printCollection((Collection<? extends URL>)c, Level.FINE);
                    newRoots.addAll(c);
                }
                for (URL uRL : newRoots) {
                    if (RepositoryUpdater.findDependencies(uRL, this.depCtx, null, null, this.getShuttdownRequest())) continue;
                    this.depCtx = null;
                    return false;
                }
                Controller controller2 = controller = (Controller)IndexingController.getDefault();
                synchronized (controller2) {
                    HashMap nextRoots2Deps = new HashMap();
                    nextRoots2Deps.putAll(this.depCtx.initialRoots2Deps);
                    nextRoots2Deps.keySet().removeAll(this.depCtx.oldRoots);
                    nextRoots2Deps.putAll(this.depCtx.newRoots2Deps);
                    controller.roots2Dependencies = Collections.unmodifiableMap(nextRoots2Deps);
                    HashMap nextBinRoots2Deps = new HashMap();
                    nextBinRoots2Deps.putAll(this.depCtx.initialBinaries2InvDeps);
                    nextBinRoots2Deps.keySet().removeAll(this.depCtx.oldBinaries);
                    nextBinRoots2Deps.putAll(this.depCtx.newBinaries2InvDeps);
                    controller.binRoots2Dependencies = Collections.unmodifiableMap(nextBinRoots2Deps);
                }
                try {
                    this.depCtx.newRootsToScan.addAll(org.openide.util.Utilities.topologicalSort(this.depCtx.newRoots2Deps.keySet(), (Map)this.depCtx.newRoots2Deps));
                }
                catch (TopologicalSortException topologicalSortException) {
                    LOGGER.log(Level.INFO, "Cycles detected in classpath roots dependencies, using partial ordering", topologicalSortException);
                    List partialSort = topologicalSortException.partialSort();
                    this.depCtx.newRootsToScan.addAll(partialSort);
                }
                Collections.reverse(this.depCtx.newRootsToScan);
                if (!this.useInitialState) {
                    HashMap hashMap = new HashMap();
                    HashMap addedOrChanged = new HashMap();
                    RootsWork.diff(this.depCtx.initialRoots2Deps, this.depCtx.newRoots2Deps, addedOrChanged, hashMap);
                    Level logLevel = Level.FINE;
                    if (LOGGER.isLoggable(logLevel) && (addedOrChanged.size() > 0 || hashMap.size() > 0)) {
                        LOGGER.log(logLevel, "Changes in dependencies detected:");
                        LOGGER.log(logLevel, "initialRoots2Deps({0})=", this.depCtx.initialRoots2Deps.size());
                        RepositoryUpdater.printMap((Map<URL, List<URL>>)this.depCtx.initialRoots2Deps, logLevel);
                        LOGGER.log(logLevel, "newRoots2Deps({0})=", this.depCtx.newRoots2Deps.size());
                        RepositoryUpdater.printMap((Map<URL, List<URL>>)this.depCtx.newRoots2Deps, logLevel);
                        LOGGER.log(logLevel, "addedOrChanged({0})=", addedOrChanged.size());
                        RepositoryUpdater.printMap((Map<URL, List<URL>>)addedOrChanged, logLevel);
                        LOGGER.log(logLevel, "removed({0})=", hashMap.size());
                        RepositoryUpdater.printMap((Map<URL, List<URL>>)hashMap, logLevel);
                    }
                    this.depCtx.oldRoots.clear();
                    this.depCtx.oldRoots.addAll(hashMap.keySet());
                    this.depCtx.newRootsToScan.retainAll(addedOrChanged.keySet());
                    this.depCtx.fullRescanSourceRoots = this.depCtx.newRoots2Deps.keySet();
                }
            } else {
                restarted = true;
                this.depCtx.newRootsToScan.removeAll(this.depCtx.scannedRoots);
                this.depCtx.scannedRoots.clear();
                this.depCtx.newBinariesToScan.removeAll(this.depCtx.scannedBinaries);
                this.depCtx.scannedBinaries.clear();
                this.depCtx.oldBinaries.clear();
                this.depCtx.oldRoots.clear();
            }
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Resolving dependencies took: {0} ms", System.currentTimeMillis() - tm1);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Running " + this + " on \n" + this.depCtx.toString());
            }
            if (finished = this.scanBinaries(this.depCtx)) {
                finished = this.scanSources(this.depCtx, this.indexers, this.scannedRoots2Dependencies);
            }
            LinkedList<URL> missingRoots = new LinkedList<URL>();
            for (URL uRL : this.depCtx.scannedRoots) {
                deps = (List<URL>)this.depCtx.newRoots2Deps.get(uRL);
                if (deps == null) {
                    deps = EMPTY_DEPS;
                    missingRoots.add(uRL);
                }
                this.scannedRoots2Dependencies.put(uRL, deps);
            }
            if (!missingRoots.isEmpty()) {
                StringBuilder log = new StringBuilder("Missing dependencies for roots: ");
                RepositoryUpdater.printCollection((Collection<? extends URL>)missingRoots, log);
                log.append("Context:");
                log.append(this.depCtx);
                log.append("Restarted: ");
                log.append(restarted);
                LOGGER.info(log.toString());
            }
            this.scannedRoots2Dependencies.keySet().removeAll(this.depCtx.oldRoots);
            for (URL uRL : this.depCtx.scannedBinaries) {
                deps = (List<URL>)this.depCtx.newBinaries2InvDeps.get(uRL);
                if (deps == null) {
                    deps = EMPTY_DEPS;
                }
                this.scannedBinaries2InvDependencies.put(uRL, deps);
            }
            this.scannedBinaries2InvDependencies.keySet().removeAll(this.depCtx.oldBinaries);
            Controller controller3 = controller = (Controller)IndexingController.getDefault();
            synchronized (controller3) {
                controller.roots2Dependencies = Collections.unmodifiableMap(new HashMap<URL, List<URL>>(this.scannedRoots2Dependencies));
                controller.binRoots2Dependencies = Collections.unmodifiableMap(new HashMap<URL, List<URL>>(this.scannedBinaries2InvDependencies));
            }
            this.notifyRootsRemoved(this.depCtx.oldBinaries, this.depCtx.oldRoots);
            Level level = Level.FINE;
            if (LOGGER.isLoggable(level)) {
                LOGGER.log(level, this + " " + (this.isCancelled() ? "cancelled" : "finished") + ": {");
                LOGGER.log(level, "  scannedRoots2Dependencies(" + this.scannedRoots2Dependencies.size() + ")=");
                RepositoryUpdater.printMap((Map<URL, List<URL>>)this.scannedRoots2Dependencies, level);
                LOGGER.log(level, "  scannedBinaries(" + this.scannedBinaries2InvDependencies.size() + ")=");
                RepositoryUpdater.printCollection((Collection<? extends URL>)this.scannedBinaries2InvDependencies.keySet(), level);
                LOGGER.log(level, "} ====");
            }
            this.refreshActiveDocument();
            return finished;
        }

        @Override
        protected boolean isCancelledBy(Work newWork) {
            boolean b;
            boolean bl = b = newWork instanceof RootsWork && this.useInitialState;
            if (b && LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Cancelling " + this + ", because of " + newWork);
            }
            return b;
        }

        @Override
        public boolean absorb(Work newWork) {
            if (newWork.getClass().equals(RootsWork.class)) {
                if (!((RootsWork)newWork).useInitialState) {
                    this.useInitialState = ((RootsWork)newWork).useInitialState;
                    LOGGER.fine("Absorbing " + newWork + ", updating useInitialState to " + this.useInitialState);
                }
                return true;
            }
            return false;
        }

        private void notifyRootsRemoved(Set<URL> binaries, Set<URL> sources) {
            if (!binaries.isEmpty()) {
                Collection binFactories = MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookupAll(BinaryIndexerFactory.class);
                Set<URL> roots = Collections.unmodifiableSet(binaries);
                for (BinaryIndexerFactory binaryIndexerFactory : binFactories) {
                    binaryIndexerFactory.rootsRemoved(roots);
                }
                RepositoryUpdater.getDefault().rootsListeners.remove(binaries, false);
            }
            if (!sources.isEmpty()) {
                Set<URL> roots = Collections.unmodifiableSet(sources);
                Collection<IndexerCache.IndexerInfo<CustomIndexerFactory>> customIndexers = IndexerCache.getCifCache().getIndexers(null);
                for (IndexerCache.IndexerInfo indexerInfo : customIndexers) {
                    ((CustomIndexerFactory)indexerInfo.getIndexerFactory()).rootsRemoved(roots);
                }
                Collection<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>> embeddingIndexers = IndexerCache.getEifCache().getIndexers(null);
                for (IndexerCache.IndexerInfo<EmbeddingIndexerFactory> embeddingIndexer : embeddingIndexers) {
                    embeddingIndexer.getIndexerFactory().rootsRemoved(roots);
                }
                RepositoryUpdater.getDefault().rootsListeners.remove(sources, true);
            }
        }

        private static <A, B> void diff(Map<A, B> oldMap, Map<A, B> newMap, Map<A, B> addedOrChangedEntries, Map<A, B> removedEntries) {
            for (A key : oldMap.keySet()) {
                if (!newMap.containsKey(key)) {
                    removedEntries.put(key, oldMap.get(key));
                    continue;
                }
                if (org.openide.util.Utilities.compareObjects(oldMap.get(key), newMap.get(key))) continue;
                addedOrChangedEntries.put(key, newMap.get(key));
            }
            for (A key : newMap.keySet()) {
                if (oldMap.containsKey(key)) continue;
                addedOrChangedEntries.put(key, newMap.get(key));
            }
        }

        private static <T> void diff(List<T> oldList, List<T> newList, Collection<? super T> added, Collection<? super T> removed) {
            HashSet<T> oldCopy = new HashSet<T>(oldList);
            HashSet<T> newCopy = new HashSet<T>(newList);
            Iterator oldIt = oldCopy.iterator();
            while (oldIt.hasNext()) {
                Object e = oldIt.next();
                oldIt.remove();
                if (newCopy.remove(e)) continue;
                removed.add(e);
            }
            added.addAll(newCopy);
        }
    }

    static final class RefreshWork
    extends AbstractRootsWork {
        private final Map<URL, List<URL>> scannedRoots2Dependencies;
        private final Map<URL, List<URL>> scannedBinaries2InvDependencies;
        private final Set<URL> sourcesForBinaryRoots;
        private final Set<Pair<Object, Boolean>> suspectFilesOrFileObjects;
        private final FSRefreshInterceptor interceptor;
        private DependenciesContext depCtx;
        private Map<URL, Set<FileObject>> fullRescanFiles;
        private Map<URL, Set<FileObject>> checkTimestampFiles;

        public RefreshWork(Map<URL, List<URL>> scannedRoots2Depencencies, Map<URL, List<URL>> scannedBinaries2InvDependencies, Set<URL> sourcesForBinaryRoots, boolean fullRescan, boolean logStatistics, Collection<? extends Object> suspectFilesOrFileObjects, FSRefreshInterceptor interceptor) {
            super(logStatistics);
            Parameters.notNull((CharSequence)"scannedRoots2Depencencies", scannedRoots2Depencencies);
            Parameters.notNull((CharSequence)"scannedBinaries2InvDependencies", scannedBinaries2InvDependencies);
            Parameters.notNull((CharSequence)"sourcesForBinaryRoots", sourcesForBinaryRoots);
            Parameters.notNull((CharSequence)"interceptor", (Object)interceptor);
            this.scannedRoots2Dependencies = scannedRoots2Depencencies;
            this.scannedBinaries2InvDependencies = scannedBinaries2InvDependencies;
            this.sourcesForBinaryRoots = sourcesForBinaryRoots;
            this.suspectFilesOrFileObjects = new HashSet<Pair<Object, Boolean>>();
            if (suspectFilesOrFileObjects != null) {
                this.addSuspects(suspectFilesOrFileObjects, fullRescan);
            }
            this.interceptor = interceptor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        protected boolean getDone() {
            if (this.depCtx == null) {
                this.depCtx = new DependenciesContext(this.scannedRoots2Dependencies, this.scannedBinaries2InvDependencies, this.sourcesForBinaryRoots, false);
                if (this.suspectFilesOrFileObjects.isEmpty()) {
                    this.depCtx.newBinariesToScan.addAll(this.scannedBinaries2InvDependencies.keySet());
                    try {
                        this.depCtx.newRootsToScan.addAll(org.openide.util.Utilities.topologicalSort(this.scannedRoots2Dependencies.keySet(), this.scannedRoots2Dependencies));
                    }
                    catch (TopologicalSortException tse) {
                        LOGGER.log(Level.INFO, "Cycles detected in classpath roots dependencies, using partial ordering", tse);
                        List partialSort = tse.partialSort();
                        this.depCtx.newRootsToScan.addAll(partialSort);
                    }
                    Collections.reverse(this.depCtx.newRootsToScan);
                } else {
                    FileObject rootFo;
                    HashSet suspects = new HashSet();
                    for (Pair<Object, Boolean> pair : this.suspectFilesOrFileObjects) {
                        Pair fileObject = null;
                        if (pair.first instanceof File) {
                            FileObject fileObject2 = FileUtil.toFileObject((File)((File)pair.first));
                            if (fileObject2 != null) {
                                fileObject = Pair.of(fileObject2, pair.second);
                            }
                        } else if (pair.first instanceof FileObject) {
                            fileObject = Pair.of((FileObject)pair.first, pair.second);
                        } else {
                            LOGGER.fine("Not File or FileObject, ignoring: " + pair);
                        }
                        if (fileObject == null) continue;
                        suspects.add(fileObject);
                    }
                    block8: for (Pair<Object, Boolean> pair : suspects) {
                        for (URL uRL : this.scannedBinaries2InvDependencies.keySet()) {
                            FileObject rootFo2;
                            File rootFile = FileUtil.archiveOrDirForURL((URL)uRL);
                            if (rootFile != null && (rootFo2 = FileUtil.toFileObject((File)rootFile)) != null && (pair.first == rootFo2 || FileUtil.isParentOf((FileObject)((FileObject)pair.first), (FileObject)rootFo2))) {
                                this.depCtx.newBinariesToScan.add(uRL);
                                continue block8;
                            }
                            FileObject rootFo3 = URLCache.getInstance().findFileObject(uRL);
                            if (rootFo3 == null || pair.first != rootFo3 && !FileUtil.isParentOf((FileObject)rootFo3, (FileObject)((FileObject)pair.first))) continue;
                            this.depCtx.newBinariesToScan.add(uRL);
                            continue block8;
                        }
                    }
                    HashSet<Pair> containers = new HashSet<Pair>();
                    HashMap hashMap = new HashMap();
                    for (URL uRL : this.scannedRoots2Dependencies.keySet()) {
                        rootFo = URLCache.getInstance().findFileObject(uRL);
                        if (rootFo == null) continue;
                        for (Pair pair : suspects) {
                            if (pair.first != rootFo && !FileUtil.isParentOf((FileObject)((FileObject)pair.first), (FileObject)rootFo)) continue;
                            Pair<FileObject, Object> pair2 = (Pair)hashMap.get(uRL);
                            pair2 = pair2 == null ? Pair.of(rootFo, pair.second) : Pair.of(rootFo, (Boolean)pair2.second != false || (Boolean)pair.second != false);
                            hashMap.put(uRL, pair2);
                            containers.add(pair);
                        }
                    }
                    suspects.removeAll(containers);
                    for (Map.Entry entry : hashMap.entrySet()) {
                        Iterator it = suspects.iterator();
                        while (it.hasNext()) {
                            Pair f = (Pair)it.next();
                            Pair pair = (Pair)entry.getValue();
                            if (!FileUtil.isParentOf((FileObject)((FileObject)pair.first), (FileObject)((FileObject)f.first)) || !((Boolean)pair.second).booleanValue() && ((Boolean)f.second).booleanValue()) continue;
                            it.remove();
                        }
                    }
                    for (Map.Entry entry : hashMap.entrySet()) {
                        this.depCtx.newRootsToScan.add(entry.getKey());
                        if (!((Boolean)((Pair)entry.getValue()).second).booleanValue()) continue;
                        this.depCtx.fullRescanSourceRoots.add(entry.getKey());
                    }
                    this.fullRescanFiles = new HashMap<URL, Set<FileObject>>();
                    this.checkTimestampFiles = new HashMap<URL, Set<FileObject>>();
                    block15: for (Pair<Object, Boolean> pair : suspects) {
                        for (URL uRL : this.scannedRoots2Dependencies.keySet()) {
                            void var8_32;
                            rootFo = URLCache.getInstance().findFileObject(uRL);
                            if (rootFo == null || pair.first != rootFo && !FileUtil.isParentOf((FileObject)rootFo, (FileObject)((FileObject)pair.first))) continue;
                            Map<URL, Set<FileObject>> map = (Boolean)pair.second != false ? this.fullRescanFiles : this.checkTimestampFiles;
                            Set<FileObject> set = map.get(uRL);
                            if (set == null) {
                                HashSet hashSet = new HashSet();
                                map.put(uRL, hashSet);
                            }
                            var8_32.add(pair.first);
                            continue block15;
                        }
                    }
                }
                FileSystem.AtomicAction aa = new FileSystem.AtomicAction(){

                    public void run() throws IOException {
                        FileUtil.refreshAll();
                    }
                };
                this.interceptor.setIgnoreFsEvents(true);
                try {
                    FileUtil.runAtomicAction((FileSystem.AtomicAction)aa);
                }
                catch (IOException ex) {
                    LOGGER.log(Level.WARNING, null, ex);
                }
                finally {
                    this.interceptor.setIgnoreFsEvents(false);
                }
            } else {
                this.depCtx.newRootsToScan.removeAll(this.depCtx.scannedRoots);
                this.depCtx.scannedRoots.clear();
                this.depCtx.newBinariesToScan.removeAll(this.depCtx.scannedBinaries);
                this.depCtx.scannedBinaries.clear();
            }
            boolean finished = this.scanBinaries(this.depCtx);
            if (finished && (finished = this.scanSources(this.depCtx, null, null)) && (finished = this.scanRootFiles(this.fullRescanFiles))) {
                finished = this.scanRootFiles(this.checkTimestampFiles);
            }
            Level logLevel = Level.FINE;
            if (LOGGER.isLoggable(logLevel)) {
                LOGGER.log(logLevel, this + " " + (this.isCancelled() ? "cancelled" : "finished") + ": {");
                LOGGER.log(logLevel, "  scannedRoots2Dependencies(" + this.scannedRoots2Dependencies.size() + ")=");
                RepositoryUpdater.printMap((Map<URL, List<URL>>)this.scannedRoots2Dependencies, logLevel);
                LOGGER.log(logLevel, "  scannedBinaries(" + this.scannedBinaries2InvDependencies.size() + ")=");
                RepositoryUpdater.printCollection((Collection<? extends URL>)this.scannedBinaries2InvDependencies.keySet(), logLevel);
                LOGGER.log(logLevel, "} ====");
            }
            this.refreshActiveDocument();
            return finished;
        }

        @Override
        public boolean absorb(Work newWork) {
            if (newWork instanceof RefreshWork) {
                this.suspectFilesOrFileObjects.addAll(((RefreshWork)newWork).suspectFilesOrFileObjects);
                return true;
            }
            if (newWork instanceof FileListWork) {
                FileListWork flw = (FileListWork)newWork;
                if (flw.files.isEmpty()) {
                    this.suspectFilesOrFileObjects.add(Pair.of(URLCache.getInstance().findFileObject(flw.root), flw.forceRefresh));
                } else {
                    this.addSuspects(flw.files, flw.forceRefresh);
                }
                return true;
            }
            if (newWork instanceof DeleteWork) {
                this.suspectFilesOrFileObjects.add(Pair.of(URLCache.getInstance().findFileObject(((DeleteWork)newWork).root), false));
                return true;
            }
            return false;
        }

        public void addSuspects(Collection<? extends Object> filesOrFolders, boolean fullRescan) {
            for (Object object : filesOrFolders) {
                this.suspectFilesOrFileObjects.add(Pair.of(object, fullRescan));
            }
        }

        private boolean scanRootFiles(Map<URL, Set<FileObject>> files) {
            if (files != null && files.size() > 0) {
                Iterator<Map.Entry<URL, Set<FileObject>>> it = files.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<URL, Set<FileObject>> entry = it.next();
                    URL root = entry.getKey();
                    if (this.scanFiles(root, (Collection<FileObject>)entry.getValue(), true, this.sourcesForBinaryRoots.contains(root))) {
                        it.remove();
                        continue;
                    }
                    return false;
                }
            }
            return true;
        }

        @Override
        public String toString() {
            return super.toString() + ", suspectFilesOrFileObjects=" + this.suspectFilesOrFileObjects;
        }
    }

    private static class RefreshEifIndices
    extends Work {
        private final Collection<? extends IndexerCache.IndexerInfo<EmbeddingIndexerFactory>> eifInfos;
        private final Map<URL, List<URL>> scannedRoots2Dependencies;
        private final Set<URL> sourcesForBinaryRoots;

        public RefreshEifIndices(Collection<? extends IndexerCache.IndexerInfo<EmbeddingIndexerFactory>> eifInfos, Map<URL, List<URL>> scannedRoots2Depencencies, Set<URL> sourcesForBinaryRoots) {
            super(false, false, NbBundle.getMessage(RepositoryUpdater.class, (String)"MSG_RefreshingIndices"), true);
            this.eifInfos = eifInfos;
            this.scannedRoots2Dependencies = scannedRoots2Depencencies;
            this.sourcesForBinaryRoots = sourcesForBinaryRoots;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected boolean getDone() {
            Iterator<URL> i$ = this.scannedRoots2Dependencies.keySet().iterator();
            while (i$.hasNext()) {
                URL root = i$.next();
                if (this.getShuttdownRequest().isRaised()) {
                    return true;
                }
                this.updateProgress(root);
                try {
                    FileObject rootFo = URLMapper.findFileObject((URL)root);
                    if (rootFo == null) continue;
                    boolean sourceForBinaryRoot = this.sourcesForBinaryRoots.contains(root);
                    ClassPath.Entry entry = sourceForBinaryRoot ? null : RepositoryUpdater.getClassPathEntry(rootFo);
                    FileObjectCrawler crawler = new FileObjectCrawler(rootFo, false, entry, this.getShuttdownRequest());
                    Collection<IndexableImpl> resources = crawler.getResources();
                    Collection<IndexableImpl> deleted = crawler.getDeletedResources();
                    if (!crawler.isFinished()) continue;
                    if (deleted.size() > 0) {
                        this.delete(deleted, root);
                    }
                    LinkedList<Context> transactionContexts = new LinkedList<Context>();
                    LinkedList<Iterable<Indexable>> allIndexblesSentToIndexers = new LinkedList<Iterable<Indexable>>();
                    try {
                        HashMap<String, Set<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>>> eifInfosMap = new HashMap<String, Set<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>>>();
                        for (IndexerCache.IndexerInfo<EmbeddingIndexerFactory> indexerInfo : this.eifInfos) {
                            for (String mimeType : indexerInfo.getMimeTypes()) {
                                HashSet<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>> infos = (HashSet<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>>)eifInfosMap.get(mimeType);
                                if (infos == null) {
                                    infos = new HashSet<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>>();
                                    eifInfosMap.put(mimeType, infos);
                                }
                                infos.add(indexerInfo);
                            }
                        }
                        ClusteredIndexables ci = new ClusteredIndexables(resources);
                        FileObject fileObject = CacheFolder.getDataFolder(root);
                        for (String mimeType : Util.getAllMimeTypes()) {
                            if (this.getShuttdownRequest().isRaised()) {
                                boolean infos = false;
                                return infos;
                            }
                            if (!Util.canBeParsed(mimeType)) continue;
                            Iterable<Indexable> indexables = ci.getIndexablesFor(mimeType);
                            allIndexblesSentToIndexers.add(indexables);
                            long tm1 = System.currentTimeMillis();
                            boolean f = this.indexEmbedding(eifInfosMap, fileObject, root, indexables, transactionContexts, sourceForBinaryRoot);
                            long tm2 = System.currentTimeMillis();
                            if (!f) {
                                boolean bl = false;
                                return bl;
                            }
                            if (!LOGGER.isLoggable(Level.FINE)) continue;
                            LOGGER.fine("Indexing " + mimeType + " embeddables under " + root + "; took " + (tm2 - tm1) + "ms");
                        }
                    }
                    finally {
                        Iterator i$2 = transactionContexts.iterator();
                        while (true) {
                            if (!i$2.hasNext()) {
                            }
                            Context ctx = (Context)i$2.next();
                            IndexImpl index = SPIAccessor.getInstance().getIndexFactory(ctx).getIndex(ctx.getIndexFolder());
                            if (index == null) continue;
                            index.store(this.isSteady(), new ProxyIterable<Indexable>(allIndexblesSentToIndexers, false));
                        }
                    }
                    crawler.storeTimestamps();
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.WARNING, null, ioe);
                }
            }
            return true;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            Iterator<? extends IndexerCache.IndexerInfo<EmbeddingIndexerFactory>> it = this.eifInfos.iterator();
            while (it.hasNext()) {
                IndexerCache.IndexerInfo<EmbeddingIndexerFactory> eifInfo = it.next();
                sb.append(" indexer=").append(eifInfo.getIndexerName()).append('/').append(eifInfo.getIndexerVersion());
                sb.append(" (");
                RepositoryUpdater.printMimeTypes(eifInfo.getMimeTypes(), sb);
                sb.append(')');
                if (!it.hasNext()) continue;
                sb.append(',');
            }
            return super.toString() + sb.toString();
        }
    }

    private static class RefreshCifIndices
    extends Work {
        private final Collection<? extends IndexerCache.IndexerInfo<CustomIndexerFactory>> cifInfos;
        private final Map<URL, List<URL>> scannedRoots2Dependencies;
        private final Set<URL> sourcesForBinaryRoots;

        public RefreshCifIndices(Collection<? extends IndexerCache.IndexerInfo<CustomIndexerFactory>> cifInfos, Map<URL, List<URL>> scannedRoots2Depencencies, Set<URL> sourcesForBinaryRoots) {
            super(false, false, NbBundle.getMessage(RepositoryUpdater.class, (String)"MSG_RefreshingIndices"), true);
            this.cifInfos = cifInfos;
            this.scannedRoots2Dependencies = scannedRoots2Depencencies;
            this.sourcesForBinaryRoots = sourcesForBinaryRoots;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected boolean getDone() {
            Iterator<URL> i$ = this.scannedRoots2Dependencies.keySet().iterator();
            while (i$.hasNext()) {
                URL root = i$.next();
                if (this.getShuttdownRequest().isRaised()) {
                    return true;
                }
                this.updateProgress(root);
                try {
                    Context ctx;
                    FileObject rootFo = URLMapper.findFileObject((URL)root);
                    if (rootFo == null) continue;
                    boolean sourceForBinaryRoot = this.sourcesForBinaryRoots.contains(root);
                    ClassPath.Entry entry = sourceForBinaryRoot ? null : RepositoryUpdater.getClassPathEntry(rootFo);
                    FileObjectCrawler crawler = new FileObjectCrawler(rootFo, false, entry, this.getShuttdownRequest());
                    Collection<IndexableImpl> resources = crawler.getResources();
                    Collection<IndexableImpl> deleted = crawler.getDeletedResources();
                    if (!crawler.isFinished()) continue;
                    if (deleted.size() > 0) {
                        this.delete(deleted, root);
                    }
                    LinkedList<Context> transactionContexts = new LinkedList<Context>();
                    LinkedList allIndexblesSentToIndexers = new LinkedList();
                    try {
                        ClusteredIndexables ci = new ClusteredIndexables(resources);
                        for (IndexerCache.IndexerInfo<CustomIndexerFactory> indexerInfo : this.cifInfos) {
                            LinkedList<Iterable<Indexable>> indexerIndexablesList = new LinkedList<Iterable<Indexable>>();
                            for (String mimeType : indexerInfo.getMimeTypes()) {
                                indexerIndexablesList.add(ci.getIndexablesFor(mimeType));
                            }
                            ProxyIterable indexables = new ProxyIterable(indexerIndexablesList);
                            allIndexblesSentToIndexers.addAll(indexerIndexablesList);
                            if (this.getShuttdownRequest().isRaised()) {
                                boolean mimeType = false;
                                return mimeType;
                            }
                            CustomIndexerFactory factory = indexerInfo.getIndexerFactory();
                            FileObject cacheRoot = CacheFolder.getDataFolder(root);
                            ctx = SPIAccessor.getInstance().createContext(cacheRoot, root, factory.getIndexerName(), factory.getIndexVersion(), null, false, false, sourceForBinaryRoot, this.getShuttdownRequest());
                            SPIAccessor.getInstance().setAllFilesJob(ctx, true);
                            transactionContexts.add(ctx);
                            CustomIndexer indexer = factory.createIndexer();
                            if (LOGGER.isLoggable(Level.FINE)) {
                                StringBuilder sb = RepositoryUpdater.printMimeTypes(indexerInfo.getMimeTypes(), new StringBuilder());
                                LOGGER.fine("Reindexing " + root + " using " + indexer + "; mimeTypes=" + sb.toString());
                            }
                            try {
                                SPIAccessor.getInstance().index(indexer, indexables, ctx);
                            }
                            catch (ThreadDeath td) {
                                throw td;
                            }
                            catch (Throwable t) {
                                LOGGER.log(Level.WARNING, null, t);
                            }
                        }
                    }
                    finally {
                        Iterator i$2 = transactionContexts.iterator();
                        while (true) {
                            if (!i$2.hasNext()) {
                            }
                            ctx = (Context)i$2.next();
                            IndexImpl index = SPIAccessor.getInstance().getIndexFactory(ctx).getIndex(ctx.getIndexFolder());
                            if (index == null) continue;
                            index.store(this.isSteady(), new ProxyIterable<Indexable>(allIndexblesSentToIndexers, false));
                        }
                    }
                    crawler.storeTimestamps();
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.WARNING, null, ioe);
                }
            }
            return true;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            Iterator<? extends IndexerCache.IndexerInfo<CustomIndexerFactory>> it = this.cifInfos.iterator();
            while (it.hasNext()) {
                IndexerCache.IndexerInfo<CustomIndexerFactory> cifInfo = it.next();
                sb.append(" indexer=").append(cifInfo.getIndexerName()).append('/').append(cifInfo.getIndexerVersion());
                sb.append(" (");
                RepositoryUpdater.printMimeTypes(cifInfo.getMimeTypes(), sb);
                sb.append(')');
                if (!it.hasNext()) continue;
                sb.append(',');
            }
            return super.toString() + sb.toString();
        }
    }

    private static final class DeleteWork
    extends Work {
        private final URL root;
        private final Set<String> relativePaths = new HashSet<String>();

        public DeleteWork(URL root, Set<String> relativePaths) {
            super(false, false, false, true);
            Parameters.notNull((CharSequence)"root", (Object)root);
            Parameters.notNull((CharSequence)"relativePath", relativePaths);
            this.root = root;
            this.relativePaths.addAll(relativePaths);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("DeleteWork@" + Integer.toHexString(System.identityHashCode(this)) + ": root=" + root + ", files=" + relativePaths);
            }
        }

        @Override
        public boolean getDone() {
            try {
                LinkedList<IndexableImpl> indexables = new LinkedList<IndexableImpl>();
                for (String path : this.relativePaths) {
                    indexables.add(new DeletedIndexable(this.root, path));
                }
                this.delete(indexables, this.root);
                TEST_LOGGER.log(Level.FINEST, "delete");
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, null, ioe);
            }
            return true;
        }

        @Override
        public boolean absorb(Work newWork) {
            if (newWork instanceof DeleteWork) {
                DeleteWork ndw = (DeleteWork)newWork;
                if (ndw.root.equals(this.root)) {
                    this.relativePaths.addAll(ndw.relativePaths);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(this + ", root=" + this.root + " absorbed: " + ndw.relativePaths);
                    }
                    return true;
                }
            }
            return false;
        }
    }

    private static final class BinaryWork
    extends AbstractRootsWork {
        private final URL root;

        public BinaryWork(URL root) {
            super(false);
            this.root = root;
        }

        @Override
        protected boolean getDone() {
            return this.scanBinary(this.root, BinaryIndexers.load(), null, null);
        }

        @Override
        public boolean absorb(Work newWork) {
            if (newWork instanceof BinaryWork) {
                return this.root.equals(((BinaryWork)newWork).root);
            }
            return false;
        }
    }

    static final class FileListWork
    extends Work {
        private final URL root;
        private final Collection<FileObject> files = new HashSet<FileObject>();
        private final boolean forceRefresh;
        private final boolean sourceForBinaryRoot;
        private final Map<URL, List<URL>> scannedRoots2Depencencies;

        public FileListWork(Map<URL, List<URL>> scannedRoots2Depencencies, URL root, boolean followUpJob, boolean checkEditor, boolean forceRefresh, boolean sourceForBinaryRoot) {
            super(followUpJob, checkEditor, true, true);
            assert (root != null);
            this.root = root;
            this.forceRefresh = forceRefresh;
            this.sourceForBinaryRoot = sourceForBinaryRoot;
            this.scannedRoots2Depencencies = scannedRoots2Depencencies;
        }

        public FileListWork(Map<URL, List<URL>> scannedRoots2Depencencies, URL root, Collection<FileObject> files, boolean followUpJob, boolean checkEditor, boolean forceRefresh, boolean sourceForBinaryRoot, boolean steady) {
            super(followUpJob, checkEditor, followUpJob, steady);
            assert (root != null);
            assert (files != null && files.size() > 0);
            this.root = root;
            this.files.addAll(files);
            this.forceRefresh = forceRefresh;
            this.sourceForBinaryRoot = sourceForBinaryRoot;
            this.scannedRoots2Depencencies = scannedRoots2Depencencies;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("FileListWork@" + Integer.toHexString(System.identityHashCode(this)) + ": root=" + root + ", file=" + files);
            }
        }

        public void addFile(FileObject f) {
            assert (f != null);
            assert (FileUtil.isParentOf((FileObject)URLMapper.findFileObject((URL)this.root), (FileObject)f)) : "File " + f + " does not belong under the root: " + this.root;
            this.files.add(f);
        }

        @Override
        protected boolean getDone() {
            this.updateProgress(this.root);
            if (this.scanFiles(this.root, this.files, this.forceRefresh, this.sourceForBinaryRoot)) {
                if (!this.files.isEmpty()) {
                    Map f2d = RepositoryUpdater.getEditorFiles();
                    for (FileObject f : this.files) {
                        Document d = (Document)f2d.get(f);
                        if (d == null) continue;
                        long version = DocumentUtilities.getDocumentVersion((Document)d);
                        d.putProperty(PROP_LAST_INDEXED_VERSION, version);
                        d.putProperty(PROP_LAST_DIRTY_VERSION, null);
                    }
                }
                if (!this.scannedRoots2Depencencies.containsKey(this.root)) {
                    this.scannedRoots2Depencencies.put(this.root, EMPTY_DEPS);
                }
            }
            TEST_LOGGER.log(Level.FINEST, "filelist");
            this.refreshActiveDocument();
            return true;
        }

        @Override
        public boolean absorb(Work newWork) {
            if (newWork instanceof FileListWork) {
                FileListWork nflw = (FileListWork)newWork;
                if (nflw.root.equals(this.root) && nflw.isFollowUpJob() == this.isFollowUpJob() && nflw.hasToCheckEditor() == this.hasToCheckEditor()) {
                    this.files.addAll(nflw.files);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(this + ", root=" + this.root + " absorbed: " + nflw.files);
                    }
                    return true;
                }
            }
            return false;
        }
    }

    static abstract class Work {
        private final AtomicBoolean cancelled = new AtomicBoolean(false);
        private final AtomicBoolean finished = new AtomicBoolean(false);
        private final AtomicBoolean externalCancel = new AtomicBoolean(false);
        private final boolean followUpJob;
        private final boolean checkEditor;
        private final boolean steady;
        private final CountDownLatch latch = new CountDownLatch(1);
        private final CancelRequest cancelRequest = new CancelRequest(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isRaised() {
                if (Work.this.cancelled.get()) {
                    RepositoryUpdater repositoryUpdater = RepositoryUpdater.getDefault();
                    synchronized (repositoryUpdater) {
                        if (RepositoryUpdater.getDefault().getState() == State.STOPPED) {
                            return true;
                        }
                    }
                }
                return false;
            }
        };
        private final String progressTitle;
        private ProgressHandle progressHandle = null;

        protected Work(boolean followUpJob, boolean checkEditor, boolean supportsProgress, boolean steady) {
            this(followUpJob, checkEditor, supportsProgress ? NbBundle.getMessage(RepositoryUpdater.class, (String)"MSG_BackgroundCompileStart") : null, steady);
        }

        protected Work(boolean followUpJob, boolean checkEditor, String progressTitle, boolean steady) {
            this.followUpJob = followUpJob;
            this.checkEditor = checkEditor;
            this.progressTitle = progressTitle;
            this.steady = steady;
        }

        protected final boolean isFollowUpJob() {
            return this.followUpJob;
        }

        protected final boolean hasToCheckEditor() {
            return this.checkEditor;
        }

        protected final boolean isSteady() {
            return this.steady;
        }

        protected final void updateProgress(String message) {
            assert (message != null);
            if (this.progressHandle == null) {
                return;
            }
            this.progressHandle.progress(message);
        }

        protected final void updateProgress(URL currentlyScannedRoot) {
            assert (currentlyScannedRoot != null);
            if (this.progressHandle == null) {
                return;
            }
            this.progressHandle.progress(this.urlForMessage(currentlyScannedRoot));
        }

        protected final void updateProgress(URL currentlyScannedRoot, int scannedFiles, int totalFiles) {
            assert (currentlyScannedRoot != null);
            if (this.progressHandle == null) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.urlForMessage(currentlyScannedRoot));
            sb.append(" (").append(scannedFiles).append(" of ").append(totalFiles).append(")");
            this.progressHandle.progress(sb.toString());
        }

        protected final void scanStarted(URL root, boolean sourceForBinaryRoot, SourceIndexers indexers, Map<SourceIndexerFactory, Boolean> votes, Map<SourceIndexerFactory, Context> ctxToFinish) throws IOException {
            FileObject cacheRoot = CacheFolder.getDataFolder(root);
            for (IndexerCache.IndexerInfo<CustomIndexerFactory> indexerInfo : indexers.cifInfos) {
                CustomIndexerFactory factory = indexerInfo.getIndexerFactory();
                Context ctx = SPIAccessor.getInstance().createContext(cacheRoot, root, factory.getIndexerName(), factory.getIndexVersion(), null, this.followUpJob, this.checkEditor, sourceForBinaryRoot, this.getShuttdownRequest());
                boolean vote = factory.scanStarted(ctx);
                votes.put(factory, vote);
                ctxToFinish.put(factory, ctx);
            }
            for (Set set : indexers.eifInfosMap.values()) {
                for (IndexerCache.IndexerInfo eifInfo : set) {
                    EmbeddingIndexerFactory eif = (EmbeddingIndexerFactory)eifInfo.getIndexerFactory();
                    Context context = SPIAccessor.getInstance().createContext(cacheRoot, root, eif.getIndexerName(), eif.getIndexVersion(), null, this.followUpJob, this.checkEditor, sourceForBinaryRoot, null);
                    boolean vote = eif.scanStarted(context);
                    votes.put(eif, vote);
                    ctxToFinish.put(eif, context);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void scanFinished(Map<SourceIndexerFactory, Context> ctxToFinish) throws IOException {
            try {
                for (Map.Entry<SourceIndexerFactory, Context> entry : ctxToFinish.entrySet()) {
                    entry.getKey().scanFinished(entry.getValue());
                }
            }
            catch (Throwable throwable) {
                for (Context ctx : ctxToFinish.values()) {
                    IndexImpl index = SPIAccessor.getInstance().getIndexFactory(ctx).getIndex(ctx.getIndexFolder());
                    if (index == null) continue;
                    index.store(this.isSteady(), null);
                }
                throw throwable;
            }
            for (Context ctx : ctxToFinish.values()) {
                IndexImpl index = SPIAccessor.getInstance().getIndexFactory(ctx).getIndex(ctx.getIndexFolder());
                if (index == null) continue;
                index.store(this.isSteady(), null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void delete(Collection<IndexableImpl> deleted, URL root) throws IOException {
            if (deleted == null || deleted.isEmpty()) {
                return;
            }
            LinkedList<Context> transactionContexts = new LinkedList<Context>();
            ClusteredIndexables ci = new ClusteredIndexables(deleted);
            try {
                FileObject cacheRoot = CacheFolder.getDataFolder(root);
                Collection<IndexerCache.IndexerInfo<CustomIndexerFactory>> cifInfos = IndexerCache.getCifCache().getIndexers(null);
                for (IndexerCache.IndexerInfo<CustomIndexerFactory> cifInfo : cifInfos) {
                    CustomIndexerFactory factory = cifInfo.getIndexerFactory();
                    Context ctx = SPIAccessor.getInstance().createContext(cacheRoot, root, factory.getIndexerName(), factory.getIndexVersion(), null, this.followUpJob, this.checkEditor, false, null);
                    transactionContexts.add(ctx);
                    factory.filesDeleted(ci.getIndexablesFor(null), ctx);
                }
                Collection<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>> eifInfos = IndexerCache.getEifCache().getIndexers(null);
                for (IndexerCache.IndexerInfo<EmbeddingIndexerFactory> eifInfo : eifInfos) {
                    EmbeddingIndexerFactory factory = eifInfo.getIndexerFactory();
                    Context ctx = SPIAccessor.getInstance().createContext(cacheRoot, root, factory.getIndexerName(), factory.getIndexVersion(), null, this.followUpJob, this.checkEditor, false, null);
                    transactionContexts.add(ctx);
                    factory.filesDeleted(ci.getIndexablesFor(null), ctx);
                }
            }
            finally {
                for (Context ctx : transactionContexts) {
                    IndexImpl index = SPIAccessor.getInstance().getIndexFactory(ctx).getIndex(ctx.getIndexFolder());
                    if (index == null) continue;
                    index.store(this.isSteady(), ci.getIndexablesFor(null));
                }
            }
        }

        protected final boolean index(final Collection<IndexableImpl> resources, final Collection<IndexableImpl> allResources, final URL root, final boolean sourceForBinaryRoot, final SourceIndexers indexers, final Map<SourceIndexerFactory, Boolean> votes, final long[] recursiveListenersTime) throws IOException {
            return TaskCache.getDefault().refreshTransaction(new Mutex.ExceptionAction<Boolean>(){

                public Boolean run() throws IOException {
                    return Work.this.doIndex(resources, allResources, root, sourceForBinaryRoot, indexers, votes, recursiveListenersTime);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean doIndex(Collection<IndexableImpl> resources, Collection<IndexableImpl> allResources, URL root, boolean sourceForBinaryRoot, SourceIndexers indexers, Map<SourceIndexerFactory, Boolean> votes, long[] recursiveListenersTime) throws IOException {
            long tm = System.currentTimeMillis();
            if (!RepositoryUpdater.getDefault().rootsListeners.add(root, true)) {
                return false;
            }
            if (recursiveListenersTime != null) {
                recursiveListenersTime[0] = System.currentTimeMillis() - tm;
            }
            LinkedList<Context> transactionContexts = new LinkedList<Context>();
            LinkedList allIndexblesSentToIndexers = new LinkedList();
            SourceAccessor.getINSTANCE().suppressListening(true);
            try {
                boolean bl;
                FileObject cacheRoot = CacheFolder.getDataFolder(root);
                ClusteredIndexables ci = new ClusteredIndexables(resources);
                ClusteredIndexables allCi = null;
                for (IndexerCache.IndexerInfo<CustomIndexerFactory> indexerInfo : indexers.cifInfos) {
                    Set<String> rootMimeTypes = PathRegistry.getDefault().getMimeTypesFor(root);
                    if (rootMimeTypes != null && !indexerInfo.isAllMimeTypesIndexer() && !Util.containsAny(rootMimeTypes, indexerInfo.getMimeTypes())) {
                        if (!LOGGER.isLoggable(Level.FINE)) continue;
                        LOGGER.log(Level.FINE, "Not using {0} registered for {1} to scan root {2} marked for {3}", new Object[]{indexerInfo.getIndexerFactory().getIndexerName() + "/" + indexerInfo.getIndexerFactory().getIndexVersion(), RepositoryUpdater.printMimeTypes(indexerInfo.getMimeTypes(), new StringBuilder()), root, PathRegistry.getDefault().getMimeTypesFor(root)});
                        continue;
                    }
                    CustomIndexerFactory factory = indexerInfo.getIndexerFactory();
                    Context ctx = SPIAccessor.getInstance().createContext(cacheRoot, root, factory.getIndexerName(), factory.getIndexVersion(), null, this.followUpJob, this.checkEditor, sourceForBinaryRoot, this.getShuttdownRequest());
                    transactionContexts.add(ctx);
                    boolean cifIsChanged = indexers.changedCifs != null && indexers.changedCifs.contains(indexerInfo);
                    boolean forceReindex = votes.get(factory) == Boolean.FALSE && allResources != null;
                    boolean allFiles = cifIsChanged || forceReindex || resources == allResources;
                    SPIAccessor.getInstance().setAllFilesJob(ctx, allFiles);
                    LinkedList<Iterable<Indexable>> indexerIndexablesList = new LinkedList<Iterable<Indexable>>();
                    for (String mimeType : indexerInfo.getMimeTypes()) {
                        if ((cifIsChanged || forceReindex) && resources != allResources) {
                            if (allCi == null) {
                                allCi = new ClusteredIndexables(allResources);
                            }
                            indexerIndexablesList.add(allCi.getIndexablesFor(mimeType));
                            continue;
                        }
                        indexerIndexablesList.add(ci.getIndexablesFor(mimeType));
                    }
                    ProxyIterable indexables = new ProxyIterable(indexerIndexablesList);
                    allIndexblesSentToIndexers.addAll(indexerIndexablesList);
                    if (this.getShuttdownRequest().isRaised()) {
                        boolean mimeType = false;
                        return mimeType;
                    }
                    CustomIndexer indexer = factory.createIndexer();
                    long tm1 = -1L;
                    long tm2 = -1L;
                    try {
                        tm1 = System.currentTimeMillis();
                        SPIAccessor.getInstance().index(indexer, indexables, ctx);
                        tm2 = System.currentTimeMillis();
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable t) {
                        LOGGER.log(Level.WARNING, null, t);
                    }
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    StringBuilder sb = RepositoryUpdater.printMimeTypes(indexerInfo.getMimeTypes(), new StringBuilder());
                    LOGGER.fine("Indexing source root " + root + " using " + indexer + "; mimeTypes=" + sb.toString() + "; took " + (tm1 != -1L && tm2 != -1L ? tm2 - tm1 + "ms" : "unknown time"));
                }
                if (this.getShuttdownRequest().isRaised()) {
                    boolean i$ = false;
                    return i$;
                }
                boolean containsNewIndexers = false;
                boolean bl2 = false;
                if (allResources != null) {
                    for (Set<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>> eifInfos : indexers.eifInfosMap.values()) {
                        for (IndexerCache.IndexerInfo<EmbeddingIndexerFactory> eifInfo : eifInfos) {
                            EmbeddingIndexerFactory eif;
                            if (indexers.changedEifs != null && indexers.changedEifs.contains(eifInfo)) {
                                containsNewIndexers = true;
                            }
                            bl = votes.get(eif = eifInfo.getIndexerFactory()) == Boolean.FALSE;
                        }
                    }
                }
                boolean useAllCi = false;
                if ((containsNewIndexers || bl) && resources != allResources) {
                    if (allCi == null) {
                        allCi = new ClusteredIndexables(allResources);
                    }
                    useAllCi = true;
                }
                for (String mimeType : Util.getAllMimeTypes()) {
                    if (this.getShuttdownRequest().isRaised()) {
                        boolean eifInfo = false;
                        return eifInfo;
                    }
                    if (!Util.canBeParsed(mimeType)) continue;
                    Iterable<Indexable> indexables = useAllCi ? allCi.getIndexablesFor(mimeType) : ci.getIndexablesFor(mimeType);
                    allIndexblesSentToIndexers.add(indexables);
                    long tm1 = System.currentTimeMillis();
                    boolean f = this.indexEmbedding(indexers.eifInfosMap, cacheRoot, root, indexables, transactionContexts, sourceForBinaryRoot);
                    long tm2 = System.currentTimeMillis();
                    if (!f) {
                        boolean bl3 = false;
                        return bl3;
                    }
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.fine("Indexing " + mimeType + " embeddables under " + root + "; took " + (tm2 - tm1) + "ms");
                }
                boolean bl4 = true;
                return bl4;
            }
            finally {
                SourceAccessor.getINSTANCE().suppressListening(false);
                ProxyIterable<Indexable> proxyIterable = new ProxyIterable<Indexable>(allIndexblesSentToIndexers, false, true);
                for (Context ctx : transactionContexts) {
                    if (this.getShuttdownRequest().isRaised()) {
                        return false;
                    }
                    IndexImpl index = SPIAccessor.getInstance().getIndexFactory(ctx).getIndex(ctx.getIndexFolder());
                    if (index == null) continue;
                    index.store(this.isSteady(), proxyIterable);
                }
            }
        }

        protected final void invalidateSources(Iterable<? extends IndexableImpl> toInvalidate) {
            long st = System.currentTimeMillis();
            for (IndexableImpl indexableImpl : toInvalidate) {
                Source src;
                FileObject cheapFo = indexableImpl instanceof FileObjectProvider ? ((FileObjectProvider)((Object)indexableImpl)).getFileObject() : URLMapper.findFileObject((URL)indexableImpl.getURL());
                if (cheapFo == null || (src = SourceAccessor.getINSTANCE().get(cheapFo)) == null) continue;
                SourceAccessor.getINSTANCE().setFlags(src, EnumSet.of(SourceFlags.INVALID));
            }
            long et = System.currentTimeMillis();
            LOGGER.fine("InvalidateSources took: " + (et - st));
        }

        protected final void binaryScanStarted(URL root, BinaryIndexers indexers, Map<BinaryIndexerFactory, Context> contexts, Map<BinaryIndexerFactory, Boolean> votes) throws IOException {
            FileObject cacheRoot = CacheFolder.getDataFolder(root);
            for (BinaryIndexerFactory binaryIndexerFactory : indexers.bifs) {
                Context ctx = SPIAccessor.getInstance().createContext(cacheRoot, root, binaryIndexerFactory.getIndexerName(), binaryIndexerFactory.getIndexVersion(), null, false, false, false, this.getShuttdownRequest());
                contexts.put(binaryIndexerFactory, ctx);
                boolean vote = binaryIndexerFactory.scanStarted(ctx);
                votes.put(binaryIndexerFactory, vote);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void binaryScanFinished(BinaryIndexers indexers, Map<BinaryIndexerFactory, Context> contexts) throws IOException {
            try {
                for (Map.Entry<BinaryIndexerFactory, Context> entry : contexts.entrySet()) {
                    entry.getKey().scanFinished(entry.getValue());
                }
            }
            catch (Throwable throwable) {
                for (Context ctx : contexts.values()) {
                    IndexImpl index = SPIAccessor.getInstance().getIndexFactory(ctx).getIndex(ctx.getIndexFolder());
                    if (index == null) continue;
                    index.store(this.isSteady(), null);
                }
                throw throwable;
            }
            for (Context ctx : contexts.values()) {
                IndexImpl index = SPIAccessor.getInstance().getIndexFactory(ctx).getIndex(ctx.getIndexFolder());
                if (index == null) continue;
                index.store(this.isSteady(), null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final boolean indexBinary(URL root, BinaryIndexers indexers, Map<BinaryIndexerFactory, Boolean> votes) throws IOException {
            FileObject rootFo;
            LOGGER.log(Level.FINE, "Scanning binary root: {0}", root);
            if (!RepositoryUpdater.getDefault().rootsListeners.add(root, false)) {
                return false;
            }
            Crawler crawler = null;
            boolean isFolder = false;
            boolean isUpToDate = false;
            if ("file".equals(root.getProtocol()) && (rootFo = URLMapper.findFileObject((URL)root)) != null && rootFo.isFolder()) {
                isFolder = true;
                crawler = new FileObjectCrawler(rootFo, true, null, this.getShuttdownRequest());
                Collection<IndexableImpl> modified = crawler.getResources();
                Collection<IndexableImpl> deleted = crawler.getDeletedResources();
                if (crawler.isFinished() && deleted.isEmpty() && modified.isEmpty()) {
                    isUpToDate = true;
                    LOGGER.log(Level.FINE, "Binary folder {0} is up-to-date", root);
                }
            }
            LinkedList<Context> transactionContexts = new LinkedList<Context>();
            try {
                FileObject cacheRoot = CacheFolder.getDataFolder(root);
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.fine("Using BinaryIndexerFactories: " + indexers.bifs);
                }
                for (BinaryIndexerFactory binaryIndexerFactory : indexers.bifs) {
                    if (this.getShuttdownRequest().isRaised()) break;
                    Context ctx = SPIAccessor.getInstance().createContext(cacheRoot, root, binaryIndexerFactory.getIndexerName(), binaryIndexerFactory.getIndexVersion(), null, false, false, false, this.getShuttdownRequest());
                    SPIAccessor.getInstance().setAllFilesJob(ctx, !isFolder || !isUpToDate || votes.get(binaryIndexerFactory) == false);
                    transactionContexts.add(ctx);
                    BinaryIndexer indexer = binaryIndexerFactory.createIndexer();
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Indexing binary " + root + " using " + indexer);
                    }
                    SPIAccessor.getInstance().index(indexer, ctx);
                }
                boolean bl = true;
                return bl;
            }
            finally {
                if (this.getShuttdownRequest().isRaised()) {
                    return false;
                }
                if (crawler != null && crawler.isFinished()) {
                    crawler.storeTimestamps();
                }
                for (Context ctx : transactionContexts) {
                    IndexImpl index = SPIAccessor.getInstance().getIndexFactory(ctx).getIndex(ctx.getIndexFolder());
                    if (index == null) continue;
                    index.store(this.isSteady(), null);
                }
            }
        }

        protected final boolean indexEmbedding(final Map<String, Set<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>>> eifInfosMap, final FileObject cache, final URL rootURL, Iterable<? extends Indexable> files, final List<Context> transactionContexts, final boolean sourceForBinaryRoot) throws IOException {
            for (final Indexable indexable : files) {
                FileObject fileObject;
                URL url;
                if (this.getShuttdownRequest().isRaised()) {
                    return false;
                }
                Collection infos = eifInfosMap.get(indexable.getMimeType());
                if (infos == null || infos.size() <= 0 || (url = indexable.getURL()) == null || (fileObject = URLMapper.findFileObject((URL)url)) == null) continue;
                Source src = Source.create(fileObject);
                try {
                    ParserManager.parse(Collections.singleton(src), new UserTask(){

                        @Override
                        public void run(ResultIterator resultIterator) throws Exception {
                            String mimeType = resultIterator.getSnapshot().getMimeType();
                            Collection infos = (Collection)eifInfosMap.get(mimeType);
                            if (infos != null && infos.size() > 0) {
                                for (IndexerCache.IndexerInfo info : infos) {
                                    Parser.Result pr;
                                    if (Work.this.getShuttdownRequest().isRaised()) {
                                        return;
                                    }
                                    EmbeddingIndexerFactory indexerFactory = (EmbeddingIndexerFactory)info.getIndexerFactory();
                                    if (LOGGER.isLoggable(Level.FINE)) {
                                        LOGGER.fine("Indexing file " + fileObject.getPath() + " using " + indexerFactory + "; mimeType='" + mimeType + "'");
                                    }
                                    if ((pr = resultIterator.getParserResult()) == null) continue;
                                    String indexerName = indexerFactory.getIndexerName();
                                    int indexerVersion = indexerFactory.getIndexVersion();
                                    Context context = SPIAccessor.getInstance().createContext(cache, rootURL, indexerName, indexerVersion, null, Work.this.followUpJob, Work.this.checkEditor, sourceForBinaryRoot, null);
                                    transactionContexts.add(context);
                                    EmbeddingIndexer indexer = indexerFactory.createIndexer(indexable, pr.getSnapshot());
                                    if (indexer == null) continue;
                                    try {
                                        SPIAccessor.getInstance().index(indexer, indexable, pr, context);
                                    }
                                    catch (ThreadDeath td) {
                                        throw td;
                                    }
                                    catch (Throwable t) {
                                        LOGGER.log(Level.WARNING, null, t);
                                    }
                                }
                            }
                            for (Embedding embedding : resultIterator.getEmbeddings()) {
                                if (Work.this.getShuttdownRequest().isRaised()) {
                                    return;
                                }
                                this.run(resultIterator.getResultIterator(embedding));
                            }
                        }
                    });
                }
                catch (ParseException e) {
                    LOGGER.log(Level.WARNING, null, e);
                }
            }
            return !this.getShuttdownRequest().isRaised();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected final boolean scanFiles(URL root, Collection<FileObject> files, boolean forceRefresh, boolean sourceForBinaryRoot) {
            FileObject rootFo = URLMapper.findFileObject((URL)root);
            if (rootFo == null) return true;
            try {
                ClassPath.Entry entry;
                ClassPath.Entry entry2 = entry = sourceForBinaryRoot ? null : RepositoryUpdater.getClassPathEntry(rootFo);
                FileObjectCrawler crawler = files.isEmpty() ? new FileObjectCrawler(rootFo, !forceRefresh, entry, this.getShuttdownRequest()) : new FileObjectCrawler(rootFo, files.toArray(new FileObject[files.size()]), !forceRefresh, entry, this.getShuttdownRequest());
                Collection<IndexableImpl> resources = crawler.getResources();
                if (!crawler.isFinished()) return false;
                IdentityHashMap<SourceIndexerFactory, Boolean> invalidatedMap = new IdentityHashMap<SourceIndexerFactory, Boolean>();
                IdentityHashMap<SourceIndexerFactory, Context> ctxToFinish = new IdentityHashMap<SourceIndexerFactory, Context>();
                SourceIndexers indexers = SourceIndexers.load(false);
                this.invalidateSources(resources);
                this.scanStarted(root, sourceForBinaryRoot, indexers, invalidatedMap, ctxToFinish);
                try {
                    if (!this.index(resources, files.isEmpty() && forceRefresh ? resources : null, root, sourceForBinaryRoot, indexers, invalidatedMap, null)) return false;
                    crawler.storeTimestamps();
                    boolean bl = true;
                    return bl;
                }
                finally {
                    this.scanFinished(ctxToFinish);
                }
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, null, ioe);
            }
            return true;
        }

        protected abstract boolean getDone();

        protected boolean isCancelledBy(Work newWork) {
            return false;
        }

        public boolean absorb(Work newWork) {
            return false;
        }

        protected final boolean isCancelled() {
            return this.cancelled.get();
        }

        protected final boolean isCancelledExternally() {
            return this.externalCancel.get();
        }

        protected final CancelRequest getShuttdownRequest() {
            return this.cancelRequest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void doTheWork() {
            try {
                this.finished.compareAndSet(false, this.getDone());
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, null, t);
                this.finished.set(true);
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
            }
            finally {
                this.latch.countDown();
            }
        }

        public final void waitUntilDone() {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARNING, null, e);
            }
        }

        public final void setCancelled(boolean cancelled) {
            this.cancelled.set(cancelled);
            this.externalCancel.set(cancelled);
        }

        public final void cancelBy(Work newWork) {
            if (this.isCancelledBy(newWork)) {
                LOGGER.log(Level.FINE, "{0} cancelled by {1}", new Object[]{this, newWork});
                this.cancelled.set(true);
                this.finished.set(true);
            }
        }

        public final boolean isFinished() {
            return this.finished.get();
        }

        public final String getProgressTitle() {
            return this.progressTitle;
        }

        public final void setProgressHandle(ProgressHandle progressHandle) {
            this.progressHandle = progressHandle;
        }

        private String urlForMessage(URL currentlyScannedRoot) {
            String msg = null;
            URL tmp = FileUtil.getArchiveFile((URL)currentlyScannedRoot);
            if (tmp == null) {
                tmp = currentlyScannedRoot;
            }
            try {
                if ("file".equals(tmp.getProtocol())) {
                    File file = new File(new URI(tmp.toString()));
                    msg = file.getAbsolutePath();
                }
            }
            catch (URISyntaxException ex) {
                // empty catch block
            }
            return msg == null ? tmp.toString() : msg;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)) + "[followUpJob=" + this.followUpJob + ", checkEditor=" + this.checkEditor;
        }

        protected final void refreshActiveDocument() {
            JTextComponent jtc = EditorRegistry.lastFocusedComponent();
            if (jtc == null) {
                return;
            }
            Document doc = jtc.getDocument();
            assert (doc != null);
            Source source = Source.create(doc);
            if (source != null) {
                LOGGER.fine("Invalidating source: " + source + " due to RootsWork");
                EventSupport support = SourceAccessor.getINSTANCE().getEventSupport(source);
                assert (support != null);
                support.resetState(true, -1, -1);
            }
        }
    }

    static enum State {
        CREATED,
        STARTED,
        INITIAL_SCAN_RUNNING,
        ACTIVE,
        STOPPED;

    }
}

