/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.syntax.dom;

import org.netbeans.editor.TokenItem;

public class Util {
    public static String[] knownEntityStrings = new String[]{"&lt;", "&gt;", "&apos;", "&quot;", "&amp;"};
    public static char[] knownEntityChars = new char[]{'<', '>', '\'', '\"', '&'};

    public static TokenItem skipAttributeValue(TokenItem attribute, char delim) {
        for (TokenItem next = attribute; next != null; next = next.getNext()) {
            String image = next.getImage();
            if (!image.endsWith("" + delim)) continue;
            return next.getNext();
        }
        return null;
    }

    public static String actualAttributeValue(String attributeValue) {
        int ltIndex = attributeValue.indexOf(60);
        int gtIndex = attributeValue.indexOf(62);
        int firstUnwantedIndex = -1;
        firstUnwantedIndex = gtIndex != -1 ? (ltIndex != -1 && ltIndex < gtIndex ? ltIndex : gtIndex) : ltIndex;
        if (firstUnwantedIndex != -1) {
            char charAtIndex = attributeValue.charAt(firstUnwantedIndex);
            while ((charAtIndex == ' ' || charAtIndex == '\t' || charAtIndex == '\n' || charAtIndex == '\r' || charAtIndex == '<' || charAtIndex == '>') && --firstUnwantedIndex >= 0) {
                charAtIndex = attributeValue.charAt(firstUnwantedIndex);
            }
            return attributeValue.substring(0, firstUnwantedIndex + 1);
        }
        return attributeValue;
    }

    public static String replaceEntityStringsWithChars(String value) {
        StringBuffer buf = new StringBuffer(value);
        for (int entity = 0; entity < knownEntityStrings.length; ++entity) {
            String curEntityString = knownEntityStrings[entity];
            int indexOfEntity = buf.toString().indexOf(curEntityString);
            while (indexOfEntity != -1) {
                buf.replace(indexOfEntity, indexOfEntity + curEntityString.length(), new String(new char[]{knownEntityChars[entity]}));
                indexOfEntity = buf.toString().indexOf(curEntityString);
            }
        }
        return buf.toString();
    }

    public static String replaceCharsWithEntityStrings(String value) {
        if (value == null) {
            return null;
        }
        StringBuffer replBuf = new StringBuffer(value.length());
        for (int ind = 0; ind < value.length(); ++ind) {
            boolean charReplaced = false;
            char curChar = value.charAt(ind);
            for (int entity = 0; entity < knownEntityChars.length; ++entity) {
                if (curChar != knownEntityChars[entity]) continue;
                replBuf.append(knownEntityStrings[entity]);
                charReplaced = true;
                break;
            }
            if (charReplaced) continue;
            replBuf.append(curChar);
        }
        return replBuf.toString();
    }
}

