/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.slides;

import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SingleSelectionModel;
import javax.swing.event.ChangeListener;
import org.netbeans.core.windows.Switches;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.ActionUtils;
import org.netbeans.core.windows.view.dnd.DragAndDropFeedbackVisualizer;
import org.netbeans.core.windows.view.ui.Tabbed;
import org.netbeans.core.windows.view.ui.slides.SlideBar;
import org.netbeans.swing.tabcontrol.DefaultTabDataModel;
import org.netbeans.swing.tabcontrol.SlideBarDataModel;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.TabbedContainer;
import org.openide.util.ChangeSupport;
import org.openide.windows.TopComponent;

public final class TabbedSlideAdapter
implements Tabbed {
    private TabDataModel dataModel;
    private SingleSelectionModel selModel;
    private SlideBar slideBar;
    private List<ActionListener> actionListeners;
    private final ChangeSupport cs = new ChangeSupport((Object)this);

    public TabbedSlideAdapter(String side) {
        this.dataModel = new SlideBarDataModel.Impl();
        this.setSide(side);
        this.selModel = new DefaultSingleSelectionModel();
        this.slideBar = new SlideBar(this, (SlideBarDataModel)this.dataModel, this.selModel);
    }

    @Override
    public void requestAttention(TopComponent tc) {
        this.slideBar.setBlinking(tc, true);
    }

    @Override
    public void cancelRequestAttention(TopComponent tc) {
        this.slideBar.setBlinking(tc, false);
    }

    private void setSide(String side) {
        int orientation = 2;
        if ("left".equals(side)) {
            orientation = 2;
        } else if ("right".equals(side)) {
            orientation = 1;
        } else if ("bottom".equals(side)) {
            orientation = 3;
        }
        ((SlideBarDataModel)this.dataModel).setOrientation(orientation);
    }

    @Override
    public final synchronized void addActionListener(ActionListener listener) {
        if (this.actionListeners == null) {
            this.actionListeners = new ArrayList<ActionListener>();
        }
        this.actionListeners.add(listener);
    }

    @Override
    public final synchronized void removeActionListener(ActionListener listener) {
        if (this.actionListeners != null) {
            this.actionListeners.remove(listener);
            if (this.actionListeners.isEmpty()) {
                this.actionListeners = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void postActionEvent(ActionEvent event) {
        List<ActionListener> list;
        TabbedSlideAdapter tabbedSlideAdapter = this;
        synchronized (tabbedSlideAdapter) {
            if (this.actionListeners == null) {
                return;
            }
            list = Collections.unmodifiableList(this.actionListeners);
        }
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).actionPerformed(event);
        }
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.cs.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.cs.removeChangeListener(listener);
    }

    final void postSelectionEvent() {
        this.cs.fireChange();
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener listener) {
        this.slideBar.addPropertyChangeListener(name, listener);
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener listener) {
        this.slideBar.removePropertyChangeListener(name, listener);
    }

    @Override
    public void addTopComponent(String name, Icon icon, TopComponent tc, String toolTip) {
        this.dataModel.addTab(this.dataModel.size(), new TabData((Object)tc, icon, name, toolTip));
    }

    @Override
    public TopComponent getSelectedTopComponent() {
        int index = this.selModel.getSelectedIndex();
        return index < 0 ? null : (TopComponent)this.dataModel.getTab(index).getComponent();
    }

    @Override
    public TopComponent getTopComponentAt(int index) {
        return (TopComponent)this.dataModel.getTab(index).getComponent();
    }

    @Override
    public TopComponent[] getTopComponents() {
        int size = this.dataModel.size();
        TopComponent[] result = new TopComponent[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (TopComponent)this.dataModel.getTab(i).getComponent();
        }
        return result;
    }

    @Override
    public void setActive(boolean active) {
        this.slideBar.setActive(active);
    }

    @Override
    public void setIconAt(int index, Icon icon) {
        this.dataModel.setIcon(index, icon);
    }

    @Override
    public void setTitleAt(int index, String title) {
        this.dataModel.setText(index, title);
    }

    @Override
    public void setToolTipTextAt(int index, String toolTip) {
    }

    @Override
    public void setTopComponents(TopComponent[] tcs, TopComponent selected) {
        TabData[] data = new TabData[tcs.length];
        int toSelect = -1;
        for (int i = 0; i < tcs.length; ++i) {
            TopComponent tc = tcs[i];
            Image icon = tc.getIcon();
            String displayName = WindowManagerImpl.getInstance().getTopComponentDisplayName(tc);
            data[i] = new TabData((Object)tc, (Icon)(icon == null ? null : new ImageIcon(icon)), displayName == null ? "" : displayName, tc.getToolTipText());
            if (selected != tcs[i]) continue;
            toSelect = i;
        }
        this.dataModel.setTabs(data);
        this.setSelectedComponent((Component)selected);
    }

    @Override
    public int getTabCount() {
        return this.dataModel.size();
    }

    @Override
    public int indexOf(Component tc) {
        int size = this.dataModel.size();
        for (int i = 0; i < size; ++i) {
            if (tc != this.dataModel.getTab(i).getComponent()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void insertComponent(String name, Icon icon, Component comp, String toolTip, int position) {
        this.dataModel.addTab(position, new TabData((Object)comp, icon, name, toolTip));
    }

    @Override
    public void removeComponent(Component comp) {
        int i = this.indexOf(comp);
        this.dataModel.removeTab(i);
    }

    @Override
    public void setSelectedComponent(Component comp) {
        int newIndex = this.indexOf(comp);
        if (this.selModel.getSelectedIndex() != newIndex) {
            this.selModel.setSelectedIndex(newIndex);
        }
        if (comp instanceof TopComponent) {
            TopComponent tc = (TopComponent)comp;
            tc.cancelRequestAttention();
        }
    }

    @Override
    public int tabForCoordinate(Point p) {
        return this.slideBar.tabForCoordinate(p.x, p.y);
    }

    @Override
    public Component getComponent() {
        return this.slideBar;
    }

    @Override
    public Object getConstraintForLocation(Point location, boolean attachingPossible) {
        int tab = this.slideBar.nextTabForCoordinate(location.x, location.y);
        return tab;
    }

    @Override
    public Shape getIndicationForLocation(Point location, TopComponent startingTransfer, Point startingPoint, boolean attachingPossible) {
        int nextTab = this.slideBar.nextTabForCoordinate(location.x, location.y);
        SlideBarDataModel sbdm = (SlideBarDataModel)this.dataModel;
        if (this.getTabCount() != 0) {
            if (nextTab == 0) {
                Rectangle rect = this.getTabBounds(0);
                if (sbdm.getOrientation() == 3) {
                    rect.x = 0;
                    rect.width /= 2;
                } else {
                    rect.y = 0;
                    rect.height /= 2;
                }
                return rect;
            }
            if (nextTab < this.getTabCount()) {
                Rectangle rect1 = this.getTabBounds(nextTab - 1);
                Rectangle rect2 = this.getTabBounds(nextTab);
                Rectangle result = new Rectangle();
                if (sbdm.getOrientation() == 3) {
                    result.y = rect1.y;
                    result.height = rect1.height;
                    result.x = rect1.x + rect1.width / 2;
                    result.width = rect2.x + rect2.width / 2 - result.x;
                } else {
                    result.x = rect1.x;
                    result.width = rect1.width;
                    result.y = rect1.y + rect1.height / 2;
                    result.height = rect2.y + rect2.height / 2 - result.y;
                }
                return result;
            }
            if (nextTab == this.getTabCount()) {
                Rectangle rect = this.getTabBounds(this.getTabCount() - 1);
                if (sbdm.getOrientation() == 3) {
                    rect.x += rect.width;
                } else {
                    rect.y += rect.height;
                }
                return rect;
            }
        }
        Rectangle rect = this.slideBar.getBounds();
        if (sbdm.getOrientation() == 3) {
            return new Rectangle(10, 0, 50, 20);
        }
        return new Rectangle(0, 10, 20, 50);
    }

    @Override
    public Image createImageOfTab(int tabIndex) {
        TabData dt = this.slideBar.getModel().getTab(tabIndex);
        if (dt.getComponent() instanceof TopComponent) {
            DefaultTabDataModel tempModel = new DefaultTabDataModel(new TabData[]{dt});
            TabbedContainer temp = new TabbedContainer((TabDataModel)tempModel, 0);
            temp.setSize(300, 300);
            return temp.createImageOfTab(0);
        }
        return null;
    }

    public DragAndDropFeedbackVisualizer getDragAndDropFeedbackVisualizer(int tabIndex) {
        this.slideBar.getSelectionModel().setSelectedIndex(tabIndex);
        return new DragAndDropFeedbackVisualizer(this, tabIndex);
    }

    @Override
    public Action[] getPopupActions(Action[] defaultActions, int tabIndex) {
        boolean isMDI = WindowManagerImpl.getInstance().getEditorAreaState() == 0;
        TabData td = this.slideBar.getModel().getTab(tabIndex);
        boolean slidingEnabled = true;
        if (td.getComponent() instanceof TopComponent) {
            slidingEnabled = Switches.isSlidingEnabled((TopComponent)td.getComponent());
        }
        Action[] result = new Action[defaultActions.length + (isMDI && Switches.isTopComponentSlidingEnabled() && slidingEnabled ? 2 : 0)];
        System.arraycopy(defaultActions, 0, result, 0, defaultActions.length);
        if (isMDI && Switches.isTopComponentSlidingEnabled() && slidingEnabled) {
            result[defaultActions.length] = new ActionUtils.AutoHideWindowAction(this.slideBar, tabIndex, true);
            result[defaultActions.length + 1] = new ActionUtils.ToggleWindowTransparencyAction(this.slideBar, tabIndex, this.slideBar.isSlidedTabTransparent() && tabIndex == this.slideBar.getSelectionModel().getSelectedIndex());
        }
        return result;
    }

    @Override
    public Rectangle getTabBounds(int tabIndex) {
        return this.slideBar.getTabBounds(tabIndex);
    }

    @Override
    public boolean isTransparent() {
        return false;
    }

    @Override
    public void setTransparent(boolean transparent) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

