/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.ruby.RubyType;

public final class RubyPredefinedVariable {
    private final String name;
    private final String description;
    private final RubyType type;
    private static final List<RubyPredefinedVariable> VARIABLES = RubyPredefinedVariable.initialize();
    private static final List<RubyPredefinedVariable> CLASS_VARIABLES = RubyPredefinedVariable.initializeClassVars();

    private RubyPredefinedVariable(String name, String description, RubyType type) {
        this.name = name;
        this.description = description;
        this.type = type;
    }

    private static List<RubyPredefinedVariable> initialize() {
        ArrayList<RubyPredefinedVariable> result = new ArrayList<RubyPredefinedVariable>();
        result.add(RubyPredefinedVariable.create("$!", "The exception information message set by 'raise'.", RubyType.STRING));
        result.add(RubyPredefinedVariable.create("$@", "Array of backtrace of the last exception thrown.", RubyType.ARRAY));
        result.add(RubyPredefinedVariable.create("$&", "The string matched by the last successful pattern match in this scope.", RubyType.STRING));
        result.add(RubyPredefinedVariable.create("$`", "The string to the left  of the last successful match.", RubyType.STRING));
        result.add(RubyPredefinedVariable.create("$'", "The string to the right of the last successful match.", RubyType.STRING));
        result.add(RubyPredefinedVariable.create("$+", "The last bracket matched by the last successful match.", RubyType.STRING));
        result.add(RubyPredefinedVariable.create("$n", "The Nth group of the last successful regexp match.", RubyType.STRING));
        result.add(RubyPredefinedVariable.create("$~", "The information about the last match in the current scope.", RubyType.STRING));
        result.add(RubyPredefinedVariable.create("$=", "The flag for case insensitive, nil by default.", RubyType.BOOLEAN));
        result.add(RubyPredefinedVariable.create("$/", "The input record separator, newline by default.", RubyType.STRING));
        result.add(RubyPredefinedVariable.create("$\\", "The output record separator for the print and IO#write. Default is nil.", RubyType.STRING));
        result.add(RubyPredefinedVariable.create("$,", "The output field separator for the print and Array#join.", RubyType.STRING));
        result.add(RubyPredefinedVariable.create("$;", "The default separator for String#split.", RubyType.STRING));
        result.add(RubyPredefinedVariable.create("$.", "The current input line number of the last file that was read.", RubyType.STRING));
        result.add(RubyPredefinedVariable.create("$<", "The virtual concatenation file of the files given on command line.", RubyType.STRING));
        result.add(RubyPredefinedVariable.create("$>", "The default output for print, printf. $stdout by default.", "IO"));
        result.add(RubyPredefinedVariable.create("$_", "The last input line of string by gets or readline.", RubyType.STRING));
        result.add(RubyPredefinedVariable.create("$0", "Contains the name of the script being executed. May be assignable.", RubyType.STRING));
        result.add(RubyPredefinedVariable.create("$*", "Command line arguments given for the script sans args.", RubyType.ARRAY));
        result.add(RubyPredefinedVariable.create("$$", "The process number of the Ruby running this script.", RubyType.FIXNUM));
        result.add(RubyPredefinedVariable.create("$?", "The status of the last executed child process.", RubyType.STRING));
        result.add(RubyPredefinedVariable.create("$:", "Load path for scripts and binary modules by load or require.", RubyType.ARRAY));
        result.add(RubyPredefinedVariable.create("$\"", "The array contains the module names loaded by require.", RubyType.ARRAY));
        result.add(RubyPredefinedVariable.create("$DEBUG", "The status of the -d switch.", RubyType.BOOLEAN));
        result.add(RubyPredefinedVariable.create("$FILENAME", "Current input file from $&lt;. Same as $&lt;.filename.", RubyType.STRING));
        result.add(RubyPredefinedVariable.create("$LOAD_PATH", "The alias to the $:.", RubyType.ARRAY));
        result.add(RubyPredefinedVariable.create("$stderr", "The current standard error output.", "IO"));
        result.add(RubyPredefinedVariable.create("$stdin", "The current standard input.", "IO"));
        result.add(RubyPredefinedVariable.create("$stdout", "The current standard output.", "IO"));
        result.add(RubyPredefinedVariable.create("$VERBOSE", "The verbose flag, which is set by the -v switch.", RubyType.BOOLEAN));
        result.add(RubyPredefinedVariable.create("$-0", "The alias to $/.", RubyType.STRING));
        result.add(RubyPredefinedVariable.create("$-a", "True if option -a (\"autosplit\" mode) is set. Read-only variable.", RubyType.BOOLEAN));
        result.add(RubyPredefinedVariable.create("$-d", "The alias to $DEBUG.", RubyType.BOOLEAN));
        result.add(RubyPredefinedVariable.create("$-F", "The alias to $;.", RubyType.STRING));
        result.add(RubyPredefinedVariable.create("$-i", "If in-place-edit mode is set, this variable holds the extension, otherwise nil.", RubyType.STRING));
        result.add(RubyPredefinedVariable.create("$-I", "The alias to $:.", RubyType.ARRAY));
        result.add(RubyPredefinedVariable.create("$-l", "True if option -l is set (\"line-ending processing\" is on). Read-only variable.", RubyType.BOOLEAN));
        result.add(RubyPredefinedVariable.create("$-p", "True if option -p is set (\"loop\" mode is on). Read-only variable.", RubyType.BOOLEAN));
        result.add(RubyPredefinedVariable.create("$-v", "The alias to $VERBOSE.", RubyType.BOOLEAN));
        result.add(RubyPredefinedVariable.create("$-w", "True if option -w is set.", RubyType.BOOLEAN));
        return result;
    }

    private static List<RubyPredefinedVariable> initializeClassVars() {
        ArrayList<RubyPredefinedVariable> result = new ArrayList<RubyPredefinedVariable>();
        result.add(RubyPredefinedVariable.create("__FILE__", RubyType.STRING));
        result.add(RubyPredefinedVariable.create("__LINE__", RubyType.FIXNUM));
        result.add(RubyPredefinedVariable.create("ARGF", "Object"));
        result.add(RubyPredefinedVariable.create("ARGV", RubyType.ARRAY));
        result.add(RubyPredefinedVariable.create("DATA", "File"));
        result.add(RubyPredefinedVariable.create("DATA", "IO"));
        result.add(RubyPredefinedVariable.create("ENV", RubyType.OBJECT));
        result.add(RubyPredefinedVariable.create("FALSE", RubyType.FALSE_CLASS));
        result.add(RubyPredefinedVariable.create("NIL", RubyType.NIL_CLASS));
        result.add(RubyPredefinedVariable.create("RUBY_PLATFORM", RubyType.STRING));
        result.add(RubyPredefinedVariable.create("RUBY_RELEASE_DATE", RubyType.STRING));
        result.add(RubyPredefinedVariable.create("RUBY_VERSION", RubyType.STRING));
        result.add(RubyPredefinedVariable.create("SCRIPT_LINES__", "Hash"));
        result.add(RubyPredefinedVariable.create("STDERR", "IO"));
        result.add(RubyPredefinedVariable.create("STDIN", "IO"));
        result.add(RubyPredefinedVariable.create("STDOUT", "IO"));
        result.add(RubyPredefinedVariable.create("TOPLEVEL_BINDING", "Binding"));
        result.add(RubyPredefinedVariable.create("TRUE", RubyType.TRUE_CLASS));
        return result;
    }

    private static RubyPredefinedVariable create(String name, String description, RubyType type) {
        return new RubyPredefinedVariable(name, description, type);
    }

    private static RubyPredefinedVariable create(String name, RubyType type) {
        return new RubyPredefinedVariable(name, "", type);
    }

    private static RubyPredefinedVariable create(String name, String type) {
        return new RubyPredefinedVariable(name, "", RubyType.create(type));
    }

    private static RubyPredefinedVariable create(String name, String description, String type) {
        return new RubyPredefinedVariable(name, description, RubyType.create(type));
    }

    String getDescription() {
        return this.description;
    }

    String getName() {
        return this.name;
    }

    RubyType getType() {
        return this.type;
    }

    static List<RubyPredefinedVariable> getPredefinedVariables() {
        return VARIABLES;
    }

    static List<RubyPredefinedVariable> getPredefinedClassVariables() {
        return CLASS_VARIABLES;
    }

    public static RubyType getType(String name) {
        for (RubyPredefinedVariable each : VARIABLES) {
            if (!each.getName().equals(name)) continue;
            return each.getType();
        }
        for (RubyPredefinedVariable each : CLASS_VARIABLES) {
            if (!each.getName().equals(name)) continue;
            return each.getType();
        }
        return null;
    }

    public String toString() {
        return RubyPredefinedVariable.class.getSimpleName() + "[name: " + this.name + ", type: " + this.type + "]";
    }
}

