/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.codecoverage;

import org.netbeans.modules.gsf.codecoverage.api.CoverageType;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageDetails;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageSummary;
import org.netbeans.modules.php.project.ui.codecoverage.CoverageVO;
import org.netbeans.modules.php.project.ui.codecoverage.PhpCoverageProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class PhpFileCoverageDetails
implements FileCoverageDetails {
    private final FileObject fo;
    private final CoverageVO.FileVO file;
    private final long generated;

    public PhpFileCoverageDetails(FileObject fo, CoverageVO.FileVO file) {
        assert (fo != null);
        assert (file != null);
        this.fo = fo;
        this.file = file;
        this.generated = FileUtil.toFile((FileObject)fo).lastModified();
    }

    public FileObject getFile() {
        return this.fo;
    }

    public int getLineCount() {
        return this.file.getMetrics().loc;
    }

    public boolean hasHitCounts() {
        return true;
    }

    public long lastUpdated() {
        return this.generated;
    }

    public FileCoverageSummary getSummary() {
        return PhpCoverageProvider.getFileCoverageSummary(this.file);
    }

    public CoverageType getType(int lineNo) {
        ++lineNo;
        for (CoverageVO.LineVO line : this.file.getLines()) {
            if (line.num != lineNo) continue;
            if (line.count > 0) {
                return CoverageType.COVERED;
            }
            return CoverageType.NOT_COVERED;
        }
        return CoverageType.UNKNOWN;
    }

    public int getHitCount(int lineNo) {
        ++lineNo;
        for (CoverageVO.LineVO line : this.file.getLines()) {
            if (line.num != lineNo) continue;
            return line.count;
        }
        return 0;
    }
}

