/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.spi;

import org.netbeans.api.keyring.Keyring;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.openide.util.NbBundle;

public abstract class RemoteConfiguration {
    private final String displayName;
    private final String name;
    private final String passwordKey;

    public RemoteConfiguration(ConfigManager.Configuration cfg) {
        this(cfg.getName(), cfg.getDisplayName());
    }

    protected RemoteConfiguration(String name, String displayName) {
        assert (name != null);
        assert (displayName != null);
        this.passwordKey = this.getClass().getName() + "." + name + ".password";
        this.name = name;
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.getUrl("");
    }

    public abstract String getUrl(String var1);

    public abstract String getInitialDirectory();

    public boolean saveProperty(String key, String value) {
        return false;
    }

    public void notifyDeleted() {
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteConfiguration other = (RemoteConfiguration)obj;
        return this.name == other.name || this.name != null && this.name.equals(other.name);
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append(this.getClass().getName());
        sb.append(" [displayName: ");
        sb.append(this.displayName);
        sb.append(", name: ");
        sb.append(this.name);
        sb.append("]");
        return sb.toString();
    }

    protected String readPassword(ConfigManager.Configuration cfg, String key) {
        String oldPassword = cfg.getValue(key, true);
        if (oldPassword != null) {
            return oldPassword;
        }
        char[] newPassword = Keyring.read((String)this.passwordKey);
        if (newPassword != null) {
            String newPasswordString = new String(newPassword);
            cfg.putValue(key, newPasswordString, true);
            return newPasswordString;
        }
        return null;
    }

    protected void savePassword(String password, String type) {
        if (StringUtils.hasText((String)password)) {
            Keyring.save((String)this.passwordKey, (char[])password.toCharArray(), (String)NbBundle.getMessage(RemoteConfiguration.class, (String)"MSG_PasswordFor", (Object)this.getDisplayName(), (Object)type));
        } else {
            this.deletePassword();
        }
    }

    protected void deletePassword() {
        Keyring.delete((String)this.passwordKey);
    }

    public static final class Empty
    extends RemoteConfiguration {
        public Empty(String name, String displayName) {
            super(name, displayName);
        }

        @Override
        public String getUrl(String directory) {
            return "";
        }

        @Override
        public String getInitialDirectory() {
            return "/";
        }
    }
}

