/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.PhpVisibilityQuery;
import org.netbeans.modules.php.project.connections.RemoteConnections;
import org.netbeans.modules.php.project.connections.RemoteException;
import org.netbeans.modules.php.project.connections.TransferFile;
import org.netbeans.modules.php.project.connections.TransferInfo;
import org.netbeans.modules.php.project.connections.spi.RemoteConfiguration;
import org.netbeans.modules.php.project.connections.spi.RemoteConnectionProvider;
import org.netbeans.modules.php.project.connections.spi.RemoteFile;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.windows.InputOutput;

public final class RemoteClient
implements Cancellable {
    private static final Logger LOGGER = Logger.getLogger(RemoteClient.class.getName());
    public static final FileSystem.AtomicAction DOWNLOAD_ATOMIC_ACTION = new DownloadAtomicAction(null);
    private static final AdvancedProperties DEFAULT_ADVANCED_PROPERTIES = new AdvancedProperties();
    private static final OperationMonitor DEV_NULL_OPERATION_MONITOR = new DevNullOperationMonitor();
    private static final Set<String> IGNORED_DIRS = new HashSet<String>(Arrays.asList(".", "..", "nbproject"));
    private static final int TRIES_TO_TRANSFER = 3;
    private static final String LOCAL_TMP_NEW_SUFFIX = ".new~";
    private static final String LOCAL_TMP_OLD_SUFFIX = ".old~";
    private static final String REMOTE_TMP_NEW_SUFFIX = ".new";
    private static final String REMOTE_TMP_OLD_SUFFIX = ".old";
    private final RemoteConfiguration configuration;
    private final AdvancedProperties properties;
    private final OperationMonitor operationMonitor;
    private final String baseRemoteDirectory;
    private final org.netbeans.modules.php.project.connections.spi.RemoteClient remoteClient;
    private volatile boolean cancelled = false;

    public RemoteClient(RemoteConfiguration configuration) {
        this(configuration, DEFAULT_ADVANCED_PROPERTIES);
    }

    public RemoteClient(RemoteConfiguration configuration, AdvancedProperties properties) {
        RemoteConnectionProvider provider;
        String baseDir;
        assert (configuration != null);
        assert (properties != null);
        this.configuration = configuration;
        this.properties = properties;
        OperationMonitor monitor = properties.getOperationMonitor();
        this.operationMonitor = monitor != null ? monitor : DEV_NULL_OPERATION_MONITOR;
        StringBuilder baseDirBuffer = new StringBuilder(configuration.getInitialDirectory());
        String additionalInitialSubdirectory = properties.getAdditionalInitialSubdirectory();
        if (StringUtils.hasText((String)additionalInitialSubdirectory)) {
            if (!additionalInitialSubdirectory.startsWith("/")) {
                throw new IllegalArgumentException("additionalInitialSubdirectory must start with /");
            }
            baseDirBuffer.append(additionalInitialSubdirectory);
        }
        if ((baseDir = baseDirBuffer.toString()).length() > 1 && baseDir.endsWith("/")) {
            baseDir = baseDir.substring(0, baseDir.length() - 1);
        }
        this.baseRemoteDirectory = baseDir.replaceAll("/{2,}", "/");
        assert (this.baseRemoteDirectory.startsWith("/")) : "base directory must start with /: " + this.baseRemoteDirectory;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("Remote client created with configuration: %s, advanced properties: %s, base remote directory: %s", configuration, properties, this.baseRemoteDirectory));
        }
        org.netbeans.modules.php.project.connections.spi.RemoteClient client = null;
        Iterator<RemoteConnectionProvider> i$ = RemoteConnections.get().getConnectionProviders().iterator();
        while (i$.hasNext() && (client = (provider = i$.next()).getRemoteClient(configuration, properties.getInputOutput())) == null) {
        }
        assert (client != null) : "no suitable remote client for configuration: " + configuration;
        this.remoteClient = client;
    }

    public void connect() throws RemoteException {
        this.remoteClient.connect();
        assert (this.remoteClient.isConnected()) : "Remote client should be connected";
        if (!this.cdBaseRemoteDirectory()) {
            if (this.remoteClient.isConnected()) {
                this.disconnect();
            }
            throw new RemoteException(NbBundle.getMessage(RemoteClient.class, (String)"MSG_CannotChangeDirectory", (Object)this.baseRemoteDirectory), this.remoteClient.getReplyString());
        }
    }

    public void disconnect() throws RemoteException {
        this.remoteClient.disconnect();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean cancel() {
        this.cancelled = true;
        return true;
    }

    public void reset() {
        this.cancelled = false;
    }

    public boolean exists(TransferFile file) throws RemoteException {
        this.ensureConnected();
        LOGGER.fine(String.format("Checking whether file %s exists", file));
        this.cdBaseRemoteDirectory();
        boolean exists = this.remoteClient.exists(file.getParentRelativePath(), file.getName());
        LOGGER.fine(String.format("Exists: %b", exists));
        return exists;
    }

    public boolean rename(TransferFile from, TransferFile to) throws RemoteException {
        this.ensureConnected();
        LOGGER.fine(String.format("Moving file from %s to %s", from, to));
        this.cdBaseRemoteDirectory();
        boolean success = this.remoteClient.rename(from.getRelativePath(), to.getRelativePath());
        LOGGER.fine(String.format("Success: %b", success));
        return success;
    }

    public Set<TransferFile> prepareUpload(FileObject baseLocalDirectory, FileObject ... filesToUpload) throws RemoteException {
        assert (baseLocalDirectory != null);
        assert (filesToUpload != null);
        assert (baseLocalDirectory.isFolder()) : "Base local directory must be a directory";
        assert (filesToUpload.length > 0) : "At least one file to upload must be specified";
        File baseLocalDir = FileUtil.toFile((FileObject)baseLocalDirectory);
        String baseLocalAbsolutePath = baseLocalDir.getAbsolutePath();
        LinkedList<TransferFile> queue = new LinkedList<TransferFile>();
        for (FileObject fo : filesToUpload) {
            File f = FileUtil.toFile((FileObject)fo);
            if (f == null) continue;
            if (this.isVisible(f)) {
                LOGGER.log(Level.FINE, "File {0} added to upload queue", fo);
                queue.offer(TransferFile.fromFileObject(null, fo, baseLocalAbsolutePath));
                continue;
            }
            LOGGER.log(Level.FINE, "File {0} NOT added to upload queue [invisible]", fo);
        }
        HashSet<TransferFile> files = new HashSet<TransferFile>();
        while (!queue.isEmpty()) {
            File f;
            File[] children;
            if (this.cancelled) {
                LOGGER.fine("Prepare upload cancelled");
                break;
            }
            TransferFile file = (TransferFile)queue.poll();
            if (!files.add(file)) {
                LOGGER.log(Level.FINE, "File {0} already in queue", file);
                files.remove(file);
                files.add(file);
            }
            if (!file.isDirectory() || (children = (f = this.getLocalFile(baseLocalDir, file)).listFiles()) == null) continue;
            for (File child : children) {
                if (this.isVisible(child)) {
                    LOGGER.log(Level.FINE, "File {0} added to upload queue", child);
                    queue.offer(TransferFile.fromFile(file, child, baseLocalAbsolutePath));
                    continue;
                }
                LOGGER.log(Level.FINE, "File {0} NOT added to upload queue [invisible]", child);
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Prepared for upload: {0}", files);
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferInfo upload(FileObject baseLocalDirectory, Set<TransferFile> filesToUpload) throws RemoteException {
        assert (baseLocalDirectory != null);
        assert (filesToUpload != null);
        assert (baseLocalDirectory.isFolder()) : "Base local directory must be a directory";
        assert (filesToUpload.size() > 0) : "At least one file to upload must be specified";
        this.ensureConnected();
        long start = System.currentTimeMillis();
        TransferInfo transferInfo = new TransferInfo();
        File baseLocalDir = FileUtil.toFile((FileObject)baseLocalDirectory);
        try {
            this.operationMonitor.operationStart(Operation.UPLOAD, filesToUpload);
            for (TransferFile file : filesToUpload) {
                if (this.cancelled) {
                    LOGGER.fine("Upload cancelled");
                    break;
                }
                this.operationMonitor.operationProcess(Operation.UPLOAD, file);
                try {
                    this.uploadFile(transferInfo, baseLocalDir, file);
                }
                catch (IOException exc) {
                    this.transferFailed(transferInfo, file, NbBundle.getMessage(RemoteClient.class, (String)"MSG_ErrorReason", (Object)exc.getMessage().trim()));
                }
                catch (RemoteException exc) {
                    this.transferFailed(transferInfo, file, NbBundle.getMessage(RemoteClient.class, (String)"MSG_ErrorReason", (Object)exc.getMessage().trim()));
                }
            }
        }
        finally {
            this.operationMonitor.operationFinish(Operation.UPLOAD, filesToUpload);
            transferInfo.setRuntime(System.currentTimeMillis() - start);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(transferInfo.toString());
            }
        }
        return transferInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void uploadFile(TransferInfo transferInfo, File baseLocalDir, TransferFile file) throws IOException, RemoteException {
        if (file.isDirectory()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Uploading directory: {0}", file);
            }
            this.cdBaseRemoteDirectory(file.getRelativePath(), true);
            this.transferSucceeded(transferInfo, file);
            return;
        }
        assert (file.getParentRelativePath() != null) : "Must be underneath base remote directory! [" + file + "]";
        if (!this.cdBaseRemoteDirectory(file.getParentRelativePath(), true)) {
            this.transferIgnored(transferInfo, file, NbBundle.getMessage(RemoteClient.class, (String)"MSG_CannotChangeDirectory", (Object)file.getParentRelativePath()));
            return;
        }
        String fileName = file.getName();
        int oldPermissions = -1;
        if (this.properties.isPreservePermissions()) {
            oldPermissions = this.remoteClient.getPermissions(fileName);
            LOGGER.fine(String.format("Original permissions of %s: %d", fileName, oldPermissions));
        } else {
            LOGGER.fine("Permissions are not preserved.");
        }
        String tmpFileName = null;
        if (this.properties.isUploadDirectly()) {
            LOGGER.fine("File will be uploaded directly.");
            tmpFileName = fileName;
        } else {
            tmpFileName = fileName + REMOTE_TMP_NEW_SUFFIX;
            LOGGER.fine("File will be uploaded using a temporary file.");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Uploading file {0} => {1}", new Object[]{fileName, this.remoteClient.printWorkingDirectory() + "/" + tmpFileName});
        }
        FileInputStream is = new FileInputStream(new File(baseLocalDir, file.getRelativePath(true)));
        boolean success = false;
        try {
            for (int i = 1; i <= 3; ++i) {
                String f;
                if (this.remoteClient.storeFile(tmpFileName, is)) {
                    success = true;
                    if (LOGGER.isLoggable(Level.FINE)) {
                        f = file.getRelativePath() + (this.properties.isUploadDirectly() ? "" : REMOTE_TMP_NEW_SUFFIX);
                        LOGGER.fine(String.format("The %d. attempt to upload '%s' was successful", i, f));
                    }
                    break;
                }
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                f = file.getRelativePath() + (this.properties.isUploadDirectly() ? "" : REMOTE_TMP_NEW_SUFFIX);
                LOGGER.fine(String.format("The %d. attempt to upload '%s' was NOT successful", i, f));
            }
        }
        catch (Throwable throwable) {
            ((InputStream)is).close();
            if (success) {
                if (!this.properties.isUploadDirectly()) {
                    success = this.moveRemoteFile(tmpFileName, fileName);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(String.format("File %s renamed to %s: %s", tmpFileName, fileName, success));
                    }
                }
                if (this.properties.isPreservePermissions() && success && oldPermissions != -1) {
                    int newPermissions = this.remoteClient.getPermissions(fileName);
                    LOGGER.fine(String.format("New permissions of %s: %d", fileName, newPermissions));
                    if (oldPermissions != newPermissions) {
                        LOGGER.fine(String.format("Setting permissions %d for %s.", oldPermissions, fileName));
                        boolean permissionsSet = this.remoteClient.setPermissions(oldPermissions, fileName);
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine(String.format("Permissions for %s set: %s", fileName, permissionsSet));
                            LOGGER.fine(String.format("Permissions for %s read: %s", fileName, this.remoteClient.getPermissions(fileName)));
                        }
                        if (!permissionsSet) {
                            this.transferPartiallyFailed(transferInfo, file, NbBundle.getMessage(RemoteClient.class, (String)"MSG_PermissionsNotSet", (Object)oldPermissions, (Object)file.getName()));
                        }
                    }
                }
            }
            if (success) {
                this.transferSucceeded(transferInfo, file);
                throw throwable;
            }
            this.transferFailed(transferInfo, file, this.getOperationFailureMessage(Operation.UPLOAD, fileName));
            boolean deleted = this.remoteClient.deleteFile(tmpFileName);
            if (!LOGGER.isLoggable(Level.FINE)) throw throwable;
            LOGGER.fine(String.format("Unsuccessfully uploaded file %s deleted: %s", file.getRelativePath() + REMOTE_TMP_NEW_SUFFIX, deleted));
            throw throwable;
        }
        ((InputStream)is).close();
        if (success) {
            if (!this.properties.isUploadDirectly()) {
                success = this.moveRemoteFile(tmpFileName, fileName);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(String.format("File %s renamed to %s: %s", tmpFileName, fileName, success));
                }
            }
            if (this.properties.isPreservePermissions() && success && oldPermissions != -1) {
                int newPermissions = this.remoteClient.getPermissions(fileName);
                LOGGER.fine(String.format("New permissions of %s: %d", fileName, newPermissions));
                if (oldPermissions != newPermissions) {
                    LOGGER.fine(String.format("Setting permissions %d for %s.", oldPermissions, fileName));
                    boolean permissionsSet = this.remoteClient.setPermissions(oldPermissions, fileName);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(String.format("Permissions for %s set: %s", fileName, permissionsSet));
                        LOGGER.fine(String.format("Permissions for %s read: %s", fileName, this.remoteClient.getPermissions(fileName)));
                    }
                    if (!permissionsSet) {
                        this.transferPartiallyFailed(transferInfo, file, NbBundle.getMessage(RemoteClient.class, (String)"MSG_PermissionsNotSet", (Object)oldPermissions, (Object)file.getName()));
                    }
                }
            }
        }
        if (success) {
            this.transferSucceeded(transferInfo, file);
            return;
        }
        this.transferFailed(transferInfo, file, this.getOperationFailureMessage(Operation.UPLOAD, fileName));
        boolean deleted = this.remoteClient.deleteFile(tmpFileName);
        if (!LOGGER.isLoggable(Level.FINE)) return;
        LOGGER.fine(String.format("Unsuccessfully uploaded file %s deleted: %s", file.getRelativePath() + REMOTE_TMP_NEW_SUFFIX, deleted));
    }

    private boolean moveRemoteFile(String source, String target) throws RemoteException {
        boolean moved = this.remoteClient.rename(source, target);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("File %s directly renamed to %s: %s", source, target, moved));
        }
        if (moved) {
            return true;
        }
        String oldPath = target + REMOTE_TMP_OLD_SUFFIX;
        this.remoteClient.deleteFile(oldPath);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Renaming in chain: (1) <file> -> <file>.old~ ; (2) <file>.new~ -> <file> ; (3) rm <file>.old~");
        }
        moved = this.remoteClient.rename(target, oldPath);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("(1) File %s renamed to %s: %s", target, oldPath, moved));
        }
        if (!moved) {
            return false;
        }
        moved = this.remoteClient.rename(source, target);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("(2) File %s renamed to %s: %s", source, target, moved));
        }
        if (!moved) {
            boolean restored = this.remoteClient.rename(oldPath, target);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("(-) File %s restored to original %s: %s", oldPath, target, restored));
            }
        } else {
            boolean deleted = this.remoteClient.deleteFile(oldPath);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("(3) File %s deleted: %s", oldPath, deleted));
            }
        }
        return moved;
    }

    public Set<TransferFile> prepareDownload(FileObject baseLocalDirectory, FileObject ... filesToDownload) throws RemoteException {
        assert (baseLocalDirectory != null);
        assert (baseLocalDirectory.isFolder()) : "Base local directory must be a directory";
        assert (filesToDownload != null);
        assert (filesToDownload.length > 0) : "At least one file to download must be specified";
        ArrayList<File> files = new ArrayList<File>(filesToDownload.length);
        for (FileObject fo : filesToDownload) {
            File f = FileUtil.toFile((FileObject)fo);
            if (f == null) continue;
            files.add(f);
        }
        return this.prepareDownload(FileUtil.toFile((FileObject)baseLocalDirectory), files.toArray(new File[files.size()]));
    }

    public Set<TransferFile> prepareDownload(File baseLocalDir, File ... filesToDownload) throws RemoteException {
        assert (baseLocalDir != null);
        assert (filesToDownload != null);
        assert (filesToDownload.length > 0) : "At least one file to download must be specified";
        this.ensureConnected();
        String baseLocalAbsolutePath = baseLocalDir.getAbsolutePath();
        LinkedList<TransferFile> queue = new LinkedList<TransferFile>();
        for (File f : filesToDownload) {
            if (this.isVisible(f)) {
                LOGGER.log(Level.FINE, "File {0} added to download queue", f);
                TransferFile tf = null;
                tf = f.exists() ? TransferFile.fromFile(null, f, baseLocalAbsolutePath) : TransferFile.fromFile(null, f, baseLocalAbsolutePath, true);
                queue.offer(tf);
                continue;
            }
            LOGGER.log(Level.FINE, "File {0} NOT added to download queue [invisible]", f);
        }
        HashSet<TransferFile> files = new HashSet<TransferFile>();
        while (!queue.isEmpty()) {
            if (this.cancelled) {
                LOGGER.fine("Prepare download cancelled");
                break;
            }
            TransferFile file = (TransferFile)queue.poll();
            if (!files.add(file)) {
                LOGGER.log(Level.FINE, "File {0} already in queue", file);
                files.remove(file);
                files.add(file);
            }
            if (!file.isDirectory()) continue;
            try {
                if (!this.cdBaseRemoteDirectory(file.getRelativePath(), false)) {
                    LOGGER.log(Level.FINE, "Remote directory {0} cannot be entered or does not exist => ignoring", file.getRelativePath());
                    continue;
                }
                String relPath = this.getRemoteRelativePath(file);
                for (RemoteFile child : this.remoteClient.listFiles()) {
                    if (this.isVisible(this.getLocalFile(baseLocalDir, file, child))) {
                        LOGGER.log(Level.FINE, "File {0} added to download queue", child);
                        queue.offer(TransferFile.fromRemoteFile(file, child, this.baseRemoteDirectory, relPath));
                        continue;
                    }
                    LOGGER.log(Level.FINE, "File {0} NOT added to download queue [invisible]", child);
                }
            }
            catch (RemoteException exc) {
                LOGGER.log(Level.FINE, "Remote directory {0}/* cannot be entered or does not exist => ignoring", file.getRelativePath());
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Prepared for download: {0}", files);
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferInfo download(FileObject baseLocalDirectory, Set<TransferFile> filesToDownload) throws RemoteException {
        assert (baseLocalDirectory != null);
        assert (filesToDownload != null);
        assert (baseLocalDirectory.isFolder()) : "Base local directory must be a directory";
        assert (filesToDownload.size() > 0) : "At least one file to download must be specified";
        this.ensureConnected();
        long start = System.currentTimeMillis();
        final TransferInfo transferInfo = new TransferInfo();
        final File baseLocalDir = FileUtil.toFile((FileObject)baseLocalDirectory);
        try {
            this.operationMonitor.operationStart(Operation.DOWNLOAD, filesToDownload);
            for (final TransferFile file : filesToDownload) {
                if (this.cancelled) {
                    LOGGER.fine("Download cancelled");
                    break;
                }
                this.operationMonitor.operationProcess(Operation.DOWNLOAD, file);
                try {
                    FileUtil.runAtomicAction((FileSystem.AtomicAction)new DownloadAtomicAction(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                RemoteClient.this.downloadFile(transferInfo, baseLocalDir, file);
                            }
                            catch (IOException exc) {
                                RemoteClient.this.transferFailed(transferInfo, file, NbBundle.getMessage(RemoteClient.class, (String)"MSG_ErrorReason", (Object)exc.getMessage().trim()));
                            }
                            catch (RemoteException exc) {
                                RemoteClient.this.transferFailed(transferInfo, file, NbBundle.getMessage(RemoteClient.class, (String)"MSG_ErrorReason", (Object)exc.getMessage().trim()));
                            }
                        }
                    }));
                }
                catch (IOException ex) {
                    this.transferFailed(transferInfo, file, NbBundle.getMessage(RemoteClient.class, (String)"MSG_ErrorReason", (Object)ex.getMessage().trim()));
                }
            }
            this.operationMonitor.operationFinish(Operation.DOWNLOAD, filesToDownload);
        }
        catch (Throwable throwable) {
            this.operationMonitor.operationFinish(Operation.DOWNLOAD, filesToDownload);
            FileUtil.refreshFor((File[])new File[]{baseLocalDir});
            transferInfo.setRuntime(System.currentTimeMillis() - start);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(transferInfo.toString());
            }
            throw throwable;
        }
        FileUtil.refreshFor((File[])new File[]{baseLocalDir});
        transferInfo.setRuntime(System.currentTimeMillis() - start);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(transferInfo.toString());
        }
        return transferInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void downloadFile(TransferInfo transferInfo, File baseLocalDir, TransferFile file) throws IOException, RemoteException {
        File localFile = this.getLocalFile(baseLocalDir, file);
        if (file.isDirectory()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Downloading directory: {0}", file);
            }
            if (!this.cdBaseRemoteDirectory(file.getRelativePath(), false)) {
                LOGGER.log(Level.FINE, "Remote directory {0} does not exist => ignoring", file.getRelativePath());
                this.transferIgnored(transferInfo, file, NbBundle.getMessage(RemoteClient.class, (String)"MSG_CannotChangeDirectory", (Object)file.getRelativePath()));
                return;
            }
            if (!localFile.exists()) {
                if (!RemoteClient.mkLocalDirs(localFile)) {
                    this.transferFailed(transferInfo, file, NbBundle.getMessage(RemoteClient.class, (String)"MSG_CannotCreateDir", (Object)localFile));
                    return;
                }
            } else if (localFile.isFile()) {
                this.transferIgnored(transferInfo, file, NbBundle.getMessage(RemoteClient.class, (String)"MSG_DirFileCollision", (Object)file));
                return;
            }
            this.transferSucceeded(transferInfo, file);
            return;
        }
        if (!file.isFile()) {
            this.transferIgnored(transferInfo, file, NbBundle.getMessage(RemoteClient.class, (String)"MSG_UnknownFileType", (Object)file.getRelativePath()));
            return;
        }
        File parent = localFile.getParentFile();
        assert (parent != null) : "File " + localFile + " has no parent file?!";
        if (!parent.exists()) {
            if (!RemoteClient.mkLocalDirs(parent)) {
                this.transferIgnored(transferInfo, file, NbBundle.getMessage(RemoteClient.class, (String)"MSG_CannotCreateDir", (Object)parent));
                return;
            }
        } else {
            if (parent.isFile()) {
                this.transferIgnored(transferInfo, file, NbBundle.getMessage(RemoteClient.class, (String)"MSG_DirFileCollision", (Object)file));
                return;
            }
            if (localFile.exists() && !localFile.canWrite()) {
                this.transferIgnored(transferInfo, file, NbBundle.getMessage(RemoteClient.class, (String)"MSG_FileNotWritable", (Object)localFile));
                return;
            }
        }
        assert (parent.isDirectory()) : "Parent file of " + localFile + " must be a directory";
        File tmpLocalFile = new File(localFile.getAbsolutePath() + LOCAL_TMP_NEW_SUFFIX);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Downloading {0} => {1}", new Object[]{file.getRelativePath(), tmpLocalFile.getAbsolutePath()});
        }
        if (!this.cdBaseRemoteDirectory(file.getParentRelativePath(), false)) {
            LOGGER.log(Level.FINE, "Remote directory {0} does not exist => ignoring file {1}", new Object[]{file.getParentRelativePath(), file.getRelativePath()});
            this.transferIgnored(transferInfo, file, NbBundle.getMessage(RemoteClient.class, (String)"MSG_CannotChangeDirectory", (Object)file.getParentRelativePath()));
            return;
        }
        FileOutputStream os = new FileOutputStream(tmpLocalFile);
        boolean success = false;
        try {
            for (int i = 1; i <= 3; ++i) {
                if (this.remoteClient.retrieveFile(file.getName(), os)) {
                    success = true;
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(String.format("The %d. attempt to download '%s' was successful", i, file.getRelativePath()));
                    }
                    break;
                }
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.fine(String.format("The %d. attempt to download '%s' was NOT successful", i, file.getRelativePath()));
            }
        }
        catch (Throwable throwable) {
            ((OutputStream)os).close();
            if (success) {
                success = this.moveLocalFile(tmpLocalFile, localFile);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(String.format("File %s renamed to %s: %s", tmpLocalFile, localFile, success));
                }
            }
            if (success) {
                this.transferSucceeded(transferInfo, file);
                throw throwable;
            }
            this.transferFailed(transferInfo, file, this.getOperationFailureMessage(Operation.DOWNLOAD, file.getName()));
            boolean deleted = tmpLocalFile.delete();
            if (!LOGGER.isLoggable(Level.FINE)) throw throwable;
            LOGGER.fine(String.format("Unsuccessfully downloaded file %s deleted: %s", tmpLocalFile, deleted));
            throw throwable;
        }
        ((OutputStream)os).close();
        if (success) {
            success = this.moveLocalFile(tmpLocalFile, localFile);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("File %s renamed to %s: %s", tmpLocalFile, localFile, success));
            }
        }
        if (success) {
            this.transferSucceeded(transferInfo, file);
            return;
        }
        this.transferFailed(transferInfo, file, this.getOperationFailureMessage(Operation.DOWNLOAD, file.getName()));
        boolean deleted = tmpLocalFile.delete();
        if (!LOGGER.isLoggable(Level.FINE)) return;
        LOGGER.fine(String.format("Unsuccessfully downloaded file %s deleted: %s", tmpLocalFile, deleted));
    }

    private boolean moveLocalFile(final File source, final File target) {
        final boolean[] moved = new boolean[1];
        FileUtil.runAtomicAction((Runnable)new Runnable(){

            @Override
            public void run() {
                File oldPath = new File(target.getAbsolutePath() + RemoteClient.LOCAL_TMP_OLD_SUFFIX);
                String tmpLocalFileName = source.getName();
                String localFileName = target.getName();
                String oldPathName = oldPath.getName();
                if (!target.exists()) {
                    moved[0] = RemoteClient.renameLocalFileTo(source, target);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(String.format("File %s directly renamed to %s: %s", tmpLocalFileName, localFileName, moved[0]));
                    }
                    if (moved[0]) {
                        return;
                    }
                }
                RemoteClient.this.deleteLocalFile(oldPath, "");
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Renaming in chain: (1) <file> -> <file>.old~ ; (2) <file>.new~ -> <file> ; (3) rm <file>.old~");
                }
                moved[0] = target.renameTo(oldPath);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(String.format("(1) File %s renamed to %s: %s", localFileName, oldPathName, moved[0]));
                }
                if (!moved[0]) {
                    return;
                }
                moved[0] = RemoteClient.renameLocalFileTo(source, target);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(String.format("(2) File %s renamed to %s: %s", tmpLocalFileName, localFileName, moved[0]));
                }
                if (!moved[0] && oldPath.exists() && !target.exists()) {
                    boolean restored = RemoteClient.renameLocalFileTo(oldPath, target);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(String.format("(-) File %s restored to original %s: %s", oldPathName, localFileName, restored));
                    }
                    return;
                }
                RemoteClient.this.deleteLocalFile(oldPath, "(3) ");
            }
        });
        assert (moved[0] || !moved[0]);
        return moved[0];
    }

    private File getLocalFile(File localFile, TransferFile transferFile) {
        if (transferFile.getRelativePath() == ".") {
            return localFile;
        }
        return new File(localFile, transferFile.getRelativePath(true));
    }

    private File getLocalFile(File localFile, TransferFile parent, RemoteFile file) {
        return new File(this.getLocalFile(localFile, parent), file.getName());
    }

    public Set<TransferFile> prepareDelete(FileObject baseLocalDirectory, FileObject ... filesToDelete) throws RemoteException {
        LOGGER.fine("Preparing files to delete => calling prepareUpload because in fact the same operation is done");
        return this.prepareUpload(baseLocalDirectory, filesToDelete);
    }

    public TransferInfo delete(TransferFile fileToDelete) throws RemoteException {
        return this.delete(Collections.singleton(fileToDelete));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferInfo delete(Set<TransferFile> filesToDelete) throws RemoteException {
        assert (filesToDelete != null);
        assert (filesToDelete.size() > 0) : "At least one file to upload must be specified";
        this.ensureConnected();
        long start = System.currentTimeMillis();
        TransferInfo transferInfo = new TransferInfo();
        try {
            Set<TransferFile> files = this.getFiles(filesToDelete);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("Only files: %s => %s", filesToDelete, files));
            }
            this.delete(transferInfo, files);
            Set<TransferFile> dirs = this.getDirectories(filesToDelete);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("Only dirs: %s => %s", filesToDelete, dirs));
            }
            this.delete(transferInfo, dirs);
            assert (filesToDelete.size() == files.size() + dirs.size()) : String.format("%s does not match files and dirs: %s %s", filesToDelete, files, dirs);
        }
        finally {
            transferInfo.setRuntime(System.currentTimeMillis() - start);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(transferInfo.toString());
            }
        }
        return transferInfo;
    }

    private void delete(TransferInfo transferInfo, Set<TransferFile> filesToDelete) {
        for (TransferFile file : filesToDelete) {
            if (this.cancelled) {
                LOGGER.fine("Delete cancelled");
                break;
            }
            try {
                this.deleteFile(transferInfo, file);
            }
            catch (IOException exc) {
                this.transferFailed(transferInfo, file, NbBundle.getMessage(RemoteClient.class, (String)"MSG_ErrorReason", (Object)exc.getMessage().trim()));
            }
            catch (RemoteException exc) {
                this.transferFailed(transferInfo, file, NbBundle.getMessage(RemoteClient.class, (String)"MSG_ErrorReason", (Object)exc.getMessage().trim()));
            }
        }
    }

    private void deleteFile(TransferInfo transferInfo, TransferFile file) throws IOException, RemoteException {
        boolean success = false;
        this.cdBaseRemoteDirectory();
        if (file.isDirectory()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Deleting directory: {0}", file);
            }
            success = this.remoteClient.deleteDirectory(file.getRelativePath());
            LOGGER.log(Level.FINE, "Folder deleted: {0}", success);
        } else {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Deleting file: {0}", file);
            }
            success = this.remoteClient.deleteFile(file.getRelativePath());
            LOGGER.log(Level.FINE, "File deleted: {0}", success);
        }
        if (success) {
            this.transferSucceeded(transferInfo, file);
        } else {
            String msg = null;
            msg = !this.remoteClient.exists(file.getParentRelativePath(), file.getName()) ? NbBundle.getMessage(RemoteClient.class, (String)"MSG_FileNotExists", (Object)file.getName()) : (file.isDirectory() && this.cdBaseRemoteDirectory(file.getParentRelativePath(), false) && this.remoteClient.listFiles().size() > 0 ? NbBundle.getMessage(RemoteClient.class, (String)"MSG_FolderNotEmpty", (Object)file.getName()) : this.getOperationFailureMessage(Operation.DELETE, file.getName()));
            this.transferFailed(transferInfo, file, msg);
        }
    }

    private void transferSucceeded(TransferInfo transferInfo, TransferFile file) {
        transferInfo.addTransfered(file);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Transfered: {0}", file);
        }
    }

    private void transferFailed(TransferInfo transferInfo, TransferFile file, String reason) {
        if (!transferInfo.isFailed(file)) {
            transferInfo.addFailed(file, reason);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Failed: {0}, reason: {1}", new Object[]{file, reason});
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Failed: {0}, reason: {1} [ignored, failed already]", new Object[]{file, reason});
        }
    }

    private void transferPartiallyFailed(TransferInfo transferInfo, TransferFile file, String reason) {
        if (!transferInfo.isPartiallyFailed(file)) {
            transferInfo.addPartiallyFailed(file, reason);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Partially failed: {0}, reason: {1}", new Object[]{file, reason});
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Partially failed: {0}, reason: {1} [ignored, partially failed already]", new Object[]{file, reason});
        }
    }

    private void transferIgnored(TransferInfo transferInfo, TransferFile file, String reason) {
        if (!transferInfo.isIgnored(file)) {
            transferInfo.addIgnored(file, reason);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Ignored: {0}, reason: {1}", new Object[]{file, reason});
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Ignored: {0}, reason: {1} [ignored, ignored already]", new Object[]{file, reason});
        }
    }

    private String getOperationFailureMessage(Operation operation, String fileName) {
        String message = this.remoteClient.getNegativeReplyString();
        if (message == null) {
            String key = null;
            switch (operation) {
                case UPLOAD: {
                    key = "MSG_CannotUploadFile";
                    break;
                }
                case DOWNLOAD: {
                    key = "MSG_CannotDownloadFile";
                    break;
                }
                case DELETE: {
                    key = "MSG_CannotDeleteFile";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown operation type: " + (Object)((Object)operation));
                }
            }
            message = NbBundle.getMessage(RemoteClient.class, (String)key, (Object)fileName);
        }
        return message;
    }

    private void ensureConnected() throws RemoteException {
        if (!this.remoteClient.isConnected()) {
            LOGGER.fine("Client not connected -> connecting");
            this.connect();
        }
    }

    private boolean cdBaseRemoteDirectory() throws RemoteException {
        return this.cdRemoteDirectory(this.baseRemoteDirectory, true);
    }

    private boolean cdBaseRemoteDirectory(String subdirectory, boolean create) throws RemoteException {
        assert (subdirectory == null || !subdirectory.startsWith("/")) : "Subdirectory must be null or relative [" + subdirectory + "]";
        String path = this.baseRemoteDirectory;
        if (subdirectory != null && !subdirectory.equals(".")) {
            path = this.baseRemoteDirectory + "/" + subdirectory;
        }
        return this.cdRemoteDirectory(path, create);
    }

    private boolean cdRemoteDirectory(String directory, boolean create) throws RemoteException {
        LOGGER.log(Level.FINE, "Changing directory to {0}", directory);
        boolean success = this.remoteClient.changeWorkingDirectory(directory);
        if (!success && create) {
            return this.createAndCdRemoteDirectory(directory);
        }
        return success;
    }

    private boolean createAndCdRemoteDirectory(String filePath) throws RemoteException {
        LOGGER.log(Level.FINE, "Creating file path {0}", filePath);
        if (filePath.startsWith("/") && !this.remoteClient.changeWorkingDirectory("/")) {
            throw new RemoteException(NbBundle.getMessage(RemoteClient.class, (String)"MSG_CannotChangeDirectory", (Object)"/"), this.remoteClient.getReplyString());
        }
        for (String dir : filePath.split("/")) {
            if (dir.length() == 0 || this.remoteClient.changeWorkingDirectory(dir)) continue;
            if (!this.remoteClient.makeDirectory(dir)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Cannot create directory: {0}", this.remoteClient.printWorkingDirectory() + "/" + dir);
                }
                throw new RemoteException(NbBundle.getMessage(RemoteClient.class, (String)"MSG_CannotCreateDirectory", (Object)dir), this.remoteClient.getReplyString());
            }
            if (!this.remoteClient.changeWorkingDirectory(dir)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Cannot enter directory: {0}", this.remoteClient.printWorkingDirectory() + "/" + dir);
                }
                return false;
            }
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.log(Level.FINE, "Directory '{0}' created and entered", this.remoteClient.printWorkingDirectory());
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append(this.getClass().getName());
        sb.append(" [remote configuration: ");
        sb.append(this.configuration);
        sb.append(", baseRemoteDirectory: ");
        sb.append(this.baseRemoteDirectory);
        sb.append("]");
        return sb.toString();
    }

    private boolean isVisible(File file) {
        assert (file != null);
        if (IGNORED_DIRS.contains(file.getName())) {
            return false;
        }
        return this.properties.getPhpVisibilityQuery().isVisible(file);
    }

    private static boolean mkLocalDirs(File folder) {
        try {
            FileUtil.createFolder((File)folder);
        }
        catch (IOException exc) {
            LOGGER.log(Level.INFO, null, exc);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean renameLocalFileTo(File source, File target) {
        long start = 0L;
        if (LOGGER.isLoggable(Level.FINE)) {
            start = System.currentTimeMillis();
        }
        assert (source.exists()) : "Source file must exist " + source;
        assert (!target.exists()) : "Target file cannot exist " + target;
        FileObject sourceFO = FileUtil.toFileObject((File)source);
        assert (sourceFO != null) : "Source fileobject must exist " + source;
        String name = RemoteClient.getName(target.getName());
        String ext = FileUtil.getExtension((String)target.getName());
        boolean moved = false;
        try {
            FileLock lock = sourceFO.lock();
            try {
                sourceFO.rename(lock, name, ext);
                moved = true;
            }
            catch (IOException exc) {
                LOGGER.log(Level.INFO, null, exc);
            }
            finally {
                lock.releaseLock();
            }
        }
        catch (IOException exc) {
            LOGGER.log(Level.WARNING, null, exc);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("Move %s -> %s took: %sms", source, target, System.currentTimeMillis() - start));
        }
        return moved;
    }

    private void deleteLocalFile(File file, String logMsgPrefix) {
        if (!file.exists()) {
            return;
        }
        boolean deleted = file.delete();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format(logMsgPrefix + "File %s deleted: %s", file.getName(), deleted));
        }
    }

    private static String getName(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return fileName;
        }
        return fileName.substring(0, index);
    }

    private String getRemoteRelativePath(TransferFile file) {
        StringBuilder relativePath = new StringBuilder(this.baseRemoteDirectory);
        if (file.getRelativePath() != ".") {
            relativePath.append("/");
            relativePath.append(file.getRelativePath());
        }
        return relativePath.toString();
    }

    private Set<TransferFile> getFiles(Set<TransferFile> all) {
        HashSet<TransferFile> files = new HashSet<TransferFile>();
        for (TransferFile file : all) {
            if (!file.isFile()) continue;
            files.add(file);
        }
        return files;
    }

    private Set<TransferFile> getDirectories(Set<TransferFile> all) {
        TreeSet<TransferFile> dirs = new TreeSet<TransferFile>(new Comparator<TransferFile>(){
            private final String SEPARATOR = Pattern.quote("/");

            @Override
            public int compare(TransferFile o1, TransferFile o2) {
                int cmp = o2.getRelativePath().split(this.SEPARATOR).length - o1.getRelativePath().split(this.SEPARATOR).length;
                return cmp != 0 ? cmp : 1;
            }
        });
        for (TransferFile file : all) {
            if (!file.isDirectory()) continue;
            dirs.add(file);
        }
        return dirs;
    }

    private static final class DownloadAtomicAction
    implements FileSystem.AtomicAction {
        private final Runnable runnable;

        public DownloadAtomicAction(Runnable runnable) {
            this.runnable = runnable;
        }

        public void run() throws IOException {
            if (this.runnable != null) {
                this.runnable.run();
            }
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return this.getClass() == obj.getClass();
        }

        public int hashCode() {
            return 42;
        }
    }

    private static final class AdvancedPropertiesBuilder {
        InputOutput io;
        String additionalInitialSubdirectory;
        boolean preservePermissions = false;
        boolean uploadDirectly = false;
        OperationMonitor operationMonitor;
        PhpVisibilityQuery phpVisibilityQuery;

        AdvancedPropertiesBuilder() {
        }

        public AdvancedPropertiesBuilder(AdvancedProperties properties) {
            this.io = properties.getInputOutput();
            this.additionalInitialSubdirectory = properties.getAdditionalInitialSubdirectory();
            this.preservePermissions = properties.isPreservePermissions();
            this.uploadDirectly = properties.isUploadDirectly();
            this.operationMonitor = properties.getOperationMonitor();
            this.phpVisibilityQuery = properties.getPhpVisibilityQuery();
        }

        public AdvancedPropertiesBuilder setAdditionalInitialSubdirectory(String additionalInitialSubdirectory) {
            this.additionalInitialSubdirectory = additionalInitialSubdirectory;
            return this;
        }

        public AdvancedPropertiesBuilder setInputOutput(InputOutput io) {
            this.io = io;
            return this;
        }

        public AdvancedPropertiesBuilder setOperationMonitor(OperationMonitor operationMonitor) {
            this.operationMonitor = operationMonitor;
            return this;
        }

        public AdvancedPropertiesBuilder setPreservePermissions(boolean preservePermissions) {
            this.preservePermissions = preservePermissions;
            return this;
        }

        public AdvancedPropertiesBuilder setUploadDirectly(boolean uploadDirectly) {
            this.uploadDirectly = uploadDirectly;
            return this;
        }

        public AdvancedPropertiesBuilder setPhpVisibilityQuery(PhpVisibilityQuery phpVisibilityQuery) {
            this.phpVisibilityQuery = phpVisibilityQuery;
            return this;
        }
    }

    public static final class AdvancedProperties {
        private final InputOutput io;
        private final String additionalInitialSubdirectory;
        private final boolean preservePermissions;
        private final boolean uploadDirectly;
        private final OperationMonitor operationMonitor;
        private final PhpVisibilityQuery phpVisibilityQuery;

        public AdvancedProperties() {
            this(new AdvancedPropertiesBuilder());
        }

        private AdvancedProperties(AdvancedPropertiesBuilder builder) {
            this.io = builder.io;
            this.additionalInitialSubdirectory = builder.additionalInitialSubdirectory;
            this.preservePermissions = builder.preservePermissions;
            this.uploadDirectly = builder.uploadDirectly;
            this.operationMonitor = builder.operationMonitor;
            this.phpVisibilityQuery = builder.phpVisibilityQuery;
        }

        public String getAdditionalInitialSubdirectory() {
            return this.additionalInitialSubdirectory;
        }

        public AdvancedProperties setAdditionalInitialSubdirectory(String additionalInitialSubdirectory) {
            return new AdvancedProperties(new AdvancedPropertiesBuilder(this).setAdditionalInitialSubdirectory(additionalInitialSubdirectory));
        }

        public InputOutput getInputOutput() {
            return this.io;
        }

        public AdvancedProperties setInputOutput(InputOutput io) {
            Parameters.notNull((CharSequence)"io", (Object)io);
            return new AdvancedProperties(new AdvancedPropertiesBuilder(this).setInputOutput(io));
        }

        public OperationMonitor getOperationMonitor() {
            return this.operationMonitor;
        }

        public AdvancedProperties setOperationMonitor(OperationMonitor operationMonitor) {
            Parameters.notNull((CharSequence)"operationMonitor", (Object)operationMonitor);
            return new AdvancedProperties(new AdvancedPropertiesBuilder(this).setOperationMonitor(operationMonitor));
        }

        public boolean isPreservePermissions() {
            return this.preservePermissions;
        }

        public AdvancedProperties setPreservePermissions(boolean preservePermissions) {
            Parameters.notNull((CharSequence)"preservePermissions", (Object)preservePermissions);
            return new AdvancedProperties(new AdvancedPropertiesBuilder(this).setPreservePermissions(preservePermissions));
        }

        public boolean isUploadDirectly() {
            return this.uploadDirectly;
        }

        public AdvancedProperties setUploadDirectly(boolean uploadDirectly) {
            Parameters.notNull((CharSequence)"uploadDirectly", (Object)uploadDirectly);
            return new AdvancedProperties(new AdvancedPropertiesBuilder(this).setUploadDirectly(uploadDirectly));
        }

        public PhpVisibilityQuery getPhpVisibilityQuery() {
            if (this.phpVisibilityQuery != null) {
                return this.phpVisibilityQuery;
            }
            return PhpVisibilityQuery.getDefault();
        }

        public AdvancedProperties setPhpVisibilityQuery(PhpVisibilityQuery phpVisibilityQuery) {
            Parameters.notNull((CharSequence)"phpVisibilityQuery", (Object)phpVisibilityQuery);
            return new AdvancedProperties(new AdvancedPropertiesBuilder(this).setPhpVisibilityQuery(phpVisibilityQuery));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(200);
            sb.append("AdvancedProperties [ io: ");
            sb.append(this.io);
            sb.append(", additionalInitialSubdirectory: ");
            sb.append(this.additionalInitialSubdirectory);
            sb.append(", preservePermissions: ");
            sb.append(this.preservePermissions);
            sb.append(", uploadDirectly: ");
            sb.append(this.uploadDirectly);
            sb.append(", operationMonitor: ");
            sb.append(this.operationMonitor);
            sb.append(", phpVisibilityQuery: ");
            sb.append(this.phpVisibilityQuery);
            sb.append(" ]");
            return sb.toString();
        }
    }

    private static final class DevNullOperationMonitor
    implements OperationMonitor {
        private DevNullOperationMonitor() {
        }

        @Override
        public void operationStart(Operation operation, Collection<TransferFile> forFiles) {
        }

        @Override
        public void operationProcess(Operation operation, TransferFile forFile) {
        }

        @Override
        public void operationFinish(Operation operation, Collection<TransferFile> forFiles) {
        }
    }

    public static interface OperationMonitor {
        public void operationStart(Operation var1, Collection<TransferFile> var2);

        public void operationProcess(Operation var1, TransferFile var2);

        public void operationFinish(Operation var1, Collection<TransferFile> var2);
    }

    public static enum Operation {
        UPLOAD,
        DOWNLOAD,
        DELETE;

    }
}

