<?php

/*
 * Outputs a stacked, filled line graph
 *
 * Variables:
 *   $rrd_list    array   required - array of data sets to graph.  Each item is an array that contains the following
 *          ds        string  required - data set name as defined in rrd
 *          filename  string  required - path to the rrd file as generated by rrd_name()
 *          descr     string  required - the label for this data set
 *          colour    string  optional - Defines the colour for this data set (overrides the overall colour set)
 *          invert    boolean optional - multiplies values in this data set by -1
 *   $colours     string  required - colour set as defined in $config['graph_colours']
 *   $print_total boolean optional - Sum all the values and output the last, min, max, and avg in the legend
 *   $simplerrd   boolean optional - All data sets reside in the same rrd file
 */

require 'includes/graphs/common.inc.php';

if ($width > '500') {
    $descr_len = 24;
} else {
    $descr_len  = 12;
    # FIXME - Presently overflows graph
    #$descr_len += round(($width - 250) / 8);
}

if ($nototal) {
    $descr_len += '2';
    $unitlen  += '2';
}

if ($width > '500') {
    $rrd_options .= " COMMENT:'".substr(str_pad($unit_text, ($descr_len + 5)), 0, ($descr_len + 5))."Now      Min      Max     Avg\l'";
    if (!$nototal) {
        $rrd_options .= " COMMENT:'Total      '";
    }

    $rrd_options .= " COMMENT:'\l'";
} else {
    $rrd_options .= " COMMENT:'".substr(str_pad($unit_text, ($descr_len + 5)), 0, ($descr_len + 5))."Now      Min      Max     Avg\l'";
}

$i    = 0;
$iter = 0;
$ids = array();

foreach ($rrd_list as $rrd) {
    // get the color for this data set
    if (isset($rrd['colour'])) {
        $colour = $rrd['colour'];
    } else {
        if (!$config['graph_colours'][$colours][$iter]) {
            $iter = 0;
        }
        $colour = $config['graph_colours'][$colours][$iter];
        $iter++;
    }

    $ds       = $rrd['ds'];
    $filename = $rrd['filename'];

    $descr = rrdtool_escape($rrd['descr'], $descr_len);

    $ids[] = ($id = 'ds'.$i);

    $rrd_options .= ' DEF:'.$id."=$filename:$ds:AVERAGE";

    if ($simple_rrd) {
        $rrd_options .= ' CDEF:'.$id.'min='.$id.' ';
        $rrd_options .= ' CDEF:'.$id.'max='.$id.' ';
    } else {
        $rrd_options .= ' DEF:'.$id."min=$filename:$ds:MIN";
        $rrd_options .= ' DEF:'.$id."max=$filename:$ds:MAX";
    }

    if ($rrd['invert']) {
        $rrd_options  .= ' CDEF:'.$id.'i='.$id.',-1,*';
        $rrd_optionsc .= ' AREA:'.$id.'i#'.$colour.":'$descr'".$cstack;
        $rrd_optionsc .= ' GPRINT:'.$id.':LAST:%5.1lf%s GPRINT:'.$id.'min:MIN:%5.1lf%s';
        $rrd_optionsc .= ' GPRINT:'.$id.'max:MAX:%5.1lf%s GPRINT:'.$id.":AVERAGE:'%5.1lf%s\\n'";
        $cstack        = ':STACK';
    } else {
        $rrd_optionsb .= ' AREA:'.$id.'#'.$colour.":'$descr'".$bstack;
        $rrd_optionsb .= ' GPRINT:'.$id.':LAST:%5.1lf%s GPRINT:'.$id.'min:MIN:%5.1lf%s';
        $rrd_optionsb .= ' GPRINT:'.$id.'max:MAX:%5.1lf%s GPRINT:'.$id.":AVERAGE:'%5.1lf%s\\n'";
        $bstack        = ':STACK';
    }




    $i++;
}//end foreach

if ($print_total) {
    $tot = $ids;
    for ($i=1; $i<count($ids); $i++) {
        $tot[] = '+';
    }

    $rrd_options .= ' CDEF:tot=' . implode($tot, ',');
    $rrd_options .= ' COMMENT:"  '.rrdtool_escape('Total', $descr_len).'"';
    $rrd_options .= ' GPRINT:tot:LAST:%5.1lf%s';
    $rrd_options .= ' GPRINT:tot:MIN:%5.1lf%s';
    $rrd_options .= ' GPRINT:tot:MAX:%5.1lf%s';
    $rrd_options .= ' GPRINT:tot:AVERAGE:%5.1lf%s\n';
}

$rrd_options .= $rrd_optionsb;
$rrd_options .= ' HRULE:0#555555';
$rrd_options .= $rrd_optionsc;
