/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public final class Logging {
    public static final Level LEVEL_ERROR = Level.SEVERE;
    public static final Level LEVEL_WARN = Level.WARNING;
    public static final Level LEVEL_INFO = Level.INFO;
    public static final Level LEVEL_DEBUG = Level.FINE;
    public static final Level LEVEL_TRACE = Level.FINEST;
    private static final Logger LOGGER = Logger.getAnonymousLogger();
    private static final RememberWarningHandler WARNINGS = new RememberWarningHandler();

    private Logging() {
    }

    public static void setLogLevel(Level level) {
        LOGGER.setLevel(level);
    }

    public static void error(String string) {
        Logging.logPrivate(LEVEL_ERROR, string);
    }

    public static void error(String string, Object ... objectArray) {
        Logging.logPrivate(LEVEL_ERROR, string, objectArray);
    }

    public static void warn(String string) {
        Logging.logPrivate(LEVEL_WARN, string);
    }

    public static void warn(String string, Object ... objectArray) {
        Logging.logPrivate(LEVEL_WARN, string, objectArray);
    }

    public static void info(String string) {
        Logging.logPrivate(LEVEL_INFO, string);
    }

    public static void info(String string, Object ... objectArray) {
        Logging.logPrivate(LEVEL_INFO, string, objectArray);
    }

    public static void debug(String string) {
        Logging.logPrivate(LEVEL_DEBUG, string);
    }

    public static void debug(String string, Object ... objectArray) {
        Logging.logPrivate(LEVEL_DEBUG, string, objectArray);
    }

    public static void trace(String string) {
        Logging.logPrivate(LEVEL_TRACE, string);
    }

    public static void trace(String string, Object ... objectArray) {
        Logging.logPrivate(LEVEL_TRACE, string, objectArray);
    }

    public static void log(Level level, Throwable throwable) {
        Logging.logPrivate(level, () -> Logging.getErrorLog(null, throwable));
    }

    public static void log(Level level, String string, Throwable throwable) {
        Logging.logPrivate(level, () -> Logging.getErrorLog(string, throwable));
    }

    public static void logWithStackTrace(Level level, Throwable throwable) {
        Logging.logPrivate(level, () -> Logging.getErrorLogWithStack(null, throwable));
    }

    public static void logWithStackTrace(Level level, String string, Throwable throwable) {
        Logging.logPrivate(level, () -> Logging.getErrorLogWithStack(string, throwable));
    }

    private static void logPrivate(Level level, String string, Object ... objectArray) {
        Logging.logPrivate(level, () -> MessageFormat.format(string, objectArray));
    }

    private static void logPrivate(Level level, String string) {
        Logging.logPrivate(level, () -> string);
    }

    private static void logPrivate(Level level, Supplier<String> supplier) {
        if (LOGGER.isLoggable(level)) {
            StackTraceElement stackTraceElement = BugReport.getCallingMethod(1, Logging.class.getName(), string -> !"logPrivate".equals(string));
            LOGGER.logp(level, stackTraceElement.getClassName(), stackTraceElement.getMethodName(), supplier);
        }
    }

    public static boolean isLoggingEnabled(Level level) {
        return LOGGER.isLoggable(level);
    }

    private static String getErrorLog(String string, Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            stringBuilder.append(string).append(": ");
        }
        stringBuilder.append(Logging.getErrorMessage(throwable));
        return stringBuilder.toString();
    }

    private static String getErrorLogWithStack(String string, Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        stringWriter.append(Logging.getErrorLog(string, throwable));
        if (throwable != null) {
            stringWriter.append('\n');
            throwable.printStackTrace(new PrintWriter(stringWriter));
        }
        return stringWriter.toString();
    }

    public static String getErrorMessage(Throwable throwable) {
        Throwable throwable2;
        if (throwable == null) {
            return "(no error)";
        }
        StringBuilder stringBuilder = new StringBuilder(throwable.getClass().getName());
        String string = throwable.getMessage();
        if (string != null) {
            stringBuilder.append(": ").append(string.trim());
        }
        if ((throwable2 = throwable.getCause()) != null && !throwable2.equals(throwable)) {
            stringBuilder.append(". ").append(I18n.tr("Cause: ", new Object[0])).append(Logging.getErrorMessage(throwable2));
        }
        return stringBuilder.toString();
    }

    public static void clearLastErrorAndWarnings() {
        WARNINGS.clear();
    }

    public static List<String> getLastErrorAndWarnings() {
        return WARNINGS.getMessages();
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    static {
        LOGGER.setLevel(Level.ALL);
        LOGGER.setUseParentHandlers(false);
        Utils.updateSystemProperty("java.util.logging.SimpleFormatter.format", "%1$tF %1$tT.%1$tL %4$s: %5$s%6$s%n");
        final ConsoleHandler consoleHandler = new ConsoleHandler();
        LOGGER.addHandler(consoleHandler);
        consoleHandler.setLevel(LEVEL_WARN);
        ConsoleHandler consoleHandler2 = new ConsoleHandler(){

            @Override
            protected synchronized void setOutputStream(OutputStream outputStream) {
                super.setOutputStream(System.out);
            }

            @Override
            public void publish(LogRecord logRecord) {
                if (!consoleHandler.isLoggable(logRecord)) {
                    super.publish(logRecord);
                }
            }
        };
        LOGGER.addHandler(consoleHandler2);
        consoleHandler2.setLevel(Level.ALL);
        LOGGER.addHandler(WARNINGS);
    }

    private static class RememberWarningHandler
    extends Handler {
        private final String[] log = new String[10];
        private int messagesLogged;

        RememberWarningHandler() {
            this.setLevel(LEVEL_WARN);
        }

        synchronized void clear() {
            this.messagesLogged = 0;
            Arrays.fill(this.log, null);
        }

        @Override
        public synchronized void publish(LogRecord logRecord) {
            if (!this.isLoggable(logRecord)) {
                return;
            }
            String string = RememberWarningHandler.getPrefix(logRecord) + logRecord.getMessage();
            int n = string.indexOf(10);
            if (n > 0) {
                string = string.substring(0, n);
            }
            this.log[this.messagesLogged % this.log.length] = string;
            ++this.messagesLogged;
        }

        private static String getPrefix(LogRecord logRecord) {
            if (logRecord.getLevel().equals(LEVEL_WARN)) {
                return "W: ";
            }
            return "E: ";
        }

        synchronized List<String> getMessages() {
            List<String> list = Arrays.asList(this.log);
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = this.messagesLogged % this.log.length;
            if (this.messagesLogged > n) {
                arrayList.addAll(list.subList(n, this.log.length));
            }
            arrayList.addAll(list.subList(0, n));
            return arrayList;
        }

        @Override
        public synchronized void flush() {
        }

        @Override
        public void close() {
        }
    }
}

