/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.layer;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.datatransfer.LayerTransferable;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;

public class LayerListTransferHandler
extends TransferHandler {
    @Override
    public int getSourceActions(JComponent jComponent) {
        LayerListDialog.LayerListModel layerListModel = (LayerListDialog.LayerListModel)((JTable)jComponent).getModel();
        if (layerListModel.getSelectedLayers().isEmpty()) {
            return 0;
        }
        int n = 2;
        if (LayerListTransferHandler.onlyDataLayersSelected(layerListModel)) {
            n |= 1;
        }
        return n;
    }

    private static boolean onlyDataLayersSelected(LayerListDialog.LayerListModel layerListModel) {
        for (Layer layer : layerListModel.getSelectedLayers()) {
            if (layer instanceof OsmDataLayer) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        LayerListDialog.LayerListModel layerListModel = (LayerListDialog.LayerListModel)((JTable)jComponent).getModel();
        return new LayerTransferable(layerListModel.getLayerManager(), layerListModel.getSelectedLayers());
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        if (transferSupport.isDrop()) {
            transferSupport.setShowDropLocation(true);
        }
        if (!transferSupport.isDataFlavorSupported(LayerTransferable.LAYER_DATA)) {
            return false;
        }
        return transferSupport.getDropAction() != 0x40000000;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        try {
            boolean bl;
            int n;
            LayerListDialog.LayerListModel layerListModel = (LayerListDialog.LayerListModel)((JTable)transferSupport.getComponent()).getModel();
            LayerTransferable.Data data = (LayerTransferable.Data)transferSupport.getTransferable().getTransferData(LayerTransferable.LAYER_DATA);
            if (transferSupport.isDrop()) {
                JTable.DropLocation dropLocation = (JTable.DropLocation)transferSupport.getDropLocation();
                n = dropLocation.getRow();
            } else {
                n = data.getLayers().get(0).getDefaultLayerPosition().getPosition(data.getManager());
            }
            boolean bl2 = bl = layerListModel.getLayerManager() == data.getManager();
            if (bl && transferSupport.getDropAction() == 2) {
                for (Layer layer : data.getLayers()) {
                    boolean bl3;
                    boolean bl4 = bl3 = data.getManager().getLayers().indexOf(layer) <= n;
                    if (bl3) {
                        --n;
                    }
                    data.getManager().moveLayer(layer, n);
                    ++n;
                }
            } else {
                List<Layer> list = data.getLayers();
                if (transferSupport.getDropAction() == 1) {
                    list = LayerListTransferHandler.createCopy(list, data.getManager().getLayers());
                }
                for (Layer layer : list) {
                    data.getManager().addLayer(layer);
                    data.getManager().moveLayer(layer, n);
                    ++n;
                }
            }
            return true;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            Main.warn("Flavor not supported", unsupportedFlavorException);
            return false;
        }
        catch (IOException iOException) {
            Main.warn("Error while pasting layer", iOException);
            return false;
        }
    }

    private static List<Layer> createCopy(List<Layer> list, List<Layer> list2) {
        List<String> list3 = LayerListTransferHandler.getNames(list2);
        ArrayList<Layer> arrayList = new ArrayList<Layer>();
        for (Layer layer : list) {
            if (!(layer instanceof OsmDataLayer)) continue;
            String string = LayerListTransferHandler.suggestNewLayerName(layer.getName(), list3);
            OsmDataLayer osmDataLayer = new OsmDataLayer(new DataSet(((OsmDataLayer)layer).data), string, null);
            arrayList.add(osmDataLayer);
            list3.add(string);
        }
        return arrayList;
    }

    public static String suggestNewLayerName(String string, List<Layer> list) {
        List<String> list2 = LayerListTransferHandler.getNames(list);
        return LayerListTransferHandler.suggestNewLayerName(string, list2);
    }

    private static List<String> getNames(List<Layer> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Layer layer : list) {
            arrayList.add(layer.getName());
        }
        return arrayList;
    }

    private static String suggestNewLayerName(String string, Collection<String> collection) {
        String string2 = I18n.tr("Copy of {0}", string);
        int n = 2;
        while (collection.contains(string2)) {
            string2 = I18n.tr("Copy {1} of {0}", string, n);
            ++n;
        }
        return string2;
    }
}

