/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Shortcut;

public final class OrthogonalizeAction
extends JosmAction {
    private static final String USAGE = I18n.tr("<h3>When one or more ways are selected, the shape is adjusted such, that all angles are 90 or 180 degrees.</h3>You can add two nodes to the selection. Then, the direction is fixed by these two reference nodes. (Afterwards, you can undo the movement for certain nodes:<br>Select them and press the shortcut for Orthogonalize / Undo. The default is Shift-Q.)", new Object[0]);
    private static final double EPSILON = 1.0E-6;
    private static final double TOLERANCE1 = Math.toRadians(45.0);
    private static final double TOLERANCE2 = Math.toRadians(45.0);
    private static final Map<Node, EastNorth> rememberMovements = new HashMap<Node, EastNorth>();

    public OrthogonalizeAction() {
        super(I18n.tr("Orthogonalize Shape", new Object[0]), "ortho", I18n.tr("Move nodes so all angles are 90 or 180 degrees", new Object[0]), Shortcut.registerShortcut("tools:orthogonalize", I18n.tr("Tool: {0}", I18n.tr("Orthogonalize Shape", new Object[0])), 81, 5003), true);
        this.putValue("help", HelpUtil.ht("/Action/OrthogonalizeShape"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        if (!this.isEnabled()) {
            return;
        }
        if ("EPSG:4326".equals(Main.getProjection().toString()) && !ConditionalOptionPaneUtil.showConfirmationDialog("align_rectangular_4326", Main.parent, object = I18n.tr("<html>You are using the EPSG:4326 projection which might lead<br>to undesirable results when doing rectangular alignments.<br>Change your projection to get rid of this warning.<br>Do you want to continue?</html>", new Object[0]), I18n.tr("Warning", new Object[0]), 0, 3, 0)) {
            return;
        }
        object = this.getLayerManager().getEditDataSet().getSelected();
        try {
            SequenceCommand sequenceCommand = OrthogonalizeAction.orthogonalize((Iterable<OsmPrimitive>)object);
            Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Orthogonalize", new Object[0]), sequenceCommand));
        }
        catch (InvalidUserInputException invalidUserInputException) {
            Main.debug(invalidUserInputException);
            String string = "usage".equals(invalidUserInputException.getMessage()) ? "<h2>" + I18n.tr("Usage", new Object[0]) + "</h2>" + USAGE : invalidUserInputException.getMessage() + "<br><hr><h2>" + I18n.tr("Usage", new Object[0]) + "</h2>" + USAGE;
            new Notification(string).setIcon(1).setDuration(Notification.TIME_DEFAULT).show();
        }
    }

    static SequenceCommand orthogonalize(Iterable<OsmPrimitive> iterable) throws InvalidUserInputException {
        LinkedList<Command> linkedList;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<WayData> arrayList2 = new ArrayList<WayData>();
        for (OsmPrimitive object2 : iterable) {
            if (object2 instanceof Node) {
                arrayList.add((Node)object2);
                continue;
            }
            if (object2 instanceof Way) {
                arrayList2.add(new WayData(((Way)object2).getNodes()));
                continue;
            }
            throw new InvalidUserInputException(I18n.tr("Selection must consist only of ways and nodes.", new Object[0]));
        }
        if (arrayList2.isEmpty() && arrayList.size() > 2) {
            linkedList = new WayData(arrayList);
            Collection<Command> collection = OrthogonalizeAction.orthogonalize(Collections.singletonList(linkedList), Collections.emptyList());
            return new SequenceCommand(I18n.tr("Orthogonalize", new Object[0]), collection);
        }
        if (arrayList2.isEmpty()) {
            throw new InvalidUserInputException("usage");
        }
        if (arrayList.size() == 2 || arrayList.isEmpty()) {
            rememberMovements.clear();
            linkedList = new LinkedList<Command>();
            if (arrayList.size() == 2) {
                linkedList.addAll(OrthogonalizeAction.orthogonalize(arrayList2, arrayList));
            } else if (arrayList.isEmpty()) {
                List<List<WayData>> list = OrthogonalizeAction.buildGroups(arrayList2);
                for (List<WayData> list2 : list) {
                    linkedList.addAll(OrthogonalizeAction.orthogonalize(list2, arrayList));
                }
            } else {
                throw new IllegalStateException();
            }
            return new SequenceCommand(I18n.tr("Orthogonalize", new Object[0]), linkedList);
        }
        throw new InvalidUserInputException("usage");
    }

    private static List<List<WayData>> buildGroups(List<WayData> list) {
        ArrayList<List<WayData>> arrayList = new ArrayList<List<WayData>>();
        HashSet<WayData> hashSet = new HashSet<WayData>(list);
        while (!hashSet.isEmpty()) {
            ArrayList<WayData> arrayList2 = new ArrayList<WayData>();
            arrayList.add(arrayList2);
            Iterator iterator = hashSet.iterator();
            WayData wayData = (WayData)iterator.next();
            iterator.remove();
            OrthogonalizeAction.extendGroupRec(arrayList2, wayData, new ArrayList<WayData>(hashSet));
            hashSet.removeAll(arrayList2);
        }
        return arrayList;
    }

    private static void extendGroupRec(List<WayData> list, WayData wayData, List<WayData> list2) {
        list.add(wayData);
        for (int i = 0; i < list2.size(); ++i) {
            WayData wayData2 = list2.get(i);
            if (wayData2 == null || Collections.disjoint(wayData2.wayNodes, wayData.wayNodes)) continue;
            list2.set(i, null);
            OrthogonalizeAction.extendGroupRec(list, wayData2, list2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Collection<Command> orthogonalize(List<WayData> list, List<Node> list2) throws InvalidUserInputException {
        Direction[][] directionArrayArray;
        double d;
        try {
            if (list2.isEmpty()) {
                void n;
                list.get(0).calcDirections(Direction.RIGHT);
                double d2 = list.get((int)0).heading;
                EastNorth serializable2 = new EastNorth(0.0, 0.0);
                for (WayData wayData : list) {
                    wayData.calcDirections(Direction.RIGHT);
                    int n2 = OrthogonalizeAction.angleToDirectionChange(wayData.heading - d2, TOLERANCE2);
                    wayData.calcDirections(Direction.RIGHT.changeBy(n2));
                    if (OrthogonalizeAction.angleToDirectionChange(d2 - wayData.heading, TOLERANCE2) != 0) {
                        throw new JosmRuntimeException("orthogonalize error");
                    }
                    EastNorth eastNorth = EN.sum((EastNorth)n, wayData.segSum);
                }
                d = EN.polar(new EastNorth(0.0, 0.0), (EastNorth)n);
            } else {
                d = EN.polar(list2.get(0).getEastNorth(), list2.get(1).getEastNorth());
                for (WayData wayData : list) {
                    wayData.calcDirections(Direction.RIGHT);
                    int n = OrthogonalizeAction.angleToDirectionChange(wayData.heading - d, TOLERANCE2);
                    wayData.calcDirections(Direction.RIGHT.changeBy(n));
                }
            }
        }
        catch (RejectedAngleException rejectedAngleException) {
            throw new InvalidUserInputException(I18n.tr("<html>Please make sure all selected ways head in a similar direction<br>or orthogonalize them one by one.</html>", new Object[0]), rejectedAngleException);
        }
        HashSet<Node> hashSet = new HashSet<Node>();
        for (WayData wayData : list) {
            hashSet.addAll(wayData.wayNodes);
        }
        HashMap<Node, Double> hashMap = new HashMap<Node, Double>();
        HashMap<Node, Double> hashMap2 = new HashMap<Node, Double>();
        Object object = new EastNorth(0.0, 0.0);
        for (Node node : hashSet) {
            object = EN.sum((EastNorth)object, node.getEastNorth());
        }
        object = new EastNorth(((EastNorth)object).east() / (double)hashSet.size(), ((EastNorth)object).north() / (double)hashSet.size());
        for (Node node : hashSet) {
            directionArrayArray = EN.rotateCC((EastNorth)object, node.getEastNorth(), -d);
            hashMap.put(node, directionArrayArray.east());
            hashMap2.put(node, directionArrayArray.north());
        }
        Direction[] directionArray = new Direction[]{Direction.RIGHT, Direction.LEFT};
        Direction[] directionArray2 = new Direction[]{Direction.UP, Direction.DOWN};
        directionArrayArray = new Direction[][]{directionArray, directionArray2};
        for (Direction[] directionArray3 : directionArrayArray) {
            HashSet hashSet2 = new HashSet(hashSet);
            int n = hashSet2.size();
            for (int i = 0; i < n && !hashSet2.isEmpty(); ++i) {
                Node node = (Node)hashSet2.iterator().next();
                HashSet<Object> hashSet3 = new HashSet<Object>();
                hashSet3.add(node);
                boolean bl = true;
                while (bl) {
                    bl = false;
                    for (WayData wayData : list) {
                        for (int j = 0; j < wayData.nSeg; ++j) {
                            Iterator iterator = wayData.wayNodes.get(j);
                            Node node2 = wayData.wayNodes.get(j + 1);
                            if (!Arrays.asList(directionArray3).contains((Object)wayData.segDirections[j])) continue;
                            if (hashSet3.contains(iterator) && !hashSet3.contains(node2)) {
                                hashSet3.add(node2);
                                bl = true;
                            }
                            if (!hashSet3.contains(node2) || hashSet3.contains(iterator)) continue;
                            hashSet3.add(iterator);
                            bl = true;
                        }
                    }
                }
                HashMap<Node, Double> hashMap3 = directionArray3 == directionArray ? hashMap2 : hashMap;
                double d2 = 0.0;
                for (Node node3 : hashSet3) {
                    hashSet2.remove(node3);
                    d2 += ((Double)hashMap3.get(node3)).doubleValue();
                }
                d2 /= (double)hashSet3.size();
                for (Node node4 : list2) {
                    if (!hashSet3.contains(node4)) continue;
                    d2 = (Double)hashMap3.get(node4);
                }
                if (directionArray3 == directionArray2 && list2.size() == 2 && hashSet3.containsAll(list2)) continue;
                for (Node node5 : hashSet3) {
                    hashMap3.put(node5, d2);
                }
            }
            if (hashSet2.isEmpty()) continue;
            throw new JosmRuntimeException("orthogonalize error");
        }
        LinkedList linkedList = new LinkedList();
        for (Node node : hashSet) {
            EastNorth eastNorth2 = new EastNorth((Double)hashMap.get(node), (Double)hashMap2.get(node));
            eastNorth2 = EN.rotateCC((EastNorth)object, eastNorth2, d);
            double d3 = eastNorth2.east() - node.getEastNorth().east();
            double d4 = eastNorth2.north() - node.getEastNorth().north();
            if (list2.contains(node)) {
                if (Math.abs(d3) > Math.abs(1.0E-6 * eastNorth2.east()) || Math.abs(d4) > Math.abs(1.0E-6 * eastNorth2.east())) {
                    throw new AssertionError((Object)"heading node has changed");
                }
                continue;
            }
            rememberMovements.put(node, new EastNorth(d3, d4));
            linkedList.add(new MoveCommand((OsmPrimitive)node, d3, d4));
        }
        return linkedList;
    }

    private static double standardAngle0to2PI(double d) {
        while (d >= Math.PI * 2) {
            d -= Math.PI * 2;
        }
        while (d < 0.0) {
            d += Math.PI * 2;
        }
        return d;
    }

    private static double standardAngleMPItoPI(double d) {
        while (d > Math.PI) {
            d -= Math.PI * 2;
        }
        while (d <= -Math.PI) {
            d += Math.PI * 2;
        }
        return d;
    }

    private static int angleToDirectionChange(double d, double d2) throws RejectedAngleException {
        int n;
        d = OrthogonalizeAction.standardAngleMPItoPI(d);
        double d3 = Math.abs(d);
        double d4 = Math.abs(d - 1.5707963267948966);
        double d5 = Math.abs(d + 1.5707963267948966);
        if (d3 < d2) {
            n = 0;
        } else if (d4 < d2) {
            n = 1;
        } else if (d5 < d2) {
            n = -1;
        } else {
            double d6 = Math.abs((d = OrthogonalizeAction.standardAngle0to2PI(d)) - Math.PI);
            if (d6 < d2) {
                n = 2;
            } else {
                throw new RejectedAngleException();
            }
        }
        return n;
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }

    protected static class RejectedAngleException
    extends Exception {
        RejectedAngleException() {
        }
    }

    protected static class InvalidUserInputException
    extends Exception {
        InvalidUserInputException(String string) {
            super(string);
        }

        InvalidUserInputException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    private static final class EN {
        private EN() {
        }

        public static EastNorth rotateCC(EastNorth eastNorth, EastNorth eastNorth2, double d) {
            double d2 = Math.cos(d);
            double d3 = Math.sin(d);
            double d4 = eastNorth2.east() - eastNorth.east();
            double d5 = eastNorth2.north() - eastNorth.north();
            double d6 = d2 * d4 - d3 * d5 + eastNorth.east();
            double d7 = d3 * d4 + d2 * d5 + eastNorth.north();
            return new EastNorth(d6, d7);
        }

        public static EastNorth sum(EastNorth eastNorth, EastNorth eastNorth2) {
            return new EastNorth(eastNorth.east() + eastNorth2.east(), eastNorth.north() + eastNorth2.north());
        }

        public static EastNorth diff(EastNorth eastNorth, EastNorth eastNorth2) {
            return new EastNorth(eastNorth.east() - eastNorth2.east(), eastNorth.north() - eastNorth2.north());
        }

        public static double polar(EastNorth eastNorth, EastNorth eastNorth2) {
            return Math.atan2(eastNorth2.north() - eastNorth.north(), eastNorth2.east() - eastNorth.east());
        }
    }

    private static enum Direction {
        RIGHT,
        UP,
        LEFT,
        DOWN;


        public Direction changeBy(int n) {
            int n2 = (this.ordinal() + n) % 4;
            if (n2 < 0) {
                n2 += 4;
            }
            return Direction.values()[n2];
        }
    }

    private static class WayData {
        public final List<Node> wayNodes;
        public final int nSeg;
        public final int nNode;
        public final Direction[] segDirections;
        public EastNorth segSum;
        public double heading;

        WayData(List<Node> list) {
            this.wayNodes = list;
            this.nNode = list.size();
            this.nSeg = this.nNode - 1;
            this.segDirections = new Direction[this.nSeg];
        }

        public void calcDirections(Direction direction) throws InvalidUserInputException {
            Direction direction2;
            EastNorth[] eastNorthArray = new EastNorth[this.nNode];
            for (int i = 0; i < this.nNode; ++i) {
                eastNorthArray[i] = this.wayNodes.get(i).getEastNorth();
            }
            this.segDirections[0] = direction2 = direction;
            for (int i = 0; i < this.nSeg - 1; ++i) {
                double d = EN.polar(eastNorthArray[i], eastNorthArray[i + 1]);
                double d2 = EN.polar(eastNorthArray[i + 1], eastNorthArray[i + 2]);
                try {
                    direction2 = direction2.changeBy(OrthogonalizeAction.angleToDirectionChange(d2 - d, TOLERANCE1));
                }
                catch (RejectedAngleException rejectedAngleException) {
                    throw new InvalidUserInputException(I18n.tr("Please select ways with angles of approximately 90 or 180 degrees.", new Object[0]), rejectedAngleException);
                }
                this.segDirections[i + 1] = direction2;
            }
            EastNorth eastNorth = new EastNorth(0.0, 0.0);
            EastNorth eastNorth2 = new EastNorth(0.0, 0.0);
            for (int i = 0; i < this.nSeg; ++i) {
                EastNorth eastNorth3 = EN.diff(eastNorthArray[i + 1], eastNorthArray[i]);
                if (this.segDirections[i] == Direction.RIGHT) {
                    eastNorth = EN.sum(eastNorth, eastNorth3);
                    continue;
                }
                if (this.segDirections[i] == Direction.UP) {
                    eastNorth2 = EN.sum(eastNorth2, eastNorth3);
                    continue;
                }
                if (this.segDirections[i] == Direction.LEFT) {
                    eastNorth = EN.diff(eastNorth, eastNorth3);
                    continue;
                }
                if (this.segDirections[i] == Direction.DOWN) {
                    eastNorth2 = EN.diff(eastNorth2, eastNorth3);
                    continue;
                }
                throw new IllegalStateException();
            }
            this.segSum = EN.sum(eastNorth, new EastNorth(eastNorth2.north(), -eastNorth2.east()));
            this.heading = EN.polar(new EastNorth(0.0, 0.0), this.segSum);
        }
    }

    public static class Undo
    extends JosmAction {
        public Undo() {
            super(I18n.tr("Orthogonalize Shape / Undo", new Object[0]), "ortho", I18n.tr("Undo orthogonalization for certain nodes", new Object[0]), Shortcut.registerShortcut("tools:orthogonalizeUndo", I18n.tr("Tool: {0}", I18n.tr("Orthogonalize Shape / Undo", new Object[0])), 81, 5005), true, "action/orthogonalize/undo", true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            LinkedList<Command> linkedList = new LinkedList<Command>();
            Collection<OsmPrimitive> collection = this.getLayerManager().getEditDataSet().getSelected();
            try {
                for (OsmPrimitive osmPrimitive : collection) {
                    if (!(osmPrimitive instanceof Node)) {
                        throw new InvalidUserInputException("selected object is not a node");
                    }
                    Node node = (Node)osmPrimitive;
                    if (!rememberMovements.containsKey(node)) continue;
                    EastNorth eastNorth = (EastNorth)rememberMovements.get(node);
                    linkedList.add(new MoveCommand((OsmPrimitive)node, -eastNorth.east(), -eastNorth.north()));
                    rememberMovements.remove(node);
                }
                if (linkedList.isEmpty()) {
                    throw new InvalidUserInputException("Commands are empty");
                }
                Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Orthogonalize / Undo", new Object[0]), linkedList));
            }
            catch (InvalidUserInputException invalidUserInputException) {
                Main.debug(invalidUserInputException);
                new Notification(I18n.tr("Orthogonalize Shape / Undo<br>Please select nodes that were moved by the previous Orthogonalize Shape action!", new Object[0])).setIcon(1).show();
            }
        }

        @Override
        protected void updateEnabledState() {
            this.updateEnabledStateOnCurrentSelection();
        }

        @Override
        protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
            this.setEnabled(collection != null && !collection.isEmpty());
        }
    }
}

