/*
 * Decompiled with CFR 0.152.
 */
import elements.Window;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import values.BrickColor;
import values.Settings;

public class Game
extends JDialog
implements ActionListener {
    private Settings settings;
    private Window window;

    public Game(JFrame jFrame) {
        super(jFrame);
        this.printJvmDetails();
        this.settings = new Settings();
        BrickColor.init(this.settings.getThemeIndex());
        this.window = new Window(this.settings);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Game.this.window.windowClosing(windowEvent);
                System.exit(0);
            }
        });
        this.setLAF();
        this.setMenu();
        this.start();
    }

    private void printJvmDetails() {
        String string = System.getProperty("java.version");
        String string2 = System.getProperty("java.vendor");
        System.out.println("JVM v" + string + " by " + string2);
    }

    private void start() {
        this.window.activateSlots();
        this.setDefaultCloseOperation(2);
        this.setTitle(this.settings.getString("TITLE"));
        this.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("images/icon.png")).getImage());
        ((JFrame)this.getParent()).setIconImages(this.getIconImages());
        this.setBackground(Settings.BACKGROUND);
        this.setContentPane(this.window);
        this.addWindowListener(this.window);
        this.pack();
        this.addComponentListener(new ComponentAdapter(){
            private int width;
            private int height;
            private int size;
            private Insets insets;
            {
                this.width = Game.this.getWidth();
                this.height = Game.this.getHeight();
            }

            public void componentResized(ComponentEvent componentEvent) {
                this.width = Game.this.getWidth();
                this.height = Game.this.getHeight();
                this.insets = Game.this.getInsets();
                this.width = this.width - this.insets.right - this.insets.left;
                this.height = this.height - this.insets.bottom - this.insets.top - Game.this.getJMenuBar().getHeight();
                this.size = this.height < this.width ? this.height : this.width;
                Settings.setBrickSize(this.size / 16);
                Game.this.window.doResize();
            }
        });
        this.fixWindowSize();
        this.setMinimumSize(this.getSize());
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        try {
            this.window.loadFromFile();
            this.window.updateTitle();
        }
        catch (Exception exception) {
            System.out.println(this.settings.getString("ERROR_LOAD") + " (" + exception.getMessage() + ")");
        }
        this.resize((double)this.settings.getSavedBrickSize() / 30.0);
        this.setVisible(true);
        this.toFront();
    }

    public void fixWindowSize() {
        Insets insets = this.getInsets();
        int n = Settings.getBrickSize() * 16;
        int n2 = Settings.getBrickSize() * 16;
        this.setSize(n + insets.left + insets.right, n2 + insets.top + insets.bottom + this.getJMenuBar().getHeight());
    }

    private void setLAF() {
        try {
            String string = this.settings.getLaF();
            UIManager.setLookAndFeel(string);
        }
        catch (Exception exception) {
            System.out.println(this.settings.getString("ERROR_LAF"));
        }
    }

    private void setMenu() {
        Integer n;
        Serializable serializable;
        this.setJMenuBar(this.settings.getMenu());
        this.settings.getMenu().setBackground(Settings.BACKGROUND);
        this.settings.getMenu().setBorderPainted(false);
        JMenu jMenu = new JMenu(this.settings.getString("MENU_GAME"));
        jMenu.setForeground(Color.lightGray);
        this.settings.getMenu().add(jMenu);
        JMenuItem jMenuItem = new JMenuItem(this.settings.getString("MENU_GAME_NEW"), 78);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        jMenuItem.addActionListener(this.window);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.settings.getString("MENU_GAME_UNDO"), 90);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        jMenuItem.addActionListener(this.window);
        jMenuItem.setEnabled(false);
        jMenu.add(jMenuItem);
        this.settings.setUndo(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(this.settings.getString("MENU_GAME_SAVE"), 83);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        jMenuItem.addActionListener(this.window);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenu(this.settings.getString("MENU_GAME_SAVE_SLOT"));
        jMenuItem.addActionListener(this.window);
        jMenu.add(jMenuItem);
        Serializable serializable2 = Integer.valueOf(1);
        while ((Integer)serializable2 <= 5) {
            serializable = new JMenuItem(this.settings.getString("MENU_GAME_SLOT") + " " + serializable2);
            ((Component)serializable).setName(this.settings.getString("MENU_GAME_SAVE_SLOT") + " " + serializable2);
            ((AbstractButton)serializable).addActionListener(this.window);
            jMenuItem.add((Component)serializable);
            this.window.addSaveSlot((JMenuItem)serializable);
            serializable = serializable2;
            serializable2 = Integer.valueOf((Integer)serializable2 + 1);
            n = serializable2;
        }
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(this.settings.getString("MENU_GAME_LOAD"), 76);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        jMenuItem.addActionListener(this.window);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenu(this.settings.getString("MENU_GAME_LOAD_SLOT"));
        jMenuItem.addActionListener(this.window);
        jMenu.add(jMenuItem);
        serializable2 = Integer.valueOf(1);
        while ((Integer)serializable2 <= 5) {
            serializable = new JMenuItem(this.settings.getString("MENU_GAME_SLOT") + " " + serializable2);
            ((Component)serializable).setName(this.settings.getString("MENU_GAME_LOAD_SLOT") + " " + serializable2);
            ((AbstractButton)serializable).addActionListener(this.window);
            jMenuItem.add((Component)serializable);
            this.window.addLoadSlot((JMenuItem)serializable);
            serializable = serializable2;
            serializable2 = Integer.valueOf((Integer)serializable2 + 1);
            n = serializable2;
        }
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(this.settings.getString("MENU_GAME_OPTIONS"), 80);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        jMenuItem.addActionListener(this.window);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(this.settings.getString("MENU_GAME_SIZE1"), 49);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(49, 8));
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.settings.getString("MENU_GAME_SIZE2"), 50);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(50, 8));
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.settings.getString("MENU_GAME_SIZE3"), 51);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(51, 8));
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(this.settings.getString("MENU_GAME_EXIT"), 88);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        jMenuItem.addActionListener(this.window);
        jMenu.add(jMenuItem);
        serializable2 = new JMenu(this.settings.getString("MENU_ABOUT"));
        ((JComponent)serializable2).setForeground(Color.lightGray);
        this.settings.getMenu().add((JMenu)serializable2);
        jMenuItem = new JMenuItem(this.settings.getString("MENU_ABOUT_HIGHSCORES"), 72);
        jMenuItem.addActionListener(this.window);
        ((JMenu)serializable2).add(jMenuItem);
        jMenuItem = new JMenuItem(this.settings.getString("MENU_ABOUT_GAME"), 71);
        jMenuItem.addActionListener(this.window);
        ((JMenu)serializable2).add(jMenuItem);
    }

    private void resize(double d) {
        Insets insets = this.getInsets();
        int n = (int)this.getBounds().getX();
        int n2 = (int)this.getBounds().getY();
        int n3 = 480;
        n3 = (int)((double)n3 * d);
        this.setBounds(n, n2, n3 + insets.left + insets.right, n3 + insets.top + insets.bottom + this.getJMenuBar().getHeight());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().getClass().isAssignableFrom(JMenuItem.class)) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getText();
            if (string.equals(this.settings.getString("MENU_GAME_SIZE1"))) {
                this.resize(1.0);
                return;
            }
            if (string.equals(this.settings.getString("MENU_GAME_SIZE2"))) {
                this.resize(1.25);
                return;
            }
            if (string.equals(this.settings.getString("MENU_GAME_SIZE3"))) {
                this.resize(1.5);
            }
        }
    }
}

