#!/bin/sh
export PATH='/usr/obj/ports/hs-hedis-0.9.7/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: hedis
version: 0.9.7
id: hedis-0.9.7-00e0501b38525ba37d5508fc31e05986
key: hedis_HlfthfxFu425afqfHlPOQo
license: BSD3
copyright: Copyright (c) 2011 Falko Peters
maintainer: Kostiantyn Rybnikov <k-bx@k-bx.com>
homepage: https://github.com/informatikr/hedis
synopsis: Client library for the Redis datastore: supports full command set,
          pipelining.
description:
    Redis is an open source, advanced key-value store. It is often referred to
    as a data structure server since keys can contain strings, hashes, lists,
    sets and sorted sets. This library is a Haskell client for the Redis
    datastore. Compared to other Haskell client libraries it has some
    advantages:
    .
    [Compatibility with Latest Stable Redis:] Hedis is intended
    to be used with the latest stable version of Redis (currently 3.2).
    Most redis commands (<http://redis.io/commands>) are available as
    haskell functions, although MONITOR and SYNC are intentionally
    omitted. Additionally, a low-level API is
    exposed that  makes it easy for the library user to implement further
    commands, such as new commands from an experimental Redis version.
    .
    [Automatic Optimal Pipelining:] Commands are pipelined
    (<http://redis.io/topics/pipelining>) as much as possible without any
    work by the user. See
    <http://informatikr.com/2012/redis-pipelining.html> for a
    technical explanation of automatic optimal pipelining.
    .
    [Enforced Pub\/Sub semantics:] When subscribed to the Redis Pub\/Sub server
    (<http://redis.io/topics/pubsub>), clients are not allowed to issue
    commands other than subscribing to or unsubscribing from channels. This
    library uses the type system to enforce the correct behavior.
    .
    [Connect via TCP or Unix Domain Socket:] TCP sockets are the default way to
    connect to a Redis server. For connections to a server on the same
    machine, Unix domain sockets offer higher performance than the standard
    TCP connection.
    .
    For detailed documentation, see the "Database.Redis" module.
    .
category: Database
author: Falko Peters <falko.peters@gmail.com>
exposed: True
exposed-modules:
    Database.Redis
hidden-modules: Database.Redis.Core
                Database.Redis.ProtocolPipelining Database.Redis.Protocol
                Database.Redis.PubSub Database.Redis.Transactions
                Database.Redis.Types Database.Redis.Commands
                Database.Redis.ManualCommands
trusted: False
import-dirs: /usr/local/lib/ghc/hedis-0.9.7
library-dirs: /usr/local/lib/ghc/hedis-0.9.7
data-dir: /usr/local/share/hs-hedis-0.9.7
hs-libraries: HShedis-0.9.7-HlfthfxFu425afqfHlPOQo
depends:
    async-2.1.0-db22393651203be429cac4ac0146df5f
    base-4.8.2.0-6d41353bf1900ecbb9b02a306c286c36
    bytestring-0.10.6.0-0aa78e663f1d7b0d4f434cabb130075c
    bytestring-lexing-0.5.0.2-1105d35b64ccd4cc85542d94df1bc249
    deepseq-1.4.1.1-7c4279727854e7903ef5ae9e7eb525a5
    mtl-2.2.1-05005bb32df8fbad260aa2bc8c4b64aa
    network-2.6.2.1-3b665743d23d24bea9ea15fe12214a85
    resource-pool-0.2.1.1-0ee20e750de8ba030c9ee03cc43775fe
    scanner-0.2-4aee23d2c27707df5e6ba3b6a069a3b5
    stm-2.4.4-6daf3e3a9d54ebee7d9ac7589c1eeb30
    text-1.2.1.3-b81318aa9c5f332f4a693000ebc8a335
    time-1.5.0.1-7f6e7d3125c12e9efdc302bc6ee0a210
    unordered-containers-0.2.5.1-b2aacfb1d76cc25f280714e3d5d12fef
    vector-0.11.0.0-038317210aedffb94db1b450a91d7de1
haddock-interfaces: /usr/local/share/doc/hs-hedis-0.9.7/html/hedis.haddock
haddock-html: /usr/local/share/doc/hs-hedis-0.9.7/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
