#!/bin/sh
export PATH='/usr/obj/ports/hs-dbus-0.10.12/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: dbus
version: 0.10.12
id: dbus-0.10.12-5a31a2298f2b83a4ca917a6fc2365c54
key: dbus_DBnqWRFYSDCGATcO6p8Nya
license: GPL-3
maintainer: John Millikin <john@john-millikin.com>
stability: experimental
homepage: https://john-millikin.com/software/haskell-dbus/
synopsis: A client library for the D-Bus IPC system.
description:
    D-Bus is a simple, message-based protocol for inter-process
    communication, which allows applications to interact with other parts of
    the machine and the user'\''s session using remote procedure calls.
    .
    D-Bus is a essential part of the modern Linux desktop, where it replaces
    earlier protocols such as CORBA and DCOP.
    .
    This library is an implementation of the D-Bus protocol in Haskell. It
    can be used to add D-Bus support to Haskell applications, without the
    awkward interfaces common to foreign bindings.
    .
    Example: connect to the session bus, and get a list of active names.
    .
    @
    &#x7b;-\# LANGUAGE OverloadedStrings \#-&#x7d;
    .
    import Data.List (sort)
    import DBus
    import DBus.Client
    .
    main = do
    &#x20;   client <- connectSession
    &#x20;   //
    &#x20;   \-- Request a list of connected clients from the bus
    &#x20;   reply <- call_ client (methodCall \"\/org\/freedesktop\/DBus\" \"org.freedesktop.DBus\" \"ListNames\")
    &#x20;       &#x7b; methodCallDestination = Just \"org.freedesktop.DBus\"
    &#x20;       &#x7d;
    &#x20;   //
    &#x20;   \-- org.freedesktop.DBus.ListNames() returns a single value, which is
    &#x20;   \-- a list of names (here represented as [String])
    &#x20;   let Just names = fromVariant (methodReturnBody reply !! 0)
    &#x20;   //
    &#x20;   \-- Print each name on a line, sorted so reserved names are below
    &#x20;   \-- temporary names.
    &#x20;   mapM_ putStrLn (sort names)
    @
    .
    >$ ghc --make list-names.hs
    >$ ./list-names
    >:1.0
    >:1.1
    >:1.10
    >:1.106
    >:1.109
    >:1.110
    >ca.desrt.dconf
    >org.freedesktop.DBus
    >org.freedesktop.Notifications
    >org.freedesktop.secrets
    >org.gnome.ScreenSaver
category: Network, Desktop
author: John Millikin <john@john-millikin.com>
exposed: True
exposed-modules:
    DBus DBus.Client DBus.Introspection DBus.Socket DBus.Transport
hidden-modules: DBus.Address DBus.Message DBus.Types DBus.Wire
trusted: False
import-dirs: /usr/local/lib/ghc/dbus-0.10.12
library-dirs: /usr/local/lib/ghc/dbus-0.10.12
data-dir: /usr/local/share/hs-dbus-0.10.12
hs-libraries: HSdbus-0.10.12-DBnqWRFYSDCGATcO6p8Nya
depends:
    base-4.8.2.0-6d41353bf1900ecbb9b02a306c286c36
    bytestring-0.10.6.0-0aa78e663f1d7b0d4f434cabb130075c
    cereal-0.4.1.0-7d381ec81cd00a9ccdaa13b77e9ebf00
    containers-0.5.6.2-72662c7d6dea4fa8c95128efb85ebc60
    libxml-sax-0.7.5-816104299289914989e2d885e0bfe928
    network-2.6.2.1-3b665743d23d24bea9ea15fe12214a85
    parsec-3.1.9-0bc62b5601d05cd60af5b5aa86497840
    random-1.1-29ff1dff757b7db4e436b4cdcc22a979
    text-1.2.1.3-b81318aa9c5f332f4a693000ebc8a335
    transformers-0.4.2.0-a5bbd954d1c2451a9da96a3615054cc0
    unix-2.7.1.0-85db450d00e9ff06d3c7b98547c203ce
    vector-0.11.0.0-038317210aedffb94db1b450a91d7de1
    xml-types-0.3.6-8dc9287ff5f359f6503e5d06849b8058
haddock-interfaces: /usr/local/share/doc/hs-dbus-0.10.12/html/dbus.haddock
haddock-html: /usr/local/share/doc/hs-dbus-0.10.12/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
