/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import gnu.gcj.RawData;
import java.nio.Buffer;
import java.nio.ByteOrder;
import java.nio.DoubleBufferImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DoubleBuffer
extends Buffer
implements Comparable<DoubleBuffer> {
    final int array_offset;
    final double[] backing_buffer;

    DoubleBuffer(int capacity, int limit, int position, int mark, RawData address, double[] backing_buffer, int array_offset) {
        super(capacity, limit, position, mark, address);
        this.backing_buffer = backing_buffer;
        this.array_offset = array_offset;
    }

    public static DoubleBuffer allocate(int capacity) {
        return new DoubleBufferImpl(capacity);
    }

    public static final DoubleBuffer wrap(double[] array, int offset, int length) {
        return new DoubleBufferImpl(array, 0, array.length, offset + length, offset, -1, false);
    }

    public static final DoubleBuffer wrap(double[] array) {
        return DoubleBuffer.wrap(array, 0, array.length);
    }

    public DoubleBuffer get(double[] dst, int offset, int length) {
        DoubleBuffer.checkArraySize(dst.length, offset, length);
        this.checkForUnderflow(length);
        int i = offset;
        while (i < offset + length) {
            dst[i] = this.get();
            ++i;
        }
        return this;
    }

    public DoubleBuffer get(double[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public DoubleBuffer put(DoubleBuffer src) {
        if (src == this) {
            throw new IllegalArgumentException();
        }
        this.checkForOverflow(src.remaining());
        if (src.remaining() > 0) {
            double[] toPut = new double[src.remaining()];
            src.get(toPut);
            this.put(toPut);
        }
        return this;
    }

    public DoubleBuffer put(double[] src, int offset, int length) {
        DoubleBuffer.checkArraySize(src.length, offset, length);
        this.checkForOverflow(length);
        int i = offset;
        while (i < offset + length) {
            this.put(src[i]);
            ++i;
        }
        return this;
    }

    public final DoubleBuffer put(double[] src) {
        return this.put(src, 0, src.length);
    }

    public final boolean hasArray() {
        return this.backing_buffer != null && !this.isReadOnly();
    }

    public final double[] array() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        this.checkIfReadOnly();
        return this.backing_buffer;
    }

    public final int arrayOffset() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        this.checkIfReadOnly();
        return this.array_offset;
    }

    public int hashCode() {
        long hashCode = Double.doubleToLongBits(this.get(this.position())) + 31L;
        long multiplier = 1L;
        int i = this.position() + 1;
        while (i < this.limit()) {
            hashCode += (Double.doubleToLongBits(this.get(i)) + 30L) * (multiplier *= 31L);
            ++i;
        }
        return (int)hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DoubleBuffer) {
            return this.compareTo((DoubleBuffer)obj) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(DoubleBuffer other) {
        int num = Math.min(this.remaining(), other.remaining());
        int pos_this = this.position();
        int pos_other = other.position();
        int count = 0;
        while (count < num) {
            double b;
            double a;
            if ((a = this.get(pos_this++)) != (b = other.get(pos_other++))) {
                if (a < b) {
                    return -1;
                }
                return 1;
            }
            ++count;
        }
        return this.remaining() - other.remaining();
    }

    public abstract ByteOrder order();

    public abstract double get();

    public abstract DoubleBuffer put(double var1);

    public abstract double get(int var1);

    public abstract DoubleBuffer put(int var1, double var2);

    public abstract DoubleBuffer compact();

    public abstract boolean isDirect();

    public abstract DoubleBuffer slice();

    public abstract DoubleBuffer duplicate();

    public abstract DoubleBuffer asReadOnlyBuffer();
}

