/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.functionscore;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;
import org.elasticsearch.common.lucene.search.function.ScriptScoreFunction;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.functionscore.ScoreFunctionBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.SearchScript;

public class ScriptScoreFunctionBuilder
extends ScoreFunctionBuilder<ScriptScoreFunctionBuilder> {
    public static final String NAME = "script_score";
    private final Script script;

    public ScriptScoreFunctionBuilder(Script script) {
        if (script == null) {
            throw new IllegalArgumentException("script must not be null");
        }
        this.script = script;
    }

    public ScriptScoreFunctionBuilder(StreamInput in) throws IOException {
        super(in);
        this.script = new Script(in);
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        this.script.writeTo(out);
    }

    public Script getScript() {
        return this.script;
    }

    @Override
    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        builder.field(Script.SCRIPT_PARSE_FIELD.getPreferredName(), this.script);
        builder.endObject();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected boolean doEquals(ScriptScoreFunctionBuilder functionBuilder) {
        return Objects.equals(this.script, functionBuilder.script);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.script);
    }

    @Override
    protected ScoreFunction doToFunction(QueryShardContext context) {
        try {
            SearchScript searchScript = context.getSearchScript(this.script, ScriptContext.Standard.SEARCH);
            return new ScriptScoreFunction(this.script, searchScript);
        }
        catch (Exception e) {
            throw new QueryShardException(context, "script_score: the script could not be loaded", e, new Object[0]);
        }
    }

    public static ScriptScoreFunctionBuilder fromXContent(QueryParseContext parseContext) throws IOException, ParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        Script script = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (Script.SCRIPT_PARSE_FIELD.match(currentFieldName)) {
                script = Script.parse(parser, parseContext.getParseFieldMatcher(), parseContext.getDefaultScriptLanguage());
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "script_score query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (script == null) {
            throw new ParsingException(parser.getTokenLocation(), "script_score requires 'script' field", new Object[0]);
        }
        return new ScriptScoreFunctionBuilder(script);
    }
}

