/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.apache.lucene.queries.ExtendedCommonTermsQuery;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.GraphQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.support.QueryParsers;
import org.elasticsearch.index.search.MatchQuery;

public class MatchQueryBuilder
extends AbstractQueryBuilder<MatchQueryBuilder> {
    public static final ParseField SLOP_FIELD = new ParseField("slop", "phrase_slop").withAllDeprecated("match_phrase query");
    public static final ParseField ZERO_TERMS_QUERY_FIELD = new ParseField("zero_terms_query", new String[0]);
    public static final ParseField CUTOFF_FREQUENCY_FIELD = new ParseField("cutoff_frequency", new String[0]);
    public static final ParseField LENIENT_FIELD = new ParseField("lenient", new String[0]);
    public static final ParseField FUZZY_TRANSPOSITIONS_FIELD = new ParseField("fuzzy_transpositions", new String[0]);
    public static final ParseField FUZZY_REWRITE_FIELD = new ParseField("fuzzy_rewrite", new String[0]);
    public static final ParseField MINIMUM_SHOULD_MATCH_FIELD = new ParseField("minimum_should_match", new String[0]);
    public static final ParseField OPERATOR_FIELD = new ParseField("operator", new String[0]);
    public static final ParseField MAX_EXPANSIONS_FIELD = new ParseField("max_expansions", new String[0]);
    public static final ParseField PREFIX_LENGTH_FIELD = new ParseField("prefix_length", new String[0]);
    public static final ParseField ANALYZER_FIELD = new ParseField("analyzer", new String[0]);
    public static final ParseField TYPE_FIELD = new ParseField("type", new String[0]).withAllDeprecated("match_phrase and match_phrase_prefix query");
    public static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    public static final String NAME = "match";
    public static final ParseField QUERY_NAME_FIELD = new ParseField("match", "match_fuzzy", "fuzzy_match");
    public static final Operator DEFAULT_OPERATOR = Operator.OR;
    @Deprecated
    public static final MatchQuery.Type DEFAULT_TYPE = MatchQuery.Type.BOOLEAN;
    private final String fieldName;
    private final Object value;
    @Deprecated
    private MatchQuery.Type type = DEFAULT_TYPE;
    private Operator operator = DEFAULT_OPERATOR;
    private String analyzer;
    @Deprecated
    private int slop = 0;
    private Fuzziness fuzziness = null;
    private int prefixLength = 0;
    private int maxExpansions = 50;
    private boolean fuzzyTranspositions = true;
    private String minimumShouldMatch;
    private String fuzzyRewrite = null;
    private boolean lenient = false;
    private MatchQuery.ZeroTermsQuery zeroTermsQuery = MatchQuery.DEFAULT_ZERO_TERMS_QUERY;
    private Float cutoffFrequency = null;

    public MatchQueryBuilder(String fieldName, Object value) {
        if (fieldName == null) {
            throw new IllegalArgumentException("[match] requires fieldName");
        }
        if (value == null) {
            throw new IllegalArgumentException("[match] requires query value");
        }
        this.fieldName = fieldName;
        this.value = value;
    }

    public MatchQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.value = in.readGenericValue();
        this.type = MatchQuery.Type.readFromStream(in);
        this.operator = Operator.readFromStream(in);
        this.slop = in.readVInt();
        this.prefixLength = in.readVInt();
        this.maxExpansions = in.readVInt();
        this.fuzzyTranspositions = in.readBoolean();
        this.lenient = in.readBoolean();
        this.zeroTermsQuery = MatchQuery.ZeroTermsQuery.readFromStream(in);
        this.analyzer = in.readOptionalString();
        this.minimumShouldMatch = in.readOptionalString();
        this.fuzzyRewrite = in.readOptionalString();
        this.fuzziness = in.readOptionalWriteable(Fuzziness::new);
        this.cutoffFrequency = in.readOptionalFloat();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeGenericValue(this.value);
        this.type.writeTo(out);
        this.operator.writeTo(out);
        out.writeVInt(this.slop);
        out.writeVInt(this.prefixLength);
        out.writeVInt(this.maxExpansions);
        out.writeBoolean(this.fuzzyTranspositions);
        out.writeBoolean(this.lenient);
        this.zeroTermsQuery.writeTo(out);
        out.writeOptionalString(this.analyzer);
        out.writeOptionalString(this.minimumShouldMatch);
        out.writeOptionalString(this.fuzzyRewrite);
        out.writeOptionalWriteable(this.fuzziness);
        out.writeOptionalFloat(this.cutoffFrequency);
    }

    public String fieldName() {
        return this.fieldName;
    }

    public Object value() {
        return this.value;
    }

    @Deprecated
    public MatchQueryBuilder type(MatchQuery.Type type) {
        if (type == null) {
            throw new IllegalArgumentException("[match] requires type to be non-null");
        }
        this.type = type;
        return this;
    }

    @Deprecated
    public MatchQuery.Type type() {
        return this.type;
    }

    public MatchQueryBuilder operator(Operator operator) {
        if (operator == null) {
            throw new IllegalArgumentException("[match] requires operator to be non-null");
        }
        this.operator = operator;
        return this;
    }

    public Operator operator() {
        return this.operator;
    }

    public MatchQueryBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public String analyzer() {
        return this.analyzer;
    }

    @Deprecated
    public MatchQueryBuilder slop(int slop) {
        if (slop < 0) {
            throw new IllegalArgumentException("No negative slop allowed.");
        }
        this.slop = slop;
        return this;
    }

    @Deprecated
    public int slop() {
        return this.slop;
    }

    public MatchQueryBuilder fuzziness(Object fuzziness) {
        this.fuzziness = Fuzziness.build(fuzziness);
        return this;
    }

    public Fuzziness fuzziness() {
        return this.fuzziness;
    }

    public MatchQueryBuilder prefixLength(int prefixLength) {
        if (prefixLength < 0) {
            throw new IllegalArgumentException("[match] requires prefix length to be non-negative.");
        }
        this.prefixLength = prefixLength;
        return this;
    }

    public int prefixLength() {
        return this.prefixLength;
    }

    public MatchQueryBuilder maxExpansions(int maxExpansions) {
        if (maxExpansions <= 0) {
            throw new IllegalArgumentException("[match] requires maxExpansions to be positive.");
        }
        this.maxExpansions = maxExpansions;
        return this;
    }

    public int maxExpansions() {
        return this.maxExpansions;
    }

    public MatchQueryBuilder cutoffFrequency(float cutoff) {
        this.cutoffFrequency = Float.valueOf(cutoff);
        return this;
    }

    public Float cutoffFrequency() {
        return this.cutoffFrequency;
    }

    public MatchQueryBuilder minimumShouldMatch(String minimumShouldMatch) {
        this.minimumShouldMatch = minimumShouldMatch;
        return this;
    }

    public String minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    public MatchQueryBuilder fuzzyRewrite(String fuzzyRewrite) {
        this.fuzzyRewrite = fuzzyRewrite;
        return this;
    }

    public String fuzzyRewrite() {
        return this.fuzzyRewrite;
    }

    public MatchQueryBuilder fuzzyTranspositions(boolean fuzzyTranspositions) {
        this.fuzzyTranspositions = fuzzyTranspositions;
        return this;
    }

    public boolean fuzzyTranspositions() {
        return this.fuzzyTranspositions;
    }

    @Deprecated
    public MatchQueryBuilder setLenient(boolean lenient) {
        return this.lenient(lenient);
    }

    public MatchQueryBuilder lenient(boolean lenient) {
        this.lenient = lenient;
        return this;
    }

    public boolean lenient() {
        return this.lenient;
    }

    public MatchQueryBuilder zeroTermsQuery(MatchQuery.ZeroTermsQuery zeroTermsQuery) {
        if (zeroTermsQuery == null) {
            throw new IllegalArgumentException("[match] requires zeroTermsQuery to be non-null");
        }
        this.zeroTermsQuery = zeroTermsQuery;
        return this;
    }

    public MatchQuery.ZeroTermsQuery zeroTermsQuery() {
        return this.zeroTermsQuery;
    }

    @Override
    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startObject(this.fieldName);
        builder.field(QUERY_FIELD.getPreferredName(), this.value);
        if (this.type != MatchQuery.Type.BOOLEAN) {
            builder.field(TYPE_FIELD.getPreferredName(), this.type.toString().toLowerCase(Locale.ENGLISH));
        }
        builder.field(OPERATOR_FIELD.getPreferredName(), this.operator.toString());
        if (this.analyzer != null) {
            builder.field(ANALYZER_FIELD.getPreferredName(), this.analyzer);
        }
        if (this.slop != 0) {
            builder.field(SLOP_FIELD.getPreferredName(), this.slop);
        }
        if (this.fuzziness != null) {
            this.fuzziness.toXContent(builder, params);
        }
        builder.field(PREFIX_LENGTH_FIELD.getPreferredName(), this.prefixLength);
        builder.field(MAX_EXPANSIONS_FIELD.getPreferredName(), this.maxExpansions);
        if (this.minimumShouldMatch != null) {
            builder.field(MINIMUM_SHOULD_MATCH_FIELD.getPreferredName(), this.minimumShouldMatch);
        }
        if (this.fuzzyRewrite != null) {
            builder.field(FUZZY_REWRITE_FIELD.getPreferredName(), this.fuzzyRewrite);
        }
        builder.field(FUZZY_TRANSPOSITIONS_FIELD.getPreferredName(), this.fuzzyTranspositions);
        builder.field(LENIENT_FIELD.getPreferredName(), this.lenient);
        builder.field(ZERO_TERMS_QUERY_FIELD.getPreferredName(), this.zeroTermsQuery.toString());
        if (this.cutoffFrequency != null) {
            builder.field(CUTOFF_FREQUENCY_FIELD.getPreferredName(), this.cutoffFrequency);
        }
        this.printBoostAndQueryName(builder);
        builder.endObject();
        builder.endObject();
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        if (this.analyzer != null && context.getIndexAnalyzers().get(this.analyzer) == null) {
            throw new QueryShardException(context, "[match] analyzer [" + this.analyzer + "] not found", new Object[0]);
        }
        MatchQuery matchQuery = new MatchQuery(context);
        matchQuery.setOccur(this.operator.toBooleanClauseOccur());
        matchQuery.setAnalyzer(this.analyzer);
        matchQuery.setPhraseSlop(this.slop);
        matchQuery.setFuzziness(this.fuzziness);
        matchQuery.setFuzzyPrefixLength(this.prefixLength);
        matchQuery.setMaxExpansions(this.maxExpansions);
        matchQuery.setTranspositions(this.fuzzyTranspositions);
        matchQuery.setFuzzyRewriteMethod(QueryParsers.parseRewriteMethod(this.fuzzyRewrite, null));
        matchQuery.setLenient(this.lenient);
        matchQuery.setCommonTermsCutoff(this.cutoffFrequency);
        matchQuery.setZeroTermsQuery(this.zeroTermsQuery);
        Query query = matchQuery.parse(this.type, this.fieldName, this.value);
        if (query == null) {
            return null;
        }
        if (query instanceof BooleanQuery && !((BooleanQuery)query).isCoordDisabled()) {
            query = Queries.applyMinimumShouldMatch((BooleanQuery)query, this.minimumShouldMatch);
        } else if (query instanceof GraphQuery && ((GraphQuery)query).hasBoolean()) {
            List oldQueries = ((GraphQuery)query).getQueries();
            Query[] queries = new Query[oldQueries.size()];
            for (int i = 0; i < queries.length; ++i) {
                Query oldQuery = (Query)oldQueries.get(i);
                queries[i] = oldQuery instanceof BooleanQuery ? Queries.applyMinimumShouldMatch((BooleanQuery)oldQuery, this.minimumShouldMatch) : oldQuery;
            }
            query = new GraphQuery(queries);
        } else if (query instanceof ExtendedCommonTermsQuery) {
            ((ExtendedCommonTermsQuery)query).setLowFreqMinimumNumberShouldMatch(this.minimumShouldMatch);
        }
        return query;
    }

    @Override
    protected boolean doEquals(MatchQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.value, other.value) && Objects.equals(this.type, other.type) && Objects.equals(this.operator, other.operator) && Objects.equals(this.analyzer, other.analyzer) && Objects.equals(this.slop, other.slop) && Objects.equals(this.fuzziness, other.fuzziness) && Objects.equals(this.prefixLength, other.prefixLength) && Objects.equals(this.maxExpansions, other.maxExpansions) && Objects.equals(this.minimumShouldMatch, other.minimumShouldMatch) && Objects.equals(this.fuzzyRewrite, other.fuzzyRewrite) && Objects.equals(this.lenient, other.lenient) && Objects.equals(this.fuzzyTranspositions, other.fuzzyTranspositions) && Objects.equals(this.zeroTermsQuery, other.zeroTermsQuery) && Objects.equals(this.cutoffFrequency, other.cutoffFrequency);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.fieldName, this.value, this.type, this.operator, this.analyzer, this.slop, this.fuzziness, this.prefixLength, this.maxExpansions, this.minimumShouldMatch, this.fuzzyRewrite, this.lenient, this.fuzzyTranspositions, this.zeroTermsQuery, this.cutoffFrequency);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    public static Optional<MatchQueryBuilder> fromXContent(QueryParseContext parseContext) throws IOException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String fieldName = null;
        MatchQuery.Type type = MatchQuery.Type.BOOLEAN;
        Object value = null;
        float boost = 1.0f;
        String minimumShouldMatch = null;
        String analyzer = null;
        Operator operator = DEFAULT_OPERATOR;
        int slop = 0;
        Fuzziness fuzziness = null;
        int prefixLength = 0;
        int maxExpansion = 50;
        boolean fuzzyTranspositions = true;
        String fuzzyRewrite = null;
        boolean lenient = false;
        Float cutOffFrequency = null;
        MatchQuery.ZeroTermsQuery zeroTermsQuery = MatchQuery.DEFAULT_ZERO_TERMS_QUERY;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (parseContext.isDeprecatedSetting(currentFieldName)) continue;
            if (token == XContentParser.Token.START_OBJECT) {
                MatchQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, currentFieldName);
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (token.isValue()) {
                        if (QUERY_FIELD.match(currentFieldName)) {
                            value = parser.objectText();
                            continue;
                        }
                        if (TYPE_FIELD.match(currentFieldName)) {
                            String tStr = parser.text();
                            if ("boolean".equals(tStr)) {
                                type = MatchQuery.Type.BOOLEAN;
                                continue;
                            }
                            if ("phrase".equals(tStr)) {
                                type = MatchQuery.Type.PHRASE;
                                continue;
                            }
                            if ("phrase_prefix".equals(tStr) || "phrasePrefix".equals(tStr)) {
                                type = MatchQuery.Type.PHRASE_PREFIX;
                                continue;
                            }
                            throw new ParsingException(parser.getTokenLocation(), "[match] query does not support type " + tStr, new Object[0]);
                        }
                        if (ANALYZER_FIELD.match(currentFieldName)) {
                            analyzer = parser.text();
                            continue;
                        }
                        if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName)) {
                            boost = parser.floatValue();
                            continue;
                        }
                        if (SLOP_FIELD.match(currentFieldName)) {
                            slop = parser.intValue();
                            continue;
                        }
                        if (Fuzziness.FIELD.match(currentFieldName)) {
                            fuzziness = Fuzziness.parse(parser);
                            continue;
                        }
                        if (PREFIX_LENGTH_FIELD.match(currentFieldName)) {
                            prefixLength = parser.intValue();
                            continue;
                        }
                        if (MAX_EXPANSIONS_FIELD.match(currentFieldName)) {
                            maxExpansion = parser.intValue();
                            continue;
                        }
                        if (OPERATOR_FIELD.match(currentFieldName)) {
                            operator = Operator.fromString(parser.text());
                            continue;
                        }
                        if (MINIMUM_SHOULD_MATCH_FIELD.match(currentFieldName)) {
                            minimumShouldMatch = parser.textOrNull();
                            continue;
                        }
                        if (FUZZY_REWRITE_FIELD.match(currentFieldName)) {
                            fuzzyRewrite = parser.textOrNull();
                            continue;
                        }
                        if (FUZZY_TRANSPOSITIONS_FIELD.match(currentFieldName)) {
                            fuzzyTranspositions = parser.booleanValue();
                            continue;
                        }
                        if (LENIENT_FIELD.match(currentFieldName)) {
                            lenient = parser.booleanValue();
                            continue;
                        }
                        if (CUTOFF_FREQUENCY_FIELD.match(currentFieldName)) {
                            cutOffFrequency = Float.valueOf(parser.floatValue());
                            continue;
                        }
                        if (ZERO_TERMS_QUERY_FIELD.match(currentFieldName)) {
                            String zeroTermsDocs = parser.text();
                            if ("none".equalsIgnoreCase(zeroTermsDocs)) {
                                zeroTermsQuery = MatchQuery.ZeroTermsQuery.NONE;
                                continue;
                            }
                            if ("all".equalsIgnoreCase(zeroTermsDocs)) {
                                zeroTermsQuery = MatchQuery.ZeroTermsQuery.ALL;
                                continue;
                            }
                            throw new ParsingException(parser.getTokenLocation(), "Unsupported zero_terms_docs value [" + zeroTermsDocs + "]", new Object[0]);
                        }
                        if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName)) {
                            queryName = parser.text();
                            continue;
                        }
                        throw new ParsingException(parser.getTokenLocation(), "[match] query does not support [" + currentFieldName + "]", new Object[0]);
                    }
                    throw new ParsingException(parser.getTokenLocation(), "[match] unknown token [" + (Object)((Object)token) + "] after [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            MatchQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, parser.currentName());
            fieldName = parser.currentName();
            value = parser.objectText();
        }
        if (value == null) {
            throw new ParsingException(parser.getTokenLocation(), "No text specified for text query", new Object[0]);
        }
        MatchQueryBuilder matchQuery = new MatchQueryBuilder(fieldName, value);
        matchQuery.operator(operator);
        matchQuery.type(type);
        matchQuery.analyzer(analyzer);
        matchQuery.slop(slop);
        matchQuery.minimumShouldMatch(minimumShouldMatch);
        if (fuzziness != null) {
            matchQuery.fuzziness(fuzziness);
        }
        matchQuery.fuzzyRewrite(fuzzyRewrite);
        matchQuery.prefixLength(prefixLength);
        matchQuery.fuzzyTranspositions(fuzzyTranspositions);
        matchQuery.maxExpansions(maxExpansion);
        matchQuery.lenient(lenient);
        if (cutOffFrequency != null) {
            matchQuery.cutoffFrequency(cutOffFrequency.floatValue());
        }
        matchQuery.zeroTermsQuery(zeroTermsQuery);
        matchQuery.queryName(queryName);
        matchQuery.boost(boost);
        return Optional.of(matchQuery);
    }
}

